<?php

use Aheto\Helper;

add_action('aheto_before_aheto_title-bar_register', 'vestry_title_bar_layout1');

/**
 * Title Bar
 */

function vestry_title_bar_layout1($shortcode)
{
	$dir = plugins_url('', \AAddons\PLUGIN_ROOT_FILE) . '/shortcodes/title-bar/previews/';
	$shortcode->add_layout('vestry_layout1', [
		'title' => esc_html__('Vestry title bar', 'vestry'),
		'image' => $dir . 'vestry_layout1.jpg',
	]);
	$shortcode->add_dependecy('vestry_use_title_typo', 'template', 'vestry_layout1');
	$shortcode->add_dependecy('vestry_title_typo', 'vestry_use_title_typo', 'true');
	$shortcode->add_dependecy('vestry_use_arrow_typo', 'template', 'vestry_layout1');
	$shortcode->add_dependecy('vestry_arrow_typo', 'vestry_use_arrow_typo', 'true');

	$shortcode->add_params([
		'vestry_use_title_typo' => [
			'type'    => 'switch',
			'heading' => esc_html__('Use custom font for title?', 'vestry'),
			'grid'    => 3,
		],
		'vestry_title_typo' => [
			'type'     => 'typography',
			'group'    => 'Vestry Title Typography',
			'settings' => [
				'tag'        => false,
				'text_align' => false,
			],
			'selector' => '{{WRAPPER}} .aht-breadcrumbs__item',
		],
		'vestry_use_arrow_typo' => [
			'type'    => 'switch',
			'heading' => esc_html__('Use custom font for arrow?', 'vestry'),
			'grid'    => 3,
		],
		'vestry_arrow_typo' => [
			'type'     => 'typography',
			'group'    => 'Vestry Arrow Typography',
			'settings' => [
				'tag'        => false,
				'text_align' => false,
			],
			'selector' => '{{WRAPPER}} .aht-breadcrumbs__item:before',
		],
	]);
}
