<?php

use Aheto\Helper;

add_action('aheto_before_aheto_testimonials_register', 'rela_testimonials_layout2');


/**
 * Testimonials Shortcode
 */
function rela_testimonials_layout2($shortcode)
{

    $shortcode_dir = plugins_url('', \AAddons\PLUGIN_ROOT_FILE) . '/shortcodes/testimonials/previews/';

    $shortcode->add_layout('rela_layout2', [
        'title' => esc_html__('Rela Minimal', 'rela'),
        'image' => $shortcode_dir . 'rela_layout2.jpg',
    ]);

    $shortcode->add_dependecy('rela_testimonials_minimal', 'template', 'rela_layout2');

    $shortcode->add_params([
        'rela_testimonials_minimal' => [
            'type' => 'group',
            'heading' => esc_html__('Minimal Testimonials Items', 'rela'),
            'params' => [
                'rela_name' => [
                    'type' => 'text',
                    'heading' => esc_html__('Name', 'rela'),
                    'default' => esc_html__('Author name', 'rela'),
                ],
                'rela_company' => [
                    'type' => 'text',
                    'heading' => esc_html__('Position', 'rela'),
                    'default' => esc_html__('Author position', 'rela'),
                ],
                'rela_testimonial' => [
                    'type' => 'textarea',
                    'heading' => esc_html__('Testimonial', 'rela'),
                    'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'rela'),
                ],
            ],
        ],
    ]);

    \Aheto\Params::add_carousel_params($shortcode, [
        'custom_options' => true,
        'prefix' => 'rela_swiper_min_',
        'include' => ['loop', 'autoplay', 'speed', 'slides', 'spaces', 'simulate_touch', 'pagination'],
        'dependency' => ['template', ['rela_layout2']]
    ]);
}