<?php

use Aheto\Helper;
add_action( 'aheto_before_aheto_team-member_register', 'acacio_team_member_layout1' );
/**
 * Team Member
 */

function acacio_team_member_layout1( $shortcode ) {
	$dir = plugins_url('', \AAddons\PLUGIN_ROOT_FILE) . '/shortcodes/team-member/previews/';

	$shortcode->add_layout( 'acacio_layout1', [
		'title' => esc_html__( 'Acacio Simple', 'acacio' ),
		'image' => $dir . 'acacio_layout1.jpg',
	] );

	aheto_addon_add_dependency( ['image', 'name', 'designation'], [ 'acacio_layout1' ], $shortcode );

    $shortcode->add_dependecy( 'acacio_use_title_typo', 'template', 'acacio_layout1' );
    $shortcode->add_dependecy( 'acacio_title_typo', 'template', 'acacio_layout1' );
    $shortcode->add_dependecy( 'acacio_title_typo', 'acacio_use_title_typo', 'true' );
    $shortcode->add_dependecy( 'acacio_use_position_typo', 'template', 'acacio_layout1' );
    $shortcode->add_dependecy( 'acacio_position_typo', 'template', 'acacio_layout1' );
    $shortcode->add_dependecy( 'acacio_position_typo', 'acacio_use_position_typo', 'true' );

    $shortcode->add_params( [
        'acacio_use_title_typo' => [
            'type'    => 'switch',
            'heading' => esc_html__( 'Use custom font for name?', 'acacio' ),
            'grid'    => 3,
        ],

        'acacio_title_typo' => [
            'type'     => 'typography',
            'group'    => 'Name Typography',
            'settings' => [
                'tag'        => false,
                'text_align' => true,
            ],
            'selector' => '{{WRAPPER}} .aheto-team-member__name',
        ],
        'acacio_use_position_typo' => [
            'type'    => 'switch',
            'heading' => esc_html__( 'Use custom font for position?', 'acacio' ),
            'grid'    => 3,
        ],

        'acacio_position_typo' => [
            'type'     => 'typography',
            'group'    => 'Position Typography',
            'settings' => [
                'tag'        => false,
                'text_align' => true,
            ],
            'selector' => '{{WRAPPER}} .aheto-team-member__position',
        ],

    ] );

    \Aheto\Params::add_image_sizer_params($shortcode, [
        'group'      => esc_html__( 'Images size', 'acacio' ),
        'prefix'     => 'acacio_',
        'dependency' => ['template', [ 'acacio_layout1'] ]
    ]);

}

function acacio_team_member_layout1_dynamic_css( $css, $shortcode ) {
    if ( ! empty( $shortcode->atts['acacio_use_title_typo'] ) && ! empty( $shortcode->atts['acacio_title_typo'] ) ) {
        \aheto_add_props( $css['global']['%1$s .aheto-team-member__name'], $shortcode->parse_typography( $shortcode->atts['acacio_title_typo'] ) );
    }
    if ( ! empty( $shortcode->atts['acacio_use_position_typo'] ) && ! empty( $shortcode->atts['acacio_position_typo'] ) ) {
        \aheto_add_props( $css['global']['%1$s .aheto-team-member__position'], $shortcode->parse_typography( $shortcode->atts['acacio_position_typo'] ) );
    }

	return $css;
}

add_filter( 'aheto_team_member_dynamic_css', 'acacio_team_member_layout1_dynamic_css', 10, 2 );