<?php

/**
 * Header Modern Menu.
 */

use Aheto\Helper;

extract($atts);

if (empty($menus)) {
	return;
}

$this->generate_css();

// Wrapper.
$this->add_render_attribute('wrapper', 'id', 'vestry-header');
$this->add_render_attribute('wrapper', 'class', $this->the_custom_classes());
$this->add_render_attribute('wrapper', 'class', 'main-header--vestry');
$this->add_render_attribute('wrapper', 'class', 'main-header-js');
$this->add_render_attribute('wrapper', 'class', $transparent);

$type_logo = isset($type_logo) && !empty($type_logo) ? $type_logo : 'image';

if ($type_logo == 'image' && is_array($scroll_logo)) {

	$scroll_logo     = !empty($scroll_logo['id']) ? $scroll_logo : $logo;
} elseif ($type_logo == 'image' && !is_array($scroll_logo)) {
	$scroll_logo     = isset($scroll_logo) && !empty($scroll_logo) ? $scroll_logo : $logo;
}

$button = $this->get_button_attributes('main');
$add_button = $this->get_button_attributes('add');

/**
 * Set dependent style
 */
$shortcode_dir = plugins_url('', \AAddons\PLUGIN_ROOT_FILE) . '/shortcodes/navigation/';
$custom_css    = Helper::get_settings( 'general.custom_css_including' );
$custom_css    = ( isset( $custom_css ) && ! empty( $custom_css ) ) ? $custom_css : false;
if ( empty( $custom_css ) || ( $custom_css == "disabled" ) ) {
  wp_enqueue_style('vestry-navigation-layout1', $shortcode_dir . 'assets/css/vestry_layout1.css', null, null);
}
wp_enqueue_script('vestry-navigation-layout1-js', $shortcode_dir . 'assets/js/vestry_layout1.js', array('jquery'), null);
?>

<div <?php $this->render_attribute_string('wrapper'); ?>>
	<div class="main-header__main-line">
		<div class="main-header__menu-box">
			<?php
			wp_nav_menu([
				'container'       => 'nav',
				'container_class' => 'menu-home-page-container',
				'menu_class'      => 'main-menu main-menu--inline',
				'menu'            => $menus,
			]);
			?>
		</div>
		<div class="aheto-logo main-header__logo">
			<a href="<?php echo esc_url(home_url('/')); ?>">
				<?php if (!empty($logo) && $type_logo == 'image') {
					echo Helper::get_attachment($logo, ['class' => 'aheto-logo__image']);
				}
				if (!empty($scroll_logo) && $type_logo == 'image') {
					echo Helper::get_attachment($scroll_logo, ['class' => 'aheto-logo__image aheto-logo__image-scroll']);
				}
				if (!empty($text_logo) && $type_logo == 'text') { ?>
					<span><?php echo esc_html($text_logo); ?></span>
				<?php } ?>
			</a>
		</div>
		<div class="main-header__menu-box">
			<?php
			wp_nav_menu([
				'container'       => 'nav',
				'container_class' => 'menu-home-page-container',
				'menu_class'      => 'main-menu main-menu--inline',
				'menu'            => $vestry_menus_right,
			]);
			?>
		</div>
	</div>
</div>