<?php
/**
 * Header Modern Menu.
 */

use Aheto\Helper;

extract ( $atts );

if (empty( $menus )) {
	return;
}

$this -> generate_css ();

// Wrapper.
$this -> add_render_attribute ( 'wrapper', 'id', $element_id );
$this -> add_render_attribute ( 'wrapper', 'class', $this -> the_custom_classes () );
$this -> add_render_attribute ( 'wrapper', 'class', 'main-header--ninedok' );
$this -> add_render_attribute ( 'wrapper', 'class', 'main-header-js' );
$this -> add_render_attribute ( 'wrapper', 'class', $transparent );

$type_logo = isset( $type_logo ) && !empty( $type_logo ) ? $type_logo : 'image';


$button = $this -> get_button_attributes ( 'main' );

/**
 * Set dependent style
 */
$shortcode_dir = plugins_url ( '', \AAddons\PLUGIN_ROOT_FILE ) . '/shortcodes/navigation/';
$custom_css = Helper ::get_settings ( 'general.custom_css_including' );
$custom_css = ( isset( $custom_css ) && !empty( $custom_css ) ) ? $custom_css : false;
if (empty( $custom_css ) || ( $custom_css == "disabled" )) {
	wp_enqueue_style ( 'ninedok-navigation-layout1', $shortcode_dir . 'assets/css/ninedok_layout1.css', null, null );
} ?>
<div <?php $this -> render_attribute_string ( 'wrapper' ); ?>>
    <div class="main-header__main-line">
        <div class="aheto-logo main-header__logo">
            <a href="<?php echo esc_url ( home_url ( '/' ) ); ?>">
				<?php if ( !empty( $logo ) && $type_logo == 'image') {
					echo Helper ::get_attachment ( $logo, [ 'class' => 'aheto-logo__image' ] );
				}

				if ( !empty( $mob_logo ) && $type_logo == 'image') {
					echo Helper ::get_attachment ( $mob_logo, [ 'class' => 'aheto-logo__image mob-logo' ] );
				}

				if ( !empty( $scroll_mob_logo ) && $type_logo == 'image') {
					echo Helper ::get_attachment ( $scroll_mob_logo, [ 'class' => 'aheto-logo__image mob-logo aheto-logo__image-mob-scroll' ] );
				}

				if ( !empty( $text_logo ) && $type_logo == 'text') { ?>
                    <span><?php echo esc_html ( $text_logo ); ?></span>
				<?php } ?>

            </a>
			<?php if ( !empty( $label_logo )) { ?>
                <span class="main-header__logo-label">
			            <?php echo esc_html ( $label_logo ); ?>
                        </span>
			<?php } ?>
        </div>
        <div class="main-header__menu-box">
            <h5 class="main-header__mob_menu_title">Menu</h5>
			<?php
			wp_nav_menu ( [
				'container' => 'nav',
				'container_class' => 'menu-home-page-container',
				'menu_class' => 'main-menu main-menu--inline',
				'menu' => $menus,
			] );
			?>

            <div class="main-header__widget-box-mobile">
				<?php if ($ninedok_main_mob_add_button) { ?>
					<?php echo Helper ::get_button ( $this, $atts, 'ninedok_main_mob_' ); ?>
				<?php } ?>
            </div>


        </div>
        <div class="main-header__widget-box">

            <div class="main-header__widget-box-desktop">
				<?php if ($ninedok_main_add_button) { ?>
					<?php echo Helper ::get_button ( $this, $atts, 'ninedok_main_' ); ?>
				<?php } ?>
            </div>

            <button class="hamburger main-header__hamburger js-toggle-mobile-menu" type="button">
                <span class="hamburger-box">
                    <span class="hamburger-inner"></span>
                </span>
            </button>
        </div>
    </div>
</div>
