<?php

use Aheto\Helper;

add_action( 'aheto_before_aheto_custom-post-types_register', 'outsourceo_custom_post_types_skins' );

/**
 * Custom Post Type Shortcode
 */

function outsourceo_custom_post_types_skins( $shortcode ) {


	$shortcode->add_dependecy( 'outsourceo_img_off', 'skin', 'outsourceo_skin-1' );
	$shortcode->add_dependecy( 'outsourceo_use_dot', 'skin', 'outsourceo_skin-1' );
	$shortcode->add_dependecy( 'outsourceo_use_author_typo', 'skin', 'outsourceo_skin-1' );
	$shortcode->add_dependecy( 'outsourceo_author_typo', 'skin', 'outsourceo_skin-1' );
	$shortcode->add_dependecy( 'outsourceo_author_typo', 'outsourceo_use_author_typo', 'true' );
	$shortcode->add_dependecy( 'outsourceo_add_borderradius', 'skin', 'outsourceo_skin-2' );

	// CUSTOM SKIN 1

	$aheto_skins      = $shortcode->params['skin']['options'];
	$outsourceo_skins = array(
		'outsourceo_skin-1' => 'Outsourceo skin 1',
		'outsourceo_skin-2' => 'Outsourceo skin 2',
	);

	$shortcode->add_params( [
		'outsourceo_img_off' => [
			'type'    => 'switch',
			'heading' => esc_html__( 'Disable post image?', 'outsourceo' ),
			'grid'    => 12,
		],
		'outsourceo_use_dot'       => [
			'type'    => 'switch',
			'heading' => esc_html__( 'Use dot at the end of the title?', 'outsourceo' ),
			'grid'    => 12,
		],
		'outsourceo_use_author_typo' => [
			'type'    => 'switch',
			'heading' => esc_html__( 'Use custom font for author?', 'outsourceo' ),
			'grid'    => 6,
		],

		'outsourceo_author_typo' => [
			'type'     => 'typography',
			'group'    => 'Outsourceo Author Typography',
			'settings' => [
				'tag'        => false,
			],
			'selector' => '{{WRAPPER}} .aheto-cpt-article__author',
		],
		'outsourceo_add_borderradius' => [
			'type'    => 'switch',
			'heading' => esc_html__('Add border radius on hover', 'outsourceo')
		],
	] );

	$all_skins                            = array_merge( $aheto_skins, $outsourceo_skins );
	$shortcode->params['skin']['options'] = $all_skins;

}


function outsourceo_cpt_skins_shortcode_dynamic_css( $css, $shortcode ) {

	if ( ! empty( $shortcode->atts['outsourceo_use_author_typo'] ) && ! empty( $shortcode->atts['outsourceo_author_typo'] ) ) {
		\aheto_add_props( $css['global']['%1$s .aheto-cpt-article__author'], $shortcode->parse_typography( $shortcode->atts['outsourceo_author_typo'] ) );
	}

	return $css;
}

add_filter( 'aheto_cpt_dynamic_css', 'outsourceo_cpt_skins_shortcode_dynamic_css', 10, 2 );