<?php

use Aheto\Helper;

add_action('aheto_before_aheto_contact-forms_register', 'soapy_contact_forms_layout1');

/**
 * Contact forms Shortcode
 */

function soapy_contact_forms_layout1($shortcode) {

	$preview_dir = plugins_url('', \AAddons\PLUGIN_ROOT_FILE) . '/shortcodes/contact-forms/previews/';

	$shortcode->add_layout('soapy_layout1', [
		'title' => esc_html__('Soapy Classic', 'soapy'),
		'image' => $preview_dir . 'soapy_layout1.jpg',
	]);

	$shortcode->add_dependecy( 'soapy_color_text', 'template', 'soapy_layout1');
	$shortcode->add_dependecy( 'soapy_color_placeholder', 'template', 'soapy_layout1');


	aheto_addon_add_dependency(['bg_color_fields', 'count_input', 'button_align', 'full_width_button'], ['soapy_layout1'], $shortcode);

	$shortcode->add_params([
	
		'soapy_color_text'    => [
			'type'      => 'colorpicker',
			'heading'   => esc_html__('Text input color', 'soapy'),
			'selectors' => ['{{WRAPPER}} input:-webkit-autofill,
			 {{WRAPPER}} input:-webkit-autofill:focus,
			  {{WRAPPER}} .widget_aheto__form .wpcf7 input:not([type=submit]),
			  {{WRAPPER}} .widget_aheto__form .wpcf7 textarea' => '-webkit-text-fill-color: {{VALUE}};'],
		],
		'soapy_color_placeholder'    => [
			'type'      => 'colorpicker',
			'heading'   => esc_html__('Placeholder color', 'soapy'),
			'selectors' => ['{{WRAPPER}} .widget_aheto__form .wpcf7 textarea::placeholder,
			{{WRAPPER}} .widget_aheto__form .wpcf7 input:not([type=submit])::placeholder' => 'color: {{VALUE}}; -webkit-text-fill-color: {{VALUE}};'],
		],
		

	]);

}

function soapy_contact_forms_layout1_dynamic_css( $css, $shortcode ) {

	if (isset($shortcode->atts['soapy_color_text']) && !empty($shortcode->atts['soapy_color_text'])) {
		$css['global']['%1$s input:-webkit-autofill, %1$s input:-webkit-autofill:focus, %1$s .widget_aheto__form .wpcf7 input:not([type=submit]), %1$s .widget_aheto__form .wpcf7 textarea']['-webkit-text-fill-color'] = \Aheto\Sanitize::color($shortcode->atts['soapy_color_text']);
	}
	
	if (isset($shortcode->atts['soapy_color_placeholder']) && !empty($shortcode->atts['soapy_color_placeholder'])) {
		$css['global']['%1$s .widget_aheto__form .wpcf7 textarea::placeholder, %1$s .widget_aheto__form .wpcf7 input:not([type=submit])::placeholder']['color'] = \Aheto\Sanitize::color($shortcode->atts['soapy_color_placeholder']);
		$css['global']['%1$s .widget_aheto__form .wpcf7 textarea::placeholder, %1$s .widget_aheto__form .wpcf7 input:not([type=submit])::placeholder']['-webkit-text-fill-color'] = \Aheto\Sanitize::color($shortcode->atts['soapy_color_placeholder']);
	}
	
	return $css;
}

add_filter( 'aheto_contact_forms_dynamic_css', 'soapy_contact_forms_layout1_dynamic_css', 10, 2 );

function soapy_contact_forms_layout1_button($form_button) {

	$form_button['dependency'][1][] = 'soapy_layout1';

	return $form_button;
}

add_filter('aheto_button_contact-forms', 'soapy_contact_forms_layout1_button', 10, 2);

