<?php

use Aheto\Helper;

add_action( 'aheto_before_aheto_contact-forms_register', 'noize_contact_forms_layout1' );

/**
 * Contact forms Shortcode
 */
function noize_contact_forms_layout1( $shortcode ) {
    $preview_dir = plugins_url('', \AAddons\PLUGIN_ROOT_FILE) . '/shortcodes/contact-forms/previews/';

    $shortcode->add_layout( 'noize_layout1', [
        'title' => esc_html__( 'Noize Subscribe', 'noize' ),
        'image' => $preview_dir . 'noize_layout1.jpg',
    ] );

    aheto_addon_add_dependency( 'bg_color_fields', [ 'noize_layout1' ], $shortcode );
}

function noize_contact_forms_layout1_button( $form_button ) {
    $form_button['dependency'][1][] = 'noize_layout1';

    return $form_button;
}

add_filter( 'aheto_button_contact-forms', 'noize_contact_forms_layout1_button', 10, 2 );