<?php
/**
 * Plugin Name: Aheto Shortcodes Add-Ons
 * Plugin URI: https://foxthemes.helpscoutdocs.com/collection/2471-aheto
 * Description: Additional shortcodes for Aheto
 * Version: 1.0.0
 * Text Domain: aheto-shortcodes-add-ons
 * Author:            UPQODE
 * Author URI:        https://upqode.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 */

namespace AAddons;
const ACTIVE           = true;
const PLUGIN_ROOT      = __DIR__;
const PLUGIN_ROOT_FILE = __FILE__;

spl_autoload_register( function ( $name ) {
	$name    = explode( '\\', $name );
	$name[0] = 'includes';
	$path    = __DIR__ . DIRECTORY_SEPARATOR . implode( DIRECTORY_SEPARATOR, $name ) . '.php';

	if ( file_exists( $path ) ) {
		require_once $path;
	}
}, false );

require_once __DIR__ . '/includes/helper-functions.php';

$shortcodes_dir = __DIR__ . DIRECTORY_SEPARATOR . 'shortcodes';

$files = glob( $shortcodes_dir . '/*/controllers/*.php' );

foreach ( $files as $file ) {
	require_once( $file );
}


new AhetoAddon();
