<?php
/**
 * Karma functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Karma
 */

defined( 'KARMA_T_URI' ) or define( 'KARMA_T_URI', get_template_directory_uri() );
defined( 'KARMA_T_PATH' ) or define( 'KARMA_T_PATH', get_template_directory() );

require_once ABSPATH . 'wp-admin/includes/plugin.php';

require_once KARMA_T_PATH . '/include/class-tgm-plugin-activation.php';
require_once KARMA_T_PATH . '/include/custom-header.php';
require_once KARMA_T_PATH . '/include/actions-config.php';
require_once KARMA_T_PATH . '/include/helper-function.php';
require_once KARMA_T_PATH . '/include/aheto-shortcodes.php';
require_once KARMA_T_PATH . '/include/customizer.php';

require KARMA_T_PATH .'/plugin-update-checker/plugin-update-checker.php';
$MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://main.aheto.co/wp-update/?action=get_metadata&slug=karma', //Metadata URL.
	__FILE__, //Full path to the main plugin file.
	'karma' //Plugin slug. Usually it's the same as the name of the directory.
);


if ( ! function_exists( 'karma_setup' ) ) :

	function karma_setup() {

		register_nav_menus( array( 'primary-menu' => esc_html__( 'Primary menu', 'karma' ) ) );
		load_theme_textdomain( 'karma', get_template_directory() . '/languages' );


		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption' ) );
		add_theme_support( 'post-formats', array(
			'aside',
			'gallery',
			'link',
			'image',
			'quote',
			'status',
			'video',
			'audio',
			'chat'
		) );

		add_theme_support( 'woocommerce' );


		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'karma_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );


		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;

add_action( 'after_setup_theme', 'karma_setup' );

// Disable REST API link tag
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );

add_filter( 'aheto_template_kit_category', function () {
	return 'karma';
} );

if ( ! function_exists( 'karma_woocommerce_template_loop_product_title' ) ) {

	/**
	 * Show the product title in the product loop. By default this is an H2.
	 */
	function karma_woocommerce_template_loop_product_title() {
		echo '<h4 class="woocommerce-loop-product--title">' . get_the_title() . '</h4>';
	}
}

add_action( 'woocommerce_shop_loop_item_title', 'karma_woocommerce_template_loop_product_title', 20 );


if ( function_exists( 'aheto' ) ) {
	function karma_theme_options( $theme_tabs ) {

		$theme_tabs = [
			'karma_shop' => [
				'icon'  => 'dashicons dashicons-admin-generic pink-color',
				'title' => esc_html__( 'Shop Options', 'aheto' ),
				'desc'  => esc_html__( 'This tab contains the theme shop options.', 'aheto' ),
				'file'  => KARMA_T_PATH . '/include/shop-options.php',
			],
		];

		return $theme_tabs;
	}
}

add_filter( 'aheto_theme_options', 'karma_theme_options', 10, 2 );

$shortcodes_dir = get_template_directory() .'/aheto';
$files = glob( $shortcodes_dir . '/*/controllers/*.php' );
foreach ( $files as $file ) {
	require_once( $file );
}

function export_data() {
	$response = wp_remote_get( 'https://main.aheto.co/wp-json/aheto/v1/getThemeTemplate/5899', [] );
	$response = json_decode( $response['body'], true );
	return $response;
}

add_filter( 'export_data', 'export_data', 10 );