<?php
/**
 * The Heading Shortcode.
 */

use Aheto\Helper;

extract( $atts );

$this->generate_css();


// Wrapper.
$this->add_render_attribute( 'wrapper', 'id', $element_id );
$this->add_render_attribute( 'wrapper', 'class', 'aheto-heading' );
$this->add_render_attribute( 'wrapper', 'class', 'aheto-heading--karma__simple' );
$this->add_render_attribute( 'wrapper', 'class', $alignment );
$this->add_render_attribute( 'wrapper', 'class', 'align-mob-' . $karma_align_mobile );
$this->add_render_attribute( 'wrapper', 'class', $this->the_custom_classes() );


/**
 * Set dependent style
 */
$custom_css = Helper::get_settings( 'general.custom_css_including' );
$custom_css = ( isset( $custom_css ) && ! empty( $custom_css ) ) ? $custom_css : false;
$sc_dir     = KARMA_T_URI . '/aheto/heading/';

if ( empty( $custom_css ) || ( $custom_css == "disabled" ) ) {
	wp_enqueue_style( 'karma-heading-simple', $sc_dir . 'assets/css/karma_layout1.css', null, null );
}

?>

<div <?php $this->render_attribute_string( 'wrapper' ); ?>>

	<?php
	// Heading.
	$heading = $this->get_heading();

	if ( ! empty( $karma_subtitle ) ) {
		echo '<' . $karma_subtitle_tag . ' class="aheto-heading__subtitle">' . esc_html( $karma_subtitle ) . '</' . $karma_subtitle_tag . '>';
	}

	if ( ! empty( $heading ) ) {

		$heading = $this->highlight_text( $heading );

		echo '<' . $text_tag . ' class="aheto-heading__title">' . wp_kses( $heading, 'post' ) . '</' . $text_tag . '>';

	} ?>

</div>
