<?php
/**
 * The Media Shortcode.
 *
 * @since      1.0.0
 * @package    Aheto
 * @subpackage Aheto\Shortcodes
 * @author     UPQODE <info@upqode.com>
 */

namespace Aheto\Shortcodes;

use Aheto\Shortcode;
use Aheto\Sanitize;

defined('ABSPATH') || exit;

/**
 * Media class.
 */
class Media extends Shortcode {

	/**
	 * Setup
	 */
	public function setup() {
		$this->slug        = 'media';
		$this->title       = esc_html__('Media', 'aheto');
		$this->icon        = 'fas fa-play-circle';
		$this->description = esc_html__('Add media', 'aheto');
		$this->default_layout = 'view';

		// Layouts.
		$dir = plugin_dir_url(__FILE__) . 'previews/';
		$this->add_layout('layout1', [
			'title' => esc_html__('Simple/Slider Image', 'aheto'),
			'image' => $dir . 'layout1.jpg',
		]);

		$this->add_layout( 'layout4', [
			'title' => esc_html__( 'Modern Slider', 'aheto' ),
			'image' => $dir . 'layout4.jpg',
		]);

		// Dependency.
		$this->add_dependecy('image', 'template', ['view', 'layout1', 'layout4']);
		$this->add_dependecy('custom_options', 'template', ['view', 'layout1', 'layout4'] );

		$this->register();
	}

	/**
	 * Set dependent style
	 *
	 * @return array
	 */
	public function get_style_depends() {
		return ['swiper'];
	}

	/**
	 * Set dependent scripts
	 *
	 * @return array
	 */
	public function get_script_depends() {
		return ['swiper'];
	}

	/**
	 * Set shortcode params
	 */
	public function set_params() {
		$this->params = [
			'image'    => [
				'type'    => 'attach_images',
				'heading' => esc_html__('Images', 'aheto'),
			],
			'advanced' => true,
		];


		$carousel_params = array(
			'custom_options' => true,
			'include'        => ['pagination', 'arrows', 'loop', 'autoplay', 'speed', 'slides', 'spaces', 'overflow', 'initial_slide', 'simulate_touch', 'arrows_color', 'arrows_size'],
			'dependency'     => [ 'template', [ 'view', 'layout1', 'layout4' ] ]
		);

		$carousel_params = apply_filters( "aheto_media_carousel",  $carousel_params );


		\Aheto\Params::add_carousel_params($this, $carousel_params);

		\Aheto\Params::add_image_sizer_params($this, [
			'dependency' => ['template', [ 'view', 'layout1', 'layout4']]
		]);
	}


	/**
	 * Pre dynamic CSS.
	 *
	 * @param  array $css Array of dynamic CSS.
	 *
	 * @return array
	 */
	public function pre_dynamic_css( $css ) {

		if ( !empty($this->atts['arrows_color']) ) {
			$css['global'][ '%1$s .swiper-button-next, %1$s .swiper-button-prev']['color'] = Sanitize::color($this->atts['arrows_color']);
		}

		if ( !empty($this->atts['arrows_size']) ) {
			$css['global']['%1$s .swiper-button-next, %1$s .swiper-button-prev']['font-size'] = Sanitize::size($this->atts['arrows_size'] );
		}

		return apply_filters( "aheto_media_dynamic_css", $css, $this );
	}
}
