<?php
/**
 * Typography settings.
 *
 * @since      1.0.0
 * @package    Aheto
 * @subpackage Aheto
 * @author     UPQODE <info@upqode.com>
 */

$font_fields = [
	'font-size'      => false,
	'font-weight'    => false,
	'color'          => false,
	'text-align'     => false,
	'text-transform' => false,
	'line-height'    => false,
	'letter-spacing' => false,
	'word-spacing'   => false,
	'margin-top'     => false,
	'margin-bottom'  => false,
];

$cmb->add_field([
	'id'     => 'primary_font',
	'type'   => 'typography',
	'name'   => esc_html__( 'Primary Font', 'aheto' ),
	'desc'   => esc_html__( 'Please, select Primary Font Family.', 'aheto' ),
	'fields' => $font_fields,
]);

$cmb->add_field([
	'id'     => 'secondary_font',
	'type'   => 'typography',
	'name'   => esc_html__( 'Secondary Font', 'aheto' ),
	'desc'   => esc_html__( 'Please, select Secondary Font Family.', 'aheto' ),
	'fields' => $font_fields,
]);


$cmb->add_field([
	'id'     => 'tertiary_font',
	'type'   => 'typography',
	'name'   => esc_html__( 'Tertiary Font', 'aheto' ),
	'desc'   => esc_html__( 'Please, select Tertiary Font Family.', 'aheto' ),
	'fields' => $font_fields,
]);

$cmb->add_field([
	'id'      => 'subtitle_font',
	'type'    => 'typography',
	'name'    => esc_html__( 'Subtitle Font', 'aheto' ),
	'desc'    => esc_html__( 'Please, enter values to customize your subtitle font.', 'aheto' ),
	'classes' => 'second-line',
	'fields'  => [
		'font-family'    => false,
		'color'          => false,
		'text-align'     => false,
		'text-transform' => false,
		'line-height'    => false,
		'word-spacing'   => false,
		'margin-top'     => false,
	],
]);

$cmb->add_field([
	'id'     => 'text_font',
	'type'   => 'typography',
	'name'   => esc_html__( 'Text Font', 'aheto' ),
	'desc'   => esc_html__( 'Please, enter values to customize your text font.', 'aheto' ),
	'fields' => [
		'text-align'     => false,
		'text-transform' => false,
		'word-spacing'   => false,
		'margin-top'     => false,
		'margin-bottom'  => false,
	],
]);

$cmb->add_field([
	'id'     => 'links',
	'type'   => 'typography',
	'name'   => esc_html__( 'Links', 'aheto' ),
	'desc'   => esc_html__( 'Please, enter values to customize your links.', 'aheto' ),
	'fields' => [
		'font-family'    => true,
		'font-size'      => true,
		'font-weight'    => true,
		'color'          => true,
		'text-align'     => false,
		'text-transform' => false,
		'line-height'    => false,
		'letter-spacing' => true,
		'word-spacing'   => false,
		'margin-top'     => false,
		'margin-bottom'  => false,
	],
]);

$cmb->add_field([
	'id'      => 'widget_title',
	'type'    => 'typography',
	'name'    => esc_html__( 'Widget Title', 'aheto' ),
	'desc'    => esc_html__( 'Please, enter values to customize your widget title.', 'aheto' ),
	'classes' => 'second-line',
	'fields'  => [
		'text-align'   => false,
		'word-spacing' => false,
	],
]);

$cmb->add_field([
	'id'   => 'widget_title_border',
	'type' => 'border',
	'name' => esc_html__( 'Widget Title Border', 'aheto' ),
	'desc' => esc_html__( 'Please, enter values to customize your Title Border.', 'aheto' ),
]);

$cmb->add_field([
	'id'   => 'widget_title_padding',
	'type' => 'spacing',
	'name' => esc_html__( 'Widget Title Padding', 'aheto' ),
	'desc' => esc_html__( 'Please, enter values to customize your Title Padding.', 'aheto' ),
]);
