<?php
/**
 * Skins settings.
 *
 * @since      1.0.0
 * @package    Aheto
 * @subpackage Aheto
 * @author     UPQODE <info@upqode.com>
 */

use Aheto\Helper;

$cmb->add_field([
	'id'    => 'skins',
	'type'  => 'title',
	'name'  => esc_html__( 'Skin List', 'aheto' ),
	'after' => function() {
		$url = Helper::get_admin_url( 'skin-generator' );
		echo '<table class="skin-listing wp-core-ui"><tbody>';

        $selected_skin = Helper::get_active_skin();

		foreach ( Helper::skins() as $id => $name ) {
		    $active = ( $selected_skin == $id ) ? ' active_skin' : '';

			printf(
				'<tr class="%6$s">
                        <td><input type="text" name="skin_name" class="aheto_skin_name" value="%1$s" data-skin_id="%2$s"></td>                    
                        <td><span><a href="%3$s" class="custom-btn">' . esc_html__('Edit', 'aheto') . '</a></span></td>
                        <td><span><a href="%4$s" class="custom-btn clone-btn">' . esc_html__('Clone', 'aheto') . '</a></span></td>
                        <td><a href="%5$s" class="button-link-delete custom-btn secondary">' . esc_html__('Delete', 'aheto') . '</a></span></td>
                        </tr>',
				$name,
                $id,
				$url . '&aheto-edit-skin=' . $id,
                $url . '&aheto-clone-skin=' . $id,
				$url . '&aheto-delete-skin=' . $id,
                $active
			);
		}
		echo '</tbody></table>';
	},
]);

$skin_name = ( isset( $_GET['aheto-edit-skin'] ) ) ? $_GET['aheto-edit-skin'] : '';

$cmb->add_field([
	'id'   => 'skin',
	'type' => 'hidden',
	'default' => $skin_name
]);

$cmb->add_field([
	'id'          => 'new_skin',
	'type'        => 'text',
	'name'        => esc_html__( 'New Skin Name', 'aheto' ),
	'classes'     => 'with-button',
	'after_field' => '<button type="submit" class="custom-btn  button-create-new">Create New Skin</a>',
	'save_field'  => false,
]);
