<?php
/**
 * All skins settings.
 *
 * @since      1.0.0
 * @package    Aheto
 * @subpackage Aheto
 * @author     UPQODE <info@upqode.com>
 */

return [
	// Colors.
	'colors'        => [
		'color_1'  => [
			'active' => '#CF2632',
			'alter'  => '#27389A',
			'alter2' => '#FC8D43',
			'alter3' => '#EEEEEE',
			'grey'   => '#999999',
			'light'  => '#F9F9F9',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_2'  => [
			'active' => '#FC8D43',
			'alter'  => '#FF9C81',
			'alter2' => '#0F7DCC',
			'alter3' => '#FFC015',
			'grey'   => '#999999',
			'light'  => '#F7F7F7',
			'dark'   => '#222222',
			'dark2'  => '#5E5E5E',
		],
		'color_3'  => [
			'active' => '#E32682',
			'alter'  => '#FFC015',
			'alter2' => '#0F7DCC',
			'alter3' => '#7FBC48',
			'grey'   => '#999999',
			'light'  => '#F7F7F7',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_4'  => [
			'active' => '#0F7DCC',
			'alter'  => '#FF9C81',
			'alter2' => '#60BBC3',
			'alter3' => '#FFC015',
			'grey'   => '#999999',
			'light'  => '#EAF7FF',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_5'  => [
			'active' => '#7FBC48',
			'alter'  => '#FFC015',
			'alter2' => '#FC81A9',
			'alter3' => '#60BBC3',
			'grey'   => '#999999',
			'light'  => '#F9F9F9',
			'dark'   => '#555555',
			'dark2'  => '#222222',
		],
		'color_6'  => [
			'active' => '#FFD40D',
			'alter'  => '#FF9C81',
			'alter2' => '#0F7DCC',
			'alter3' => '#7FBC48',
			'grey'   => '#999999',
			'light'  => '#F9F9F9',
			'dark'   => '#0D369F',
			'dark2'  => '#555555',
		],
		'color_7'  => [
			'active' => '#80261B',
			'alter'  => '#E32682',
			'alter2' => '#FFC015',
			'alter3' => '#7FBC48',
			'grey'   => '#999999',
			'light'  => '#F7F7F7',
			'dark'   => '#222222',
			'dark2'  => '#302F33',
		],
		'color_8'  => [
			'active' => '#2C49FF',
			'alter'  => '#4FB557',
			'alter2' => '#FFC015',
			'alter3' => '#7FBC48',
			'grey'   => '#999999',
			'light'  => '#F9F9F9',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_9'  => [
			'active' => '#2A74ED',
			'alter'  => '#FF704F',
			'alter2' => '#FFBE0D',
			'alter3' => '#4FB557',
			'grey'   => '#999999',
			'light'  => '#F9F9F9',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_10' => [
			'active' => '#EBB113',
			'alter'  => '#2A74ED',
			'alter2' => '#FF704F',
			'alter3' => '#FFC015',
			'grey'   => '#999999',
			'light'  => '#EBEBEB',
			'dark'   => '#111539',
			'dark2'  => '#555555',
		],
		'color_11' => [
			'active' => '#5307DE',
			'alter'  => '#DA00FF',
			'alter2' => '#FF704F',
			'alter3' => '#FFC015',
			'grey'   => '#888888',
			'light'  => '#CCCCCC',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_12' => [
			'active' => '#B56246',
			'alter'  => '#FFBF37',
			'alter2' => '#FF704F',
			'alter3' => '#7FBC48',
			'grey'   => '#999999',
			'light'  => '#EEEEEE',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_13' => [
			'active' => '#FA6742',
			'alter'  => '#FFBB49',
			'alter2' => '#2A74ED',
			'alter3' => '#FFC015',
			'grey'   => '#999999',
			'light'  => '#F7F7F7',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_14' => [
			'active' => '#0536A5',
			'alter'  => '#DD2932',
			'alter2' => '#2A74ED',
			'alter3' => '#FFC015',
			'grey'   => '#999999',
			'light'  => '#EBF1FE',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_15' => [
			'active' => '#2A74ED',
			'alter'  => '#FFC015',
			'alter2' => '#0536A5',
			'alter3' => '#7FBC48',
			'grey'   => '#999999',
			'light'  => '#F6F9FF',
			'dark'   => '#222222',
			'dark2'  => '#555555',
		],
		'color_16' => [
			'active' => '#B58E4C',
			'alter'  => '#A58247',
			'alter2' => '#A60000',
			'alter3' => '#EEEEEE',
			'grey'   => '#989898',
			'light'  => '#F9F9F9',
			'dark'   => '#262626',
			'dark2'  => '#515151',
		],
	],

	// Typography.
	'typography'    => [
		'typo_1'  => [
			'primary_font'   => 'Karla, sans-serif',
			'secondary_font' => 'Karla, sans-serif',
			'tertiary_font'  => 'Karla, sans-serif',
		],
		'typo_2'  => [
			'primary_font'   => 'Karla, sans-serif',
			'secondary_font' => 'Playfair Display, serif',
			'tertiary_font'  => 'Karla, sans-serif',
		],
		'typo_3'  => [
			'primary_font'   => 'Poppins, sans-serif',
			'secondary_font' => 'Karla, sans-serif',
			'tertiary_font'  => 'Poppins, sans-serif',
		],
		'typo_4'  => [
			'primary_font'   => 'Roboto, sans-serif',
			'secondary_font' => 'Gilroy, sans-serif',
			'tertiary_font'  => 'Gilroy, sans-serif',
		],
		'typo_5'  => [
			'primary_font'   => 'Gilroy, sans-serif',
			'secondary_font' => 'Futura, sans-serif',
			'tertiary_font'  => 'Karla, sans-serif',
		],
		'typo_6'  => [
			'primary_font'   => 'Roboto, sans-serif',
			'secondary_font' => "'Roboto Slab', serif",
			'tertiary_font'  => 'Playfair Display, serif',
		],
		'typo_7'  => [
			'primary_font'   => 'Catamaran, sans-serif',
			'secondary_font' => 'Playfair Display, serif',
			'tertiary_font'  => 'Playfair Display, serif',
		],
		'typo_8'  => [
			'primary_font'   => "'Open Sans', sans-serif",
			'secondary_font' => 'Playfair Display, serif',
			'tertiary_font'  => 'Playfair Display, serif',
		],
		'typo_9'  => [
			'primary_font'   => 'Roboto, sans-serif',
			'secondary_font' => 'Playfair Display, serif',
			'tertiary_font'  => 'Playfair Display, serif',
		],
		'typo_10' => [
			'primary_font'   => "'Source Sans Pro', sans-serif",
			'secondary_font' => 'Roboto, sans-serif',
			'tertiary_font'  => 'Roboto, sans-serif',
		],
		'typo_11' => [
			'primary_font'   => 'Poppins, sans-serif',
			'secondary_font' => 'Poppins, sans-serif',
			'tertiary_font'  => 'Poppins, sans-serif',
		],
		'typo_12' => [
			'primary_font'   => "'Proxima Nova Rg', sans-serif",
			'secondary_font' => "'Droid Serif', sans-serif",
			'tertiary_font'  => "'Droid Serif', sans-serif",
		],
		'typo_13' => [
			'primary_font'   => 'Mukta, sans-serif',
			'secondary_font' => "'Open Sans', sans-serif",
			'tertiary_font'  => 'SignPainter, sans-serif',
		],
		'typo_14' => [
			'primary_font'   => 'Oswald, sans-serif',
			'secondary_font' => 'Playfair Display, serif',
			'tertiary_font'  => 'Lato, sans-serif',
		],
		'typo_15' => [
			'primary_font'   => 'Roboto, sans-serif',
			'secondary_font' => 'Playfair Display, serif',
			'tertiary_font'  => 'Playfair Display, serif',
		],
		'typo_16' => [
			'primary_font'   => 'Mukta, sans-serif',
			'secondary_font' => "'Open Sans', sans-serif",
			'tertiary_font'  => 'SignPainter, sans-serif',
		],
	],

	// Subtitle.
	'subtitle_font' => [
		'typo_1'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_2'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_3'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_4'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_5'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_6'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_7'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_8'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_9'  => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_10' => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_11' => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_12' => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_13' => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_14' => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_15' => [
			'font-size'     => '14px',
			'font-weight'   => 'bold',
			'letter-space'  => '2.8px',
			'margin-bottom' => '20px',
		],
		'typo_16' => [
			'font-size'     => '30px',
			'font-weight'   => 'normal',
			'letter-space'  => '0',
			'margin-bottom' => '5px',
		],
	],

	// Heading.
	'headings'      => [
		'typo_1'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '-1px',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_2'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_3'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_4'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => '500',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_5'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'secondary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => '500',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_6'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'secondary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_7'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_8'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_9'  => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_10' => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_11' => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_12' => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '60px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_13' => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'bold',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_14' => [
			'h-color'       => 'active',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_15' => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '0',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '50px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '20px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '16px',
			'h6-ln-height'  => '1.2',
		],
		'typo_16' => [
			'h-color'       => 'dark',
			'h-font-family' => 'primary',
			'h-ltr-spacing' => '3.2px',
			'h-fnt-wgt'     => 'normal',
			'h1-fnt-size'   => '60px',
			'h1-ln-height'  => '1.2',
			'h2-fnt-size'   => '40px',
			'h2-ln-height'  => '1.2',
			'h3-fnt-size'   => '30px',
			'h3-ln-height'  => '1.2',
			'h4-fnt-size'   => '24px',
			'h4-ln-height'  => '1.2',
			'h5-fnt-size'   => '21px',
			'h5-ln-height'  => '1.2',
			'h6-fnt-size'   => '17px',
			'h6-ln-height'  => '1.2',
		],
	],

	// Paragraph.
	'paragraph'     => [
		'typo_1'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_2'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_3'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_4'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_5'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_6'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_7'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_8'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_9'  => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '24px',
			'ltr-spng'   => '0',
		],
		'typo_10' => [
			'color'      => 'grey',
			'fnt-family' => 'secondary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_11' => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '14px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_12' => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_13' => [
			'color'      => 'grey',
			'fnt-family' => 'secondary',
			'fnt-size'   => '15px',
			'ln-height'  => '22.5px',
			'ltr-spng'   => '0',
		],
		'typo_14' => [
			'color'      => 'grey',
			'fnt-family' => 'tertiary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_15' => [
			'color'      => 'grey',
			'fnt-family' => 'primary',
			'fnt-size'   => '16px',
			'ln-height'  => '1.5',
			'ltr-spng'   => '0',
		],
		'typo_16' => [
			'color'      => 'grey',
			'fnt-family' => 'secondary',
			'fnt-size'   => '15px',
			'ln-height'  => '1.93',
			'ltr-spng'   => '0',
		],
	],

	// Links.
	'links'         => [
		'typo_1'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_2'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_3'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '600',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_4'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0.5px',
			'color'      => 'active',
		],
		'typo_5'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_6'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0.5px',
			'color'      => 'dark',
		],
		'typo_7'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '600',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_8'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_9'  => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '400',
			'fnt-size'   => '16px',
			'ltr-spng'   => '1.5',
			'color'      => 'active',
		],
		'typo_10' => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '600',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_11' => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '600',
			'fnt-size'   => '14px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_12' => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '18px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_13' => [
			'fnt-family' => 'secondary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '15px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_14' => [
			'fnt-family' => 'tertiary',
			'fnt-wgt'    => '700',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_15' => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '400',
			'fnt-size'   => '16px',
			'ltr-spng'   => '0',
			'color'      => 'active',
		],
		'typo_16' => [
			'fnt-family' => 'primary',
			'fnt-wgt'    => '400',
			'fnt-size'   => '15px',
			'ltr-spng'   => '3px',
			'color'      => 'active',
		],
	],

	// Buttons.
	'buttons'       => [
		'typo_1'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '21',
					'horizontal' => '37',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '0',
					'hoffset' => '0',
					'blur'    => '32px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.3,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '42',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '16',
					'horizontal' => '37',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'alter',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_2'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '21',
					'horizontal' => '39',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '0',
					'hoffset' => '0',
					'blur'    => '32px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.3,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '32',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1px',
				'padding'        => [
					'vertical'   => '16',
					'horizontal' => '39',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'dark2',
				'border'     => 'dark2',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_3'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '600',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '21',
					'horizontal' => '41',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '0',
					'hoffset' => '0',
					'blur'    => '32px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.3,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '33',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '13px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '17',
					'horizontal' => '40',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'weight'         => '600',
			],
			'secondary' => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_4'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '20px',
				'border_radius'   => '5px',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '21',
					'horizontal' => '37',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '33',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '16',
					'horizontal' => '33',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '2px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_5'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '0.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '16',
					'horizontal' => '41',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '14px',
				'letter_spacing' => '0.5px',
				'padding'        => [
					'vertical'   => '20',
					'horizontal' => '37',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '13px',
				'letter_spacing' => '0.5px',
				'padding'        => [
					'vertical'   => '13',
					'horizontal' => '37',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '0.5px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'grey',
				'border'     => 'grey',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_6'  => [
			'button'    => [
				'background'      => 'dark',
				'icon_size'       => '14px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '5px',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '20',
					'horizontal' => '40',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '2px',
					'style'   => 'solid',
					'color'   => 'dark',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'dark',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '24',
					'horizontal' => '41',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '15',
					'horizontal' => '37',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'active',
				'border'     => 'active',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'grey',
				'border'     => 'grey',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'dark',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_7'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '14px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '21',
					'horizontal' => '42',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '2px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '42',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '16',
					'horizontal' => '35',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'dark2',
				'border'     => 'dark2',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_8'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '14px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '5px',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '21',
					'horizontal' => '44',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '2px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '40',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '16',
					'horizontal' => '37',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_9'  => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '20px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '5px',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '500',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '25',
					'horizontal' => '38',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '43',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '15',
					'horizontal' => '33',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'weight'         => '500',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_10' => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '14px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '5px',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '18',
					'horizontal' => '39',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '23',
					'horizontal' => '45',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '13',
					'horizontal' => '34',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'light',
				'border'     => 'light',
				'color'      => 'grey',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '115px',
				'height'     => '115px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_11' => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '8px',
				'icon_size_large' => '24px',
				'icon_margin'     => '8px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '0.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '22',
					'horizontal' => '45',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '0.5px',
				'padding'        => [
					'vertical'   => '27',
					'horizontal' => '45',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '0.5px',
				'padding'        => [
					'vertical'   => '17',
					'horizontal' => '38',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '14px',
				'letter_spacing' => '0',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '120px',
				'height'     => '120px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_12' => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '18px',
					'line-height'    => '1.15',
					'letter-spacing' => '2px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '20',
					'horizontal' => '40',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '20px',
				'letter_spacing' => '2px',
				'padding'        => [
					'vertical'   => '22',
					'horizontal' => '42',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '18px',
				'letter_spacing' => '2px',
				'padding'        => [
					'vertical'   => '14',
					'horizontal' => '38',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '18px',
				'letter_spacing' => '2px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '120px',
				'height'     => '120px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_13' => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '15px',
					'line-height'    => '1.15',
					'letter-spacing' => '3px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '18',
					'horizontal' => '46',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '3px',
				'padding'        => [
					'vertical'   => '22',
					'horizontal' => '45',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '15px',
				'letter_spacing' => '3px',
				'padding'        => [
					'vertical'   => '12',
					'horizontal' => '35',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '16px',
				'letter_spacing' => '2.3px',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '120px',
				'height'     => '120px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_14' => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '5px',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '700',
					'font-size'      => '16px',
					'line-height'    => '1.15',
					'letter-spacing' => '0',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '15',
					'horizontal' => '36',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '18px',
				'letter_spacing' => '0',
				'padding'        => [
					'vertical'   => '19',
					'horizontal' => '42',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '16px',
				'letter_spacing' => '0',
				'padding'        => [
					'vertical'   => '10',
					'horizontal' => '29',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '16px',
				'letter_spacing' => '0',
				'weight'         => '700',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '120px',
				'height'     => '120px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_15' => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '5px',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '500',
					'font-size'      => '14px',
					'line-height'    => '1.15',
					'letter-spacing' => '1.5px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '21',
					'horizontal' => '37',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '42',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '16',
					'horizontal' => '37',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '16px',
				'letter_spacing' => '0',
				'weight'         => '400',
			],
			'secondary' => [
				'background' => 'alter',
				'border'     => 'alter',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '120px',
				'height'     => '120px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
		'typo_16' => [
			'button'    => [
				'background'      => 'active',
				'icon_size'       => '18px',
				'icon_size_large' => '24px',
				'icon_margin'     => '10px',
				'border_radius'   => '0',
				'font'            => [
					'font-family'    => 'primary',
					'font-weight'    => '500',
					'font-size'      => '15px',
					'line-height'    => '1.15',
					'letter-spacing' => '3px',
					'color'          => 'white',
				],
				'padding'         => [
					'vertical'   => '18',
					'horizontal' => '25',
					'units'      => 'px',
				],
				'border'          => [
					'all'     => '1px',
					'style'   => 'solid',
					'color'   => 'active',
					'opacity' => 0.5,
				],
				'box_shadow'      => [
					'voffset' => '1.169px',
					'hoffset' => '3.825px',
					'blur'    => '15.66px',
					'spread'  => '2.34px',
					'color'   => 'active',
					'opacity' => 0.2,
					'inset'   => '',
				],
			],
			'large'     => [
				'font_size'      => '16px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '25',
					'horizontal' => '42',
					'units'      => 'px',
				],
			],
			'small'     => [
				'font_size'      => '14px',
				'letter_spacing' => '1.5px',
				'padding'        => [
					'vertical'   => '16',
					'horizontal' => '37',
					'units'      => 'px',
				],
			],
			'inline'    => [
				'font_size'      => '16px',
				'letter_spacing' => '0',
				'weight'         => '400',
			],
			'secondary' => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'active',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'light'     => [
				'background' => 'white',
				'border'     => 'white',
				'color'      => 'dark',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'dark'      => [
				'background' => 'dark',
				'border'     => 'dark',
				'color'      => 'white',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'gradient'  => [
				'circle'     => '120deg',
				'default'    => '-90deg',
				'box_shadow' => [
					'voffset' => '',
					'hoffset' => '',
					'blur'    => '',
					'spread'  => '',
					'color'   => '',
					'inset'   => '',
				],
			],
			'big'       => [
				'font_size'      => '24px',
				'letter_spacing' => '1px',
				'padding'        => [
					'top'    => '60',
					'right'  => '23',
					'bottom' => '30',
					'left'   => '23',
					'units'  => 'px',
				],
			],
			'circle'    => [
				'width'      => '120px',
				'height'     => '120px',
				'icon_size'  => '24px',
				'box_shadow' => [
					'voffset' => '0',
					'hoffset' => '7px',
					'blur'    => '16px',
					'spread'  => '0',
					'color'   => 'active',
					'opacity' => 0.44,
					'inset'   => '',
				],
			],
		],
	],
	'testimonial'   => [
		'typo_1'  => [
			'background'   => 'transparent',
			'author_color' => 'grey',
			'author_size'  => '14px',
		],
		'typo_2'  => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
		'typo_3'  => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
		'typo_4'  => [
			'background'   => 'transparent',
			'author_color' => 'grey',
			'author_size'  => '14px',
		],
		'typo_5'  => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
		'typo_6'  => [
			'background'   => 'transparent',
			'author_color' => 'grey',
			'author_size'  => '14px',
		],
		'typo_7'  => [
			'background'   => 'transparent',
			'author_color' => 'dark',
			'author_size'  => '14px',
		],
		'typo_8'  => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
		'typo_9'  => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
		'typo_10' => [
			'background'   => 'light',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
		'typo_11' => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '16px',
		],
		'typo_12' => [
			'background'   => 'light',
			'author_color' => 'active',
			'author_size'  => '16px',
		],
		'typo_13' => [
			'background'   => 'light',
			'author_color' => 'active',
			'author_size'  => '24px',
		],
		'typo_14' => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '16px',
		],
		'typo_15' => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
		'typo_16' => [
			'background'   => 'transparent',
			'author_color' => 'active',
			'author_size'  => '14px',
		],
	],
];
