<?php
/**
 * Color settings.
 *
 * @since      1.0.0
 * @package    Aheto
 * @subpackage Aheto
 * @author     UPQODE <info@upqode.com>
 */

$set_colors = array();

if ( isset( $_GET['aheto-edit-skin'] ) && !empty( $_GET['aheto-edit-skin'] ) ) {
	$skin_id = $_GET['aheto-edit-skin'];

	$colors = ['active', 'alter', 'alter2', 'alter3', 'grey', 'light', 'dark', 'dark2', 'white', 'black'];

	$settings = get_option( 'aheto_skin_' . $skin_id );

	foreach ( $colors as $color ) {
		if(isset($settings[$color]) && !empty($settings[$color])){
			$set_colors[] = $settings[$color];
		}
	}
}

$cmb->add_field( [
	'id'   => 'active',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Primary Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select primary color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );

$cmb->add_field( [
	'id'   => 'alter',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Secondary Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select secondary color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );

$cmb->add_field( [
	'id'   => 'alter2',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Tertiary Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select tertiary color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );

$cmb->add_field( [
	'id'   => 'alter3',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Quaternary Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select quaternary color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );

$cmb->add_field( [
	'id'   => 'grey',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Grey Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select grey color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );

$cmb->add_field( [
	'id'   => 'light',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Light Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select light color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );

$cmb->add_field( [
	'id'   => 'dark',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Dark Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select dark color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );

$cmb->add_field( [
	'id'   => 'dark2',
	'type' => 'colorpicker',
	'name' => esc_html__( 'Dark2 Color', 'aheto' ),
	'desc' => esc_html__( 'Please, select second dark color.', 'aheto' ),
	'attributes' => array(
		'data-colorpicker' => json_encode( array(
			'palettes' => $set_colors,
		) ),
	)
] );
