<?php
/**
 * Buttons settings.
 *
 * @since      1.0.0
 * @package    Aheto
 * @subpackage Aheto
 * @author     UPQODE <info@upqode.com>
 */

// Button.
$cmb->add_field([
	'id'         => 'button',
	'type'       => 'group',
	'options'    => [
		'closed'      => false,
		'group_title' => esc_html__( 'Button Styling', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'     => 'font',
			'type'   => 'typography',
			'name'   => __( '<i class="fas fa-align-left yellow-color"></i> Font', 'aheto' ),
			'desc'   => esc_html__( 'Please enter a value to customize the button font.', 'aheto' ),
			'fields' => [
				'text-align'     => false,
				'text-transform' => false,
				'word-spacing'   => false,
				'margin-top'     => false,
				'margin-bottom'  => false,
				'color'          => false,
				'color_hover'    => false,
			],
		],
		[
			'id'     => 'padding',
			'type'   => 'spacing',
			'name'   => __( '<i class="fas fa-indent pink-color"></i>Padding', 'aheto' ),
			'desc'   => esc_html__( 'Please add padding to your button.', 'aheto' ),
			'fields' => [
				'vertical'   => true,
				'horizontal' => true,
			],
		],
		[
			'id'     => 'mobile_padding',
			'type'   => 'spacing',
			'name'   => __( '<i class="fas fa-indent pink-color"></i>Mobile Padding', 'aheto' ),
			'desc'   => esc_html__( 'Please, enter your custom paddings for the Large Button.', 'aheto' ),
			'fields' => [
				'vertical'   => true,
				'horizontal' => true,
			],
		],
		[
			'id'   => 'border_radius',
			'type' => 'text_small',
			'name' => __( '<i class="fas fa-circle blue-color"></i>Border Radius', 'aheto' ),
			'desc' => esc_html__( 'Please enter a border radius for your button.', 'aheto' ),
		],
		[
			'id'     => 'border',
			'type'   => 'border',
			'name'   => __( '<i class="fas fa-window-maximize green-color"></i>Border', 'aheto' ),
			'desc'   => esc_html__( 'Please add border weight and choose style.', 'aheto' ),
			'fields' => [
				'all'   => true,
				'style' => true,
				'color' => false,
				'color_hover'    => false,
			],
		],
		[
			'id'   => 'icon_size',
			'type' => 'text_small',
			'name' => __( '<i class="fas fa-certificate yellow-color"></i>Icon Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter the size of the icon.', 'aheto' ),
		],
//		[
//			'id'   => 'icon_size_large',
//			'type' => 'text_small',
//			'name' => esc_html__( 'Icon Size Large', 'aheto' ),
//			'desc' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//		],
		[
			'id'   => 'icon_margin',
			'type' => 'text_small',
			'name' => __( '<i class="fas fa-outdent pink-color"></i>Icon Margin', 'aheto' ),
			'desc' => esc_html__( 'Please, enter margin for your button icon.', 'aheto' ),
		],
	],
]);


// Button Large.
$cmb->add_field([
	'id'         => 'button_large',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Large Styling', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'font_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Font Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter a font size for the Large button.', 'aheto' ),
		],
		[
			'id'   => 'letter_spacing',
			'type' => 'text_small',
			'name' => esc_html__( 'Letter Spacing', 'aheto' ),
			'desc' => esc_html__( 'Please enter a letter spacing for the Large button.', 'aheto' ),
		],
		[
			'id'     => 'padding',
			'type'   => 'spacing',
			'name'   => esc_html__( 'Desktop Padding', 'aheto' ),
			'desc'   => esc_html__( 'Please, enter your custom paddings for the Large Button.', 'aheto' ),
			'fields' => [
				'vertical'   => true,
				'horizontal' => true,
			],
		],
		[
			'id'     => 'mobile_padding',
			'type'   => 'spacing',
			'name'   => esc_html__( 'Mobile Padding', 'aheto' ),
			'desc'   => esc_html__( 'Please, enter your custom paddings for the Large Button.', 'aheto' ),
			'fields' => [
				'vertical'   => true,
				'horizontal' => true,
			],
		],
	]
]);

// Button Small.
$cmb->add_field([
	'id'         => 'button_small',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Small Styling', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'font_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Font Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter a font size for the Small button.', 'aheto' ),
		],
		[
			'id'   => 'letter_spacing',
			'type' => 'text_small',
			'name' => esc_html__( 'Letter Spacing', 'aheto' ),
			'desc' => esc_html__( 'Please enter a letter spacing for the Small button.', 'aheto' ),
		],
		[
			'id'     => 'padding',
			'type'   => 'spacing',
			'name'   => esc_html__( 'Padding', 'aheto' ),
			'desc'   => esc_html__( 'Please, enter your custom paddings for the Small Button.', 'aheto' ),
			'fields' => [
				'vertical'   => true,
				'horizontal' => true,
			],
		],
	],
]);


// Button Primary.
$cmb->add_field([
	'id'         => 'button_primary',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Primary', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'background',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Background', 'aheto' ),
			'desc' => esc_html__( 'Please, select background color for Primary button.', 'aheto' ),
		],
		[
			'id'   => 'color',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Font Color', 'aheto' ),
			'desc' => esc_html__( 'Please, select font color for Primary button.', 'aheto' ),
		],
		[
			'id'   => 'border',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Border color', 'aheto' ),
			'desc' => esc_html__( 'Please, select border color for Primary button.', 'aheto' ),
		],
		[
			'id'   => 'background_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Background (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select background color for Primary button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'color_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Font Color (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select font color for Primary button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'border_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Border color (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select border color for Primary button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'box_shadow',
			'type' => 'box_shadow',
			'name' => esc_html__( 'Box Shadow', 'aheto' ),
			'desc' => esc_html__( 'Please, enter values to customize box shadow for Primary button.', 'aheto' ),
		],
	],
]);

//// Secondary Button.
//$cmb->add_field([
//	'id'         => 'button_secondary',
//	'type'       => 'group',
//	'options'    => [
//		'closed'      => true,
//		'group_title' => esc_html__( 'Button Secondary', 'aheto' ),
//	],
//	'repeatable' => false,
//	'fields'     => $button_color_fields,
//]);

// Button Dark.
$cmb->add_field([
	'id'         => 'button_dark',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Dark', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'background',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Background', 'aheto' ),
			'desc' => esc_html__( 'Please, select background color for Dark button.', 'aheto' ),
		],
		[
			'id'   => 'color',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Font Color', 'aheto' ),
			'desc' => esc_html__( 'Please, select font color for Dark button.', 'aheto' ),
		],
		[
			'id'   => 'border',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Border color', 'aheto' ),
			'desc' => esc_html__( 'Please, select border color for Dark button.', 'aheto' ),
		],
		[
			'id'   => 'background_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Background (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select background color for Dark button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'color_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Font Color (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select font color for Dark button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'border_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Border color (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select border color for Dark button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'box_shadow',
			'type' => 'box_shadow',
			'name' => esc_html__( 'Box Shadow', 'aheto' ),
			'desc' => esc_html__( 'Please, enter values to customize box shadow for Dark button.', 'aheto' ),
		],
	],
]);

// Light Button.
$cmb->add_field([
	'id'         => 'button_light',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Light', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'background',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Background', 'aheto' ),
			'desc' => esc_html__( 'Please, select background color for Light button.', 'aheto' ),
		],
		[
			'id'   => 'color',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Font Color', 'aheto' ),
			'desc' => esc_html__( 'Please, select font color for Light button.', 'aheto' ),
		],
		[
			'id'   => 'border',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Border color', 'aheto' ),
			'desc' => esc_html__( 'Please, select border color for Light button.', 'aheto' ),
		],
		[
			'id'   => 'background_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Background (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select background color for Light button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'color_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Font Color (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select font color for Light button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'border_hover',
			'type' => 'colorpicker',
			'name' => esc_html__( 'Border color (hover)', 'aheto' ),
			'desc' => esc_html__( 'Please, select border color for Light button hover effect.', 'aheto' ),
		],
		[
			'id'   => 'box_shadow',
			'type' => 'box_shadow',
			'name' => esc_html__( 'Box Shadow', 'aheto' ),
			'desc' => esc_html__( 'Please, enter values to customize box shadow for Light button.', 'aheto' ),
		],
	],
]);

// Button inline.
$cmb->add_field([
	'id'         => 'button_inline',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Inline/Underline Styling', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'     => 'font',
			'type'   => 'typography',
			'name'   => __( '<i class="fas fa-align-left yellow-color"></i> Font', 'aheto' ),
			'desc'   => esc_html__( 'Please enter a value to customize the Inline/Underline button styling.', 'aheto' ),
			'fields' => [
				'color_hover'    => false,
				'text-align'     => false,
				'text-transform' => false,
				'word-spacing'   => false,
				'margin-top'     => false,
				'margin-bottom'  => false,
				'color'          => false,
				'color_hover'    => false,
			]
		]
	],
]);

// Button video small.
$cmb->add_field([
	'id'         => 'button_video',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Video', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'font_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Font Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter a font size for the video button.', 'aheto' ),
		],
		[
			'id'   => 'btn_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Button Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter the video button size.', 'aheto' ),
		],
	],
]);

// Button video small.
$cmb->add_field([
	'id'         => 'button_video_small',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Video Small', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'font_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Font Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter the font size for the Small video button.', 'aheto' ),
		],
		[
			'id'   => 'btn_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Button Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter a button size for a Small video button.', 'aheto' ),
		],
	],
]);

// Button video small.
$cmb->add_field([
	'id'         => 'button_video_large',
	'type'       => 'group',
	'options'    => [
		'closed'      => true,
		'group_title' => esc_html__( 'Button Video Large', 'aheto' ),
	],
	'repeatable' => false,
	'fields'     => [
		[
			'id'   => 'font_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Font Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter the font size for the Large video button.', 'aheto' ),
		],
		[
			'id'   => 'btn_size',
			'type' => 'text_small',
			'name' => esc_html__( 'Button Size', 'aheto' ),
			'desc' => esc_html__( 'Please enter a button size for a Large video button.', 'aheto' ),
		],
	],
]);

// Button Gradient.
//$cmb->add_field([
//	'id'         => 'button_gradient',
//	'type'       => 'group',
//	'options'    => [
//		'closed'      => true,
//		'group_title' => esc_html__( 'Button Gradient', 'aheto' ),
//	],
//	'repeatable' => false,
//	'fields'     => [
//		[
//			'id'   => 'circle',
//			'type' => 'text_small',
//			'name' => esc_html__( 'Circle Degree', 'aheto' ),
//			'desc' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//		],
//		[
//			'id'   => 'default',
//			'type' => 'text_small',
//			'name' => esc_html__( 'Default', 'aheto' ),
//			'desc' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//		],
//		[
//			'id'   => 'box_shadow',
//			'type' => 'box_shadow',
//			'name' => esc_html__( 'Box Shadow', 'aheto' ),
//			'desc' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//		],
//	],
//]);

// Button Big Size.
//unset( $button_fields[2]['fields'] );
//$cmb->add_field([
//	'id'         => 'button_big',
//	'type'       => 'group',
//	'options'    => [
//		'closed'      => true,
//		'group_title' => esc_html__( 'Button Big Size', 'aheto' ),
//	],
//	'repeatable' => false,
//	'fields'     => $button_fields,
//]);

// Button Circle.
//$cmb->add_field([
//	'id'         => 'button_circle',
//	'type'       => 'group',
//	'options'    => [
//		'closed'      => true,
//		'group_title' => esc_html__( 'Button Circle', 'aheto' ),
//	],
//	'repeatable' => false,
//	'fields'     => [
//		[
//			'id'   => 'width',
//			'type' => 'text_small',
//			'name' => esc_html__( 'Width', 'aheto' ),
//			'desc' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//		],
//		[
//			'id'   => 'height',
//			'type' => 'text_small',
//			'name' => esc_html__( 'Height', 'aheto' ),
//			'desc' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//		],
//		[
//			'id'   => 'icon_size',
//			'type' => 'text_small',
//			'name' => esc_html__( 'Icon Size', 'aheto' ),
//			'desc' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//		],
//		[
//			'id'     => 'box_shadow',
//			'type'   => 'box_shadow',
//			'name'   => esc_html__( 'Box Shadow', 'aheto' ),
//			'desc'   => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis tempor.', 'aheto' ),
//			'fields' => [ 'color' => false ],
//		],
//	],
//]);
