<?php
/**
 * The icons library.
 *
 * @since      1.0.0
 * @package    Aheto
 * @subpackage Aheto
 * @author     UPQODE <info@upqode.com>
 */

use Aheto\Helper;

defined( 'ABSPATH' ) || exit;

/**
 * Get icons by id.
 *
 * @param  string $id Icon id.
 * @return array
 */
function ahet_get_icons( $id ) {
	static $aheto_formatted_icons;
	$id = str_replace( '-', '_', $id );

	if ( isset( $aheto_formatted_icons, $aheto_formatted_icons[ $id ] ) ) {
		return $aheto_formatted_icons[ $id ];
	}

	$func  = 'aheto_icons_' . $id;
	$icons = $func();
	if ( 'elementor' === Helper::get_settings( 'general.builder' ) ) {
		if ( in_array( $id, [ 'elegant', 'font_awesome' ] ) ) {
			$icons = aheto_assoc_icon_has_cats( $icons );
		} else {
			$icons = aheto_assoc_icon( $icons );
		}
	}

	$aheto_formatted_icons[ $id ] = $icons;

	return $icons;
}

/**
 * Convert to assoc.
 *
 * @param  array $icons Array to convert.
 * @return array
 */
function aheto_assoc_icon_has_cats( $icons ) {
	$new_icons = [];
	foreach ( $icons as $icon ) {
		$new_icons = array_merge( $new_icons, aheto_assoc_icon( $icon ) );
	}

	return $new_icons;
}

/**
 * Convert to assoc.
 *
 * @param  array $icons Array to convert.
 * @return array
 */
function aheto_assoc_icon( $icons ) {
	$new_icons = [];
	foreach ( $icons as $icon ) {
		$new_icons[ key( $icon ) ] = current( $icon );
	}

	return $new_icons;
}

/**
 * Elegant Icons.
 *
 * @return array
 */
function aheto_icons_elegant() {
	return [
		'Arrow'  => [
			[ 'el arrow_up' => 'Up' ],
			[ 'el arrow_down' => 'Down' ],
			[ 'el arrow_left' => 'Left' ],
			[ 'el arrow_right' => 'Right' ],
			[ 'el arrow_left-up' => 'Left Up' ],
			[ 'el arrow_right-up' => 'Right Up' ],
			[ 'el arrow_right-down' => 'Right Down' ],
			[ 'el arrow_left-down' => 'Left Down' ],
			[ 'el arrow-up-down' => 'Up Down' ],
			[ 'el arrow_up-down_alt' => 'Up Down Alt' ],
			[ 'el arrow_left-right_alt' => 'Left Right Alt' ],
			[ 'el arrow_left-right' => 'Left Right' ],
			[ 'el arrow_expand_alt2' => 'Expand Alt2' ],
			[ 'el arrow_expand_alt' => 'Expand Alt' ],
			[ 'el arrow_condense' => 'Condense' ],
			[ 'el arrow_expand' => 'Expand' ],
			[ 'el arrow_move' => 'Move' ],
			[ 'el arrow_carrot-up' => 'Carrot Up' ],
			[ 'el arrow_carrot-down' => 'Carrot Down' ],
			[ 'el arrow_carrot-left' => 'Carrot Left' ],
			[ 'el arrow_carrot-right' => 'Carrot Right' ],
			[ 'el arrow_carrot-2up' => 'Carrot 2up' ],
			[ 'el arrow_carrot-2down' => 'Carrot 2down' ],
			[ 'el arrow_carrot-2left' => 'Carrot 2left' ],
			[ 'el arrow_carrot-2right' => 'Carrot 2right' ],
			[ 'el arrow_carrot-up_alt2' => 'Carrot Up Alt2' ],
			[ 'el arrow_carrot-down_alt2' => 'Carrot Down Alt2' ],
			[ 'el arrow_carrot-left_alt2' => 'Carrot Left Alt2' ],
			[ 'el arrow_carrot-right_alt2' => 'Carrot Right Alt2' ],
			[ 'el arrow_carrot-2up_alt2' => 'Carrot 2up Alt2' ],
			[ 'el arrow_carrot-2down_alt2' => 'Carrot 2down Alt2' ],
			[ 'el arrow_carrot-2left_alt2' => 'Carrot 2left Alt2' ],
			[ 'el arrow_carrot-2right_alt2' => 'Carrot 2right Alt2' ],
			[ 'el arrow_triangle-up' => 'Triangle Up' ],
			[ 'el arrow_triangle-down' => 'Triangle Down' ],
			[ 'el arrow_triangle-left' => 'Triangle Left' ],
			[ 'el arrow_triangle-right' => 'Triangle Right' ],
			[ 'el arrow_triangle-up_alt2' => 'Triangle Up Alt2' ],
			[ 'el arrow_triangle-down_alt2' => 'Triangle Down Alt2' ],
			[ 'el arrow_triangle-left_alt2' => 'Triangle Left Alt2' ],
			[ 'el arrow_triangle-right_alt2' => 'Triangle Right Alt2' ],
			[ 'el arrow_back' => 'Back' ],
			[ 'el arrow_up_alt' => 'Up Alt' ],
			[ 'el arrow_down_alt' => 'Down Alt' ],
			[ 'el arrow_left_alt' => 'Left Alt' ],
			[ 'el arrow_right_alt' => 'Right Alt' ],
			[ 'el arrow_left-up_alt' => 'Left Up Alt' ],
			[ 'el arrow_right-up_alt' => 'Right Up Alt' ],
			[ 'el arrow_right-down_alt' => 'Right Down Alt' ],
			[ 'el arrow_left-down_alt' => 'Left Down Alt' ],
			[ 'el arrow_condense_alt' => 'Condense Alt' ],
			[ 'el arrow_expand_alt3' => 'Expand Alt3' ],
			[ 'el arrow_carrot_up_alt' => 'Carrot Up Alt' ],
			[ 'el arrow_carrot-down_alt' => 'Carrot Down Alt' ],
			[ 'el arrow_carrot-left_alt' => 'Carrot Left Alt' ],
			[ 'el arrow_carrot-right_alt' => 'Carrot Right Alt' ],
			[ 'el arrow_carrot-2up_alt' => 'Carrot 2up Alt' ],
			[ 'el arrow_carrot-2dwnn_alt' => 'Carrot 2dwnn Alt' ],
			[ 'el arrow_carrot-2left_alt' => 'Carrot 2left Alt' ],
			[ 'el arrow_carrot-2right_alt' => 'Carrot 2right Alt' ],
			[ 'el arrow_triangle-up_alt' => 'Triangle Up Alt' ],
			[ 'el arrow_triangle-down_alt' => 'Triangle Down Alt' ],
			[ 'el arrow_triangle-left_alt' => 'Triangle Left Alt' ],
			[ 'el arrow_triangle-right_alt' => 'Triangle Right Alt' ],
		],
		'Social' => [
			[ 'el social_facebook' => 'Facebook' ],
			[ 'el social_twitter' => 'Twitter' ],
			[ 'el social_pinterest' => 'Pinterest' ],
			[ 'el social_googleplus' => 'Googleplus' ],
			[ 'el social_tumblr' => 'Tumblr' ],
			[ 'el social_tumbleupon' => 'Tumbleupon' ],
			[ 'el social_wordpress' => 'Wordpress' ],
			[ 'el social_instagram' => 'Instagram' ],
			[ 'el social_dribbble' => 'Dribbble' ],
			[ 'el social_vimeo' => 'Vimeo' ],
			[ 'el social_linkedin' => 'Linkedin' ],
			[ 'el social_rss' => 'Rss' ],
			[ 'el social_deviantart' => 'Deviantart' ],
			[ 'el social_share' => 'Share' ],
			[ 'el social_myspace' => 'Myspace' ],
			[ 'el social_skype' => 'Skype' ],
			[ 'el social_youtube' => 'Youtube' ],
			[ 'el social_picassa' => 'Picassa' ],
			[ 'el social_googledrive' => 'Googledrive' ],
			[ 'el social_flickr' => 'Flickr' ],
			[ 'el social_blogger' => 'Blogger' ],
			[ 'el social_spotify' => 'Spotify' ],
			[ 'el social_delicious' => 'Delicious' ],
			[ 'el social_facebook_circle' => 'Facebook Circle' ],
			[ 'el social_twitter_circle' => 'Twitter Circle' ],
			[ 'el social_pinterest_circle' => 'Pinterest Circle' ],
			[ 'el social_googleplus_circle' => 'Googleplus Circle' ],
			[ 'el social_tumblr_circle' => 'Tumblr Circle' ],
			[ 'el social_stumbleupon_circle' => 'Stumbleupon Circle' ],
			[ 'el social_wordpress_circle' => 'Wordpress Circle' ],
			[ 'el social_instagram_circle' => 'Instagram Circle' ],
			[ 'el social_dribbble_circle' => 'Dribbble Circle' ],
			[ 'el social_vimeo_circle' => 'Vimeo Circle' ],
			[ 'el social_linkedin_circle' => 'Linkedin Circle' ],
			[ 'el social_rss_circle' => 'Rss Circle' ],
			[ 'el social_deviantart_circle' => 'Deviantart Circle' ],
			[ 'el social_share_circle' => 'Share Circle' ],
			[ 'el social_myspace_circle' => 'Myspace Circle' ],
			[ 'el social_skype_circle' => 'Skype Circle' ],
			[ 'el social_youtube_circle' => 'Youtube Circle' ],
			[ 'el social_picassa_circle' => 'Picassa Circle' ],
			[ 'el social_googledrive_alt2' => 'Googledrive Alt2' ],
			[ 'el social_flickr_circle' => 'Flickr Circle' ],
			[ 'el social_blogger_circle' => 'Blogger Circle' ],
			[ 'el social_spotify_circle' => 'Spotify Circle' ],
			[ 'el social_delicious_circle' => 'Delicious Circle' ],
			[ 'el social_facebook_square' => 'Facebook Square' ],
			[ 'el social_twitter_square' => 'Twitter Square' ],
			[ 'el social_pinterest_square' => 'Pinterest Square' ],
			[ 'el social_googleplus_square' => 'Googleplus Square' ],
			[ 'el social_tumblr_square' => 'Tumblr Square' ],
			[ 'el social_stumbleupon_square' => 'Stumbleupon Square' ],
			[ 'el social_wordpress_square' => 'Wordpress Square' ],
			[ 'el social_instagram_square' => 'Instagram Square' ],
			[ 'el social_dribbble_square' => 'Dribbble Square' ],
			[ 'el social_vimeo_square' => 'Vimeo Square' ],
			[ 'el social_linkedin_square' => 'Linkedin Square' ],
			[ 'el social_rss_square' => 'Rss Square' ],
			[ 'el social_deviantart_square' => 'Deviantart Square' ],
			[ 'el social_share_square' => 'Share Square' ],
			[ 'el social_myspace_square' => 'Myspace Square' ],
			[ 'el social_skype_square' => 'Skype Square' ],
			[ 'el social_youtube_square' => 'Youtube Square' ],
			[ 'el social_picassa_square' => 'Picassa Square' ],
			[ 'el social_googledrive_square' => 'Googledrive Square' ],
			[ 'el social_flickr_square' => 'Flickr Square' ],
			[ 'el social_blogger_square' => 'Blogger Square' ],
			[ 'el social_spotify_square' => 'Spotify Square' ],
			[ 'el social_delicious_square' => 'Delicious Square' ],
		],
		'Misc'   => [
			[ 'el icon_minus-06' => 'Minus 06' ],
			[ 'el icon_plus' => 'Plus' ],
			[ 'el icon_close' => 'Close' ],
			[ 'el icon_check' => 'Check' ],
			[ 'el icon_minus_alt2' => 'Minus Alt2' ],
			[ 'el icon_plus_alt2' => 'Plus Alt2' ],
			[ 'el icon_close_alt2' => 'Close Alt2' ],
			[ 'el icon_check_alt2' => 'Check Alt2' ],
			[ 'el icon_zoom-out_alt' => 'Zoom Out Alt' ],
			[ 'el icon_zoom-in_alt' => 'Zoom In Alt' ],
			[ 'el icon_search' => 'Search' ],
			[ 'el icon_box-empty' => 'Box Empty' ],
			[ 'el icon_box-selected' => 'Box Selected' ],
			[ 'el icon_minus-box' => 'Minus Box' ],
			[ 'el icon_plus-box' => 'Plus Box' ],
			[ 'el icon_box-checked' => 'Box Checked' ],
			[ 'el icon_circle-empty' => 'Circle Empty' ],
			[ 'el icon_circle-slelected' => 'Circle Slelected' ],
			[ 'el icon_stop_alt2' => 'Stop Alt2' ],
			[ 'el icon_stop' => 'Stop' ],
			[ 'el icon_pause_alt2' => 'Pause Alt2' ],
			[ 'el icon_pause' => 'Pause' ],
			[ 'el icon_menu' => 'Menu' ],
			[ 'el icon_menu-square_alt2' => 'Menu Square Alt2' ],
			[ 'el icon_menu-circle_alt2' => 'Menu Circle Alt2' ],
			[ 'el icon_ul' => 'Ul' ],
			[ 'el icon_ol' => 'Ol' ],
			[ 'el icon_adjust-horiz' => 'Adjust Horiz' ],
			[ 'el icon_adjust-vert' => 'Adjust Vert' ],
			[ 'el icon_document_alt' => 'Document Alt' ],
			[ 'el icon_documents_alt' => 'Documents Alt' ],
			[ 'el icon_pencil' => 'Pencil' ],
			[ 'el icon_pencil-edit_alt' => 'Pencil Edit Alt' ],
			[ 'el icon_pencil-edit' => 'Pencil Edit' ],
			[ 'el icon_folder-alt' => 'Folder Alt' ],
			[ 'el icon_folder-open_alt' => 'Folder Open Alt' ],
			[ 'el icon_folder-add_alt' => 'Folder Add Alt' ],
			[ 'el icon_info_alt' => 'Info Alt' ],
			[ 'el icon_error-oct_alt' => 'Error Oct Alt' ],
			[ 'el icon_error-circle_alt' => 'Error Circle Alt' ],
			[ 'el icon_error-triangle_alt' => 'Error Triangle Alt' ],
			[ 'el icon_question_alt2' => 'Question Alt2' ],
			[ 'el icon_question' => 'Question' ],
			[ 'el icon_comment_alt' => 'Comment Alt' ],
			[ 'el icon_chat_alt' => 'Chat Alt' ],
			[ 'el icon_vol-mute_alt' => 'Vol Mute Alt' ],
			[ 'el icon_volume-low_alt' => 'Volume Low Alt' ],
			[ 'el icon_volume-high_alt' => 'Volume High Alt' ],
			[ 'el icon_quotations' => 'Quotations' ],
			[ 'el icon_quotations_alt2' => 'Quotations Alt2' ],
			[ 'el icon_clock_alt' => 'Clock Alt' ],
			[ 'el icon_lock_alt' => 'Lock Alt' ],
			[ 'el icon_lock-open_alt' => 'Lock Open Alt' ],
			[ 'el icon_key_alt' => 'Key Alt' ],
			[ 'el icon_cloud_alt' => 'Cloud Alt' ],
			[ 'el icon_cloud-upload_alt' => 'Cloud Upload Alt' ],
			[ 'el icon_cloud-download_alt' => 'Cloud Download Alt' ],
			[ 'el icon_image' => 'Image' ],
			[ 'el icon_images' => 'Images' ],
			[ 'el icon_lightbulb_alt' => 'Lightbulb Alt' ],
			[ 'el icon_gift_alt' => 'Gift Alt' ],
			[ 'el icon_house_alt' => 'House Alt' ],
			[ 'el icon_genius' => 'Genius' ],
			[ 'el icon_mobile' => 'Mobile' ],
			[ 'el icon_tablet' => 'Tablet' ],
			[ 'el icon_laptop' => 'Laptop' ],
			[ 'el icon_desktop' => 'Desktop' ],
			[ 'el icon_camera_alt' => 'Camera Alt' ],
			[ 'el icon_mail_alt' => 'Mail Alt' ],
			[ 'el icon_cone_alt' => 'Cone Alt' ],
			[ 'el icon_ribbon_alt' => 'Ribbon Alt' ],
			[ 'el icon_bag_alt' => 'Bag Alt' ],
			[ 'el icon_creditcard' => 'Creditcard' ],
			[ 'el icon_cart_alt' => 'Cart Alt' ],
			[ 'el icon_paperclip' => 'Paperclip' ],
			[ 'el icon_tag_alt' => 'Tag Alt' ],
			[ 'el icon_tags_alt' => 'Tags Alt' ],
			[ 'el icon_trash_alt' => 'Trash Alt' ],
			[ 'el icon_cursor_alt' => 'Cursor Alt' ],
			[ 'el icon_mic_alt' => 'Mic Alt' ],
			[ 'el icon_compass_alt' => 'Compass Alt' ],
			[ 'el icon_pin_alt' => 'Pin Alt' ],
			[ 'el icon_pushpin_alt' => 'Pushpin Alt' ],
			[ 'el icon_map_alt' => 'Map Alt' ],
			[ 'el icon_drawer_alt' => 'Drawer Alt' ],
			[ 'el icon_toolbox_alt' => 'Toolbox Alt' ],
			[ 'el icon_book_alt' => 'Book Alt' ],
			[ 'el icon_calendar' => 'Calendar' ],
			[ 'el icon_film' => 'Film' ],
			[ 'el icon_table' => 'Table' ],
			[ 'el icon_contacts_alt' => 'Contacts Alt' ],
			[ 'el icon_headphones' => 'Headphones' ],
			[ 'el icon_lifesaver' => 'Lifesaver' ],
			[ 'el icon_piechart' => 'Piechart' ],
			[ 'el icon_refresh' => 'Refresh' ],
			[ 'el icon_link_alt' => 'Link Alt' ],
			[ 'el icon_link' => 'Link' ],
			[ 'el icon_loading' => 'Loading' ],
			[ 'el icon_blocked' => 'Blocked' ],
			[ 'el icon_archive_alt' => 'Archive Alt' ],
			[ 'el icon_heart_alt' => 'Heart Alt' ],
			[ 'el icon_star_alt' => 'Star Alt' ],
			[ 'el icon_star-half_alt' => 'Star Half Alt' ],
			[ 'el icon_star' => 'Star' ],
			[ 'el icon_star-half' => 'Star Half' ],
			[ 'el icon_tools' => 'Tools' ],
			[ 'el icon_tool' => 'Tool' ],
			[ 'el icon_cog' => 'Cog' ],
			[ 'el icon_cogs' => 'Cogs' ],
			[ 'el icon_minus_alt' => 'Minus Alt' ],
			[ 'el icon_plus_alt' => 'Plus Alt' ],
			[ 'el icon_close_alt' => 'Close Alt' ],
			[ 'el icon_check_alt' => 'Check Alt' ],
			[ 'el icon_zoom-out' => 'Zoom Out' ],
			[ 'el icon_zoom-in' => 'Zoom In' ],
			[ 'el icon_stop_alt' => 'Stop Alt' ],
			[ 'el icon_menu-square_alt' => 'Menu Square Alt' ],
			[ 'el icon_menu-circle_alt' => 'Menu Circle Alt' ],
			[ 'el icon_document' => 'Document' ],
			[ 'el icon_documents' => 'Documents' ],
			[ 'el icon_pencil_alt' => 'Pencil Alt' ],
			[ 'el icon_folder' => 'Folder' ],
			[ 'el icon_folder-open' => 'Folder Open' ],
			[ 'el icon_folder-add' => 'Folder Add' ],
			[ 'el icon_folder_upload' => 'Folder Upload' ],
			[ 'el icon_folder_download' => 'Folder Download' ],
			[ 'el icon_info' => 'Info' ],
			[ 'el icon_error-circle' => 'Error Circle' ],
			[ 'el icon_error-oct' => 'Error Oct' ],
			[ 'el icon_error-triangle' => 'Error Triangle' ],
			[ 'el icon_question_alt' => 'Question Alt' ],
			[ 'el icon_comment' => 'Comment' ],
			[ 'el icon_chat' => 'Chat' ],
			[ 'el icon_vol-mute' => 'Vol Mute' ],
			[ 'el icon_volume-low' => 'Volume Low' ],
			[ 'el icon_volume-high' => 'Volume High' ],
			[ 'el icon_quotations_alt' => 'Quotations Alt' ],
			[ 'el icon_clock' => 'Clock' ],
			[ 'el icon_lock' => 'Lock' ],
			[ 'el icon_lock-open' => 'Lock Open' ],
			[ 'el icon_key' => 'Key' ],
			[ 'el icon_cloud' => 'Cloud' ],
			[ 'el icon_cloud-upload' => 'Cloud Upload' ],
			[ 'el icon_cloud-download' => 'Cloud Download' ],
			[ 'el icon_lightbulb' => 'Lightbulb' ],
			[ 'el icon_gift' => 'Gift' ],
			[ 'el icon_house' => 'House' ],
			[ 'el icon_camera' => 'Camera' ],
			[ 'el icon_mail' => 'Mail' ],
			[ 'el icon_cone' => 'Cone' ],
			[ 'el icon_ribbon' => 'Ribbon' ],
			[ 'el icon_bag' => 'Bag' ],
			[ 'el icon_cart' => 'Cart' ],
			[ 'el icon_tag' => 'Tag' ],
			[ 'el icon_tags' => 'Tags' ],
			[ 'el icon_trash' => 'Trash' ],
			[ 'el icon_cursor' => 'Cursor' ],
			[ 'el icon_mic' => 'Mic' ],
			[ 'el icon_compass' => 'Compass' ],
			[ 'el icon_pin' => 'Pin' ],
			[ 'el icon_pushpin' => 'Pushpin' ],
			[ 'el icon_map' => 'Map' ],
			[ 'el icon_drawer' => 'Drawer' ],
			[ 'el icon_toolbox' => 'Toolbox' ],
			[ 'el icon_book' => 'Book' ],
			[ 'el icon_contacts' => 'Contacts' ],
			[ 'el icon_archive' => 'Archive' ],
			[ 'el icon_heart' => 'Heart' ],
			[ 'el icon_profile' => 'Profile' ],
			[ 'el icon_group' => 'Group' ],
			[ 'el icon_grid-2x2' => 'Grid 2x2' ],
			[ 'el icon_grid-3x3' => 'Grid 3x3' ],
			[ 'el icon_music' => 'Music' ],
			[ 'el icon_pause_alt' => 'Pause Alt' ],
			[ 'el icon_phone' => 'Phone' ],
			[ 'el icon_upload' => 'Upload' ],
			[ 'el icon_download' => 'Download' ],
			[ 'el icon_printer' => 'Printer' ],
			[ 'el icon_calulator' => 'Calulator' ],
			[ 'el icon_building' => 'Building' ],
			[ 'el icon_floppy' => 'Floppy' ],
			[ 'el icon_drive' => 'Drive' ],
			[ 'el icon_search-2' => 'Search 2' ],
			[ 'el icon_id' => 'Id' ],
			[ 'el icon_id-2' => 'Id 2' ],
			[ 'el icon_puzzle' => 'Puzzle' ],
			[ 'el icon_like' => 'Like' ],
			[ 'el icon_dislike' => 'Dislike' ],
			[ 'el icon_mug' => 'Mug' ],
			[ 'el icon_currency' => 'Currency' ],
			[ 'el icon_wallet' => 'Wallet' ],
			[ 'el icon_pens' => 'Pens' ],
			[ 'el icon_easel' => 'Easel' ],
			[ 'el icon_flowchart' => 'Flowchart' ],
			[ 'el icon_datareport' => 'Datareport' ],
			[ 'el icon_briefcase' => 'Briefcase' ],
			[ 'el icon_shield' => 'Shield' ],
			[ 'el icon_percent' => 'Percent' ],
			[ 'el icon_globe' => 'Globe' ],
			[ 'el icon_globe-2' => 'Globe 2' ],
			[ 'el icon_target' => 'Target' ],
			[ 'el icon_hourglass' => 'Hourglass' ],
			[ 'el icon_balance' => 'Balance' ],
			[ 'el icon_rook' => 'Rook' ],
			[ 'el icon_printer-alt' => 'Printer Alt' ],
			[ 'el icon_calculator_alt' => 'Calculator Alt' ],
			[ 'el icon_building_alt' => 'Building Alt' ],
			[ 'el icon_floppy_alt' => 'Floppy Alt' ],
			[ 'el icon_drive_alt' => 'Drive Alt' ],
			[ 'el icon_search_alt' => 'Search Alt' ],
			[ 'el icon_id_alt' => 'Id Alt' ],
			[ 'el icon_id-2_alt' => 'Id 2 Alt' ],
			[ 'el icon_puzzle_alt' => 'Puzzle Alt' ],
			[ 'el icon_like_alt' => 'Like Alt' ],
			[ 'el icon_dislike_alt' => 'Dislike Alt' ],
			[ 'el icon_mug_alt' => 'Mug Alt' ],
			[ 'el icon_currency_alt' => 'Currency Alt' ],
			[ 'el icon_wallet_alt' => 'Wallet Alt' ],
			[ 'el icon_pens_alt' => 'Pens Alt' ],
			[ 'el icon_easel_alt' => 'Easel Alt' ],
			[ 'el icon_flowchart_alt' => 'Flowchart Alt' ],
			[ 'el icon_datareport_alt' => 'Datareport Alt' ],
			[ 'el icon_briefcase_alt' => 'Briefcase Alt' ],
			[ 'el icon_shield_alt' => 'Shield Alt' ],
			[ 'el icon_percent_alt' => 'Percent Alt' ],
			[ 'el icon_globe_alt' => 'Globe Alt' ],
			[ 'el icon_clipboard' => 'Clipboard' ],
		],
	];
}

/**
 * Font Awesome Icons.
 *
 * @return array
 */
function aheto_icons_font_awesome() {
	return [
		'New in 4.7'            => [
			[ 'fa fa-handshake-o' => 'Handshake Outlined' ],
			[ 'fa fa-envelope-open' => 'Envelope Open(email, e-mail, letter, support, mail, message, notification)' ],
			[ 'fa fa-envelope-open-o' => 'Envelope Open Outlined(email, e-mail, letter, support, mail, message, notification)' ],
			[ 'fa fa-linode' => 'Linode' ],
			[ 'fa fa-address-book' => 'Address Book' ],
			[ 'fa fa-address-book-o' => 'Address Book Outlined' ],
			[ 'fa fa-address-card' => 'Address Card(vcard)' ],
			[ 'fa fa-address-card-o' => 'Address Card Outlined(vcard-o)' ],
			[ 'fa fa-user-circle' => 'User Circle' ],
			[ 'fa fa-user-circle-o' => 'User Circle Outlined' ],
			[ 'fa fa-user-o' => 'User Outlined' ],
			[ 'fa fa-id-badge' => 'Identification Badge' ],
			[ 'fa fa-id-card' => 'Identification Card(drivers-license)' ],
			[ 'fa fa-id-card-o' => 'Identification Card Outlined(drivers-license-o)' ],
			[ 'fa fa-quora' => 'Quora' ],
			[ 'fa fa-free-code-camp' => 'Free Code Camp' ],
			[ 'fa fa-telegram' => 'Telegram' ],
			[ 'fa fa-thermometer-full' => 'Thermometer Full(thermometer-4, thermometer)' ],
			[ 'fa fa-thermometer-three-quarters' => 'Thermometer 3/4 Full(thermometer-3)' ],
			[ 'fa fa-thermometer-half' => 'Thermometer 1/2 Full(thermometer-2)' ],
			[ 'fa fa-thermometer-quarter' => 'Thermometer 1/4 Full(thermometer-1)' ],
			[ 'fa fa-thermometer-empty' => 'Thermometer Empty(thermometer-0)' ],
			[ 'fa fa-shower' => 'Shower' ],
			[ 'fa fa-bath' => 'Bath(bathtub, s15)' ],
			[ 'fa fa-podcast' => 'Podcast' ],
			[ 'fa fa-window-maximize' => 'Window Maximize' ],
			[ 'fa fa-window-minimize' => 'Window Minimize' ],
			[ 'fa fa-window-restore' => 'Window Restore' ],
			[ 'fa fa-window-close' => 'Window Close(times-rectangle)' ],
			[ 'fa fa-window-close-o' => 'Window Close Outline(times-rectangle-o)' ],
			[ 'fa fa-bandcamp' => 'Bandcamp' ],
			[ 'fa fa-grav' => 'Grav' ],
			[ 'fa fa-etsy' => 'Etsy' ],
			[ 'fa fa-imdb' => 'IMDB' ],
			[ 'fa fa-ravelry' => 'Ravelry' ],
			[ 'fa fa-eercast' => 'Eercast' ],
			[ 'fa fa-microchip' => 'Microchip' ],
			[ 'fa fa-snowflake-o' => 'Snowflake Outlined' ],
			[ 'fa fa-superpowers' => 'Superpowers' ],
			[ 'fa fa-wpexplorer' => 'WPExplorer' ],
			[ 'fa fa-meetup' => 'Meetup' ],
		],
		'Web Application Icons' => [
			[ 'fa fa-glass' => 'Glass(martini, drink, bar, alcohol, liquor)' ],
			[ 'fa fa-music' => 'Music(note, sound)' ],
			[ 'fa fa-search' => 'Search(magnify, zoom, enlarge, bigger)' ],
			[ 'fa fa-envelope-o' => 'Envelope Outlined(email, e-mail, letter, support, mail, message, notification)' ],
			[ 'fa fa-heart' => 'Heart(love, like, favorite)' ],
			[ 'fa fa-star' => 'Star(award, achievement, night, rating, score, favorite)' ],
			[ 'fa fa-star-o' => 'Star Outlined(award, achievement, night, rating, score, favorite)' ],
			[ 'fa fa-user' => 'User(person, man, head, profile)' ],
			[ 'fa fa-film' => 'Film(movie)' ],
			[ 'fa fa-check' => 'Check(checkmark, done, todo, agree, accept, confirm, tick, ok)' ],
			[ 'fa fa-times' => 'Times(close, exit, x, cross)(remove, close)' ],
			[ 'fa fa-search-plus' => 'Search Plus(magnify, zoom, enlarge, bigger)' ],
			[ 'fa fa-search-minus' => 'Search Minus(magnify, minify, zoom, smaller)' ],
			[ 'fa fa-power-off' => 'Power Off(on)' ],
			[ 'fa fa-signal' => 'signal(graph, bars)' ],
			[ 'fa fa-cog' => 'cog(settings)(gear)' ],
			[ 'fa fa-trash-o' => 'Trash Outlined(garbage, delete, remove, trash, hide)' ],
			[ 'fa fa-home' => 'home(main, house)' ],
			[ 'fa fa-clock-o' => 'Clock Outlined(watch, timer, late, timestamp)' ],
			[ 'fa fa-road' => 'road(street)' ],
			[ 'fa fa-download' => 'Download(import)' ],
			[ 'fa fa-inbox' => 'inbox' ],
			[ 'fa fa-refresh' => 'refresh(reload, sync)' ],
			[ 'fa fa-lock' => 'lock(protect, admin, security)' ],
			[ 'fa fa-flag' => 'flag(report, notification, notify)' ],
			[ 'fa fa-headphones' => 'headphones(sound, listen, music, audio)' ],
			[ 'fa fa-volume-off' => 'volume-off(audio, mute, sound, music)' ],
			[ 'fa fa-volume-down' => 'volume-down(audio, lower, quieter, sound, music)' ],
			[ 'fa fa-volume-up' => 'volume-up(audio, higher, louder, sound, music)' ],
			[ 'fa fa-qrcode' => 'qrcode(scan)' ],
			[ 'fa fa-barcode' => 'barcode(scan)' ],
			[ 'fa fa-tag' => 'tag(label)' ],
			[ 'fa fa-tags' => 'tags(labels)' ],
			[ 'fa fa-book' => 'book(read, documentation)' ],
			[ 'fa fa-bookmark' => 'bookmark(save)' ],
			[ 'fa fa-print' => 'print' ],
			[ 'fa fa-camera' => 'camera(photo, picture, record)' ],
			[ 'fa fa-video-camera' => 'Video Camera(film, movie, record)' ],
			[ 'fa fa-picture-o' => 'Picture Outlined(photo, image)' ],
			[ 'fa fa-pencil' => 'pencil(write, edit, update)' ],
			[ 'fa fa-map-marker' => 'map-marker(map, pin, location, coordinates, localize, address, travel, where, place)' ],
			[ 'fa fa-adjust' => 'adjust(contrast)' ],
			[ 'fa fa-tint' => 'tint(raindrop, waterdrop, drop, droplet)' ],
			[ 'fa fa-pencil-square-o' => 'Pencil Square Outlined(write, edit, update)(edit)' ],
			[ 'fa fa-share-square-o' => 'Share Square Outlined(social, send, arrow)' ],
			[ 'fa fa-check-square-o' => 'Check Square Outlined(todo, done, agree, accept, confirm, ok)' ],
			[ 'fa fa-arrows' => 'Arrows(move, reorder, resize)' ],
			[ 'fa fa-plus-circle' => 'Plus Circle(add, new, create, expand)' ],
			[ 'fa fa-minus-circle' => 'Minus Circle(delete, remove, trash, hide)' ],
			[ 'fa fa-times-circle' => 'Times Circle(close, exit, x)' ],
			[ 'fa fa-check-circle' => 'Check Circle(todo, done, agree, accept, confirm, ok)' ],
			[ 'fa fa-question-circle' => 'Question Circle(help, information, unknown, support)' ],
			[ 'fa fa-info-circle' => 'Info Circle(help, information, more, details)' ],
			[ 'fa fa-crosshairs' => 'Crosshairs(picker)' ],
			[ 'fa fa-times-circle-o' => 'Times Circle Outlined(close, exit, x)' ],
			[ 'fa fa-check-circle-o' => 'Check Circle Outlined(todo, done, agree, accept, confirm, ok)' ],
			[ 'fa fa-ban' => 'ban(delete, remove, trash, hide, block, stop, abort, cancel)' ],
			[ 'fa fa-share' => 'Share(mail-forward)' ],
			[ 'fa fa-plus' => 'plus(add, new, create, expand)' ],
			[ 'fa fa-minus' => 'minus(hide, minify, delete, remove, trash, hide, collapse)' ],
			[ 'fa fa-asterisk' => 'asterisk(details)' ],
			[ 'fa fa-exclamation-circle' => 'Exclamation Circle(warning, error, problem, notification, alert)' ],
			[ 'fa fa-gift' => 'gift(present)' ],
			[ 'fa fa-leaf' => 'leaf(eco, nature, plant)' ],
			[ 'fa fa-fire' => 'fire(flame, hot, popular)' ],
			[ 'fa fa-eye' => 'Eye(show, visible, views)' ],
			[ 'fa fa-eye-slash' => 'Eye Slash(toggle, show, hide, visible, visiblity, views)' ],
			[ 'fa fa-exclamation-triangle' => 'Exclamation Triangle(warning, error, problem, notification, alert)(warning)' ],
			[ 'fa fa-plane' => 'plane(travel, trip, location, destination, airplane, fly, mode)' ],
			[ 'fa fa-calendar' => 'calendar(date, time, when, event)' ],
			[ 'fa fa-random' => 'random(sort, shuffle)' ],
			[ 'fa fa-comment' => 'comment(speech, notification, note, chat, bubble, feedback, message, texting, sms, conversation)' ],
			[ 'fa fa-magnet' => 'magnet' ],
			[ 'fa fa-retweet' => 'retweet(refresh, reload, share)' ],
			[ 'fa fa-shopping-cart' => 'shopping-cart(checkout, buy, purchase, payment)' ],
			[ 'fa fa-folder' => 'Folder' ],
			[ 'fa fa-folder-open' => 'Folder Open' ],
			[ 'fa fa-arrows-v' => 'Arrows Vertical(resize)' ],
			[ 'fa fa-arrows-h' => 'Arrows Horizontal(resize)' ],
			[ 'fa fa-bar-chart' => 'Bar Chart(graph, analytics, statistics)(bar-chart-o)' ],
			[ 'fa fa-camera-retro' => 'camera-retro(photo, picture, record)' ],
			[ 'fa fa-key' => 'key(unlock, password)' ],
			[ 'fa fa-cogs' => 'cogs(settings)(gears)' ],
			[ 'fa fa-comments' => 'comments(speech, notification, note, chat, bubble, feedback, message, texting, sms, conversation)' ],
			[ 'fa fa-thumbs-o-up' => 'Thumbs Up Outlined(like, approve, favorite, agree, hand)' ],
			[ 'fa fa-thumbs-o-down' => 'Thumbs Down Outlined(dislike, disapprove, disagree, hand)' ],
			[ 'fa fa-star-half' => 'star-half(award, achievement, rating, score)' ],
			[ 'fa fa-heart-o' => 'Heart Outlined(love, like, favorite)' ],
			[ 'fa fa-sign-out' => 'Sign Out(log out, logout, leave, exit, arrow)' ],
			[ 'fa fa-thumb-tack' => 'Thumb Tack(marker, pin, location, coordinates)' ],
			[ 'fa fa-external-link' => 'External Link(open, new)' ],
			[ 'fa fa-sign-in' => 'Sign In(enter, join, log in, login, sign up, sign in, signin, signup, arrow)' ],
			[ 'fa fa-trophy' => 'trophy(award, achievement, cup, winner, game)' ],
			[ 'fa fa-upload' => 'Upload(import)' ],
			[ 'fa fa-lemon-o' => 'Lemon Outlined(food)' ],
			[ 'fa fa-phone' => 'Phone(call, voice, number, support, earphone, telephone)' ],
			[ 'fa fa-square-o' => 'Square Outlined(block, square, box)' ],
			[ 'fa fa-bookmark-o' => 'Bookmark Outlined(save)' ],
			[ 'fa fa-phone-square' => 'Phone Square(call, voice, number, support, telephone)' ],
			[ 'fa fa-unlock' => 'unlock(protect, admin, password, lock)' ],
			[ 'fa fa-credit-card' => 'credit-card(money, buy, debit, checkout, purchase, payment)' ],
			[ 'fa fa-rss' => 'rss(blog)(feed)' ],
			[ 'fa fa-hdd-o' => 'HDD(harddrive, hard drive, storage, save)' ],
			[ 'fa fa-bullhorn' => 'bullhorn(announcement, share, broadcast, louder, megaphone)' ],
			[ 'fa fa-bell' => 'bell(alert, reminder, notification)' ],
			[ 'fa fa-certificate' => 'certificate(badge, star)' ],
			[ 'fa fa-globe' => 'Globe(world, planet, map, place, travel, earth, global, translate, all, language, localize, location, coordinates, country)' ],
			[ 'fa fa-wrench' => 'Wrench(settings, fix, update, spanner)' ],
			[ 'fa fa-tasks' => 'Tasks(progress, loading, downloading, downloads, settings)' ],
			[ 'fa fa-filter' => 'Filter(funnel, options)' ],
			[ 'fa fa-briefcase' => 'Briefcase(work, business, office, luggage, bag)' ],
			[ 'fa fa-users' => 'Users(people, profiles, persons)(group)' ],
			[ 'fa fa-cloud' => 'Cloud(save)' ],
			[ 'fa fa-flask' => 'Flask(science, beaker, experimental, labs)' ],
			[ 'fa fa-square' => 'Square(block, box)' ],
			[ 'fa fa-bars' => 'Bars(menu, drag, reorder, settings, list, ul, ol, checklist, todo, list, hamburger)(navicon, reorder)' ],
			[ 'fa fa-magic' => 'magic(wizard, automatic, autocomplete)' ],
			[ 'fa fa-truck' => 'truck(shipping)' ],
			[ 'fa fa-money' => 'Money(cash, money, buy, checkout, purchase, payment)' ],
			[ 'fa fa-sort' => 'Sort(order)(unsorted)' ],
			[ 'fa fa-sort-desc' => 'Sort Descending(dropdown, more, menu, arrow)(sort-down)' ],
			[ 'fa fa-sort-asc' => 'Sort Ascending(arrow)(sort-up)' ],
			[ 'fa fa-envelope' => 'Envelope(email, e-mail, letter, support, mail, message, notification)' ],
			[ 'fa fa-gavel' => 'Gavel(judge, lawyer, opinion)(legal)' ],
			[ 'fa fa-tachometer' => 'Tachometer(speedometer, fast)(dashboard)' ],
			[ 'fa fa-comment-o' => 'comment-o(speech, notification, note, chat, bubble, feedback, message, texting, sms, conversation)' ],
			[ 'fa fa-comments-o' => 'comments-o(speech, notification, note, chat, bubble, feedback, message, texting, sms, conversation)' ],
			[ 'fa fa-bolt' => 'Lightning Bolt(lightning, weather)(flash)' ],
			[ 'fa fa-sitemap' => 'Sitemap(directory, hierarchy, organization)' ],
			[ 'fa fa-umbrella' => 'Umbrella' ],
			[ 'fa fa-lightbulb-o' => 'Lightbulb Outlined(idea, inspiration)' ],
			[ 'fa fa-exchange' => 'Exchange(transfer, arrows, arrow)' ],
			[ 'fa fa-cloud-download' => 'Cloud Download(import)' ],
			[ 'fa fa-cloud-upload' => 'Cloud Upload(import)' ],
			[ 'fa fa-suitcase' => 'Suitcase(trip, luggage, travel, move, baggage)' ],
			[ 'fa fa-bell-o' => 'Bell Outlined(alert, reminder, notification)' ],
			[ 'fa fa-coffee' => 'Coffee(morning, mug, breakfast, tea, drink, cafe)' ],
			[ 'fa fa-cutlery' => 'Cutlery(food, restaurant, spoon, knife, dinner, eat)' ],
			[ 'fa fa-building-o' => 'Building Outlined(work, business, apartment, office, company)' ],
			[ 'fa fa-fighter-jet' => 'fighter-jet(fly, plane, airplane, quick, fast, travel)' ],
			[ 'fa fa-beer' => 'beer(alcohol, stein, drink, mug, bar, liquor)' ],
			[ 'fa fa-plus-square' => 'Plus Square(add, new, create, expand)' ],
			[ 'fa fa-desktop' => 'Desktop(monitor, screen, desktop, computer, demo, device)' ],
			[ 'fa fa-laptop' => 'Laptop(demo, computer, device)' ],
			[ 'fa fa-tablet' => 'tablet(ipad, device)' ],
			[ 'fa fa-mobile' => 'Mobile Phone(cell phone, cellphone, text, call, iphone, number, telephone)(mobile-phone)' ],
			[ 'fa fa-circle-o' => 'Circle Outlined' ],
			[ 'fa fa-quote-left' => 'quote-left' ],
			[ 'fa fa-quote-right' => 'quote-right' ],
			[ 'fa fa-spinner' => 'Spinner(loading, progress)' ],
			[ 'fa fa-circle' => 'Circle(dot, notification)' ],
			[ 'fa fa-reply' => 'Reply(mail-reply)' ],
			[ 'fa fa-folder-o' => 'Folder Outlined' ],
			[ 'fa fa-folder-open-o' => 'Folder Open Outlined' ],
			[ 'fa fa-smile-o' => 'Smile Outlined(face, emoticon, happy, approve, satisfied, rating)' ],
			[ 'fa fa-frown-o' => 'Frown Outlined(face, emoticon, sad, disapprove, rating)' ],
			[ 'fa fa-meh-o' => 'Meh Outlined(face, emoticon, rating, neutral)' ],
			[ 'fa fa-gamepad' => 'Gamepad(controller)' ],
			[ 'fa fa-keyboard-o' => 'Keyboard Outlined(type, input)' ],
			[ 'fa fa-flag-o' => 'Flag Outlined(report, notification)' ],
			[ 'fa fa-flag-checkered' => 'flag-checkered(report, notification, notify)' ],
			[ 'fa fa-terminal' => 'Terminal(command, prompt, code)' ],
			[ 'fa fa-code' => 'Code(html, brackets)' ],
			[ 'fa fa-reply-all' => 'reply-all(mail-reply-all)' ],
			[ 'fa fa-star-half-o' => 'Star Half Outlined(award, achievement, rating, score)(star-half-empty, star-half-full)' ],
			[ 'fa fa-location-arrow' => 'location-arrow(map, coordinates, location, address, place, where)' ],
			[ 'fa fa-crop' => 'crop' ],
			[ 'fa fa-code-fork' => 'code-fork(git, fork, vcs, svn, github, rebase, version, merge)' ],
			[ 'fa fa-question' => 'Question(help, information, unknown, support)' ],
			[ 'fa fa-info' => 'Info(help, information, more, details)' ],
			[ 'fa fa-exclamation' => 'exclamation(warning, error, problem, notification, notify, alert)' ],
			[ 'fa fa-eraser' => 'eraser(remove, delete)' ],
			[ 'fa fa-puzzle-piece' => 'Puzzle Piece(addon, add-on, section)' ],
			[ 'fa fa-microphone' => 'microphone(record, voice, sound)' ],
			[ 'fa fa-microphone-slash' => 'Microphone Slash(record, voice, sound, mute)' ],
			[ 'fa fa-shield' => 'shield(award, achievement, security, winner)' ],
			[ 'fa fa-calendar-o' => 'calendar-o(date, time, when, event)' ],
			[ 'fa fa-fire-extinguisher' => 'fire-extinguisher' ],
			[ 'fa fa-rocket' => 'rocket(app)' ],
			[ 'fa fa-anchor' => 'Anchor(link)' ],
			[ 'fa fa-unlock-alt' => 'Unlock Alt(protect, admin, password, lock)' ],
			[ 'fa fa-bullseye' => 'Bullseye(target)' ],
			[ 'fa fa-ellipsis-h' => 'Ellipsis Horizontal(dots)' ],
			[ 'fa fa-ellipsis-v' => 'Ellipsis Vertical(dots)' ],
			[ 'fa fa-rss-square' => 'RSS Square(feed, blog)' ],
			[ 'fa fa-ticket' => 'Ticket(movie, pass, support)' ],
			[ 'fa fa-minus-square' => 'Minus Square(hide, minify, delete, remove, trash, hide, collapse)' ],
			[ 'fa fa-minus-square-o' => 'Minus Square Outlined(hide, minify, delete, remove, trash, hide, collapse)' ],
			[ 'fa fa-level-up' => 'Level Up(arrow)' ],
			[ 'fa fa-level-down' => 'Level Down(arrow)' ],
			[ 'fa fa-check-square' => 'Check Square(checkmark, done, todo, agree, accept, confirm, ok)' ],
			[ 'fa fa-pencil-square' => 'Pencil Square(write, edit, update)' ],
			[ 'fa fa-external-link-square' => 'External Link Square(open, new)' ],
			[ 'fa fa-share-square' => 'Share Square(social, send)' ],
			[ 'fa fa-compass' => 'Compass(safari, directory, menu, location)' ],
			[ 'fa fa-caret-square-o-down' => 'Caret Square Outlined Down(more, dropdown, menu)(toggle-down)' ],
			[ 'fa fa-caret-square-o-up' => 'Caret Square Outlined Up(toggle-up)' ],
			[ 'fa fa-caret-square-o-right' => 'Caret Square Outlined Right(next, forward)(toggle-right)' ],
			[ 'fa fa-sort-alpha-asc' => 'Sort Alpha Ascending' ],
			[ 'fa fa-sort-alpha-desc' => 'Sort Alpha Descending' ],
			[ 'fa fa-sort-amount-asc' => 'Sort Amount Ascending' ],
			[ 'fa fa-sort-amount-desc' => 'Sort Amount Descending' ],
			[ 'fa fa-sort-numeric-asc' => 'Sort Numeric Ascending(numbers)' ],
			[ 'fa fa-sort-numeric-desc' => 'Sort Numeric Descending(numbers)' ],
			[ 'fa fa-thumbs-up' => 'thumbs-up(like, favorite, approve, agree, hand)' ],
			[ 'fa fa-thumbs-down' => 'thumbs-down(dislike, disapprove, disagree, hand)' ],
			[ 'fa fa-female' => 'Female(woman, user, person, profile)' ],
			[ 'fa fa-male' => 'Male(man, user, person, profile)' ],
			[ 'fa fa-sun-o' => 'Sun Outlined(weather, contrast, lighter, brighten, day)' ],
			[ 'fa fa-moon-o' => 'Moon Outlined(night, darker, contrast)' ],
			[ 'fa fa-archive' => 'Archive(box, storage)' ],
			[ 'fa fa-bug' => 'Bug(report, insect)' ],
			[ 'fa fa-caret-square-o-left' => 'Caret Square Outlined Left(previous, back)(toggle-left)' ],
			[ 'fa fa-dot-circle-o' => 'Dot Circle Outlined(target, bullseye, notification)' ],
			[ 'fa fa-wheelchair' => 'Wheelchair(handicap, person)' ],
			[ 'fa fa-plus-square-o' => 'Plus Square Outlined(add, new, create, expand)' ],
			[ 'fa fa-space-shuttle' => 'Space Shuttle' ],
			[ 'fa fa-envelope-square' => 'Envelope Square(email, e-mail, letter, support, mail, message, notification)' ],
			[ 'fa fa-university' => 'University(institution, bank)' ],
			[ 'fa fa-graduation-cap' => 'Graduation Cap(learning, school, student)(mortar-board)' ],
			[ 'fa fa-language' => 'Language(translate)' ],
			[ 'fa fa-fax' => 'Fax' ],
			[ 'fa fa-building' => 'Building(work, business, apartment, office, company)' ],
			[ 'fa fa-child' => 'Child' ],
			[ 'fa fa-paw' => 'Paw(pet)' ],
			[ 'fa fa-spoon' => 'spoon' ],
			[ 'fa fa-cube' => 'Cube' ],
			[ 'fa fa-cubes' => 'Cubes' ],
			[ 'fa fa-recycle' => 'Recycle' ],
			[ 'fa fa-car' => 'Car(vehicle)(automobile)' ],
			[ 'fa fa-taxi' => 'Taxi(vehicle)(cab)' ],
			[ 'fa fa-tree' => 'Tree' ],
			[ 'fa fa-database' => 'Database' ],
			[ 'fa fa-file-pdf-o' => 'PDF File Outlined' ],
			[ 'fa fa-file-word-o' => 'Word File Outlined' ],
			[ 'fa fa-file-excel-o' => 'Excel File Outlined' ],
			[ 'fa fa-file-powerpoint-o' => 'Powerpoint File Outlined' ],
			[ 'fa fa-file-image-o' => 'Image File Outlined(file-photo-o, file-picture-o)' ],
			[ 'fa fa-file-archive-o' => 'Archive File Outlined(file-zip-o)' ],
			[ 'fa fa-file-audio-o' => 'Audio File Outlined(file-sound-o)' ],
			[ 'fa fa-file-video-o' => 'Video File Outlined(file-movie-o)' ],
			[ 'fa fa-file-code-o' => 'Code File Outlined' ],
			[ 'fa fa-life-ring' => 'Life Ring(life-bouy, life-buoy, life-saver, support)' ],
			[ 'fa fa-circle-o-notch' => 'Circle Outlined Notched' ],
			[ 'fa fa-paper-plane' => 'Paper Plane(send)' ],
			[ 'fa fa-paper-plane-o' => 'Paper Plane Outlined(send-o)' ],
			[ 'fa fa-history' => 'History' ],
			[ 'fa fa-circle-thin' => 'Circle Outlined Thin' ],
			[ 'fa fa-sliders' => 'Sliders(settings)' ],
			[ 'fa fa-share-alt' => 'Share Alt' ],
			[ 'fa fa-share-alt-square' => 'Share Alt Square' ],
			[ 'fa fa-bomb' => 'Bomb' ],
			[ 'fa fa-futbol-o' => 'Futbol Outlined(soccer-ball-o)' ],
			[ 'fa fa-tty' => 'TTY' ],
			[ 'fa fa-binoculars' => 'Binoculars' ],
			[ 'fa fa-plug' => 'Plug(power, connect)' ],
			[ 'fa fa-newspaper-o' => 'Newspaper Outlined(press)' ],
			[ 'fa fa-wifi' => 'WiFi' ],
			[ 'fa fa-calculator' => 'Calculator' ],
			[ 'fa fa-bell-slash' => 'Bell Slash' ],
			[ 'fa fa-bell-slash-o' => 'Bell Slash Outlined' ],
			[ 'fa fa-trash' => 'Trash(garbage, delete, remove, hide)' ],
			[ 'fa fa-copyright' => 'Copyright' ],
			[ 'fa fa-at' => 'At(email, e-mail)' ],
			[ 'fa fa-eyedropper' => 'Eyedropper' ],
			[ 'fa fa-paint-brush' => 'Paint Brush' ],
			[ 'fa fa-birthday-cake' => 'Birthday Cake' ],
			[ 'fa fa-area-chart' => 'Area Chart(graph, analytics, statistics)' ],
			[ 'fa fa-pie-chart' => 'Pie Chart(graph, analytics, statistics)' ],
			[ 'fa fa-line-chart' => 'Line Chart(graph, analytics, statistics)' ],
			[ 'fa fa-toggle-off' => 'Toggle Off' ],
			[ 'fa fa-toggle-on' => 'Toggle On' ],
			[ 'fa fa-bicycle' => 'Bicycle(vehicle, bike)' ],
			[ 'fa fa-bus' => 'Bus(vehicle)' ],
			[ 'fa fa-cc' => 'Closed Captions' ],
			[ 'fa fa-cart-plus' => 'Add to Shopping Cart(add, shopping)' ],
			[ 'fa fa-cart-arrow-down' => 'Shopping Cart Arrow Down(shopping)' ],
			[ 'fa fa-diamond' => 'Diamond(gem, gemstone)' ],
			[ 'fa fa-ship' => 'Ship(boat, sea)' ],
			[ 'fa fa-user-secret' => 'User Secret(whisper, spy, incognito, privacy)' ],
			[ 'fa fa-motorcycle' => 'Motorcycle(vehicle, bike)' ],
			[ 'fa fa-street-view' => 'Street View(map)' ],
			[ 'fa fa-heartbeat' => 'Heartbeat(ekg)' ],
			[ 'fa fa-server' => 'Server' ],
			[ 'fa fa-user-plus' => 'Add User(sign up, signup)' ],
			[ 'fa fa-user-times' => 'Remove User' ],
			[ 'fa fa-bed' => 'Bed(travel)(hotel)' ],
			[ 'fa fa-battery-full' => 'Battery Full(power)(battery-4, battery)' ],
			[ 'fa fa-battery-three-quarters' => 'Battery 3/4 Full(power)(battery-3)' ],
			[ 'fa fa-battery-half' => 'Battery 1/2 Full(power)(battery-2)' ],
			[ 'fa fa-battery-quarter' => 'Battery 1/4 Full(power)(battery-1)' ],
			[ 'fa fa-battery-empty' => 'Battery Empty(power)(battery-0)' ],
			[ 'fa fa-mouse-pointer' => 'Mouse Pointer' ],
			[ 'fa fa-i-cursor' => 'I Beam Cursor' ],
			[ 'fa fa-object-group' => 'Object Group' ],
			[ 'fa fa-object-ungroup' => 'Object Ungroup' ],
			[ 'fa fa-sticky-note' => 'Sticky Note' ],
			[ 'fa fa-sticky-note-o' => 'Sticky Note Outlined' ],
			[ 'fa fa-clone' => 'Clone(copy)' ],
			[ 'fa fa-balance-scale' => 'Balance Scale' ],
			[ 'fa fa-hourglass-o' => 'Hourglass Outlined' ],
			[ 'fa fa-hourglass-start' => 'Hourglass Start(hourglass-1)' ],
			[ 'fa fa-hourglass-half' => 'Hourglass Half(hourglass-2)' ],
			[ 'fa fa-hourglass-end' => 'Hourglass End(hourglass-3)' ],
			[ 'fa fa-hourglass' => 'Hourglass' ],
			[ 'fa fa-hand-rock-o' => 'Rock (Hand)(hand-grab-o)' ],
			[ 'fa fa-hand-paper-o' => 'Paper (Hand)(stop)(hand-stop-o)' ],
			[ 'fa fa-hand-scissors-o' => 'Scissors (Hand)' ],
			[ 'fa fa-hand-lizard-o' => 'Lizard (Hand)' ],
			[ 'fa fa-hand-spock-o' => 'Spock (Hand)' ],
			[ 'fa fa-hand-pointer-o' => 'Hand Pointer' ],
			[ 'fa fa-hand-peace-o' => 'Hand Peace' ],
			[ 'fa fa-trademark' => 'Trademark' ],
			[ 'fa fa-registered' => 'Registered Trademark' ],
			[ 'fa fa-creative-commons' => 'Creative Commons' ],
			[ 'fa fa-television' => 'Television(display, computer, monitor)(tv)' ],
			[ 'fa fa-calendar-plus-o' => 'Calendar Plus Outlined' ],
			[ 'fa fa-calendar-minus-o' => 'Calendar Minus Outlined' ],
			[ 'fa fa-calendar-times-o' => 'Calendar Times Outlined' ],
			[ 'fa fa-calendar-check-o' => 'Calendar Check Outlined(ok)' ],
			[ 'fa fa-industry' => 'Industry(factory)' ],
			[ 'fa fa-map-pin' => 'Map Pin' ],
			[ 'fa fa-map-signs' => 'Map Signs' ],
			[ 'fa fa-map-o' => 'Map Outlined' ],
			[ 'fa fa-map' => 'Map' ],
			[ 'fa fa-commenting' => 'Commenting(speech, notification, note, chat, bubble, feedback, message, texting, sms, conversation)' ],
			[ 'fa fa-commenting-o' => 'Commenting Outlined(speech, notification, note, chat, bubble, feedback, message, texting, sms, conversation)' ],
			[ 'fa fa-credit-card-alt' => 'Credit Card(money, buy, debit, checkout, purchase, payment, credit card)' ],
			[ 'fa fa-shopping-bag' => 'Shopping Bag' ],
			[ 'fa fa-shopping-basket' => 'Shopping Basket' ],
			[ 'fa fa-hashtag' => 'Hashtag' ],
			[ 'fa fa-bluetooth' => 'Bluetooth' ],
			[ 'fa fa-bluetooth-b' => 'Bluetooth' ],
			[ 'fa fa-percent' => 'Percent' ],
			[ 'fa fa-universal-access' => 'Universal Access' ],
			[ 'fa fa-wheelchair-alt' => 'Wheelchair Alt(handicap, person)' ],
			[ 'fa fa-question-circle-o' => 'Question Circle Outlined' ],
			[ 'fa fa-blind' => 'Blind' ],
			[ 'fa fa-audio-description' => 'Audio Description' ],
			[ 'fa fa-volume-control-phone' => 'Volume Control Phone(telephone)' ],
			[ 'fa fa-braille' => 'Braille' ],
			[ 'fa fa-assistive-listening-systems' => 'Assistive Listening Systems' ],
			[ 'fa fa-american-sign-language-interpreting' => 'American Sign Language Interpreting(asl-interpreting)' ],
			[ 'fa fa-deaf' => 'Deaf(deafness, hard-of-hearing)' ],
			[ 'fa fa-sign-language' => 'Sign Language(signing)' ],
			[ 'fa fa-low-vision' => 'Low Vision' ],
			[ 'fa fa-handshake-o' => 'Handshake Outlined' ],
			[ 'fa fa-envelope-open' => 'Envelope Open(email, e-mail, letter, support, mail, message, notification)' ],
			[ 'fa fa-envelope-open-o' => 'Envelope Open Outlined(email, e-mail, letter, support, mail, message, notification)' ],
			[ 'fa fa-address-book' => 'Address Book' ],
			[ 'fa fa-address-book-o' => 'Address Book Outlined' ],
			[ 'fa fa-address-card' => 'Address Card(vcard)' ],
			[ 'fa fa-address-card-o' => 'Address Card Outlined(vcard-o)' ],
			[ 'fa fa-user-circle' => 'User Circle' ],
			[ 'fa fa-user-circle-o' => 'User Circle Outlined' ],
			[ 'fa fa-user-o' => 'User Outlined' ],
			[ 'fa fa-id-badge' => 'Identification Badge' ],
			[ 'fa fa-id-card' => 'Identification Card(drivers-license)' ],
			[ 'fa fa-id-card-o' => 'Identification Card Outlined(drivers-license-o)' ],
			[ 'fa fa-thermometer-full' => 'Thermometer Full(thermometer-4, thermometer)' ],
			[ 'fa fa-thermometer-three-quarters' => 'Thermometer 3/4 Full(thermometer-3)' ],
			[ 'fa fa-thermometer-half' => 'Thermometer 1/2 Full(thermometer-2)' ],
			[ 'fa fa-thermometer-quarter' => 'Thermometer 1/4 Full(thermometer-1)' ],
			[ 'fa fa-thermometer-empty' => 'Thermometer Empty(thermometer-0)' ],
			[ 'fa fa-shower' => 'Shower' ],
			[ 'fa fa-bath' => 'Bath(bathtub, s15)' ],
			[ 'fa fa-podcast' => 'Podcast' ],
			[ 'fa fa-window-maximize' => 'Window Maximize' ],
			[ 'fa fa-window-minimize' => 'Window Minimize' ],
			[ 'fa fa-window-restore' => 'Window Restore' ],
			[ 'fa fa-window-close' => 'Window Close(times-rectangle)' ],
			[ 'fa fa-window-close-o' => 'Window Close Outline(times-rectangle-o)' ],
			[ 'fa fa-microchip' => 'Microchip' ],
			[ 'fa fa-snowflake-o' => 'Snowflake Outlined' ],
		],
		'Medical Icons'         => [
			[ 'fa fa-heart' => 'Heart(love, like, favorite)' ],
			[ 'fa fa-heart-o' => 'Heart Outlined(love, like, favorite)' ],
			[ 'fa fa-user-md' => 'user-md(doctor, profile, medical, nurse)' ],
			[ 'fa fa-stethoscope' => 'Stethoscope' ],
			[ 'fa fa-hospital-o' => 'hospital Outlined(building)' ],
			[ 'fa fa-ambulance' => 'ambulance(vehicle, support, help)' ],
			[ 'fa fa-medkit' => 'medkit(first aid, firstaid, help, support, health)' ],
			[ 'fa fa-h-square' => 'H Square(hospital, hotel)' ],
			[ 'fa fa-plus-square' => 'Plus Square(add, new, create, expand)' ],
			[ 'fa fa-wheelchair' => 'Wheelchair(handicap, person)' ],
			[ 'fa fa-heartbeat' => 'Heartbeat(ekg)' ],
			[ 'fa fa-wheelchair-alt' => 'Wheelchair Alt(handicap, person)' ],
		],
		'Text Editor Icons'     => [
			[ 'fa fa-th-large' => 'th-large(blocks, squares, boxes, grid)' ],
			[ 'fa fa-th' => 'th(blocks, squares, boxes, grid)' ],
			[ 'fa fa-th-list' => 'th-list(ul, ol, checklist, finished, completed, done, todo)' ],
			[ 'fa fa-file-o' => 'File Outlined(new, page, pdf, document)' ],
			[ 'fa fa-repeat' => 'Repeat(redo, forward)(rotate-right)' ],
			[ 'fa fa-list-alt' => 'list-alt(ul, ol, checklist, finished, completed, done, todo)' ],
			[ 'fa fa-font' => 'font(text)' ],
			[ 'fa fa-bold' => 'bold' ],
			[ 'fa fa-italic' => 'italic(italics)' ],
			[ 'fa fa-text-height' => 'text-height' ],
			[ 'fa fa-text-width' => 'text-width' ],
			[ 'fa fa-align-left' => 'align-left(text)' ],
			[ 'fa fa-align-center' => 'align-center(middle, text)' ],
			[ 'fa fa-align-right' => 'align-right(text)' ],
			[ 'fa fa-align-justify' => 'align-justify(text)' ],
			[ 'fa fa-list' => 'list(ul, ol, checklist, finished, completed, done, todo)' ],
			[ 'fa fa-outdent' => 'Outdent(dedent)' ],
			[ 'fa fa-indent' => 'Indent' ],
			[ 'fa fa-link' => 'Link(chain)(chain)' ],
			[ 'fa fa-scissors' => 'Scissors(cut)' ],
			[ 'fa fa-files-o' => 'Files Outlined(duplicate, clone, copy)(copy)' ],
			[ 'fa fa-paperclip' => 'Paperclip(attachment)' ],
			[ 'fa fa-floppy-o' => 'Floppy Outlined(save)' ],
			[ 'fa fa-list-ul' => 'list-ul(ul, ol, checklist, todo, list)' ],
			[ 'fa fa-list-ol' => 'list-ol(ul, ol, checklist, list, todo, list, numbers)' ],
			[ 'fa fa-strikethrough' => 'Strikethrough' ],
			[ 'fa fa-underline' => 'Underline' ],
			[ 'fa fa-table' => 'table(data, excel, spreadsheet)' ],
			[ 'fa fa-columns' => 'Columns(split, panes)' ],
			[ 'fa fa-undo' => 'Undo(back)(rotate-left)' ],
			[ 'fa fa-clipboard' => 'Clipboard(copy)(paste)' ],
			[ 'fa fa-file-text-o' => 'File Text Outlined(new, page, pdf, document)' ],
			[ 'fa fa-chain-broken' => 'Chain Broken(remove)(unlink)' ],
			[ 'fa fa-superscript' => 'superscript(exponential)' ],
			[ 'fa fa-subscript' => 'subscript' ],
			[ 'fa fa-eraser' => 'eraser(remove, delete)' ],
			[ 'fa fa-file' => 'File(new, page, pdf, document)' ],
			[ 'fa fa-file-text' => 'File Text(new, page, pdf, document)' ],
			[ 'fa fa-header' => 'header(heading)' ],
			[ 'fa fa-paragraph' => 'paragraph' ],
		],
		'Spinner Icons'         => [
			[ 'fa fa-cog' => 'cog(settings)(gear)' ],
			[ 'fa fa-refresh' => 'refresh(reload, sync)' ],
			[ 'fa fa-spinner' => 'Spinner(loading, progress)' ],
			[ 'fa fa-circle-o-notch' => 'Circle Outlined Notched' ],
		],
		'File Type Icons'       => [
			[ 'fa fa-file-o' => 'File Outlined(new, page, pdf, document)' ],
			[ 'fa fa-file-text-o' => 'File Text Outlined(new, page, pdf, document)' ],
			[ 'fa fa-file' => 'File(new, page, pdf, document)' ],
			[ 'fa fa-file-text' => 'File Text(new, page, pdf, document)' ],
			[ 'fa fa-file-pdf-o' => 'PDF File Outlined' ],
			[ 'fa fa-file-word-o' => 'Word File Outlined' ],
			[ 'fa fa-file-excel-o' => 'Excel File Outlined' ],
			[ 'fa fa-file-powerpoint-o' => 'Powerpoint File Outlined' ],
			[ 'fa fa-file-image-o' => 'Image File Outlined(file-photo-o, file-picture-o)' ],
			[ 'fa fa-file-archive-o' => 'Archive File Outlined(file-zip-o)' ],
			[ 'fa fa-file-audio-o' => 'Audio File Outlined(file-sound-o)' ],
			[ 'fa fa-file-video-o' => 'Video File Outlined(file-movie-o)' ],
			[ 'fa fa-file-code-o' => 'Code File Outlined' ],
		],
		'Directional Icons'     => [
			[ 'fa fa-arrow-circle-o-down' => 'Arrow Circle Outlined Down(download)' ],
			[ 'fa fa-arrow-circle-o-up' => 'Arrow Circle Outlined Up' ],
			[ 'fa fa-arrows' => 'Arrows(move, reorder, resize)' ],
			[ 'fa fa-chevron-left' => 'chevron-left(bracket, previous, back)' ],
			[ 'fa fa-chevron-right' => 'chevron-right(bracket, next, forward)' ],
			[ 'fa fa-arrow-left' => 'arrow-left(previous, back)' ],
			[ 'fa fa-arrow-right' => 'arrow-right(next, forward)' ],
			[ 'fa fa-arrow-up' => 'arrow-up' ],
			[ 'fa fa-arrow-down' => 'arrow-down(download)' ],
			[ 'fa fa-chevron-up' => 'chevron-up' ],
			[ 'fa fa-chevron-down' => 'chevron-down' ],
			[ 'fa fa-arrows-v' => 'Arrows Vertical(resize)' ],
			[ 'fa fa-arrows-h' => 'Arrows Horizontal(resize)' ],
			[ 'fa fa-hand-o-right' => 'Hand Outlined Right(point, right, next, forward, finger)' ],
			[ 'fa fa-hand-o-left' => 'Hand Outlined Left(point, left, previous, back, finger)' ],
			[ 'fa fa-hand-o-up' => 'Hand Outlined Up(point, finger)' ],
			[ 'fa fa-hand-o-down' => 'Hand Outlined Down(point, finger)' ],
			[ 'fa fa-arrow-circle-left' => 'Arrow Circle Left(previous, back)' ],
			[ 'fa fa-arrow-circle-right' => 'Arrow Circle Right(next, forward)' ],
			[ 'fa fa-arrow-circle-up' => 'Arrow Circle Up' ],
			[ 'fa fa-arrow-circle-down' => 'Arrow Circle Down(download)' ],
			[ 'fa fa-arrows-alt' => 'Arrows Alt(expand, enlarge, fullscreen, bigger, move, reorder, resize, arrow)' ],
			[ 'fa fa-caret-down' => 'Caret Down(more, dropdown, menu, triangle down, arrow)' ],
			[ 'fa fa-caret-up' => 'Caret Up(triangle up, arrow)' ],
			[ 'fa fa-caret-left' => 'Caret Left(previous, back, triangle left, arrow)' ],
			[ 'fa fa-caret-right' => 'Caret Right(next, forward, triangle right, arrow)' ],
			[ 'fa fa-exchange' => 'Exchange(transfer, arrows, arrow)' ],
			[ 'fa fa-angle-double-left' => 'Angle Double Left(laquo, quote, previous, back, arrows)' ],
			[ 'fa fa-angle-double-right' => 'Angle Double Right(raquo, quote, next, forward, arrows)' ],
			[ 'fa fa-angle-double-up' => 'Angle Double Up(arrows)' ],
			[ 'fa fa-angle-double-down' => 'Angle Double Down(arrows)' ],
			[ 'fa fa-angle-left' => 'angle-left(previous, back, arrow)' ],
			[ 'fa fa-angle-right' => 'angle-right(next, forward, arrow)' ],
			[ 'fa fa-angle-up' => 'angle-up(arrow)' ],
			[ 'fa fa-angle-down' => 'angle-down(arrow)' ],
			[ 'fa fa-chevron-circle-left' => 'Chevron Circle Left(previous, back, arrow)' ],
			[ 'fa fa-chevron-circle-right' => 'Chevron Circle Right(next, forward, arrow)' ],
			[ 'fa fa-chevron-circle-up' => 'Chevron Circle Up(arrow)' ],
			[ 'fa fa-chevron-circle-down' => 'Chevron Circle Down(more, dropdown, menu, arrow)' ],
			[ 'fa fa-caret-square-o-down' => 'Caret Square Outlined Down(more, dropdown, menu)(toggle-down)' ],
			[ 'fa fa-caret-square-o-up' => 'Caret Square Outlined Up(toggle-up)' ],
			[ 'fa fa-caret-square-o-right' => 'Caret Square Outlined Right(next, forward)(toggle-right)' ],
			[ 'fa fa-long-arrow-down' => 'Long Arrow Down' ],
			[ 'fa fa-long-arrow-up' => 'Long Arrow Up' ],
			[ 'fa fa-long-arrow-left' => 'Long Arrow Left(previous, back)' ],
			[ 'fa fa-long-arrow-right' => 'Long Arrow Right' ],
			[ 'fa fa-arrow-circle-o-right' => 'Arrow Circle Outlined Right(next, forward)' ],
			[ 'fa fa-arrow-circle-o-left' => 'Arrow Circle Outlined Left(previous, back)' ],
			[ 'fa fa-caret-square-o-left' => 'Caret Square Outlined Left(previous, back)(toggle-left)' ],
		],
		'Video Player Icons'    => [
			[ 'fa fa-play-circle-o' => 'Play Circle Outlined' ],
			[ 'fa fa-step-backward' => 'step-backward(rewind, previous, beginning, start, first)' ],
			[ 'fa fa-fast-backward' => 'fast-backward(rewind, previous, beginning, start, first)' ],
			[ 'fa fa-backward' => 'backward(rewind, previous)' ],
			[ 'fa fa-play' => 'play(start, playing, music, sound)' ],
			[ 'fa fa-pause' => 'pause(wait)' ],
			[ 'fa fa-stop' => 'stop(block, box, square)' ],
			[ 'fa fa-forward' => 'forward(forward, next)' ],
			[ 'fa fa-fast-forward' => 'fast-forward(next, end, last)' ],
			[ 'fa fa-step-forward' => 'step-forward(next, end, last)' ],
			[ 'fa fa-eject' => 'eject' ],
			[ 'fa fa-expand' => 'Expand(enlarge, bigger, resize)' ],
			[ 'fa fa-compress' => 'Compress(collapse, combine, contract, merge, smaller)' ],
			[ 'fa fa-random' => 'random(sort, shuffle)' ],
			[ 'fa fa-arrows-alt' => 'Arrows Alt(expand, enlarge, fullscreen, bigger, move, reorder, resize, arrow)' ],
			[ 'fa fa-play-circle' => 'Play Circle(start, playing)' ],
			[ 'fa fa-youtube-play' => 'YouTube Play(start, playing)' ],
			[ 'fa fa-pause-circle' => 'Pause Circle' ],
			[ 'fa fa-pause-circle-o' => 'Pause Circle Outlined' ],
			[ 'fa fa-stop-circle' => 'Stop Circle' ],
			[ 'fa fa-stop-circle-o' => 'Stop Circle Outlined' ],
		],
		'Form Control Icons'    => [
			[ 'fa fa-check-square-o' => 'Check Square Outlined(todo, done, agree, accept, confirm, ok)' ],
			[ 'fa fa-square-o' => 'Square Outlined(block, square, box)' ],
			[ 'fa fa-square' => 'Square(block, box)' ],
			[ 'fa fa-plus-square' => 'Plus Square(add, new, create, expand)' ],
			[ 'fa fa-circle-o' => 'Circle Outlined' ],
			[ 'fa fa-circle' => 'Circle(dot, notification)' ],
			[ 'fa fa-minus-square' => 'Minus Square(hide, minify, delete, remove, trash, hide, collapse)' ],
			[ 'fa fa-minus-square-o' => 'Minus Square Outlined(hide, minify, delete, remove, trash, hide, collapse)' ],
			[ 'fa fa-check-square' => 'Check Square(checkmark, done, todo, agree, accept, confirm, ok)' ],
			[ 'fa fa-dot-circle-o' => 'Dot Circle Outlined(target, bullseye, notification)' ],
			[ 'fa fa-plus-square-o' => 'Plus Square Outlined(add, new, create, expand)' ],
		],
		'Transportation Icons'  => [
			[ 'fa fa-plane' => 'plane(travel, trip, location, destination, airplane, fly, mode)' ],
			[ 'fa fa-truck' => 'truck(shipping)' ],
			[ 'fa fa-ambulance' => 'ambulance(vehicle, support, help)' ],
			[ 'fa fa-fighter-jet' => 'fighter-jet(fly, plane, airplane, quick, fast, travel)' ],
			[ 'fa fa-rocket' => 'rocket(app)' ],
			[ 'fa fa-wheelchair' => 'Wheelchair(handicap, person)' ],
			[ 'fa fa-space-shuttle' => 'Space Shuttle' ],
			[ 'fa fa-car' => 'Car(vehicle)(automobile)' ],
			[ 'fa fa-taxi' => 'Taxi(vehicle)(cab)' ],
			[ 'fa fa-bicycle' => 'Bicycle(vehicle, bike)' ],
			[ 'fa fa-bus' => 'Bus(vehicle)' ],
			[ 'fa fa-ship' => 'Ship(boat, sea)' ],
			[ 'fa fa-motorcycle' => 'Motorcycle(vehicle, bike)' ],
			[ 'fa fa-train' => 'Train' ],
			[ 'fa fa-subway' => 'Subway' ],
			[ 'fa fa-wheelchair-alt' => 'Wheelchair Alt(handicap, person)' ],
		],
		'Chart Icons'           => [
			[ 'fa fa-bar-chart' => 'Bar Chart(graph, analytics, statistics)(bar-chart-o)' ],
			[ 'fa fa-area-chart' => 'Area Chart(graph, analytics, statistics)' ],
			[ 'fa fa-pie-chart' => 'Pie Chart(graph, analytics, statistics)' ],
			[ 'fa fa-line-chart' => 'Line Chart(graph, analytics, statistics)' ],
		],
		'Brand Icons'           => [
			[ 'fa fa-twitter-square' => 'Twitter Square(tweet, social network)' ],
			[ 'fa fa-facebook-square' => 'Facebook Square(social network)' ],
			[ 'fa fa-linkedin-square' => 'LinkedIn Square' ],
			[ 'fa fa-github-square' => 'GitHub Square(octocat)' ],
			[ 'fa fa-twitter' => 'Twitter(tweet, social network)' ],
			[ 'fa fa-facebook' => 'Facebook(social network)(facebook-f)' ],
			[ 'fa fa-github' => 'GitHub(octocat)' ],
			[ 'fa fa-pinterest' => 'Pinterest' ],
			[ 'fa fa-pinterest-square' => 'Pinterest Square' ],
			[ 'fa fa-google-plus-square' => 'Google Plus Square(social network)' ],
			[ 'fa fa-google-plus' => 'Google Plus(social network)' ],
			[ 'fa fa-linkedin' => 'LinkedIn' ],
			[ 'fa fa-github-alt' => 'GitHub Alt(octocat)' ],
			[ 'fa fa-maxcdn' => 'MaxCDN' ],
			[ 'fa fa-html5' => 'HTML 5 Logo' ],
			[ 'fa fa-css3' => 'CSS 3 Logo(code)' ],
			[ 'fa fa-btc' => 'Bitcoin (BTC)(bitcoin)' ],
			[ 'fa fa-youtube-square' => 'YouTube Square(video, film)' ],
			[ 'fa fa-youtube' => 'YouTube(video, film)' ],
			[ 'fa fa-xing' => 'Xing' ],
			[ 'fa fa-xing-square' => 'Xing Square' ],
			[ 'fa fa-youtube-play' => 'YouTube Play(start, playing)' ],
			[ 'fa fa-dropbox' => 'Dropbox' ],
			[ 'fa fa-stack-overflow' => 'Stack Overflow' ],
			[ 'fa fa-instagram' => 'Instagram' ],
			[ 'fa fa-flickr' => 'Flickr' ],
			[ 'fa fa-adn' => 'App.net' ],
			[ 'fa fa-bitbucket' => 'Bitbucket(git)' ],
			[ 'fa fa-bitbucket-square' => 'Bitbucket Square(git)' ],
			[ 'fa fa-tumblr' => 'Tumblr' ],
			[ 'fa fa-tumblr-square' => 'Tumblr Square' ],
			[ 'fa fa-apple' => 'Apple(osx, food)' ],
			[ 'fa fa-windows' => 'Windows(microsoft)' ],
			[ 'fa fa-android' => 'Android(robot)' ],
			[ 'fa fa-linux' => 'Linux(tux)' ],
			[ 'fa fa-dribbble' => 'Dribbble' ],
			[ 'fa fa-skype' => 'Skype' ],
			[ 'fa fa-foursquare' => 'Foursquare' ],
			[ 'fa fa-trello' => 'Trello' ],
			[ 'fa fa-gratipay' => 'Gratipay (Gittip)(heart, like, favorite, love)(gittip)' ],
			[ 'fa fa-vk' => 'VK' ],
			[ 'fa fa-weibo' => 'Weibo' ],
			[ 'fa fa-renren' => 'Renren' ],
			[ 'fa fa-pagelines' => 'Pagelines(leaf, leaves, tree, plant, eco, nature)' ],
			[ 'fa fa-stack-exchange' => 'Stack Exchange' ],
			[ 'fa fa-vimeo-square' => 'Vimeo Square' ],
			[ 'fa fa-slack' => 'Slack Logo(hashtag, anchor, hash)' ],
			[ 'fa fa-wordpress' => 'WordPress Logo' ],
			[ 'fa fa-openid' => 'OpenID' ],
			[ 'fa fa-yahoo' => 'Yahoo Logo' ],
			[ 'fa fa-google' => 'Google Logo' ],
			[ 'fa fa-reddit' => 'reddit Logo' ],
			[ 'fa fa-reddit-square' => 'reddit Square' ],
			[ 'fa fa-stumbleupon-circle' => 'StumbleUpon Circle' ],
			[ 'fa fa-stumbleupon' => 'StumbleUpon Logo' ],
			[ 'fa fa-delicious' => 'Delicious Logo' ],
			[ 'fa fa-digg' => 'Digg Logo' ],
			[ 'fa fa-pied-piper-pp' => 'Pied Piper PP Logo (Old)' ],
			[ 'fa fa-pied-piper-alt' => 'Pied Piper Alternate Logo' ],
			[ 'fa fa-drupal' => 'Drupal Logo' ],
			[ 'fa fa-joomla' => 'Joomla Logo' ],
			[ 'fa fa-behance' => 'Behance' ],
			[ 'fa fa-behance-square' => 'Behance Square' ],
			[ 'fa fa-steam' => 'Steam' ],
			[ 'fa fa-steam-square' => 'Steam Square' ],
			[ 'fa fa-spotify' => 'Spotify' ],
			[ 'fa fa-deviantart' => 'deviantART' ],
			[ 'fa fa-soundcloud' => 'SoundCloud' ],
			[ 'fa fa-vine' => 'Vine' ],
			[ 'fa fa-codepen' => 'Codepen' ],
			[ 'fa fa-jsfiddle' => 'jsFiddle' ],
			[ 'fa fa-rebel' => 'Rebel Alliance(ra, resistance)' ],
			[ 'fa fa-empire' => 'Galactic Empire(ge)' ],
			[ 'fa fa-git-square' => 'Git Square' ],
			[ 'fa fa-git' => 'Git' ],
			[ 'fa fa-hacker-news' => 'Hacker News(y-combinator-square, yc-square)' ],
			[ 'fa fa-tencent-weibo' => 'Tencent Weibo' ],
			[ 'fa fa-qq' => 'QQ' ],
			[ 'fa fa-weixin' => 'Weixin (WeChat)(wechat)' ],
			[ 'fa fa-share-alt' => 'Share Alt' ],
			[ 'fa fa-share-alt-square' => 'Share Alt Square' ],
			[ 'fa fa-slideshare' => 'Slideshare' ],
			[ 'fa fa-twitch' => 'Twitch' ],
			[ 'fa fa-yelp' => 'Yelp' ],
			[ 'fa fa-paypal' => 'Paypal' ],
			[ 'fa fa-google-wallet' => 'Google Wallet' ],
			[ 'fa fa-cc-visa' => 'Visa Credit Card' ],
			[ 'fa fa-cc-mastercard' => 'MasterCard Credit Card' ],
			[ 'fa fa-cc-discover' => 'Discover Credit Card' ],
			[ 'fa fa-cc-amex' => 'American Express Credit Card(amex)' ],
			[ 'fa fa-cc-paypal' => 'Paypal Credit Card' ],
			[ 'fa fa-cc-stripe' => 'Stripe Credit Card' ],
			[ 'fa fa-lastfm' => 'last.fm' ],
			[ 'fa fa-lastfm-square' => 'last.fm Square' ],
			[ 'fa fa-ioxhost' => 'ioxhost' ],
			[ 'fa fa-angellist' => 'AngelList' ],
			[ 'fa fa-meanpath' => 'meanpath' ],
			[ 'fa fa-buysellads' => 'BuySellAds' ],
			[ 'fa fa-connectdevelop' => 'Connect Develop' ],
			[ 'fa fa-dashcube' => 'DashCube' ],
			[ 'fa fa-forumbee' => 'Forumbee' ],
			[ 'fa fa-leanpub' => 'Leanpub' ],
			[ 'fa fa-sellsy' => 'Sellsy' ],
			[ 'fa fa-shirtsinbulk' => 'Shirts in Bulk' ],
			[ 'fa fa-simplybuilt' => 'SimplyBuilt' ],
			[ 'fa fa-skyatlas' => 'skyatlas' ],
			[ 'fa fa-facebook-official' => 'Facebook Official' ],
			[ 'fa fa-pinterest-p' => 'Pinterest P' ],
			[ 'fa fa-whatsapp' => 'What\'s App' ],
			[ 'fa fa-viacoin' => 'Viacoin' ],
			[ 'fa fa-medium' => 'Medium' ],
			[ 'fa fa-y-combinator' => 'Y Combinator(yc)' ],
			[ 'fa fa-optin-monster' => 'Optin Monster' ],
			[ 'fa fa-opencart' => 'OpenCart' ],
			[ 'fa fa-expeditedssl' => 'ExpeditedSSL' ],
			[ 'fa fa-cc-jcb' => 'JCB Credit Card' ],
			[ 'fa fa-cc-diners-club' => 'Diner\'s Club Credit Card' ],
			[ 'fa fa-gg' => 'GG Currency' ],
			[ 'fa fa-gg-circle' => 'GG Currency Circle' ],
			[ 'fa fa-tripadvisor' => 'TripAdvisor' ],
			[ 'fa fa-odnoklassniki' => 'Odnoklassniki' ],
			[ 'fa fa-odnoklassniki-square' => 'Odnoklassniki Square' ],
			[ 'fa fa-get-pocket' => 'Get Pocket' ],
			[ 'fa fa-wikipedia-w' => 'Wikipedia W' ],
			[ 'fa fa-safari' => 'Safari(browser)' ],
			[ 'fa fa-chrome' => 'Chrome(browser)' ],
			[ 'fa fa-firefox' => 'Firefox(browser)' ],
			[ 'fa fa-opera' => 'Opera' ],
			[ 'fa fa-internet-explorer' => 'Internet-explorer(browser, ie)' ],
			[ 'fa fa-contao' => 'Contao' ],
			[ 'fa fa-500px' => '500px' ],
			[ 'fa fa-amazon' => 'Amazon' ],
			[ 'fa fa-houzz' => 'Houzz' ],
			[ 'fa fa-vimeo' => 'Vimeo' ],
			[ 'fa fa-black-tie' => 'Font Awesome Black Tie' ],
			[ 'fa fa-fonticons' => 'Fonticons' ],
			[ 'fa fa-reddit-alien' => 'reddit Alien' ],
			[ 'fa fa-edge' => 'Edge Browser(browser, ie)' ],
			[ 'fa fa-codiepie' => 'Codie Pie' ],
			[ 'fa fa-modx' => 'MODX' ],
			[ 'fa fa-fort-awesome' => 'Fort Awesome' ],
			[ 'fa fa-usb' => 'USB' ],
			[ 'fa fa-product-hunt' => 'Product Hunt' ],
			[ 'fa fa-mixcloud' => 'Mixcloud' ],
			[ 'fa fa-scribd' => 'Scribd' ],
			[ 'fa fa-bluetooth' => 'Bluetooth' ],
			[ 'fa fa-bluetooth-b' => 'Bluetooth' ],
			[ 'fa fa-gitlab' => 'GitLab' ],
			[ 'fa fa-wpbeginner' => 'WPBeginner' ],
			[ 'fa fa-wpforms' => 'WPForms' ],
			[ 'fa fa-envira' => 'Envira Gallery(leaf)' ],
			[ 'fa fa-glide' => 'Glide' ],
			[ 'fa fa-glide-g' => 'Glide G' ],
			[ 'fa fa-viadeo' => 'Viadeo' ],
			[ 'fa fa-viadeo-square' => 'Viadeo Square' ],
			[ 'fa fa-snapchat' => 'Snapchat' ],
			[ 'fa fa-snapchat-ghost' => 'Snapchat Ghost' ],
			[ 'fa fa-snapchat-square' => 'Snapchat Square' ],
			[ 'fa fa-pied-piper' => 'Pied Piper Logo' ],
			[ 'fa fa-first-order' => 'First Order' ],
			[ 'fa fa-yoast' => 'Yoast' ],
			[ 'fa fa-themeisle' => 'ThemeIsle' ],
			[ 'fa fa-google-plus-official' => 'Google Plus Official(google-plus-circle)' ],
			[ 'fa fa-font-awesome' => 'Font Awesome(fa)' ],
			[ 'fa fa-linode' => 'Linode' ],
			[ 'fa fa-quora' => 'Quora' ],
			[ 'fa fa-free-code-camp' => 'Free Code Camp' ],
			[ 'fa fa-telegram' => 'Telegram' ],
			[ 'fa fa-bandcamp' => 'Bandcamp' ],
			[ 'fa fa-grav' => 'Grav' ],
			[ 'fa fa-etsy' => 'Etsy' ],
			[ 'fa fa-imdb' => 'IMDB' ],
			[ 'fa fa-ravelry' => 'Ravelry' ],
			[ 'fa fa-eercast' => 'Eercast' ],
			[ 'fa fa-superpowers' => 'Superpowers' ],
			[ 'fa fa-wpexplorer' => 'WPExplorer' ],
			[ 'fa fa-meetup' => 'Meetup' ],
		],
		'Hand Icons'            => [
			[ 'fa fa-thumbs-o-up' => 'Thumbs Up Outlined(like, approve, favorite, agree, hand)' ],
			[ 'fa fa-thumbs-o-down' => 'Thumbs Down Outlined(dislike, disapprove, disagree, hand)' ],
			[ 'fa fa-hand-o-right' => 'Hand Outlined Right(point, right, next, forward, finger)' ],
			[ 'fa fa-hand-o-left' => 'Hand Outlined Left(point, left, previous, back, finger)' ],
			[ 'fa fa-hand-o-up' => 'Hand Outlined Up(point, finger)' ],
			[ 'fa fa-hand-o-down' => 'Hand Outlined Down(point, finger)' ],
			[ 'fa fa-thumbs-up' => 'thumbs-up(like, favorite, approve, agree, hand)' ],
			[ 'fa fa-thumbs-down' => 'thumbs-down(dislike, disapprove, disagree, hand)' ],
			[ 'fa fa-hand-rock-o' => 'Rock (Hand)(hand-grab-o)' ],
			[ 'fa fa-hand-paper-o' => 'Paper (Hand)(stop)(hand-stop-o)' ],
			[ 'fa fa-hand-scissors-o' => 'Scissors (Hand)' ],
			[ 'fa fa-hand-lizard-o' => 'Lizard (Hand)' ],
			[ 'fa fa-hand-spock-o' => 'Spock (Hand)' ],
			[ 'fa fa-hand-pointer-o' => 'Hand Pointer' ],
			[ 'fa fa-hand-peace-o' => 'Hand Peace' ],
		],
		'Payment Icons'         => [
			[ 'fa fa-credit-card' => 'credit-card(money, buy, debit, checkout, purchase, payment)' ],
			[ 'fa fa-paypal' => 'Paypal' ],
			[ 'fa fa-google-wallet' => 'Google Wallet' ],
			[ 'fa fa-cc-visa' => 'Visa Credit Card' ],
			[ 'fa fa-cc-mastercard' => 'MasterCard Credit Card' ],
			[ 'fa fa-cc-discover' => 'Discover Credit Card' ],
			[ 'fa fa-cc-amex' => 'American Express Credit Card(amex)' ],
			[ 'fa fa-cc-paypal' => 'Paypal Credit Card' ],
			[ 'fa fa-cc-stripe' => 'Stripe Credit Card' ],
			[ 'fa fa-cc-jcb' => 'JCB Credit Card' ],
			[ 'fa fa-cc-diners-club' => 'Diner\'s Club Credit Card' ],
			[ 'fa fa-credit-card-alt' => 'Credit Card(money, buy, debit, checkout, purchase, payment, credit card)' ],
		],
		'Currency Icons'        => [
			[ 'fa fa-money' => 'Money(cash, money, buy, checkout, purchase, payment)' ],
			[ 'fa fa-eur' => 'Euro (EUR)(euro)' ],
			[ 'fa fa-gbp' => 'GBP' ],
			[ 'fa fa-usd' => 'US Dollar(dollar)' ],
			[ 'fa fa-inr' => 'Indian Rupee (INR)(rupee)' ],
			[ 'fa fa-jpy' => 'Japanese Yen (JPY)(cny, rmb, yen)' ],
			[ 'fa fa-rub' => 'Russian Ruble (RUB)(ruble, rouble)' ],
			[ 'fa fa-krw' => 'Korean Won (KRW)(won)' ],
			[ 'fa fa-btc' => 'Bitcoin (BTC)(bitcoin)' ],
			[ 'fa fa-try' => 'Turkish Lira (TRY)(turkish-lira)' ],
			[ 'fa fa-ils' => 'Shekel (ILS)(shekel, sheqel)' ],
			[ 'fa fa-gg' => 'GG Currency' ],
			[ 'fa fa-gg-circle' => 'GG Currency Circle' ],
		],
		'Accessibility Icons'   => [
			[ 'fa fa-wheelchair' => 'Wheelchair(handicap, person)' ],
			[ 'fa fa-tty' => 'TTY' ],
			[ 'fa fa-cc' => 'Closed Captions' ],
			[ 'fa fa-universal-access' => 'Universal Access' ],
			[ 'fa fa-wheelchair-alt' => 'Wheelchair Alt(handicap, person)' ],
			[ 'fa fa-question-circle-o' => 'Question Circle Outlined' ],
			[ 'fa fa-blind' => 'Blind' ],
			[ 'fa fa-audio-description' => 'Audio Description' ],
			[ 'fa fa-volume-control-phone' => 'Volume Control Phone(telephone)' ],
			[ 'fa fa-braille' => 'Braille' ],
			[ 'fa fa-assistive-listening-systems' => 'Assistive Listening Systems' ],
			[ 'fa fa-american-sign-language-interpreting' => 'American Sign Language Interpreting(asl-interpreting)' ],
			[ 'fa fa-deaf' => 'Deaf(deafness, hard-of-hearing)' ],
			[ 'fa fa-sign-language' => 'Sign Language(signing)' ],
			[ 'fa fa-low-vision' => 'Low Vision' ],
		],
		'Gender Icons'          => [
			[ 'fa fa-venus' => 'Venus(female)' ],
			[ 'fa fa-mars' => 'Mars(male)' ],
			[ 'fa fa-mercury' => 'Mercury(transgender)' ],
			[ 'fa fa-transgender' => 'Transgender(intersex)' ],
			[ 'fa fa-transgender-alt' => 'Transgender Alt' ],
			[ 'fa fa-venus-double' => 'Venus Double' ],
			[ 'fa fa-mars-double' => 'Mars Double' ],
			[ 'fa fa-venus-mars' => 'Venus Mars' ],
			[ 'fa fa-mars-stroke' => 'Mars Stroke' ],
			[ 'fa fa-mars-stroke-v' => 'Mars Stroke Vertical' ],
			[ 'fa fa-mars-stroke-h' => 'Mars Stroke Horizontal' ],
			[ 'fa fa-neuter' => 'Neuter' ],
			[ 'fa fa-genderless' => 'Genderless' ],
		],
	];
}

/**
 * Ion Icons.
 *
 * @return array
 */
function aheto_icons_ionicons() {
	return [
		[ 'ion-alert' => 'Alert' ],
		[ 'ion-alert-circled' => 'Alert Circled' ],
		[ 'ion-android-add' => 'Android Add' ],
		[ 'ion-android-add-circle' => 'Android Add Circle' ],
		[ 'ion-android-alarm-clock' => 'Android Alarm Clock' ],
		[ 'ion-android-alert' => 'Android Alert' ],
		[ 'ion-android-apps' => 'Android Apps' ],
		[ 'ion-android-archive' => 'Android Archive' ],
		[ 'ion-android-arrow-back' => 'Android Arrow Back' ],
		[ 'ion-android-arrow-down' => 'Android Arrow Down' ],
		[ 'ion-android-arrow-dropdown' => 'Android Arrow Dropdown' ],
		[ 'ion-android-arrow-dropdown-circle' => 'Android Arrow Dropdown Circle' ],
		[ 'ion-android-arrow-dropleft' => 'Android Arrow Dropleft' ],
		[ 'ion-android-arrow-dropleft-circle' => 'Android Arrow Dropleft Circle' ],
		[ 'ion-android-arrow-dropright' => 'Android Arrow Dropright' ],
		[ 'ion-android-arrow-dropright-circle' => 'Android Arrow Dropright Circle' ],
		[ 'ion-android-arrow-dropup' => 'Android Arrow Dropup' ],
		[ 'ion-android-arrow-dropup-circle' => 'Android Arrow Dropup Circle' ],
		[ 'ion-android-arrow-forward' => 'Android Arrow Forward' ],
		[ 'ion-android-arrow-up' => 'Android Arrow Up' ],
		[ 'ion-android-attach' => 'Android Attach' ],
		[ 'ion-android-bar' => 'Android Bar' ],
		[ 'ion-android-bicycle' => 'Android Bicycle' ],
		[ 'ion-android-boat' => 'Android Boat' ],
		[ 'ion-android-bookmark' => 'Android Bookmark' ],
		[ 'ion-android-bulb' => 'Android Bulb' ],
		[ 'ion-android-bus' => 'Android Bus' ],
		[ 'ion-android-calendar' => 'Android Calendar' ],
		[ 'ion-android-call' => 'Android Call' ],
		[ 'ion-android-camera' => 'Android Camera' ],
		[ 'ion-android-cancel' => 'Android Cancel' ],
		[ 'ion-android-car' => 'Android Car' ],
		[ 'ion-android-cart' => 'Android Cart' ],
		[ 'ion-android-chat' => 'Android Chat' ],
		[ 'ion-android-checkbox' => 'Android Checkbox' ],
		[ 'ion-android-checkbox-blank' => 'Android Checkbox Blank' ],
		[ 'ion-android-checkbox-outline' => 'Android Checkbox Outline' ],
		[ 'ion-android-checkbox-outline-blank' => 'Android Checkbox Outline Blank' ],
		[ 'ion-android-checkmark-circle' => 'Android Checkmark Circle' ],
		[ 'ion-android-clipboard' => 'Android Clipboard' ],
		[ 'ion-android-close' => 'Android Close' ],
		[ 'ion-android-cloud' => 'Android Cloud' ],
		[ 'ion-android-cloud-circle' => 'Android Cloud Circle' ],
		[ 'ion-android-cloud-done' => 'Android Cloud Done' ],
		[ 'ion-android-cloud-outline' => 'Android Cloud Outline' ],
		[ 'ion-android-color-palette' => 'Android Color Palette' ],
		[ 'ion-android-compass' => 'Android Compass' ],
		[ 'ion-android-contact' => 'Android Contact' ],
		[ 'ion-android-contacts' => 'Android Contacts' ],
		[ 'ion-android-contract' => 'Android Contract' ],
		[ 'ion-android-create' => 'Android Create' ],
		[ 'ion-android-delete' => 'Android Delete' ],
		[ 'ion-android-desktop' => 'Android Desktop' ],
		[ 'ion-android-document' => 'Android Document' ],
		[ 'ion-android-done' => 'Android Done' ],
		[ 'ion-android-done-all' => 'Android Done All' ],
		[ 'ion-android-download' => 'Android Download' ],
		[ 'ion-android-drafts' => 'Android Drafts' ],
		[ 'ion-android-exit' => 'Android Exit' ],
		[ 'ion-android-expand' => 'Android Expand' ],
		[ 'ion-android-favorite' => 'Android Favorite' ],
		[ 'ion-android-favorite-outline' => 'Android Favorite Outline' ],
		[ 'ion-android-film' => 'Android Film' ],
		[ 'ion-android-folder' => 'Android Folder' ],
		[ 'ion-android-folder-open' => 'Android Folder Open' ],
		[ 'ion-android-funnel' => 'Android Funnel' ],
		[ 'ion-android-globe' => 'Android Globe' ],
		[ 'ion-android-hand' => 'Android Hand' ],
		[ 'ion-android-hangout' => 'Android Hangout' ],
		[ 'ion-android-happy' => 'Android Happy' ],
		[ 'ion-android-home' => 'Android Home' ],
		[ 'ion-android-image' => 'Android Image' ],
		[ 'ion-android-laptop' => 'Android Laptop' ],
		[ 'ion-android-list' => 'Android List' ],
		[ 'ion-android-locate' => 'Android Locate' ],
		[ 'ion-android-lock' => 'Android Lock' ],
		[ 'ion-android-mail' => 'Android Mail' ],
		[ 'ion-android-map' => 'Android Map' ],
		[ 'ion-android-menu' => 'Android Menu' ],
		[ 'ion-android-microphone' => 'Android Microphone' ],
		[ 'ion-android-microphone-off' => 'Android Microphone Off' ],
		[ 'ion-android-more-horizontal' => 'Android More Horizontal' ],
		[ 'ion-android-more-vertical' => 'Android More Vertical' ],
		[ 'ion-android-navigate' => 'Android Navigate' ],
		[ 'ion-android-notifications' => 'Android Notifications' ],
		[ 'ion-android-notifications-none' => 'Android Notifications None' ],
		[ 'ion-android-notifications-off' => 'Android Notifications Off' ],
		[ 'ion-android-open' => 'Android Open' ],
		[ 'ion-android-options' => 'Android Options' ],
		[ 'ion-android-people' => 'Android People' ],
		[ 'ion-android-person' => 'Android Person' ],
		[ 'ion-android-person-add' => 'Android Person Add' ],
		[ 'ion-android-phone-landscape' => 'Android Phone Landscape' ],
		[ 'ion-android-phone-portrait' => 'Android Phone Portrait' ],
		[ 'ion-android-pin' => 'Android Pin' ],
		[ 'ion-android-plane' => 'Android Plane' ],
		[ 'ion-android-playstore' => 'Android Playstore' ],
		[ 'ion-android-print' => 'Android Print' ],
		[ 'ion-android-radio-button-off' => 'Android Radio Button Off' ],
		[ 'ion-android-radio-button-on' => 'Android Radio Button On' ],
		[ 'ion-android-refresh' => 'Android Refresh' ],
		[ 'ion-android-remove' => 'Android Remove' ],
		[ 'ion-android-remove-circle' => 'Android Remove Circle' ],
		[ 'ion-android-restaurant' => 'Android Restaurant' ],
		[ 'ion-android-sad' => 'Android Sad' ],
		[ 'ion-android-search' => 'Android Search' ],
		[ 'ion-android-send' => 'Android Send' ],
		[ 'ion-android-settings' => 'Android Settings' ],
		[ 'ion-android-share' => 'Android Share' ],
		[ 'ion-android-share-alt' => 'Android Share Alt' ],
		[ 'ion-android-star' => 'Android Star' ],
		[ 'ion-android-star-half' => 'Android Star Half' ],
		[ 'ion-android-star-outline' => 'Android Star Outline' ],
		[ 'ion-android-stopwatch' => 'Android Stopwatch' ],
		[ 'ion-android-subway' => 'Android Subway' ],
		[ 'ion-android-sunny' => 'Android Sunny' ],
		[ 'ion-android-sync' => 'Android Sync' ],
		[ 'ion-android-textsms' => 'Android Textsms' ],
		[ 'ion-android-time' => 'Android Time' ],
		[ 'ion-android-train' => 'Android Train' ],
		[ 'ion-android-unlock' => 'Android Unlock' ],
		[ 'ion-android-upload' => 'Android Upload' ],
		[ 'ion-android-volume-down' => 'Android Volume Down' ],
		[ 'ion-android-volume-mute' => 'Android Volume Mute' ],
		[ 'ion-android-volume-off' => 'Android Volume Off' ],
		[ 'ion-android-volume-up' => 'Android Volume Up' ],
		[ 'ion-android-walk' => 'Android Walk' ],
		[ 'ion-android-warning' => 'Android Warning' ],
		[ 'ion-android-watch' => 'Android Watch' ],
		[ 'ion-android-wifi' => 'Android Wifi' ],
		[ 'ion-aperture' => 'Aperture' ],
		[ 'ion-archive' => 'Archive' ],
		[ 'ion-arrow-down-a' => 'Arrow Down A' ],
		[ 'ion-arrow-down-b' => 'Arrow Down B' ],
		[ 'ion-arrow-down-c' => 'Arrow Down C' ],
		[ 'ion-arrow-expand' => 'Arrow Expand' ],
		[ 'ion-arrow-graph-down-left' => 'Arrow Graph Down Left' ],
		[ 'ion-arrow-graph-down-right' => 'Arrow Graph Down Right' ],
		[ 'ion-arrow-graph-up-left' => 'Arrow Graph Up Left' ],
		[ 'ion-arrow-graph-up-right' => 'Arrow Graph Up Right' ],
		[ 'ion-arrow-left-a' => 'Arrow Left A' ],
		[ 'ion-arrow-left-b' => 'Arrow Left B' ],
		[ 'ion-arrow-left-c' => 'Arrow Left C' ],
		[ 'ion-arrow-move' => 'Arrow Move' ],
		[ 'ion-arrow-resize' => 'Arrow Resize' ],
		[ 'ion-arrow-return-left' => 'Arrow Return Left' ],
		[ 'ion-arrow-return-right' => 'Arrow Return Right' ],
		[ 'ion-arrow-right-a' => 'Arrow Right A' ],
		[ 'ion-arrow-right-b' => 'Arrow Right B' ],
		[ 'ion-arrow-right-c' => 'Arrow Right C' ],
		[ 'ion-arrow-shrink' => 'Arrow Shrink' ],
		[ 'ion-arrow-swap' => 'Arrow Swap' ],
		[ 'ion-arrow-up-a' => 'Arrow Up A' ],
		[ 'ion-arrow-up-b' => 'Arrow Up B' ],
		[ 'ion-arrow-up-c' => 'Arrow Up C' ],
		[ 'ion-asterisk' => 'Asterisk' ],
		[ 'ion-at' => 'At' ],
		[ 'ion-backspace' => 'Backspace' ],
		[ 'ion-backspace-outline' => 'Backspace Outline' ],
		[ 'ion-bag' => 'Bag' ],
		[ 'ion-battery-charging' => 'Battery Charging' ],
		[ 'ion-battery-empty' => 'Battery Empty' ],
		[ 'ion-battery-full' => 'Battery Full' ],
		[ 'ion-battery-half' => 'Battery Half' ],
		[ 'ion-battery-low' => 'Battery Low' ],
		[ 'ion-beaker' => 'Beaker' ],
		[ 'ion-beer' => 'Beer' ],
		[ 'ion-bluetooth' => 'Bluetooth' ],
		[ 'ion-bonfire' => 'Bonfire' ],
		[ 'ion-bookmark' => 'Bookmark' ],
		[ 'ion-bowtie' => 'Bowtie' ],
		[ 'ion-briefcase' => 'Briefcase' ],
		[ 'ion-bug' => 'Bug' ],
		[ 'ion-calculator' => 'Calculator' ],
		[ 'ion-calendar' => 'Calendar' ],
		[ 'ion-camera' => 'Camera' ],
		[ 'ion-card' => 'Card' ],
		[ 'ion-cash' => 'Cash' ],
		[ 'ion-chatbox' => 'Chatbox' ],
		[ 'ion-chatbox-working' => 'Chatbox Working' ],
		[ 'ion-chatboxes' => 'Chatboxes' ],
		[ 'ion-chatbubble' => 'Chatbubble' ],
		[ 'ion-chatbubble-working' => 'Chatbubble Working' ],
		[ 'ion-chatbubbles' => 'Chatbubbles' ],
		[ 'ion-checkmark' => 'Checkmark' ],
		[ 'ion-checkmark-circled' => 'Checkmark Circled' ],
		[ 'ion-checkmark-round' => 'Checkmark Round' ],
		[ 'ion-chevron-down' => 'Chevron Down' ],
		[ 'ion-chevron-left' => 'Chevron Left' ],
		[ 'ion-chevron-right' => 'Chevron Right' ],
		[ 'ion-chevron-up' => 'Chevron Up' ],
		[ 'ion-clipboard' => 'Clipboard' ],
		[ 'ion-clock' => 'Clock' ],
		[ 'ion-close' => 'Close' ],
		[ 'ion-close-circled' => 'Close Circled' ],
		[ 'ion-close-round' => 'Close Round' ],
		[ 'ion-closed-captioning' => 'Closed Captioning' ],
		[ 'ion-cloud' => 'Cloud' ],
		[ 'ion-code' => 'Code' ],
		[ 'ion-code-download' => 'Code Download' ],
		[ 'ion-code-working' => 'Code Working' ],
		[ 'ion-coffee' => 'Coffee' ],
		[ 'ion-compass' => 'Compass' ],
		[ 'ion-compose' => 'Compose' ],
		[ 'ion-connection-bars' => 'Connectbars' ],
		[ 'ion-contrast' => 'Contrast' ],
		[ 'ion-crop' => 'Crop' ],
		[ 'ion-cube' => 'Cube' ],
		[ 'ion-disc' => 'Disc' ],
		[ 'ion-document' => 'Document' ],
		[ 'ion-document-text' => 'Document Text' ],
		[ 'ion-drag' => 'Drag' ],
		[ 'ion-earth' => 'Earth' ],
		[ 'ion-easel' => 'Easel' ],
		[ 'ion-edit' => 'Edit' ],
		[ 'ion-egg' => 'Egg' ],
		[ 'ion-eject' => 'Eject' ],
		[ 'ion-email' => 'Email' ],
		[ 'ion-email-unread' => 'Email Unread' ],
		[ 'ion-erlenmeyer-flask' => 'Erlenmeyer Flask' ],
		[ 'ion-erlenmeyer-flask-bubbles' => 'Erlenmeyer Flask Bubbles' ],
		[ 'ion-eye' => 'Eye' ],
		[ 'ion-eye-disabled' => 'Eye Disabled' ],
		[ 'ion-female' => 'Female' ],
		[ 'ion-filing' => 'Filing' ],
		[ 'ion-film-marker' => 'Film Marker' ],
		[ 'ion-fireball' => 'Fireball' ],
		[ 'ion-flag' => 'Flag' ],
		[ 'ion-flame' => 'Flame' ],
		[ 'ion-flash' => 'Flash' ],
		[ 'ion-flash-off' => 'Flash Off' ],
		[ 'ion-folder' => 'Folder' ],
		[ 'ion-fork' => 'Fork' ],
		[ 'ion-fork-repo' => 'Fork Repo' ],
		[ 'ion-forward' => 'Forward' ],
		[ 'ion-funnel' => 'Funnel' ],
		[ 'ion-gear-a' => 'Gear A' ],
		[ 'ion-gear-b' => 'Gear B' ],
		[ 'ion-grid' => 'Grid' ],
		[ 'ion-hammer' => 'Hammer' ],
		[ 'ion-happy' => 'Happy' ],
		[ 'ion-happy-outline' => 'Happy Outline' ],
		[ 'ion-headphone' => 'Headphone' ],
		[ 'ion-heart' => 'Heart' ],
		[ 'ion-heart-broken' => 'Heart Broken' ],
		[ 'ion-help' => 'Help' ],
		[ 'ion-help-buoy' => 'Help Buoy' ],
		[ 'ion-help-circled' => 'Help Circled' ],
		[ 'ion-home' => 'Home' ],
		[ 'ion-icecream' => 'Icecream' ],
		[ 'ion-image' => 'Image' ],
		[ 'ion-images' => 'Images' ],
		[ 'ion-information' => 'Information' ],
		[ 'ion-information-circled' => 'Informatcircled' ],
		[ 'ion-ionic' => 'Ionic' ],
		[ 'ion-ios-alarm' => 'Ios Alarm' ],
		[ 'ion-ios-alarm-outline' => 'Ios Alarm Outline' ],
		[ 'ion-ios-albums' => 'Ios Albums' ],
		[ 'ion-ios-albums-outline' => 'Ios Albums Outline' ],
		[ 'ion-ios-americanfootball' => 'Ios Americanfootball' ],
		[ 'ion-ios-americanfootball-outline' => 'Ios Americanfootball Outline' ],
		[ 'ion-ios-analytics' => 'Ios Analytics' ],
		[ 'ion-ios-analytics-outline' => 'Ios Analytics Outline' ],
		[ 'ion-ios-arrow-back' => 'Ios Arrow Back' ],
		[ 'ion-ios-arrow-down' => 'Ios Arrow Down' ],
		[ 'ion-ios-arrow-forward' => 'Ios Arrow Forward' ],
		[ 'ion-ios-arrow-left' => 'Ios Arrow Left' ],
		[ 'ion-ios-arrow-right' => 'Ios Arrow Right' ],
		[ 'ion-ios-arrow-thin-down' => 'Ios Arrow Thin Down' ],
		[ 'ion-ios-arrow-thin-left' => 'Ios Arrow Thin Left' ],
		[ 'ion-ios-arrow-thin-right' => 'Ios Arrow Thin Right' ],
		[ 'ion-ios-arrow-thin-up' => 'Ios Arrow Thin Up' ],
		[ 'ion-ios-arrow-up' => 'Ios Arrow Up' ],
		[ 'ion-ios-at' => 'Ios At' ],
		[ 'ion-ios-at-outline' => 'Ios At Outline' ],
		[ 'ion-ios-barcode' => 'Ios Barcode' ],
		[ 'ion-ios-barcode-outline' => 'Ios Barcode Outline' ],
		[ 'ion-ios-baseball' => 'Ios Baseball' ],
		[ 'ion-ios-baseball-outline' => 'Ios Baseball Outline' ],
		[ 'ion-ios-basketball' => 'Ios Basketball' ],
		[ 'ion-ios-basketball-outline' => 'Ios Basketball Outline' ],
		[ 'ion-ios-bell' => 'Ios Bell' ],
		[ 'ion-ios-bell-outline' => 'Ios Bell Outline' ],
		[ 'ion-ios-body' => 'Ios Body' ],
		[ 'ion-ios-body-outline' => 'Ios Body Outline' ],
		[ 'ion-ios-bolt' => 'Ios Bolt' ],
		[ 'ion-ios-bolt-outline' => 'Ios Bolt Outline' ],
		[ 'ion-ios-book' => 'Ios Book' ],
		[ 'ion-ios-book-outline' => 'Ios Book Outline' ],
		[ 'ion-ios-bookmarks' => 'Ios Bookmarks' ],
		[ 'ion-ios-bookmarks-outline' => 'Ios Bookmarks Outline' ],
		[ 'ion-ios-box' => 'Ios Box' ],
		[ 'ion-ios-box-outline' => 'Ios Box Outline' ],
		[ 'ion-ios-briefcase' => 'Ios Briefcase' ],
		[ 'ion-ios-briefcase-outline' => 'Ios Briefcase Outline' ],
		[ 'ion-ios-browsers' => 'Ios Browsers' ],
		[ 'ion-ios-browsers-outline' => 'Ios Browsers Outline' ],
		[ 'ion-ios-calculator' => 'Ios Calculator' ],
		[ 'ion-ios-calculator-outline' => 'Ios Calculator Outline' ],
		[ 'ion-ios-calendar' => 'Ios Calendar' ],
		[ 'ion-ios-calendar-outline' => 'Ios Calendar Outline' ],
		[ 'ion-ios-camera' => 'Ios Camera' ],
		[ 'ion-ios-camera-outline' => 'Ios Camera Outline' ],
		[ 'ion-ios-cart' => 'Ios Cart' ],
		[ 'ion-ios-cart-outline' => 'Ios Cart Outline' ],
		[ 'ion-ios-chatboxes' => 'Ios Chatboxes' ],
		[ 'ion-ios-chatboxes-outline' => 'Ios Chatboxes Outline' ],
		[ 'ion-ios-chatbubble' => 'Ios Chatbubble' ],
		[ 'ion-ios-chatbubble-outline' => 'Ios Chatbubble Outline' ],
		[ 'ion-ios-checkmark' => 'Ios Checkmark' ],
		[ 'ion-ios-checkmark-empty' => 'Ios Checkmark Empty' ],
		[ 'ion-ios-checkmark-outline' => 'Ios Checkmark Outline' ],
		[ 'ion-ios-circle-filled' => 'Ios Circle Filled' ],
		[ 'ion-ios-circle-outline' => 'Ios Circle Outline' ],
		[ 'ion-ios-clock' => 'Ios Clock' ],
		[ 'ion-ios-clock-outline' => 'Ios Clock Outline' ],
		[ 'ion-ios-close' => 'Ios Close' ],
		[ 'ion-ios-close-empty' => 'Ios Close Empty' ],
		[ 'ion-ios-close-outline' => 'Ios Close Outline' ],
		[ 'ion-ios-cloud' => 'Ios Cloud' ],
		[ 'ion-ios-cloud-download' => 'Ios Cloud Download' ],
		[ 'ion-ios-cloud-download-outline' => 'Ios Cloud Download Outline' ],
		[ 'ion-ios-cloud-outline' => 'Ios Cloud Outline' ],
		[ 'ion-ios-cloud-upload' => 'Ios Cloud Upload' ],
		[ 'ion-ios-cloud-upload-outline' => 'Ios Cloud Upload Outline' ],
		[ 'ion-ios-cloudy' => 'Ios Cloudy' ],
		[ 'ion-ios-cloudy-night' => 'Ios Cloudy Night' ],
		[ 'ion-ios-cloudy-night-outline' => 'Ios Cloudy Night Outline' ],
		[ 'ion-ios-cloudy-outline' => 'Ios Cloudy Outline' ],
		[ 'ion-ios-cog' => 'Ios Cog' ],
		[ 'ion-ios-cog-outline' => 'Ios Cog Outline' ],
		[ 'ion-ios-color-filter' => 'Ios Color Filter' ],
		[ 'ion-ios-color-filter-outline' => 'Ios Color Filter Outline' ],
		[ 'ion-ios-color-wand' => 'Ios Color Wand' ],
		[ 'ion-ios-color-wand-outline' => 'Ios Color Wand Outline' ],
		[ 'ion-ios-compose' => 'Ios Compose' ],
		[ 'ion-ios-compose-outline' => 'Ios Compose Outline' ],
		[ 'ion-ios-contact' => 'Ios Contact' ],
		[ 'ion-ios-contact-outline' => 'Ios Contact Outline' ],
		[ 'ion-ios-copy' => 'Ios Copy' ],
		[ 'ion-ios-copy-outline' => 'Ios Copy Outline' ],
		[ 'ion-ios-crop' => 'Ios Crop' ],
		[ 'ion-ios-crop-strong' => 'Ios Crop Strong' ],
		[ 'ion-ios-download' => 'Ios Download' ],
		[ 'ion-ios-download-outline' => 'Ios Download Outline' ],
		[ 'ion-ios-drag' => 'Ios Drag' ],
		[ 'ion-ios-email' => 'Ios Email' ],
		[ 'ion-ios-email-outline' => 'Ios Email Outline' ],
		[ 'ion-ios-eye' => 'Ios Eye' ],
		[ 'ion-ios-eye-outline' => 'Ios Eye Outline' ],
		[ 'ion-ios-fastforward' => 'Ios Fastforward' ],
		[ 'ion-ios-fastforward-outline' => 'Ios Fastforward Outline' ],
		[ 'ion-ios-filing' => 'Ios Filing' ],
		[ 'ion-ios-filing-outline' => 'Ios Filing Outline' ],
		[ 'ion-ios-film' => 'Ios Film' ],
		[ 'ion-ios-film-outline' => 'Ios Film Outline' ],
		[ 'ion-ios-flag' => 'Ios Flag' ],
		[ 'ion-ios-flag-outline' => 'Ios Flag Outline' ],
		[ 'ion-ios-flame' => 'Ios Flame' ],
		[ 'ion-ios-flame-outline' => 'Ios Flame Outline' ],
		[ 'ion-ios-flask' => 'Ios Flask' ],
		[ 'ion-ios-flask-outline' => 'Ios Flask Outline' ],
		[ 'ion-ios-flower' => 'Ios Flower' ],
		[ 'ion-ios-flower-outline' => 'Ios Flower Outline' ],
		[ 'ion-ios-folder' => 'Ios Folder' ],
		[ 'ion-ios-folder-outline' => 'Ios Folder Outline' ],
		[ 'ion-ios-football' => 'Ios Football' ],
		[ 'ion-ios-football-outline' => 'Ios Football Outline' ],
		[ 'ion-ios-game-controller-a' => 'Ios Game Controller A' ],
		[ 'ion-ios-game-controller-a-outline' => 'Ios Game Controller A Outline' ],
		[ 'ion-ios-game-controller-b' => 'Ios Game Controller B' ],
		[ 'ion-ios-game-controller-b-outline' => 'Ios Game Controller B Outline' ],
		[ 'ion-ios-gear' => 'Ios Gear' ],
		[ 'ion-ios-gear-outline' => 'Ios Gear Outline' ],
		[ 'ion-ios-glasses' => 'Ios Glasses' ],
		[ 'ion-ios-glasses-outline' => 'Ios Glasses Outline' ],
		[ 'ion-ios-grid-view' => 'Ios Grid View' ],
		[ 'ion-ios-grid-view-outline' => 'Ios Grid View Outline' ],
		[ 'ion-ios-heart' => 'Ios Heart' ],
		[ 'ion-ios-heart-outline' => 'Ios Heart Outline' ],
		[ 'ion-ios-help' => 'Ios Help' ],
		[ 'ion-ios-help-empty' => 'Ios Help Empty' ],
		[ 'ion-ios-help-outline' => 'Ios Help Outline' ],
		[ 'ion-ios-home' => 'Ios Home' ],
		[ 'ion-ios-home-outline' => 'Ios Home Outline' ],
		[ 'ion-ios-infinite' => 'Ios Infinite' ],
		[ 'ion-ios-infinite-outline' => 'Ios Infinite Outline' ],
		[ 'ion-ios-information' => 'Ios Information' ],
		[ 'ion-ios-information-empty' => 'Ios Informatempty' ],
		[ 'ion-ios-information-outline' => 'Ios Informatoutline' ],
		[ 'ion-ios-ionic-outline' => 'Ios Ionic Outline' ],
		[ 'ion-ios-keypad' => 'Ios Keypad' ],
		[ 'ion-ios-keypad-outline' => 'Ios Keypad Outline' ],
		[ 'ion-ios-lightbulb' => 'Ios Lightbulb' ],
		[ 'ion-ios-lightbulb-outline' => 'Ios Lightbulb Outline' ],
		[ 'ion-ios-list' => 'Ios List' ],
		[ 'ion-ios-list-outline' => 'Ios List Outline' ],
		[ 'ion-ios-location' => 'Ios Location' ],
		[ 'ion-ios-location-outline' => 'Ios Locatoutline' ],
		[ 'ion-ios-locked' => 'Ios Locked' ],
		[ 'ion-ios-locked-outline' => 'Ios Locked Outline' ],
		[ 'ion-ios-loop' => 'Ios Loop' ],
		[ 'ion-ios-loop-strong' => 'Ios Loop Strong' ],
		[ 'ion-ios-medical' => 'Ios Medical' ],
		[ 'ion-ios-medical-outline' => 'Ios Medical Outline' ],
		[ 'ion-ios-medkit' => 'Ios Medkit' ],
		[ 'ion-ios-medkit-outline' => 'Ios Medkit Outline' ],
		[ 'ion-ios-mic' => 'Ios Mic' ],
		[ 'ion-ios-mic-off' => 'Ios Mic Off' ],
		[ 'ion-ios-mic-outline' => 'Ios Mic Outline' ],
		[ 'ion-ios-minus' => 'Ios Minus' ],
		[ 'ion-ios-minus-empty' => 'Ios Minus Empty' ],
		[ 'ion-ios-minus-outline' => 'Ios Minus Outline' ],
		[ 'ion-ios-monitor' => 'Ios Monitor' ],
		[ 'ion-ios-monitor-outline' => 'Ios Monitor Outline' ],
		[ 'ion-ios-moon' => 'Ios Moon' ],
		[ 'ion-ios-moon-outline' => 'Ios Moon Outline' ],
		[ 'ion-ios-more' => 'Ios More' ],
		[ 'ion-ios-more-outline' => 'Ios More Outline' ],
		[ 'ion-ios-musical-note' => 'Ios Musical Note' ],
		[ 'ion-ios-musical-notes' => 'Ios Musical Notes' ],
		[ 'ion-ios-navigate' => 'Ios Navigate' ],
		[ 'ion-ios-navigate-outline' => 'Ios Navigate Outline' ],
		[ 'ion-ios-nutrition' => 'Ios Nutrition' ],
		[ 'ion-ios-nutrition-outline' => 'Ios Nutritoutline' ],
		[ 'ion-ios-paper' => 'Ios Paper' ],
		[ 'ion-ios-paper-outline' => 'Ios Paper Outline' ],
		[ 'ion-ios-paperplane' => 'Ios Paperplane' ],
		[ 'ion-ios-paperplane-outline' => 'Ios Paperplane Outline' ],
		[ 'ion-ios-partlysunny' => 'Ios Partlysunny' ],
		[ 'ion-ios-partlysunny-outline' => 'Ios Partlysunny Outline' ],
		[ 'ion-ios-pause' => 'Ios Pause' ],
		[ 'ion-ios-pause-outline' => 'Ios Pause Outline' ],
		[ 'ion-ios-paw' => 'Ios Paw' ],
		[ 'ion-ios-paw-outline' => 'Ios Paw Outline' ],
		[ 'ion-ios-people' => 'Ios People' ],
		[ 'ion-ios-people-outline' => 'Ios People Outline' ],
		[ 'ion-ios-person' => 'Ios Person' ],
		[ 'ion-ios-person-outline' => 'Ios Person Outline' ],
		[ 'ion-ios-personadd' => 'Ios Personadd' ],
		[ 'ion-ios-personadd-outline' => 'Ios Personadd Outline' ],
		[ 'ion-ios-photos' => 'Ios Photos' ],
		[ 'ion-ios-photos-outline' => 'Ios Photos Outline' ],
		[ 'ion-ios-pie' => 'Ios Pie' ],
		[ 'ion-ios-pie-outline' => 'Ios Pie Outline' ],
		[ 'ion-ios-pint' => 'Ios Pint' ],
		[ 'ion-ios-pint-outline' => 'Ios Pint Outline' ],
		[ 'ion-ios-play' => 'Ios Play' ],
		[ 'ion-ios-play-outline' => 'Ios Play Outline' ],
		[ 'ion-ios-plus' => 'Ios Plus' ],
		[ 'ion-ios-plus-empty' => 'Ios Plus Empty' ],
		[ 'ion-ios-plus-outline' => 'Ios Plus Outline' ],
		[ 'ion-ios-pricetag' => 'Ios Pricetag' ],
		[ 'ion-ios-pricetag-outline' => 'Ios Pricetag Outline' ],
		[ 'ion-ios-pricetags' => 'Ios Pricetags' ],
		[ 'ion-ios-pricetags-outline' => 'Ios Pricetags Outline' ],
		[ 'ion-ios-printer' => 'Ios Printer' ],
		[ 'ion-ios-printer-outline' => 'Ios Printer Outline' ],
		[ 'ion-ios-pulse' => 'Ios Pulse' ],
		[ 'ion-ios-pulse-strong' => 'Ios Pulse Strong' ],
		[ 'ion-ios-rainy' => 'Ios Rainy' ],
		[ 'ion-ios-rainy-outline' => 'Ios Rainy Outline' ],
		[ 'ion-ios-recording' => 'Ios Recording' ],
		[ 'ion-ios-recording-outline' => 'Ios Recording Outline' ],
		[ 'ion-ios-redo' => 'Ios Redo' ],
		[ 'ion-ios-redo-outline' => 'Ios Redo Outline' ],
		[ 'ion-ios-refresh' => 'Ios Refresh' ],
		[ 'ion-ios-refresh-empty' => 'Ios Refresh Empty' ],
		[ 'ion-ios-refresh-outline' => 'Ios Refresh Outline' ],
		[ 'ion-ios-reload' => 'Ios Reload' ],
		[ 'ion-ios-reverse-camera' => 'Ios Reverse Camera' ],
		[ 'ion-ios-reverse-camera-outline' => 'Ios Reverse Camera Outline' ],
		[ 'ion-ios-rewind' => 'Ios Rewind' ],
		[ 'ion-ios-rewind-outline' => 'Ios Rewind Outline' ],
		[ 'ion-ios-rose' => 'Ios Rose' ],
		[ 'ion-ios-rose-outline' => 'Ios Rose Outline' ],
		[ 'ion-ios-search' => 'Ios Search' ],
		[ 'ion-ios-search-strong' => 'Ios Search Strong' ],
		[ 'ion-ios-settings' => 'Ios Settings' ],
		[ 'ion-ios-settings-strong' => 'Ios Settings Strong' ],
		[ 'ion-ios-shuffle' => 'Ios Shuffle' ],
		[ 'ion-ios-shuffle-strong' => 'Ios Shuffle Strong' ],
		[ 'ion-ios-skipbackward' => 'Ios Skipbackward' ],
		[ 'ion-ios-skipbackward-outline' => 'Ios Skipbackward Outline' ],
		[ 'ion-ios-skipforward' => 'Ios Skipforward' ],
		[ 'ion-ios-skipforward-outline' => 'Ios Skipforward Outline' ],
		[ 'ion-ios-snowy' => 'Ios Snowy' ],
		[ 'ion-ios-speedometer' => 'Ios Speedometer' ],
		[ 'ion-ios-speedometer-outline' => 'Ios Speedometer Outline' ],
		[ 'ion-ios-star' => 'Ios Star' ],
		[ 'ion-ios-star-half' => 'Ios Star Half' ],
		[ 'ion-ios-star-outline' => 'Ios Star Outline' ],
		[ 'ion-ios-stopwatch' => 'Ios Stopwatch' ],
		[ 'ion-ios-stopwatch-outline' => 'Ios Stopwatch Outline' ],
		[ 'ion-ios-sunny' => 'Ios Sunny' ],
		[ 'ion-ios-sunny-outline' => 'Ios Sunny Outline' ],
		[ 'ion-ios-telephone' => 'Ios Telephone' ],
		[ 'ion-ios-telephone-outline' => 'Ios Telephone Outline' ],
		[ 'ion-ios-tennisball' => 'Ios Tennisball' ],
		[ 'ion-ios-tennisball-outline' => 'Ios Tennisball Outline' ],
		[ 'ion-ios-thunderstorm' => 'Ios Thunderstorm' ],
		[ 'ion-ios-thunderstorm-outline' => 'Ios Thunderstorm Outline' ],
		[ 'ion-ios-time' => 'Ios Time' ],
		[ 'ion-ios-time-outline' => 'Ios Time Outline' ],
		[ 'ion-ios-timer' => 'Ios Timer' ],
		[ 'ion-ios-timer-outline' => 'Ios Timer Outline' ],
		[ 'ion-ios-toggle' => 'Ios Toggle' ],
		[ 'ion-ios-toggle-outline' => 'Ios Toggle Outline' ],
		[ 'ion-ios-trash' => 'Ios Trash' ],
		[ 'ion-ios-trash-outline' => 'Ios Trash Outline' ],
		[ 'ion-ios-undo' => 'Ios Undo' ],
		[ 'ion-ios-undo-outline' => 'Ios Undo Outline' ],
		[ 'ion-ios-unlocked' => 'Ios Unlocked' ],
		[ 'ion-ios-unlocked-outline' => 'Ios Unlocked Outline' ],
		[ 'ion-ios-upload' => 'Ios Upload' ],
		[ 'ion-ios-upload-outline' => 'Ios Upload Outline' ],
		[ 'ion-ios-videocam' => 'Ios Videocam' ],
		[ 'ion-ios-videocam-outline' => 'Ios Videocam Outline' ],
		[ 'ion-ios-volume-high' => 'Ios Volume High' ],
		[ 'ion-ios-volume-low' => 'Ios Volume Low' ],
		[ 'ion-ios-wineglass' => 'Ios Wineglass' ],
		[ 'ion-ios-wineglass-outline' => 'Ios Wineglass Outline' ],
		[ 'ion-ios-world' => 'Ios World' ],
		[ 'ion-ios-world-outline' => 'Ios World Outline' ],
		[ 'ion-ipad' => 'Ipad' ],
		[ 'ion-iphone' => 'Iphone' ],
		[ 'ion-ipod' => 'Ipod' ],
		[ 'ion-jet' => 'Jet' ],
		[ 'ion-key' => 'Key' ],
		[ 'ion-knife' => 'Knife' ],
		[ 'ion-laptop' => 'Laptop' ],
		[ 'ion-leaf' => 'Leaf' ],
		[ 'ion-levels' => 'Levels' ],
		[ 'ion-lightbulb' => 'Lightbulb' ],
		[ 'ion-link' => 'Link' ],
		[ 'ion-load-a' => 'Load A' ],
		[ 'ion-load-b' => 'Load B' ],
		[ 'ion-load-c' => 'Load C' ],
		[ 'ion-load-d' => 'Load D' ],
		[ 'ion-location' => 'Location' ],
		[ 'ion-lock-combination' => 'Lock Combination' ],
		[ 'ion-locked' => 'Locked' ],
		[ 'ion-log-in' => 'Log In' ],
		[ 'ion-log-out' => 'Log Out' ],
		[ 'ion-loop' => 'Loop' ],
		[ 'ion-magnet' => 'Magnet' ],
		[ 'ion-male' => 'Male' ],
		[ 'ion-man' => 'Man' ],
		[ 'ion-map' => 'Map' ],
		[ 'ion-medkit' => 'Medkit' ],
		[ 'ion-merge' => 'Merge' ],
		[ 'ion-mic-a' => 'Mic A' ],
		[ 'ion-mic-b' => 'Mic B' ],
		[ 'ion-mic-c' => 'Mic C' ],
		[ 'ion-minus' => 'Minus' ],
		[ 'ion-minus-circled' => 'Minus Circled' ],
		[ 'ion-minus-round' => 'Minus Round' ],
		[ 'ion-model-s' => 'Model S' ],
		[ 'ion-monitor' => 'Monitor' ],
		[ 'ion-more' => 'More' ],
		[ 'ion-mouse' => 'Mouse' ],
		[ 'ion-music-note' => 'Music Note' ],
		[ 'ion-navicon' => 'Navicon' ],
		[ 'ion-navicon-round' => 'Navicon Round' ],
		[ 'ion-navigate' => 'Navigate' ],
		[ 'ion-network' => 'Network' ],
		[ 'ion-no-smoking' => 'No Smoking' ],
		[ 'ion-nuclear' => 'Nuclear' ],
		[ 'ion-outlet' => 'Outlet' ],
		[ 'ion-paintbrush' => 'Paintbrush' ],
		[ 'ion-paintbucket' => 'Paintbucket' ],
		[ 'ion-paper-airplane' => 'Paper Airplane' ],
		[ 'ion-paperclip' => 'Paperclip' ],
		[ 'ion-pause' => 'Pause' ],
		[ 'ion-person' => 'Person' ],
		[ 'ion-person-add' => 'Person Add' ],
		[ 'ion-person-stalker' => 'Person Stalker' ],
		[ 'ion-pie-graph' => 'Pie Graph' ],
		[ 'ion-pin' => 'Pin' ],
		[ 'ion-pinpoint' => 'Pinpoint' ],
		[ 'ion-pizza' => 'Pizza' ],
		[ 'ion-plane' => 'Plane' ],
		[ 'ion-planet' => 'Planet' ],
		[ 'ion-play' => 'Play' ],
		[ 'ion-playstation' => 'Playstation' ],
		[ 'ion-plus' => 'Plus' ],
		[ 'ion-plus-circled' => 'Plus Circled' ],
		[ 'ion-plus-round' => 'Plus Round' ],
		[ 'ion-podium' => 'Podium' ],
		[ 'ion-pound' => 'Pound' ],
		[ 'ion-power' => 'Power' ],
		[ 'ion-pricetag' => 'Pricetag' ],
		[ 'ion-pricetags' => 'Pricetags' ],
		[ 'ion-printer' => 'Printer' ],
		[ 'ion-pull-request' => 'Pull Request' ],
		[ 'ion-qr-scanner' => 'Qr Scanner' ],
		[ 'ion-quote' => 'Quote' ],
		[ 'ion-radio-waves' => 'Radio Waves' ],
		[ 'ion-record' => 'Record' ],
		[ 'ion-refresh' => 'Refresh' ],
		[ 'ion-reply' => 'Reply' ],
		[ 'ion-reply-all' => 'Reply All' ],
		[ 'ion-ribbon-a' => 'Ribbon A' ],
		[ 'ion-ribbon-b' => 'Ribbon B' ],
		[ 'ion-sad' => 'Sad' ],
		[ 'ion-sad-outline' => 'Sad Outline' ],
		[ 'ion-scissors' => 'Scissors' ],
		[ 'ion-search' => 'Search' ],
		[ 'ion-settings' => 'Settings' ],
		[ 'ion-share' => 'Share' ],
		[ 'ion-shuffle' => 'Shuffle' ],
		[ 'ion-skip-backward' => 'Skip Backward' ],
		[ 'ion-skip-forward' => 'Skip Forward' ],
		[ 'ion-social-android' => 'Social Android' ],
		[ 'ion-social-android-outline' => 'Social Android Outline' ],
		[ 'ion-social-angular' => 'Social Angular' ],
		[ 'ion-social-angular-outline' => 'Social Angular Outline' ],
		[ 'ion-social-apple' => 'Social Apple' ],
		[ 'ion-social-apple-outline' => 'Social Apple Outline' ],
		[ 'ion-social-bitcoin' => 'Social Bitcoin' ],
		[ 'ion-social-bitcoin-outline' => 'Social Bitcoin Outline' ],
		[ 'ion-social-buffer' => 'Social Buffer' ],
		[ 'ion-social-buffer-outline' => 'Social Buffer Outline' ],
		[ 'ion-social-chrome' => 'Social Chrome' ],
		[ 'ion-social-chrome-outline' => 'Social Chrome Outline' ],
		[ 'ion-social-codepen' => 'Social Codepen' ],
		[ 'ion-social-codepen-outline' => 'Social Codepen Outline' ],
		[ 'ion-social-css3' => 'Social Css3' ],
		[ 'ion-social-css3-outline' => 'Social Css3 Outline' ],
		[ 'ion-social-designernews' => 'Social Designernews' ],
		[ 'ion-social-designernews-outline' => 'Social Designernews Outline' ],
		[ 'ion-social-dribbble' => 'Social Dribbble' ],
		[ 'ion-social-dribbble-outline' => 'Social Dribbble Outline' ],
		[ 'ion-social-dropbox' => 'Social Dropbox' ],
		[ 'ion-social-dropbox-outline' => 'Social Dropbox Outline' ],
		[ 'ion-social-euro' => 'Social Euro' ],
		[ 'ion-social-euro-outline' => 'Social Euro Outline' ],
		[ 'ion-social-facebook' => 'Social Facebook' ],
		[ 'ion-social-facebook-outline' => 'Social Facebook Outline' ],
		[ 'ion-social-foursquare' => 'Social Foursquare' ],
		[ 'ion-social-foursquare-outline' => 'Social Foursquare Outline' ],
		[ 'ion-social-freebsd-devil' => 'Social Freebsd Devil' ],
		[ 'ion-social-github' => 'Social Github' ],
		[ 'ion-social-github-outline' => 'Social Github Outline' ],
		[ 'ion-social-google' => 'Social Google' ],
		[ 'ion-social-google-outline' => 'Social Google Outline' ],
		[ 'ion-social-googleplus' => 'Social Googleplus' ],
		[ 'ion-social-googleplus-outline' => 'Social Googleplus Outline' ],
		[ 'ion-social-hackernews' => 'Social Hackernews' ],
		[ 'ion-social-hackernews-outline' => 'Social Hackernews Outline' ],
		[ 'ion-social-html5' => 'Social Html5' ],
		[ 'ion-social-html5-outline' => 'Social Html5 Outline' ],
		[ 'ion-social-instagram' => 'Social Instagram' ],
		[ 'ion-social-instagram-outline' => 'Social Instagram Outline' ],
		[ 'ion-social-javascript' => 'Social Javascript' ],
		[ 'ion-social-javascript-outline' => 'Social Javascript Outline' ],
		[ 'ion-social-linkedin' => 'Social Linkedin' ],
		[ 'ion-social-linkedin-outline' => 'Social Linkedin Outline' ],
		[ 'ion-social-markdown' => 'Social Markdown' ],
		[ 'ion-social-nodejs' => 'Social Nodejs' ],
		[ 'ion-social-octocat' => 'Social Octocat' ],
		[ 'ion-social-pinterest' => 'Social Pinterest' ],
		[ 'ion-social-pinterest-outline' => 'Social Pinterest Outline' ],
		[ 'ion-social-python' => 'Social Python' ],
		[ 'ion-social-reddit' => 'Social Reddit' ],
		[ 'ion-social-reddit-outline' => 'Social Reddit Outline' ],
		[ 'ion-social-rss' => 'Social Rss' ],
		[ 'ion-social-rss-outline' => 'Social Rss Outline' ],
		[ 'ion-social-sass' => 'Social Sass' ],
		[ 'ion-social-skype' => 'Social Skype' ],
		[ 'ion-social-skype-outline' => 'Social Skype Outline' ],
		[ 'ion-social-snapchat' => 'Social Snapchat' ],
		[ 'ion-social-snapchat-outline' => 'Social Snapchat Outline' ],
		[ 'ion-social-tumblr' => 'Social Tumblr' ],
		[ 'ion-social-tumblr-outline' => 'Social Tumblr Outline' ],
		[ 'ion-social-tux' => 'Social Tux' ],
		[ 'ion-social-twitch' => 'Social Twitch' ],
		[ 'ion-social-twitch-outline' => 'Social Twitch Outline' ],
		[ 'ion-social-twitter' => 'Social Twitter' ],
		[ 'ion-social-twitter-outline' => 'Social Twitter Outline' ],
		[ 'ion-social-usd' => 'Social Usd' ],
		[ 'ion-social-usd-outline' => 'Social Usd Outline' ],
		[ 'ion-social-vimeo' => 'Social Vimeo' ],
		[ 'ion-social-vimeo-outline' => 'Social Vimeo Outline' ],
		[ 'ion-social-whatsapp' => 'Social Whatsapp' ],
		[ 'ion-social-whatsapp-outline' => 'Social Whatsapp Outline' ],
		[ 'ion-social-windows' => 'Social Windows' ],
		[ 'ion-social-windows-outline' => 'Social Windows Outline' ],
		[ 'ion-social-wordpress' => 'Social Wordpress' ],
		[ 'ion-social-wordpress-outline' => 'Social Wordpress Outline' ],
		[ 'ion-social-yahoo' => 'Social Yahoo' ],
		[ 'ion-social-yahoo-outline' => 'Social Yahoo Outline' ],
		[ 'ion-social-yen' => 'Social Yen' ],
		[ 'ion-social-yen-outline' => 'Social Yen Outline' ],
		[ 'ion-social-youtube' => 'Social Youtube' ],
		[ 'ion-social-youtube-outline' => 'Social Youtube Outline' ],
		[ 'ion-soup-can' => 'Soup Can' ],
		[ 'ion-soup-can-outline' => 'Soup Can Outline' ],
		[ 'ion-speakerphone' => 'Speakerphone' ],
		[ 'ion-speedometer' => 'Speedometer' ],
		[ 'ion-spoon' => 'Spoon' ],
		[ 'ion-star' => 'Star' ],
		[ 'ion-stats-bars' => 'Stats Bars' ],
		[ 'ion-steam' => 'Steam' ],
		[ 'ion-stop' => 'Stop' ],
		[ 'ion-thermometer' => 'Thermometer' ],
		[ 'ion-thumbsdown' => 'Thumbsdown' ],
		[ 'ion-thumbsup' => 'Thumbsup' ],
		[ 'ion-toggle' => 'Toggle' ],
		[ 'ion-toggle-filled' => 'Toggle Filled' ],
		[ 'ion-transgender' => 'Transgender' ],
		[ 'ion-trash-a' => 'Trash A' ],
		[ 'ion-trash-b' => 'Trash B' ],
		[ 'ion-trophy' => 'Trophy' ],
		[ 'ion-tshirt' => 'Tshirt' ],
		[ 'ion-tshirt-outline' => 'Tshirt Outline' ],
		[ 'ion-umbrella' => 'Umbrella' ],
		[ 'ion-university' => 'University' ],
		[ 'ion-unlocked' => 'Unlocked' ],
		[ 'ion-upload' => 'Upload' ],
		[ 'ion-usb' => 'Usb' ],
		[ 'ion-videocamera' => 'Videocamera' ],
		[ 'ion-volume-high' => 'Volume High' ],
		[ 'ion-volume-low' => 'Volume Low' ],
		[ 'ion-volume-medium' => 'Volume Medium' ],
		[ 'ion-volume-mute' => 'Volume Mute' ],
		[ 'ion-wand' => 'Wand' ],
		[ 'ion-waterdrop' => 'Waterdrop' ],
		[ 'ion-wifi' => 'Wifi' ],
		[ 'ion-wineglass' => 'Wineglass' ],
		[ 'ion-woman' => 'Woman' ],
		[ 'ion-wrench' => 'Wrench' ],
		[ 'ion-xbox' => 'Xbox' ],
	];
}

/**
 * Stroke 7 Icons.
 *
 * @return array
 */
function aheto_icons_pe_icon_7_stroke() {
	return [
		[ 'pe-7s-album' => 'Album' ],
		[ 'pe-7s-arc' => 'Arc' ],
		[ 'pe-7s-back-2' => 'Back 2' ],
		[ 'pe-7s-bandaid' => 'Bandaid' ],
		[ 'pe-7s-car' => 'Car' ],
		[ 'pe-7s-diamond' => 'Diamond' ],
		[ 'pe-7s-door-lock' => 'Door Lock' ],
		[ 'pe-7s-eyedropper' => 'Eyedropper' ],
		[ 'pe-7s-female' => 'Female' ],
		[ 'pe-7s-gym' => 'Gym' ],
		[ 'pe-7s-hammer' => 'Hammer' ],
		[ 'pe-7s-headphones' => 'Headphones' ],
		[ 'pe-7s-helm' => 'Helm' ],
		[ 'pe-7s-hourglass' => 'Hourglass' ],
		[ 'pe-7s-leaf' => 'Leaf' ],
		[ 'pe-7s-magic-wand' => 'Magic Wand' ],
		[ 'pe-7s-male' => 'Male' ],
		[ 'pe-7s-map-2' => 'Map 2' ],
		[ 'pe-7s-next-2' => 'Next 2' ],
		[ 'pe-7s-paint-bucket' => 'Paint Bucket' ],
		[ 'pe-7s-pendrive' => 'Pendrive' ],
		[ 'pe-7s-photo' => 'Photo' ],
		[ 'pe-7s-piggy' => 'Piggy' ],
		[ 'pe-7s-plugin' => 'Plugin' ],
		[ 'pe-7s-refresh-2' => 'Refresh 2' ],
		[ 'pe-7s-rocket' => 'Rocket' ],
		[ 'pe-7s-settings' => 'Settings' ],
		[ 'pe-7s-shield' => 'Shield' ],
		[ 'pe-7s-smile' => 'Smile' ],
		[ 'pe-7s-usb' => 'Usb' ],
		[ 'pe-7s-vector' => 'Vector' ],
		[ 'pe-7s-wine' => 'Wine' ],
		[ 'pe-7s-cloud-upload' => 'Cloud Upload' ],
		[ 'pe-7s-cash' => 'Cash' ],
		[ 'pe-7s-close' => 'Close' ],
		[ 'pe-7s-bluetooth' => 'Bluetooth' ],
		[ 'pe-7s-cloud-download' => 'Cloud Download' ],
		[ 'pe-7s-way' => 'Way' ],
		[ 'pe-7s-close-circle' => 'Close Circle' ],
		[ 'pe-7s-id' => 'Id' ],
		[ 'pe-7s-angle-up' => 'Angle Up' ],
		[ 'pe-7s-wristwatch' => 'Wristwatch' ],
		[ 'pe-7s-angle-up-circle' => 'Angle Up Circle' ],
		[ 'pe-7s-world' => 'World' ],
		[ 'pe-7s-angle-right' => 'Angle Right' ],
		[ 'pe-7s-volume' => 'Volume' ],
		[ 'pe-7s-angle-right-circle' => 'Angle Right Circle' ],
		[ 'pe-7s-users' => 'Users' ],
		[ 'pe-7s-angle-left' => 'Angle Left' ],
		[ 'pe-7s-user-female' => 'User Female' ],
		[ 'pe-7s-angle-left-circle' => 'Angle Left Circle' ],
		[ 'pe-7s-up-arrow' => 'Up Arrow' ],
		[ 'pe-7s-angle-down' => 'Angle Down' ],
		[ 'pe-7s-switch' => 'Switch' ],
		[ 'pe-7s-angle-down-circle' => 'Angle Down Circle' ],
		[ 'pe-7s-scissors' => 'Scissors' ],
		[ 'pe-7s-wallet' => 'Wallet' ],
		[ 'pe-7s-safe' => 'Safe' ],
		[ 'pe-7s-volume2' => 'Volume2' ],
		[ 'pe-7s-volume1' => 'Volume1' ],
		[ 'pe-7s-voicemail' => 'Voicemail' ],
		[ 'pe-7s-video' => 'Video' ],
		[ 'pe-7s-user' => 'User' ],
		[ 'pe-7s-upload' => 'Upload' ],
		[ 'pe-7s-unlock' => 'Unlock' ],
		[ 'pe-7s-umbrella' => 'Umbrella' ],
		[ 'pe-7s-trash' => 'Trash' ],
		[ 'pe-7s-tools' => 'Tools' ],
		[ 'pe-7s-timer' => 'Timer' ],
		[ 'pe-7s-ticket' => 'Ticket' ],
		[ 'pe-7s-target' => 'Target' ],
		[ 'pe-7s-sun' => 'Sun' ],
		[ 'pe-7s-study' => 'Study' ],
		[ 'pe-7s-stopwatch' => 'Stopwatch' ],
		[ 'pe-7s-star' => 'Star' ],
		[ 'pe-7s-speaker' => 'Speaker' ],
		[ 'pe-7s-signal' => 'Signal' ],
		[ 'pe-7s-shuffle' => 'Shuffle' ],
		[ 'pe-7s-shopbag' => 'Shopbag' ],
		[ 'pe-7s-share' => 'Share' ],
		[ 'pe-7s-server' => 'Server' ],
		[ 'pe-7s-search' => 'Search' ],
		[ 'pe-7s-film' => 'Film' ],
		[ 'pe-7s-science' => 'Science' ],
		[ 'pe-7s-disk' => 'Disk' ],
		[ 'pe-7s-ribbon' => 'Ribbon' ],
		[ 'pe-7s-repeat' => 'Repeat' ],
		[ 'pe-7s-refresh' => 'Refresh' ],
		[ 'pe-7s-add-user' => 'Add User' ],
		[ 'pe-7s-refresh-cloud' => 'Refresh Cloud' ],
		[ 'pe-7s-paperclip' => 'Paperclip' ],
		[ 'pe-7s-radio' => 'Radio' ],
		[ 'pe-7s-note2' => 'Note2' ],
		[ 'pe-7s-print' => 'Print' ],
		[ 'pe-7s-network' => 'Network' ],
		[ 'pe-7s-prev' => 'Prev' ],
		[ 'pe-7s-mute' => 'Mute' ],
		[ 'pe-7s-power' => 'Power' ],
		[ 'pe-7s-medal' => 'Medal' ],
		[ 'pe-7s-portfolio' => 'Portfolio' ],
		[ 'pe-7s-like2' => 'Like2' ],
		[ 'pe-7s-plus' => 'Plus' ],
		[ 'pe-7s-left-arrow' => 'Left Arrow' ],
		[ 'pe-7s-play' => 'Play' ],
		[ 'pe-7s-key' => 'Key' ],
		[ 'pe-7s-plane' => 'Plane' ],
		[ 'pe-7s-joy' => 'Joy' ],
		[ 'pe-7s-photo-gallery' => 'Photo Gallery' ],
		[ 'pe-7s-pin' => 'Pin' ],
		[ 'pe-7s-phone' => 'Phone' ],
		[ 'pe-7s-plug' => 'Plug' ],
		[ 'pe-7s-pen' => 'Pen' ],
		[ 'pe-7s-right-arrow' => 'Right Arrow' ],
		[ 'pe-7s-paper-plane' => 'Paper Plane' ],
		[ 'pe-7s-delete-user' => 'Delete User' ],
		[ 'pe-7s-paint' => 'Paint' ],
		[ 'pe-7s-bottom-arrow' => 'Bottom Arrow' ],
		[ 'pe-7s-notebook' => 'Notebook' ],
		[ 'pe-7s-note' => 'Note' ],
		[ 'pe-7s-next' => 'Next' ],
		[ 'pe-7s-news-paper' => 'News Paper' ],
		[ 'pe-7s-musiclist' => 'Musiclist' ],
		[ 'pe-7s-music' => 'Music' ],
		[ 'pe-7s-mouse' => 'Mouse' ],
		[ 'pe-7s-more' => 'More' ],
		[ 'pe-7s-moon' => 'Moon' ],
		[ 'pe-7s-monitor' => 'Monitor' ],
		[ 'pe-7s-micro' => 'Micro' ],
		[ 'pe-7s-menu' => 'Menu' ],
		[ 'pe-7s-map' => 'Map' ],
		[ 'pe-7s-map-marker' => 'Map Marker' ],
		[ 'pe-7s-mail' => 'Mail' ],
		[ 'pe-7s-mail-open' => 'Mail Open' ],
		[ 'pe-7s-mail-open-file' => 'Mail Open File' ],
		[ 'pe-7s-magnet' => 'Magnet' ],
		[ 'pe-7s-loop' => 'Loop' ],
		[ 'pe-7s-look' => 'Look' ],
		[ 'pe-7s-lock' => 'Lock' ],
		[ 'pe-7s-lintern' => 'Lintern' ],
		[ 'pe-7s-link' => 'Link' ],
		[ 'pe-7s-like' => 'Like' ],
		[ 'pe-7s-light' => 'Light' ],
		[ 'pe-7s-less' => 'Less' ],
		[ 'pe-7s-keypad' => 'Keypad' ],
		[ 'pe-7s-junk' => 'Junk' ],
		[ 'pe-7s-info' => 'Info' ],
		[ 'pe-7s-home' => 'Home' ],
		[ 'pe-7s-help2' => 'Help2' ],
		[ 'pe-7s-help1' => 'Help1' ],
		[ 'pe-7s-graph3' => 'Graph3' ],
		[ 'pe-7s-graph2' => 'Graph2' ],
		[ 'pe-7s-graph1' => 'Graph1' ],
		[ 'pe-7s-graph' => 'Graph' ],
		[ 'pe-7s-global' => 'Global' ],
		[ 'pe-7s-gleam' => 'Gleam' ],
		[ 'pe-7s-glasses' => 'Glasses' ],
		[ 'pe-7s-gift' => 'Gift' ],
		[ 'pe-7s-folder' => 'Folder' ],
		[ 'pe-7s-flag' => 'Flag' ],
		[ 'pe-7s-filter' => 'Filter' ],
		[ 'pe-7s-file' => 'File' ],
		[ 'pe-7s-expand1' => 'Expand1' ],
		[ 'pe-7s-exapnd2' => 'Exapnd2' ],
		[ 'pe-7s-edit' => 'Edit' ],
		[ 'pe-7s-drop' => 'Drop' ],
		[ 'pe-7s-drawer' => 'Drawer' ],
		[ 'pe-7s-download' => 'Download' ],
		[ 'pe-7s-display2' => 'Display2' ],
		[ 'pe-7s-display1' => 'Display1' ],
		[ 'pe-7s-diskette' => 'Diskette' ],
		[ 'pe-7s-date' => 'Date' ],
		[ 'pe-7s-cup' => 'Cup' ],
		[ 'pe-7s-culture' => 'Culture' ],
		[ 'pe-7s-crop' => 'Crop' ],
		[ 'pe-7s-credit' => 'Credit' ],
		[ 'pe-7s-copy-file' => 'Copy File' ],
		[ 'pe-7s-config' => 'Config' ],
		[ 'pe-7s-compass' => 'Compass' ],
		[ 'pe-7s-comment' => 'Comment' ],
		[ 'pe-7s-coffee' => 'Coffee' ],
		[ 'pe-7s-cloud' => 'Cloud' ],
		[ 'pe-7s-clock' => 'Clock' ],
		[ 'pe-7s-check' => 'Check' ],
		[ 'pe-7s-chat' => 'Chat' ],
		[ 'pe-7s-cart' => 'Cart' ],
		[ 'pe-7s-camera' => 'Camera' ],
		[ 'pe-7s-call' => 'Call' ],
		[ 'pe-7s-calculator' => 'Calculator' ],
		[ 'pe-7s-browser' => 'Browser' ],
		[ 'pe-7s-box2' => 'Box2' ],
		[ 'pe-7s-box1' => 'Box1' ],
		[ 'pe-7s-bookmarks' => 'Bookmarks' ],
		[ 'pe-7s-bicycle' => 'Bicycle' ],
		[ 'pe-7s-bell' => 'Bell' ],
		[ 'pe-7s-battery' => 'Battery' ],
		[ 'pe-7s-ball' => 'Ball' ],
		[ 'pe-7s-back' => 'Back' ],
		[ 'pe-7s-attention' => 'Attention' ],
		[ 'pe-7s-anchor' => 'Anchor' ],
		[ 'pe-7s-albums' => 'Albums' ],
		[ 'pe-7s-alarm' => 'Alarm' ],
		[ 'pe-7s-airplay' => 'Airplay' ],
	];
}

/**
 * Themify Icons.
 *
 * @return array
 */
function aheto_icons_themify() {
	return [
		[ 'ti-wand' => 'Wand' ],
		[ 'ti-volume' => 'Volume' ],
		[ 'ti-user' => 'User' ],
		[ 'ti-unlock' => 'Unlock' ],
		[ 'ti-unlink' => 'Unlink' ],
		[ 'ti-trash' => 'Trash' ],
		[ 'ti-thought' => 'Thought' ],
		[ 'ti-target' => 'Target' ],
		[ 'ti-tag' => 'Tag' ],
		[ 'ti-tablet' => 'Tablet' ],
		[ 'ti-star' => 'Star' ],
		[ 'ti-spray' => 'Spray' ],
		[ 'ti-signal' => 'Signal' ],
		[ 'ti-shopping-cart' => 'Shopping Cart' ],
		[ 'ti-shopping-cart-full' => 'Shopping Cart Full' ],
		[ 'ti-settings' => 'Settings' ],
		[ 'ti-search' => 'Search' ],
		[ 'ti-zoom-in' => 'Zoom In' ],
		[ 'ti-zoom-out' => 'Zoom Out' ],
		[ 'ti-cut' => 'Cut' ],
		[ 'ti-ruler' => 'Ruler' ],
		[ 'ti-ruler-pencil' => 'Ruler Pencil' ],
		[ 'ti-ruler-alt' => 'Ruler Alt' ],
		[ 'ti-bookmark' => 'Bookmark' ],
		[ 'ti-bookmark-alt' => 'Bookmark Alt' ],
		[ 'ti-reload' => 'Reload' ],
		[ 'ti-plus' => 'Plus' ],
		[ 'ti-pin' => 'Pin' ],
		[ 'ti-pencil' => 'Pencil' ],
		[ 'ti-pencil-alt' => 'Pencil Alt' ],
		[ 'ti-paint-roller' => 'Paint Roller' ],
		[ 'ti-paint-bucket' => 'Paint Bucket' ],
		[ 'ti-na' => 'Na' ],
		[ 'ti-mobile' => 'Mobile' ],
		[ 'ti-minus' => 'Minus' ],
		[ 'ti-medall' => 'Medall' ],
		[ 'ti-medall-alt' => 'Medall Alt' ],
		[ 'ti-marker' => 'Marker' ],
		[ 'ti-marker-alt' => 'Marker Alt' ],
		[ 'ti-arrow-up' => 'Arrow Up' ],
		[ 'ti-arrow-right' => 'Arrow Right' ],
		[ 'ti-arrow-left' => 'Arrow Left' ],
		[ 'ti-arrow-down' => 'Arrow Down' ],
		[ 'ti-lock' => 'Lock' ],
		[ 'ti-location-arrow' => 'Location Arrow' ],
		[ 'ti-link' => 'Link' ],
		[ 'ti-layout' => 'Layout' ],
		[ 'ti-layers' => 'Layers' ],
		[ 'ti-layers-alt' => 'Layers Alt' ],
		[ 'ti-key' => 'Key' ],
		[ 'ti-import' => 'Import' ],
		[ 'ti-image' => 'Image' ],
		[ 'ti-heart' => 'Heart' ],
		[ 'ti-heart-broken' => 'Heart Broken' ],
		[ 'ti-hand-stop' => 'Hand Stop' ],
		[ 'ti-hand-open' => 'Hand Open' ],
		[ 'ti-hand-drag' => 'Hand Drag' ],
		[ 'ti-folder' => 'Folder' ],
		[ 'ti-flag' => 'Flag' ],
		[ 'ti-flag-alt' => 'Flag Alt' ],
		[ 'ti-flag-alt-2' => 'Flag Alt 2' ],
		[ 'ti-eye' => 'Eye' ],
		[ 'ti-export' => 'Export' ],
		[ 'ti-exchange-vertical' => 'Exchange Vertical' ],
		[ 'ti-desktop' => 'Desktop' ],
		[ 'ti-cup' => 'Cup' ],
		[ 'ti-crown' => 'Crown' ],
		[ 'ti-comments' => 'Comments' ],
		[ 'ti-comment' => 'Comment' ],
		[ 'ti-comment-alt' => 'Comment Alt' ],
		[ 'ti-close' => 'Close' ],
		[ 'ti-clip' => 'Clip' ],
		[ 'ti-angle-up' => 'Angle Up' ],
		[ 'ti-angle-right' => 'Angle Right' ],
		[ 'ti-angle-left' => 'Angle Left' ],
		[ 'ti-angle-down' => 'Angle Down' ],
		[ 'ti-check' => 'Check' ],
		[ 'ti-check-box' => 'Check Box' ],
		[ 'ti-camera' => 'Camera' ],
		[ 'ti-announcement' => 'Announcement' ],
		[ 'ti-brush' => 'Brush' ],
		[ 'ti-briefcase' => 'Briefcase' ],
		[ 'ti-bolt' => 'Bolt' ],
		[ 'ti-bolt-alt' => 'Bolt Alt' ],
		[ 'ti-blackboard' => 'Blackboard' ],
		[ 'ti-bag' => 'Bag' ],
		[ 'ti-move' => 'Move' ],
		[ 'ti-arrows-vertical' => 'Arrows Vertical' ],
		[ 'ti-arrows-horizontal' => 'Arrows Horizontal' ],
		[ 'ti-fullscreen' => 'Fullscreen' ],
		[ 'ti-arrow-top-right' => 'Arrow Top Right' ],
		[ 'ti-arrow-top-left' => 'Arrow Top Left' ],
		[ 'ti-arrow-circle-up' => 'Arrow Circle Up' ],
		[ 'ti-arrow-circle-right' => 'Arrow Circle Right' ],
		[ 'ti-arrow-circle-left' => 'Arrow Circle Left' ],
		[ 'ti-arrow-circle-down' => 'Arrow Circle Down' ],
		[ 'ti-angle-double-up' => 'Angle Double Up' ],
		[ 'ti-angle-double-right' => 'Angle Double Right' ],
		[ 'ti-angle-double-left' => 'Angle Double Left' ],
		[ 'ti-angle-double-down' => 'Angle Double Down' ],
		[ 'ti-zip' => 'Zip' ],
		[ 'ti-world' => 'World' ],
		[ 'ti-wheelchair' => 'Wheelchair' ],
		[ 'ti-view-list' => 'View List' ],
		[ 'ti-view-list-alt' => 'View List Alt' ],
		[ 'ti-view-grid' => 'View Grid' ],
		[ 'ti-uppercase' => 'Uppercase' ],
		[ 'ti-upload' => 'Upload' ],
		[ 'ti-underline' => 'Underline' ],
		[ 'ti-truck' => 'Truck' ],
		[ 'ti-timer' => 'Timer' ],
		[ 'ti-ticket' => 'Ticket' ],
		[ 'ti-thumb-up' => 'Thumb Up' ],
		[ 'ti-thumb-down' => 'Thumb Down' ],
		[ 'ti-text' => 'Text' ],
		[ 'ti-stats-up' => 'Stats Up' ],
		[ 'ti-stats-down' => 'Stats Down' ],
		[ 'ti-split-v' => 'Split V' ],
		[ 'ti-split-h' => 'Split H' ],
		[ 'ti-smallcap' => 'Smallcap' ],
		[ 'ti-shine' => 'Shine' ],
		[ 'ti-shift-right' => 'Shift Right' ],
		[ 'ti-shift-left' => 'Shift Left' ],
		[ 'ti-shield' => 'Shield' ],
		[ 'ti-notepad' => 'Notepad' ],
		[ 'ti-server' => 'Server' ],
		[ 'ti-quote-right' => 'Quote Right' ],
		[ 'ti-quote-left' => 'Quote Left' ],
		[ 'ti-pulse' => 'Pulse' ],
		[ 'ti-printer' => 'Printer' ],
		[ 'ti-power-off' => 'Power Off' ],
		[ 'ti-plug' => 'Plug' ],
		[ 'ti-pie-chart' => 'Pie Chart' ],
		[ 'ti-paragraph' => 'Paragraph' ],
		[ 'ti-panel' => 'Panel' ],
		[ 'ti-package' => 'Package' ],
		[ 'ti-music' => 'Music' ],
		[ 'ti-music-alt' => 'Music Alt' ],
		[ 'ti-mouse' => 'Mouse' ],
		[ 'ti-mouse-alt' => 'Mouse Alt' ],
		[ 'ti-money' => 'Money' ],
		[ 'ti-microphone' => 'Microphone' ],
		[ 'ti-menu' => 'Menu' ],
		[ 'ti-menu-alt' => 'Menu Alt' ],
		[ 'ti-map' => 'Map' ],
		[ 'ti-map-alt' => 'Map Alt' ],
		[ 'ti-loop' => 'Loop' ],
		[ 'ti-location-pin' => 'Location Pin' ],
		[ 'ti-list' => 'List' ],
		[ 'ti-light-bulb' => 'Light Bulb' ],
		[ 'ti-Italic' => 'Italic' ],
		[ 'ti-info' => 'Info' ],
		[ 'ti-infinite' => 'Infinite' ],
		[ 'ti-id-badge' => 'Id Badge' ],
		[ 'ti-hummer' => 'Hummer' ],
		[ 'ti-home' => 'Home' ],
		[ 'ti-help' => 'Help' ],
		[ 'ti-headphone' => 'Headphone' ],
		[ 'ti-harddrives' => 'Harddrives' ],
		[ 'ti-harddrive' => 'Harddrive' ],
		[ 'ti-gift' => 'Gift' ],
		[ 'ti-game' => 'Game' ],
		[ 'ti-filter' => 'Filter' ],
		[ 'ti-files' => 'Files' ],
		[ 'ti-file' => 'File' ],
		[ 'ti-eraser' => 'Eraser' ],
		[ 'ti-envelope' => 'Envelope' ],
		[ 'ti-download' => 'Download' ],
		[ 'ti-direction' => 'Direction' ],
		[ 'ti-direction-alt' => 'Direction Alt' ],
		[ 'ti-dashboard' => 'Dashboard' ],
		[ 'ti-control-stop' => 'Control Stop' ],
		[ 'ti-control-shuffle' => 'Control Shuffle' ],
		[ 'ti-control-play' => 'Control Play' ],
		[ 'ti-control-pause' => 'Control Pause' ],
		[ 'ti-control-forward' => 'Control Forward' ],
		[ 'ti-control-backward' => 'Control Backward' ],
		[ 'ti-cloud' => 'Cloud' ],
		[ 'ti-cloud-up' => 'Cloud Up' ],
		[ 'ti-cloud-down' => 'Cloud Down' ],
		[ 'ti-clipboard' => 'Clipboard' ],
		[ 'ti-car' => 'Car' ],
		[ 'ti-calendar' => 'Calendar' ],
		[ 'ti-book' => 'Book' ],
		[ 'ti-bell' => 'Bell' ],
		[ 'ti-basketball' => 'Basketball' ],
		[ 'ti-bar-chart' => 'Bar Chart' ],
		[ 'ti-bar-chart-alt' => 'Bar Chart Alt' ],
		[ 'ti-back-right' => 'Back Right' ],
		[ 'ti-back-left' => 'Back Left' ],
		[ 'ti-arrows-corner' => 'Arrows Corner' ],
		[ 'ti-archive' => 'Archive' ],
		[ 'ti-anchor' => 'Anchor' ],
		[ 'ti-align-right' => 'Align Right' ],
		[ 'ti-align-left' => 'Align Left' ],
		[ 'ti-align-justify' => 'Align Justify' ],
		[ 'ti-align-center' => 'Align Center' ],
		[ 'ti-alert' => 'Alert' ],
		[ 'ti-alarm-clock' => 'Alarm Clock' ],
		[ 'ti-agenda' => 'Agenda' ],
		[ 'ti-write' => 'Write' ],
		[ 'ti-window' => 'Window' ],
		[ 'ti-widgetized' => 'Widgetized' ],
		[ 'ti-widget' => 'Widget' ],
		[ 'ti-widget-alt' => 'Widget Alt' ],
		[ 'ti-wallet' => 'Wallet' ],
		[ 'ti-video-clapper' => 'Video Clapper' ],
		[ 'ti-video-camera' => 'Video Camera' ],
		[ 'ti-vector' => 'Vector' ],
		[ 'ti-themify-logo' => 'Themify Logo' ],
		[ 'ti-themify-favicon' => 'Themify Favicon' ],
		[ 'ti-themify-favicon-alt' => 'Themify Favicon Alt' ],
		[ 'ti-support' => 'Support' ],
		[ 'ti-stamp' => 'Stamp' ],
		[ 'ti-split-v-alt' => 'Split V Alt' ],
		[ 'ti-slice' => 'Slice' ],
		[ 'ti-shortcode' => 'Shortcode' ],
		[ 'ti-shift-right-alt' => 'Shift Right Alt' ],
		[ 'ti-shift-left-alt' => 'Shift Left Alt' ],
		[ 'ti-ruler-alt-2' => 'Ruler Alt 2' ],
		[ 'ti-receipt' => 'Receipt' ],
		[ 'ti-pin2' => 'Pin2' ],
		[ 'ti-pin-alt' => 'Pin Alt' ],
		[ 'ti-pencil-alt2' => 'Pencil Alt2' ],
		[ 'ti-palette' => 'Palette' ],
		[ 'ti-more' => 'More' ],
		[ 'ti-more-alt' => 'More Alt' ],
		[ 'ti-microphone-alt' => 'Microphone Alt' ],
		[ 'ti-magnet' => 'Magnet' ],
		[ 'ti-line-double' => 'Line Double' ],
		[ 'ti-line-dotted' => 'Line Dotted' ],
		[ 'ti-line-dashed' => 'Line Dashed' ],
		[ 'ti-layout-width-full' => 'Layout Width Full' ],
		[ 'ti-layout-width-default' => 'Layout Width Default' ],
		[ 'ti-layout-width-default-alt' => 'Layout Width Default Alt' ],
		[ 'ti-layout-tab' => 'Layout Tab' ],
		[ 'ti-layout-tab-window' => 'Layout Tab Window' ],
		[ 'ti-layout-tab-v' => 'Layout Tab V' ],
		[ 'ti-layout-tab-min' => 'Layout Tab Min' ],
		[ 'ti-layout-slider' => 'Layout Slider' ],
		[ 'ti-layout-slider-alt' => 'Layout Slider Alt' ],
		[ 'ti-layout-sidebar-right' => 'Layout Sidebar Right' ],
		[ 'ti-layout-sidebar-none' => 'Layout Sidebar None' ],
		[ 'ti-layout-sidebar-left' => 'Layout Sidebar Left' ],
		[ 'ti-layout-placeholder' => 'Layout Placeholder' ],
		[ 'ti-layout-menu' => 'Layout Menu' ],
		[ 'ti-layout-menu-v' => 'Layout Menu V' ],
		[ 'ti-layout-menu-separated' => 'Layout Menu Separated' ],
		[ 'ti-layout-menu-full' => 'Layout Menu Full' ],
		[ 'ti-layout-media-right-alt' => 'Layout Media Right Alt' ],
		[ 'ti-layout-media-right' => 'Layout Media Right' ],
		[ 'ti-layout-media-overlay' => 'Layout Media Overlay' ],
		[ 'ti-layout-media-overlay-alt' => 'Layout Media Overlay Alt' ],
		[ 'ti-layout-media-overlay-alt-2' => 'Layout Media Overlay Alt 2' ],
		[ 'ti-layout-media-left-alt' => 'Layout Media Left Alt' ],
		[ 'ti-layout-media-left' => 'Layout Media Left' ],
		[ 'ti-layout-media-center-alt' => 'Layout Media Center Alt' ],
		[ 'ti-layout-media-center' => 'Layout Media Center' ],
		[ 'ti-layout-list-thumb' => 'Layout List Thumb' ],
		[ 'ti-layout-list-thumb-alt' => 'Layout List Thumb Alt' ],
		[ 'ti-layout-list-post' => 'Layout List Post' ],
		[ 'ti-layout-list-large-image' => 'Layout List Large Image' ],
		[ 'ti-layout-line-solid' => 'Layout Line Solid' ],
		[ 'ti-layout-grid4' => 'Layout Grid4' ],
		[ 'ti-layout-grid3' => 'Layout Grid3' ],
		[ 'ti-layout-grid2' => 'Layout Grid2' ],
		[ 'ti-layout-grid2-thumb' => 'Layout Grid2 Thumb' ],
		[ 'ti-layout-cta-right' => 'Layout Cta Right' ],
		[ 'ti-layout-cta-left' => 'Layout Cta Left' ],
		[ 'ti-layout-cta-center' => 'Layout Cta Center' ],
		[ 'ti-layout-cta-btn-right' => 'Layout Cta Btn Right' ],
		[ 'ti-layout-cta-btn-left' => 'Layout Cta Btn Left' ],
		[ 'ti-layout-column4' => 'Layout Column4' ],
		[ 'ti-layout-column3' => 'Layout Column3' ],
		[ 'ti-layout-column2' => 'Layout Column2' ],
		[ 'ti-layout-accordion-separated' => 'Layout Accordion Separated' ],
		[ 'ti-layout-accordion-merged' => 'Layout Accordion Merged' ],
		[ 'ti-layout-accordion-list' => 'Layout Accordion List' ],
		[ 'ti-ink-pen' => 'Ink Pen' ],
		[ 'ti-info-alt' => 'Info Alt' ],
		[ 'ti-help-alt' => 'Help Alt' ],
		[ 'ti-headphone-alt' => 'Headphone Alt' ],
		[ 'ti-hand-point-up' => 'Hand Point Up' ],
		[ 'ti-hand-point-right' => 'Hand Point Right' ],
		[ 'ti-hand-point-left' => 'Hand Point Left' ],
		[ 'ti-hand-point-down' => 'Hand Point Down' ],
		[ 'ti-gallery' => 'Gallery' ],
		[ 'ti-face-smile' => 'Face Smile' ],
		[ 'ti-face-sad' => 'Face Sad' ],
		[ 'ti-credit-card' => 'Credit Card' ],
		[ 'ti-control-skip-forward' => 'Control Skip Forward' ],
		[ 'ti-control-skip-backward' => 'Control Skip Backward' ],
		[ 'ti-control-record' => 'Control Record' ],
		[ 'ti-control-eject' => 'Control Eject' ],
		[ 'ti-comments-smiley' => 'Comments Smiley' ],
		[ 'ti-brush-alt' => 'Brush Alt' ],
		[ 'ti-youtube' => 'Youtube' ],
		[ 'ti-vimeo' => 'Vimeo' ],
		[ 'ti-twitter' => 'Twitter' ],
		[ 'ti-time' => 'Time' ],
		[ 'ti-tumblr' => 'Tumblr' ],
		[ 'ti-skype' => 'Skype' ],
		[ 'ti-share' => 'Share' ],
		[ 'ti-share-alt' => 'Share Alt' ],
		[ 'ti-rocket' => 'Rocket' ],
		[ 'ti-pinterest' => 'Pinterest' ],
		[ 'ti-new-window' => 'New Window' ],
		[ 'ti-microsoft' => 'Microsoft' ],
		[ 'ti-list-ol' => 'List Ol' ],
		[ 'ti-linkedin' => 'Linkedin' ],
		[ 'ti-layout-sidebar-2' => 'Layout Sidebar 2' ],
		[ 'ti-layout-grid4-alt' => 'Layout Grid4 Alt' ],
		[ 'ti-layout-grid3-alt' => 'Layout Grid3 Alt' ],
		[ 'ti-layout-grid2-alt' => 'Layout Grid2 Alt' ],
		[ 'ti-layout-column4-alt' => 'Layout Column4 Alt' ],
		[ 'ti-layout-column3-alt' => 'Layout Column3 Alt' ],
		[ 'ti-layout-column2-alt' => 'Layout Column2 Alt' ],
		[ 'ti-instagram' => 'Instagram' ],
		[ 'ti-google' => 'Google' ],
		[ 'ti-github' => 'Github' ],
		[ 'ti-flickr' => 'Flickr' ],
		[ 'ti-facebook' => 'Facebook' ],
		[ 'ti-dropbox' => 'Dropbox' ],
		[ 'ti-dribbble' => 'Dribbble' ],
		[ 'ti-apple' => 'Apple' ],
		[ 'ti-android' => 'Android' ],
		[ 'ti-save' => 'Save' ],
		[ 'ti-save-alt' => 'Save Alt' ],
		[ 'ti-yahoo' => 'Yahoo' ],
		[ 'ti-wordpress' => 'Wordpress' ],
		[ 'ti-vimeo-alt' => 'Vimeo Alt' ],
		[ 'ti-twitter-alt' => 'Twitter Alt' ],
		[ 'ti-tumblr-alt' => 'Tumblr Alt' ],
		[ 'ti-trello' => 'Trello' ],
		[ 'ti-stack-overflow' => 'Stack Overflow' ],
		[ 'ti-soundcloud' => 'Soundcloud' ],
		[ 'ti-sharethis' => 'Sharethis' ],
		[ 'ti-sharethis-alt' => 'Sharethis Alt' ],
		[ 'ti-reddit' => 'Reddit' ],
		[ 'ti-pinterest-alt' => 'Pinterest Alt' ],
		[ 'ti-microsoft-alt' => 'Microsoft Alt' ],
		[ 'ti-linux' => 'Linux' ],
		[ 'ti-jsfiddle' => 'Jsfiddle' ],
		[ 'ti-joomla' => 'Joomla' ],
		[ 'ti-html5' => 'Html5' ],
		[ 'ti-flickr-alt' => 'Flickr Alt' ],
		[ 'ti-email' => 'Email' ],
		[ 'ti-drupal' => 'Drupal' ],
		[ 'ti-dropbox-alt' => 'Dropbox Alt' ],
		[ 'ti-css3' => 'Css3' ],
		[ 'ti-rss' => 'Rss' ],
		[ 'ti-rss-alt' => 'Rss Alt' ],
	];
}
