<?php
/**
 * Template kit template.
 *
 * @package Aheto
 */

use Aheto\Helper;
use Aheto\Template_Kit\API;

$template_kit = API::get();

//$categories   = $template_kit->get_categories(); -- old version
$categories   = $template_kit->get_templates_categories();
$templates    = $template_kit->get_templates("","","pages");


Helper::add_json( 'templates', $templates );
Helper::add_json( 'security', wp_create_nonce( 'aheto_ajax_page_importer' ) );
?>

<div class="wrap aheto-wrap limit-wrap">

	<?php include_once Helper::get_admin_view( 'sidebar-nav' ); ?>

	<div class="aheto-option-content">




					<select class="filter-nav">
						<?php if ( isset( $categories['all'] ) ) { ?>
							<option data-filter="tk-all" data-title="all">
								<?php echo __("All", 'aheto'); ?> (<?php echo $categories['all']; ?>)
							</option>
						<?php } ?>
						<?php foreach ( $categories as $label => $v ) : ?>
							<?php if ( $label != 'all' ) { ?>
								<option data-filter="tk-<?php echo sanitize_title_with_dashes( strtolower( $label ) ); ?>" data-title="<?php echo $label; ?>">
									<?php echo $label; ?> (<?php echo $v; ?>)
								</option>
							<?php } ?>
						<?php endforeach; ?>
					</select>



				<div class="filter-content">

					<?php foreach ( $templates as $index => $template ) : ?>
                        <div class="post tk-<?php echo join( ' tk-', $template['categories']['classes'] ); ?>" data-index="<?php echo $index; ?>" data-slug="<?php echo strtolower($template['tags']['terms'][0]) ;?>">
                            <img data-lazy-src="<?php echo esc_url_raw( $template['thumbnail'] ); ?>" src="<?php echo aheto()->plugin_url() . 'assets/images/placeholder.jpg'; ?>" />
                            <span><?php echo esc_html( $template['title'] ); ?></span>
                        </div>
					<?php endforeach; ?>

				</div>

				<div id="template-modal-content" class="template-kit-content">
					<div class="template-kit-col-left">
						<img class="template-screenshot" />
					</div>

					<!-- POPUP CONTENT START -->
					<div class="template-kit-col-right">
						<div class="template-kit-import">
							<h3>
								<a target="_blank" href="#" class="template-preview"><img src="<?php echo aheto()->plugin_url(); ?>assets/admin/img/template-kit/icon-import.png" /></a><span class="template-title"></span> <small>&times;</small>
							</h3>

							<div>
								<img src="<?php echo aheto()->plugin_url(); ?>assets/admin/img/template-kit/icon-import-2.png" />
								<h4><?php esc_html_e( 'Import template', 'aheto' ); ?></h4>
								<p><?php esc_html_e( 'Import settings by locating setting file and click "Import template".', 'aheto' ); ?></p>
								<a href="#" class="action-template-import custom-btn secondary"><?php esc_html_e( 'Import template', 'aheto' ); ?></a>
								<img src="<?php echo aheto()->plugin_url(); ?>assets/admin/img/loader.gif" id="loader_importing_page" style="margin-left:auto;margin-right:auto;display: none;" />
							</div>
						</div>

						<div class="template-kit-create-page" >
							<p><?php esc_html_e( 'Create a new page from this template to make it available as a draft page in your Page list.', 'aheto' ); ?></p>
							<form action="">
								<input type="hidden" class="template-id" name="aheto_page_template_id" value="">
                                <input type="hidden" class="template-slug" name="aheto_page_template_slug" value="">
								<input type="text" class="aheto-page-name" value="" placeholder="<?php esc_html_e( 'Enter a Page Name', 'aheto' ); ?>">
								<button type="submit" class="action-template-create-page"><?php esc_html_e( 'Create', 'aheto' ); ?></button>
							</form>
							<img src="<?php echo aheto()->plugin_url(); ?>assets/admin/img/loader.gif" id="loader_creating_page" style="position: absolute;top: 58%;right: 185px;display: none;" />
						</div>
					</div>
					<!-- POPUP CONTENT END -->


		</div>

	</div>

</div>
