<?php
/**
 * Help welcome template.
 *
 * @package Aheto
 */

use Aheto\Helper;

$registered = false;
$class      = false !== $registered ? 'status-green' : 'status-red';
$aheto_dashboard_pages = aheto()->plugin_dashboard_pages();

?>

<div class="aheto-option-main-content">

<h3><?php echo esc_html__( 'Welcome to ', 'aheto' ) . aheto()->plugin_name(); ?></h3>
<p>
	<?php esc_html_e( 'Our professional team has designed this page builder to make the site creation process as creative and easy as possible. We are constantly improving it and providing you with tools to create amazing pages for your website. With the ' . aheto()->plugin_name() . ' plugin you can fully customize the website colors, typography, header and footer in a few simple steps. In addition, the plugin is compatible with the 2 most popular WordPress page builders - Elementor and WPBakery.', 'aheto' ); ?>
</p>

<h3><?php esc_html_e( 'You can adjust your plugin in few steps', 'aheto' ); ?></h3>

    <?php if ( 'visual-composer' !== Helper::get_settings( 'general.builder' ) && array_key_exists( 'setup', $aheto_dashboard_pages ) && array_key_exists( 'templates', $aheto_dashboard_pages ) ) { ?>
        <ul class="ol-list">
            <li><i>1</i><span>Go to <a href="<?php echo admin_url( 'admin.php?page=aheto-setup' ); ?>">Wizard</a></span></li>
            <li><i>2</i><span>Then choose your <a href="<?php echo admin_url( 'admin.php?page=aheto-general-settings' ); ?>">General settings</a></span></span></li>
            <li><i>3</i><span>Create your <a href="<?php echo admin_url( 'admin.php?page=aheto-skin-generator' ); ?>">Skin</a></span></li>
            <li><i>4</i><span>Import page templates from <a href="<?php echo admin_url( 'admin.php?page=aheto-templates' ); ?>">Ready Demos</a></span></li>
        </ul>
    <?php }else{ ?>
        <ul class="ol-list">
            <li><i>1</i><span>Choose your <a href="<?php echo admin_url( 'admin.php?page=aheto-general-settings' ); ?>">General settings</a></span></span></li>
            <li><i>2</i><span>Create your <a href="<?php echo admin_url( 'admin.php?page=aheto-skin-generator' ); ?>">Skin</a></span></li>

        </ul>
    <?php } ?>

<br>
<br>
<br>

<div class="aheto-help-welcome-notice">
	<strong>Important: </strong> <?php esc_html_e( 'You’ve successfully upgraded to WordPress 5.3! We’ve made some big changes to the editor. Our new block-based editor is the first step toward an exciting new future with a streamlined editing experience across your site. You’ll have more flexibility with how content is displayed, whether you are building your first site, revamping your blog, or write code for a living.', 'aheto' ); ?>
</div>

</div>
