/*eslint no-var:0*/
( function( $ ) {
    // Document Ready
    $( function() {
        var optionaPanel = {

            init: function() {
                this.search()

                $( '.button-create-new' ).on( 'click', function( event ) {
                    event.preventDefault()

                    $( '#submit-cmb' ).trigger( 'click' )
                })
            },

            search: function() {
                var self       = this,
                    wrapper    = $( '.aheto-wrap-settings' ),
                    searchOpts = wrapper.find( '.aheto-search-options' ),
                    input      = searchOpts.find( 'input' ),
                    panels     = $( '.cmb2-panel' ),
                    container  = $( '.cmb2-panel-container' ),
                    tabWrapper = container.find( '>.cmb2-tabs-navigation' ),
                    timer

                container.find( '>.aheto-tabs-content' ).prepend( '<div class="aheto-setting-search-empty">No results found.</div>' )
                searchOpts.on( 'click', '.clear-search', function( event ) {
                    event.preventDefault()
                    input.val( '' )
                    input.trigger( 'input' )
                })

                input.on( 'input', function() {

                    if ( '' === input.val() ) {
                        wrapper.removeClass( 'searching' )
                        panels.hide()
                        self.clearSearch( container, tabWrapper )
                        return false
                    }

                    clearTimeout( timer )
                    timer = setTimeout( function() {
                        wrapper.addClass( 'searching' )
                        panels.show()
                        self.searchOptions( input.val().toLowerCase(), wrapper )
                    }, 200 )
                })
            },

            searchOptions: function( query, container ) {
                var self = this
                $( '.cmb-row' ).hide().each( function() {
                    var row = $( this )

                    if ( row.hasClass( 'cmb-type-title' ) ) {
                        row.hide()
                    } else if ( row.text().trim().toLowerCase().includes( query ) ) {
                        row.show()
                    }
                })

                var visibleRows = $( '.cmb-row:visible' )

                if ( 0 === visibleRows.length ) {
                    container.addClass( 'search-no-results' )
                } else {
                    container.removeClass( 'search-no-results' )
                    visibleRows.each( function() {
                        $( this ).find( 'input, select' ).each( function() {
                            $( 'span[data-field="' + $( this ).attr( 'name' ) + '"]' ).each( function() {
                                self.loopDependencies( $( this ).closest( '.cmb-dependency' ) )
                            })
                        })
                    })
                }
            },

            clearSearch: function( container, wrapper ) {
                var target = localStorage.getItem( container.attr( 'id' ) ),
                    nav    = $( '>a', wrapper ),
                    self   = this

                if ( null === target ) {
                    nav.eq( 0 ).trigger( 'click' )
                } else {
                    target = $( 'a[href=' + target + ']', wrapper )
                    if ( target.length ) {
                        target.trigger( 'click' )
                    } else {
                        nav.eq( 0 ).trigger( 'click' )
                    }
                }

                $( '.cmb-row' ).show()
                $( '.cmb-dependency', '.cmb-form, .aheto-metabox-wrap' ).each( function() {
                    self.loopDependencies( $( this ) )
                })
            }
        }

        optionaPanel.init()






        setTimeout(function(){
            // Set option selected onchange
            var oldValue = $('#headings_font_family').val();
            var oldValueFontWeight = $('#headings_font_weight').val();
            var oldValueFontColor = $("#headings_color").val() ;

            $('#headings_font_family').change(function(){
                var value = $(this).val();
                for (let i = 1; i < 7; i++) {
                    let x = $('#heading' + i +'_font_family')
                    if (x.val() === '' || x.val() == oldValue ) {
                        x.val(value);
                        x.trigger('change');
                    }
                }
                oldValue = $(this).val();

            });
            $('#headings_font_weight').change(function(){
                let valueFontWeight = $(this).val();
                for (let i = 1; i < 7; i++) {
                    let x = $('#heading' + i +'_font_weight')
                    if (x.val() === '400' || x.val() == oldValueFontWeight) {
                        x.val(valueFontWeight);
                        x.trigger('change');
                    }
                }
                oldValueFontWeight = $(this).val();

            });


            $("#headings_color").on("change paste keyup", function() {
                let value = $(this).val();
                for (let i = 1; i < 7; i++) {
                    let x = $('#heading' + i +'_color')
                    if (x.val() === '' || x.val() === '#' || x.val() == oldValueFontColor) {
                        x.val(value);
                        x.trigger('change');
                    }

                }
                oldValueFontColor = $(this).val();
            });



        }, 100);

        const headingItem =  document.querySelectorAll('.setting-panel-headings__item');
        [...headingItem].forEach((elem) => {
            setTimeout(function(){

                const typoghraphy = elem.querySelector('.example-js');
                const title = elem.querySelector('.title-js');
                const titleInfo = elem.querySelector('.typography-info__shot');

                const $fontFamily = elem.querySelector('select[id*="_font_family"]');
                let $fontFamilyValue = elem.querySelector('.select2-selection__rendered').getAttribute('title');

                const $fontWeight = elem.querySelector('select[id*="_font_weight"]');

                const $fontColor = elem.querySelector('.wp-color-result');
                let $fontColorValue = window.getComputedStyle($fontColor, null).getPropertyValue("background-color");

                const $fontSize = elem.querySelector('input[id*="_font_size"]');
                const responFontSize = elem.querySelector('input[id*="_font_size"]') ? elem.querySelector('input[id*="_font_size"]').closest('.col').lastChild : '';
                let createFontSize = false;
                let $fontSizeValue;

                const $lineHeight = elem.querySelector('input[id*="_line_height"]');
                const responLineHeight = elem.querySelector('input[id*="_line_height"]') ? elem.querySelector('input[id*="_line_height"]').closest('.col').lastChild : '';
                let $lineHeightValue;

                const $letterSpacing = elem.querySelector('input[id*="_letter_spacing"]');
                const responLetterSpacing = elem.querySelector('input[id*="_letter_spacing"]') ? elem.querySelector('input[id*="_letter_spacing"]').closest('.col').lastChild : '';

                if ($fontFamily) {
                    let $fontFamilyNewValue;
                    let createFont = false;
                    if ($fontFamilyValue !== null) {
                        $fontFamilyNewValue = $fontFamilyValue.split(',')[0];
                        if(($fontFamilyNewValue !== '')) {
                            let infoFontFamily = document.createElement("span");
                            infoFontFamily.classList.add('font-family');
                            infoFontFamily.innerHTML = $fontFamilyNewValue;
                            titleInfo.append(infoFontFamily);
                            createFont = true;
                        }
                    }
                    typoghraphy.style.fontFamily = $fontFamilyValue;
                    title.style.fontFamily = $fontFamilyValue;
                    if ($fontFamilyValue !== null) {
                        getFontWeight($fontFamilyValue);
                    }
                    $fontFamily.onchange = function() {
                        $fontFamilyValue = elem.querySelector('.select2-selection__rendered').getAttribute('title');
                        if ($fontFamilyValue !== null) {
                            $fontFamilyNewValue = $fontFamilyValue.split(',')[0];
                            typoghraphy.style.fontFamily = $fontFamilyValue;
                            title.style.fontFamily = $fontFamilyValue;
                            if(($fontFamily.value !== '' && createFont !== true)) {
                                let infoFontFamily = document.createElement("span");
                                infoFontFamily.classList.add('font-family');
                                infoFontFamily.innerHTML = $fontFamilyNewValue;
                                titleInfo.append(infoFontFamily);
                                createFont = true;
                            }
                            if((createFont == true)) {
                                elem.querySelector('.font-family').innerHTML = $fontFamilyNewValue;
                            }
                            if(($fontFamily.value == '')) {
                                titleInfo.querySelector('.font-family').remove();
                            }
                            getFontWeight($fontFamilyNewValue);
                        }
                    }
                }
                if ($fontColor) {
                    typoghraphy.style.color = $fontColorValue;
                    title.style.color = $fontColorValue;
                }
                if ($fontWeight) {
                    typoghraphy.style.fontWeight = parseFloat($fontWeight.value);
                    title.style.fontWeight = parseFloat($fontWeight.value);
                    elem.querySelector('.font-weight').innerHTML = $fontWeight.value;
                    $fontWeight.onchange = function() {
                        typoghraphy.style.fontWeight = parseFloat(this.value);
                        title.style.fontWeight = parseFloat(this.value);
                        elem.querySelector('.font-weight').innerHTML = this.value;
                    }
                }


                elem.querySelector('.typography-open-js').addEventListener('click', function () {
                    elem.classList.add('active');
                });
                elem.querySelector('.typography-close-js').addEventListener('click', function () {
                    elem.classList.remove('active');
                });


                if($fontSize ) {
                    $fontSizeValue = $fontSize.value.split(',');
                    typoghraphy.style.fontSize = $fontSizeValue[0] ;
                    title.style.fontSize = $fontSizeValue[0];
                    responFontSize.addEventListener('input', updateFontSize);
                    if(($fontSizeValue[0] !== '')) {
                        let infoFontSize = document.createElement("span");
                        infoFontSize.classList.add('font-size');
                        infoFontSize.innerHTML = $fontSizeValue[0];
                        titleInfo.append(infoFontSize);
                        if ($fontSizeValue[0] == '') {
                            infoFontSize.remove();
                        }
                    }
                }
                if($lineHeight) {
                    if ($lineHeight !== null) {
                        $lineHeightValue = $lineHeight.value.split(',');
                        typoghraphy.style.lineHeight = $lineHeightValue[0];
                        title.style.lineHeight = $lineHeightValue[0];
                        responLineHeight.addEventListener('input', updateLineHeight);

                        if ($lineHeightValue !== null) {
                            let infoLineHeight = document.createElement("span");
                            infoLineHeight.classList.add('line-height');
                            infoLineHeight.innerHTML = $lineHeightValue[0];
                            titleInfo.append(infoLineHeight);
                            if ($lineHeightValue[0] == '') {
                                infoLineHeight.remove();
                            }
                        }
                    }
                }
                if($letterSpacing) {
                    typoghraphy.style.letterSpacing = $letterSpacing.value;
                    title.style.letterSpacing = $letterSpacing.value;
                    responLetterSpacing.addEventListener('input', updateLetterSpacing);
                }


                function updateFontSize(e) {
                    $fontSizeValue = e.target.value.split(',');
                    typoghraphy.style.fontSize = $fontSizeValue[0];
                    title.style.fontSize = $fontSizeValue[0];
                    if ($fontSizeValue[0] !== '') {
                        if (titleInfo.querySelector('.font-size')) {
                            titleInfo.querySelector('.font-size').remove();
                        }
                        let infoFontSize = document.createElement("span");
                        infoFontSize.classList.add('font-size');
                        infoFontSize.innerHTML = $fontSizeValue[0];
                        titleInfo.append(infoFontSize);

                    }
                    if ($fontSizeValue[0] == '') {
                        titleInfo.querySelector('.font-size').remove();
                    }
                }
                function updateLineHeight(e) {
                    $lineHeightValue =  e.target.value.split(',');
                    typoghraphy.style.lineHeight = $lineHeightValue[0];
                    title.style.lineHeight = $lineHeightValue[0];
                    if ($lineHeightValue[0] !== '') {
                        if (titleInfo.querySelector('.line-height')) {
                            titleInfo.querySelector('.line-height').remove();
                        }
                        let infoLineHeight = document.createElement("span");
                        infoLineHeight.classList.add('line-height');
                        infoLineHeight.innerHTML = $lineHeightValue[0];
                        titleInfo.append(infoLineHeight);

                    }
                    if ($lineHeightValue[0] == '') {
                        titleInfo.querySelector('.line-height').remove();
                    }
                }
                function updateLetterSpacing(e) {
                    typoghraphy.style.letterSpacing = parseFloat(e.target.value) + 'px';
                    title.style.letterSpacing = parseFloat(e.target.value) + 'px';
                }


                $("input[id*='_color']").on("change paste keyup", function() {
                    $(this).closest('.cmb-td').find('.example-js').css({"color": $(this).val()});
                    $(this).closest('.cmb-td').find('.title-js').css({"color": $(this).val()});
                });



            }, 0);
        });


        /*
            Typography Buttons
        */
       const btnStyling =  document.querySelector('#setting-panel-buttons');
       if (btnStyling) {
        const btnItem =  btnStyling.querySelectorAll('.cmb-row.cmb-repeat-group-wrap');
        const btnFontFamily = btnStyling.querySelector('#button_0_font_font_family');
        let btnFontFamilyValue;

        const btnFontWeight = btnStyling.querySelector('#button_0_font_font_weight');
       
        
        let btnFontWeightValue;

        let btnFontSize;
        let btnFontSizeValue;

        let exampleBtn;


        setTimeout(function(){

            [...btnItem].forEach((elem) => {
                exampleBtn = elem.querySelector('.cmb-group-title > span').classList.add('example-btn');

                btnFontSize = elem.querySelector('input[id*="_font_size"]') ? elem.querySelector('input[id*="_0_font_size"]') : '';

            });

            if (btnFontFamily) {
                if (btnFontFamily.value !== '') {
                    btnFontFamilyValue = btnFontFamily.value.split(',');
                    getFontWeight(btnFontFamilyValue);
                    [...btnItem].forEach((elem) => {
                        elem.querySelector('.example-btn').style.fontFamily = btnFontFamilyValue;
                    });
                }
                btnFontFamily.onchange = function() {
                    btnFontFamilyValue = btnFontFamily.value.split(',');
                    console.log(btnFontFamilyValue);
                    if (btnFontFamilyValue !== '') {
                        getFontWeight(btnFontFamilyValue);
                        console.log(btnFontFamilyValue);
                        [...btnItem].forEach((elem) => {
                            elem.querySelector('.example-btn').style.fontFamily = btnFontFamilyValue;
                        });
                    }
                }
            }

            if (btnFontWeight) {
                if (btnFontWeight.value !== '') {
                    btnFontWeightValue = btnFontWeight.value;
                    [...btnItem].forEach((elem) => {
                        elem.querySelector('.example-btn').style.fontWeight = parseFloat(btnFontWeightValue);
                    });
                }
                btnFontWeight.onchange = function() {
                    btnFontWeightValue = btnFontWeight.value
                    console.log(btnFontWeightValue);
                    if (btnFontWeight.value !== '') {
                        [...btnItem].forEach((elem) => {
                            elem.querySelector('.example-btn').style.fontWeight = parseFloat(btnFontWeightValue);
                        });
                    }
                }
            }


        }, 0);

    }


        /*
            connection font family
        */
        function getFontWeight(fontFamily) {
            WebFontConfig = {
                google: { families: [ fontFamily + ':100,200,300,400,500,600,700,800,900' ] }
            };
            (function() {
                var wf = document.createElement('script');
                wf.src = 'https://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
                wf.type = 'text/javascript';
                wf.async = 'true';
                var s = document.getElementsByTagName('script')[0];
                s.parentNode.insertBefore(wf, s);
            })();
        }

    })



}( jQuery ) )
