<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 * 
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet (lowercase and without spaces)
	$themename = get_theme_data(STYLESHEETPATH . '/style.css');
	$themename = $themename['Name'];
	$themename = preg_replace("/\W/", "", strtolower($themename) );
	
	$optionsframework_settings = get_option('optionsframework');
	$optionsframework_settings['id'] = $themename;
	update_option('optionsframework', $optionsframework_settings);
	
	// echo $themename;
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the "id" fields, make sure to use all lowercase and no spaces.
 *  
 */

function optionsframework_options() {
	
	// Test data
	$slider_effect_array = array("fade" => "fade","slide" => "slide");
	
	// Test data
	$meta_font_array = array("" => "DroidSans", "arial.css" => "Arial","georgia.css" => "Georgia","lucida.css" => "Lucida","palationo.css" => "Palatino","tahoma.css" => "Tahoma","times.css" => "Times","trebuchet.css" => "Trebuchet","verdana.css" => "Verdana");
	
	// Test data
	$heading_font_array = array(
	"classic" => "ClassicRound",
	
	"adelle" => "Adelle",
	"alegreya" => "Alegreya",
	"arvo" => "Arvo",
	"bonveno" => "Bonveno",
	"bpreplay" => "BPreplay",
	"bree" => "Bree",
	"cabin" => "Cabin",
	"cantarell" => "Cantarell",
	"carto" => "Carto",
	"comfortaa" => "Comfortaa",
	"copse" => "Copse",
	"delicious" => "Delicious",
	"folks" => "Folks",
	"fontin" => "Fontin",
	"geosans" => "GeoSans",
	"kreon" => "Kreon",
	"mavenpro" => "Mavenpro",
	"merriweather" => "Merriweather",
	"mimic" => "Mimic",
	"otari" => "Otari",
	"podkova" => "Podkova",
	"ptsans" => "PTSans",
	"puritan" => "Puritan",
	"titillium" => "Titillium",
	"vollkorn" => "Vollkorn"
	);
	
	// Test data
	$secondary_font_array = array(
	"goudy" => "SortsMillGoudy",
	"georgia" => "Georgia"
	);
	
	$skin_array = array("" => "Light - Default","dark.css" => "Dark","darklight.css" => "Darklight");
	
	$body_size = array("10px" => "10px","11px" => "11px","12px" => "12px","13px" => "13px","14px" => "14px","15px" => "15px","16px" => "16px");
	
	$body_line = array("10px" => "10px","11px" => "11px","12px" => "12px","13px" => "13px","14px" => "14px","15px" => "15px","16px" => "16px","17px" => "17px","18px" => "18px","19px" => "19px","20px" => "20px","21px" => "21px","22px" => "22px","23px" => "23px","24px" => "24px","25px" => "25px","26px" => "26px","27px" => "27px","28px" => "28px","29px" => "29px","30px" => "30px");
	
	// Multicheck Array
	$multicheck_array = array("one" => "French Toast", "two" => "Pancake", "three" => "Omelette", "four" => "Crepe", "five" => "Waffle");
	
	// Multicheck Defaults
	$multicheck_defaults = array("one" => "1","five" => "1");
	
	// Background Defaults
	
	$background_defaults = array('color' => '', 'image' => '', 'repeat' => 'repeat','position' => 'top center','attachment'=>'scroll');
	
	
	// Pull all the categories into an array
	$options_categories = array();  
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
    	$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Pull all the pages into an array
	$options_pages = array();  
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages[''] = 'Select a page:';
	foreach ($options_pages_obj as $page) {
    	$options_pages[$page->ID] = $page->post_title;
	}
		
	// If using image radio buttons, define a directory path
	$imagepath =  get_stylesheet_directory_uri() . '/admin/images/';
		
	$options = array();
		
	$options[] = array( "name" => "General",
						"type" => "heading");
							
	$options[] = array( "name" => "Logo",
						"desc" => "Upload your logo.",
						"id" => "logo",
						"type" => "upload");
							
	$options[] = array( "name" => "Favicon",
						"desc" => "Upload your favicon.",
						"id" => "favicon",
						"type" => "upload");
	
	$options[] = array( "name" => "Main Intro",
						"desc" => "Will appear if you are using the default blog as the homepage.",
						"id" => "home_intro",
						"std" => "",
						"type" => "textarea"); 
	
	$options[] = array( "name" => "Tracking Code",
						"desc" => "Paste your Google Analytics (or other) tracking code here.",
						"id" => "tracking_code",
						"std" => "",
						"type" => "textarea"); 
	
	$options[] = array( "name" => "Footer Text",
						"desc" => "Enter text for footer.",
						"id" => "footer_text",
						"std" => "",
						"type" => "textarea"); 
						
	
	$options[] = array( "name" => "Backgrounds",
						"type" => "heading");
						
						
	$url =  ADMIN . 'images/';
	$options[] = array( "name" => "Body Background",
					"desc" => "Click on the image to select it as the background image",
					"id" => "body_bg",
					"std" => "",
					"type" => "images",
					"options" => array(
						'bg1.jpg' => $url . 'bg1.jpg',
						'bg2.jpg' => $url . 'bg2.jpg',
						'bg3.jpg' => $url . 'bg3.jpg',
						'bg4.jpg' => $url . 'bg4.jpg',
						'bg5.jpg' => $url . 'bg5.jpg',
						'bg6.jpg' => $url . 'bg6.jpg',
						'bg7.jpg' => $url . 'bg7.jpg',
						'bg8.jpg' => $url . 'bg8.jpg',
						'bg9.jpg' => $url . 'bg9.jpg',
						'bg10.jpg' => $url . 'bg10.jpg',
						'bg11.jpg' => $url . 'bg11.jpg',
						'bg12.jpg' => $url . 'bg12.jpg',
						'bg13.jpg' => $url . 'bg13.jpg',
						'bg14.jpg' => $url . 'bg14.jpg',
						'bg15.jpg' => $url . 'bg15.jpg',
						'bg16.jpg' => $url . 'bg16.jpg',
						'bg17.jpg' => $url . 'bg17.jpg',
						'bg18.jpg' => $url . 'bg18.jpg',
						'bg19.jpg' => $url . 'bg19.jpg',
						'bg20.jpg' => $url . 'bg20.jpg',
						'bg21.jpg' => $url . 'bg21.jpg',
						'bg22.jpg' => $url . 'bg22.jpg',
						'bg23.jpg' => $url . 'bg23.jpg',
						'bg24.jpg' => $url . 'bg24.jpg',
						'bg25.jpg' => $url . 'bg25.jpg',
						'bg26.jpg' => $url . 'bg26.jpg',
						'bg27.jpg' => $url . 'bg27.jpg'));
	
	$options[] = array( "name" => "Styling",
						"type" => "heading");
	
	$options[] = array( "name" =>  "Background Color",
					"desc" => "Pick a color for background",
					"id" => "bg_color",
					"std" => "",
					"type" => "color");

	$options[] = array( "name" =>  "Body Text Color",
					"desc" => "Pick a color for body text",
					"id" => "text_color",
					"std" => "",
					"type" => "color");

	
	
	$options[] = array( "name" =>  "Link Color",
					"desc" => "Pick a color for links",
					"id" => "link_color",
					"std" => "",
					"type" => "color");
					
					$options[] = array( "name" =>  "Hover Color",
					"desc" => "Pick a color for hover",
					"id" => "hover_color",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Meta Color",
					"desc" => "Pick a color for meta",
					"id" => "meta_color",
					"std" => "",
					"type" => "color");

	$options[] = array( "name" =>  "Headings Color",
					"desc" => "Pick a color for headings",
					"id" => "heading_color",
					"std" => "",
					"type" => "color");
					
	$options[] = array( "name" =>  "Intro Text Color",
					"desc" => "Pick a color for intro",
					"id" => "intro_color",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Footer Text Color",
					"desc" => "Pick a color for footer",
					"id" => "intro_footer",
					"std" => "",
					"type" => "color");
	
	
	$options[] = array( "name" => "Menu",
						"type" => "info");
						
	$options[] = array( "name" =>  "Menu Text Color",
					"desc" => "Pick a color for menu text",
					"id" => "menu_color",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Menu Hover Color",
					"desc" => "Pick a color for menu hover",
					"id" => "menu_hover",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Menu Border Color",
					"desc" => "Pick a color for menu border",
					"id" => "menu_border",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Menu Dropdown Background Color",
					"desc" => "Pick a color for menu dropdown background",
					"id" => "dd_bg",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Menu Dropdown Text Color",
					"desc" => "Pick a color for menu dropdown text",
					"id" => "dd_text",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Menu Dropdown Hover Color",
					"desc" => "Pick a color for menu dropdown hover",
					"id" => "dd_hover",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" =>  "Menu Dropdown Border Color",
					"desc" => "Pick a color for menu dropdown border",
					"id" => "dd_border",
					"std" => "",
					"type" => "color");
	
	$options[] = array( "name" => "Default Button",
						"type" => "info");
	


	$options[] = array( "name" =>  "Button Background",
					"desc" => "Pick a bg color for default button",
					"id" => "button_bg",
					"std" => "",
					"type" => "color");

	$options[] = array( "name" =>  "Button Border",
					"desc" => "Pick a border color for default button",
					"id" => "button_border",
					"std" => "",
					"type" => "color");

	$options[] = array( "name" =>  "Button Color",
					"desc" => "Pick a text color for deafult button",
					"id" => "button_text",
					"std" => "",
					"type" => "color");
	
	
	$options[] = array( "name" => "Comments",
						"type" => "info");
	
	
	$options[] = array( "name" =>  "Comment Background Color",
					"desc" => "Pick a background color for comments",
					"id" => "comment_bg",
					"std" => "",
					"type" => "color");
					
	$options[] = array( "name" =>  "Admin Comment Background Color",
					"desc" => "Pick a background color for admin comments",
					"id" => "admin_bg",
					"std" => "",
					"type" => "color");
	
	
	$options[] = array( "name" => "Custom CSS",
                    "desc" => "Quickly add some CSS to your theme by adding it to this block.",
                    "id" => "custom_css",
                    "std" => "",
                    "type" => "textarea");
	

	
					

					
	$options[] = array( "name" => "Typography",
						"type" => "heading");
		
	$options[] = array( "name" => "Body Font",
						"desc" => "Select font for body text.",
						"id" => "body_typo",
						"std" => array('face' => 'droid'),
						"type" => "typography");	
	
	$options[] = array( "name" => "Body Text Font Size",
						"desc" => "Select font size for body text. (Default: 13px)",
						"id" => "body_size",
						"std" => "13px",
						"type" => "select",
						"class" => "mini", //mini, tiny, small
						"options" => $body_size);
	
	$options[] = array( "name" => "Body Text Line Height",
						"desc" => "Select line height for body text. (Default: 22px)",
						"id" => "body_line",
						"std" => "22px",
						"type" => "select",
						"class" => "mini", //mini, tiny, small
						"options" => $body_line);
	
	$options[] = array( "name" => "Headings & Menu Font",
						"desc" => "Select font for menu and headings.",
						"id" => "heading_font",
						"type" => "select",
						"class" => "mini", //mini, tiny, small
						"options" => $heading_font_array);	
	
	$options[] = array( "name" => "Secondary Font",
						"desc" => "Select font for intro, blockquote, tweets etc",
						"id" => "secondary_font",
						"type" => "select",
						"class" => "mini", //mini, tiny, small
						"options" => $secondary_font_array);	
	
	$options[] = array( "name" => "H1 Font Size and Line Height",
						"desc" => "Select font size and line height for h1. (Default: 22/24px)",
						"id" => "heading1",
						"std" => array('size' => '22px','line' => '24px'),
						"type" => "size");
	
	$options[] = array( "name" => "H2 Font Size and Line Height",
						"desc" => "Select font size and line height for h2 and entry titles. (Default: 20/22px)",
						"id" => "heading2",
						"std" => array('size' => '20px','line' => '22px'),
						"type" => "size");
						
	$options[] = array( "name" => "H3 Font Size and Line Height",
						"desc" => "Select font size and line height for h3. (Default: 18/20px)",
						"id" => "heading3",
						"std" => array('size' => '18px','line' => '20px'),
						"type" => "size");
	
	$options[] = array( "name" => "H4 Font Size and Line Height",
						"desc" => "Select font size and line height for h4. (Default: 16/18px)",
						"id" => "heading4",
						"std" => array('size' => '16px','line' => '18px'),
						"type" => "size");
	
	$options[] = array( "name" => "H5 Font Size and Line Height",
						"desc" => "Select font size and line height for h5. (Default: 15/17px)",
						"id" => "heading5",
						"std" => array('size' => '15px','line' => '17px'),
						"type" => "size");
	
	$options[] = array( "name" => "H6 Font Size and Line Height",
						"desc" => "Select font size and line height for h6. (Default: 14/16px)",
						"id" => "heading6",
						"std" => array('size' => '14px','line' => '16px'),
						"type" => "size");
	
	$options[] = array( "name" => "Menu Font Size and Line Height",
						"desc" => "Select menu font size and line height. (Default: 16/16px)",
						"id" => "menu_size",
						"std" => array('size' => '16px','line' => '16px'),
						"type" => "size");
	
	$options[] = array( "name" => "Dropdown Font Size and Line Height",
						"desc" => "Select dropdown font size and line height. (Default: 14/14px)",
						"id" => "dd_size",
						"std" => array('size' => '14px','line' => '14px'),
						"type" => "size");


	$options[] = array( "name" => "Social Icons",
					"type" => "heading");                   

	$options[] = array( "name" => "RSS",
					"desc" => "Enter your RSS URL",
					"id" => "social_rss",
					"std" => "",
					"type" => "text");
					
	$options[] = array( "name" => "Facebook",
					"desc" => "Enter your Facebook URL",
					"id" => "social_facebook",
					"std" => "",
					"type" => "text");
					 
	$options[] = array( "name" => "Twitter",
					"desc" => "Enter your Twitter URL",
					"id" => "social_twitter",
					"std" => "",
					"type" => "text"); 

	$options[] = array( "name" => "Google+",
					"desc" => "Enter your Google+ URL",
					"id" => "social_gplus",
					"std" => "",
					"type" => "text"); 

	$options[] = array( "name" => "Dribbble",
					"desc" => "Enter your Dribbble URL",
					"id" => "social_dribbble",
					"std" => "",
					"type" => "text");
					 
	$options[] = array( "name" => "LinkedIn",
					"desc" => "Enter your LinkedIn URL",
					"id" => "social_linkedin",
					"std" => "",
					"type" => "text"); 

	$options[] = array( "name" => "Pinterest",
					"desc" => "Enter your Pinterest URL",
					"id" => "social_pinterest",
					"std" => "",
					"type" => "text");
	
	$options[] = array( "name" => "Flickr",
					"desc" => "Enter your Flickr URL",
					"id" => "social_flickr",
					"std" => "",
					"type" => "text"); 
	
	$options[] = array( "name" => "Skype",
					"desc" => "Enter your Skype URL",
					"id" => "social_skype",
					"std" => "",
					"type" => "text");
	
	$options[] = array( "name" => "Tumblr",
					"desc" => "Enter your Tumblr URL",
					"id" => "social_tumblr",
					"std" => "",
					"type" => "text");
	
	$options[] = array( "name" => "Forrst",
					"desc" => "Enter your Forrst URL",
					"id" => "social_forrst",
					"std" => "",
					"type" => "text");
					 
	$options[] = array( "name" => "Last FM",
					"desc" => "Enter your Last FM URL",
					"id" => "social_lastfm",
					"std" => "",
					"type" => "text"); 

	$options[] = array( "name" => "Digg",
					"desc" => "Enter your Digg URL",
					"id" => "social_digg",
					"std" => "",
					"type" => "text");
					 
	$options[] = array( "name" => "YouTube",
					"desc" => "Enter your YouTube URL",
					"id" => "social_youtube",
					"std" => "",
					"type" => "text"); 

	$options[] = array( "name" => "Vimeo",
					"desc" => "Enter your Vimeo URL",
					"id" => "social_vimeo",
					"std" => "",
					"type" => "text");

	$options[] = array( "name" => "Social Pages",
					"type" => "heading");                   

	$options[] = array( "name" => "Flickr ID",
					"desc" => "Enter your Flickr ID",
					"id" => "flickr_id",
					"std" => "",
					"type" => "text");
					
	$options[] = array( "name" => "Dribbble Username",
					"desc" => "Enter your Dribbble username",
					"id" => "dribbble_username",
					"std" => "",
					"type" => "text");

	$options[] = array( "name" => "Lastfm Username",
					"desc" => "Enter your Lastfm username",
					"id" => "lastfm_username",
					"std" => "",
					"type" => "text");
	
	
	
	$options[] = array( "name" => "Contact",
                    "type" => "heading");
	
	
	
	$options[] = array( "name" => "Google Map",
						"desc" => "Enter Google Map shortcode to insert map on the contact page template",
						"id" => "google_map",
						"std" => "",
						"type" => "textarea"); 
	
	
	$options[] = array( "name" => "Include IP",
						"desc" => "Check to include the users IP address in the email",
						"id" => "include_ip",
						"type" => "checkbox",
						"std" => "");
					
	$options[] = array( "name" => "Include URL",
						"desc" => "Check to include the page URL in the email",
						"id" => "include_url",
						"type" => "checkbox",
						"std" => "");
					
	$options[] = array( "name" => "Response - Message Sent",
                    	"desc" => "Enter the message returned when the form is successfully submitted",
                    	"id" => "response_sent",
                    	"std" => "Thank you. Your comments have been received.",
                    	"type" => "text");
					
	$options[] = array( "name" => "Use SMTP",
						"desc" => "Check to use SMTP to send email",
						"id" => "mail_smtp",
						"type" => "checkbox",
						"std" => "");
					
	$options[] = array( "name" => "SMTP Server",
                    	"desc" => "Enter the smtp server",
                    	"id" => "smtp_server",
                    	"std" => "",
                    	"type" => "text");
					
	$options[] = array( "name" => "SMTP Port",
                    	"desc" => "Enter the smtp port (if unsure use 25)",
                    	"id" => "smtp_port",
                    	"std" => "25",
                    	"type" => "text");
					
	$options[] = array( "name" => "SMTP Username",
                    	"desc" => "Enter the email account username - this must be the same account as used in 'Email From'",
                    	"id" => "smtp_user",
                    	"std" => "",
                    	"type" => "text");
					
	$options[] = array( "name" => "SMTP Password",
                    	"desc" => "Enter the email account password",
                    	"id" => "smtp_password",
                    	"std" => "",
                    	"type" => "text");
				
	return $options;
}