<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<?php global $data; ?>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
<?php if ( of_get_option('favicon') ) { echo '<link rel="shortcut icon" href="'.of_get_option('favicon').'"/>'."\n"; } ?>
<title><?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 * We filter the output of wp_title() a bit -- see
	 * twentyten_filter_wp_title() in functions.php.
	 */
	wp_title( '|', true, 'right' );

	?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/css/media-queries.css"  />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/css/blue/style.css"  />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/js/fancybox/jquery.fancybox.css" media="all" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/js/fancybox/helpers/jquery.fancybox-buttons.css?v=1.0.2" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/js/fancybox/helpers/jquery.fancybox-thumbs.css?v=1.0.2" />

<?php if ( of_get_option('heading_font') ) { echo '<link rel="stylesheet" type="text/css" media="all" href="'.get_template_directory_uri().'/style/type/'.of_get_option('heading_font').'.css"/>'."\n"; } ?>
<?php if ( of_get_option('secondary_font') ) { echo '<link rel="stylesheet" type="text/css" media="all" href="'.get_template_directory_uri().'/style/type/'.of_get_option('secondary_font').'.css"/>'."\n"; } ?>
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/type/classic.css" media="all" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/type/droid.css" media="all" />
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/type/goudy.css" media="all" />
<!--[if IE 7]>
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/css/ie7.css" media="all" />
<![endif]-->
<!--[if IE 8]>
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/css/ie8.css" media="all" />
<![endif]-->
<!--[if IE 9]>
<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/style/css/ie9.css" media="all" />
<![endif]-->
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/style/js/html5.js" type="text/javascript"></script>
<![endif]-->
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	wp_head();
?>

</head>

<body <?php body_class(); ?>>
<div id="body-wrapper"> 
  <!-- Begin Header -->
  <div id="header">
    <div class="logo">
     <a href="<?php echo home_url(); ?>">
		<?php if ( of_get_option('logo') ) { ?>
			<img src="<?php echo of_get_option('logo'); ?>" alt="<?php bloginfo( 'name' ); ?>" />
		<?php } else {?>
			<h1 class="blog-title"><?php bloginfo( 'name' ); ?></h1>
		<?php } ?>
	</a>
    </div>

     <!-- Begin Menu -->
     <nav id="access" class="access" role="navigation">
    <?php /* Our navigation menu.  If one isn't filled out, wp_nav_menu falls back to wp_page_menu. The menu assiged to the primary position is the one used. If none is assigned, the menu with the lowest ID is used. */ ?>
    <?php wp_nav_menu( array( 'container_id' => 'menu', 'container_class' => 'menu', 'theme_location' => 'primary', 'items_wrap'  => '<ul id="tiny">%3$s</ul>', ) ); ?>
  </nav>
  <!-- #access -->
    <div class="clear"></div>
    <!-- End Menu -->  
    
  </div>
  <!-- End Header --> 
  
  



		
