<?php
/**
 * Add function to widgets_init that'll load our widget.
 * @since 0.1
 */
add_action( 'widgets_init', 'example_load_widgets' );

/**
 * Register our widget.
 * 'Example_Widget' is the widget class used below.
 *
 * @since 0.1
 */
function example_load_widgets() {
	register_widget( 'Example_Widget' );
}

/**
 * Example Widget class.
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 * @since 0.1
 */
class Example_Widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function Example_Widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'example', 'description' => __('A widget that displays popular posts with or without thumbnail.', 'example') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'example-widget' );

		/* Create the widget. */
		$this->WP_Widget( 'example-widget', __('Popular Posts (Socialike)', 'example'), $widget_ops, $control_ops );
	}

	/**
	 * How to display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$show_thumbnail = isset( $instance['show_thumbnail'] ) ? $instance['show_thumbnail'] : false;

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* If show thumbnail was selected, display the thumbnails. */
		if ( $show_thumbnail )
			{
			?>

<h4 class="widget-title"><?php _e("Popular Posts", "elemis"); ?></h4>
<ul class="popular-posts">
  <?php
$pc = new WP_Query('orderby=comment_count&posts_per_page=3'); ?>
  <?php while ($pc->have_posts()) : $pc->the_post(); ?>
  <li> <a href="<?php the_permalink(); ?>">
    <?php the_post_thumbnail( 'list_thumb'); ?>
    </a>
    <div class="p-text">
    <h5><a href="<?php the_permalink(); ?>">
      <?php the_title(); ?>
      </a></h5>
    <span>
    <?php the_time('jS M Y') ?>
    |
    <?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?>
    </span>
    </div>
     </li>
  <?php endwhile; ?>
</ul>
<?php
			
			}
		/* If show thumbnail was not selected, don't display the thumbnails. */	
		if ( ! $show_thumbnail ) {
			?>
<h4 class="widget-title"><?php _e("Popular Posts", "elemis"); ?></h4>
<ul class="popular-posts">
  <?php
$pc = new WP_Query('orderby=comment_count&posts_per_page=3'); ?>
  <?php while ($pc->have_posts()) : $pc->the_post(); ?>
  <li>
    <h5><a href="<?php the_permalink(); ?>">
      <?php the_title(); ?>
      </a></h5>
    <span>
    <?php the_time('jS M Y') ?>
    |
    <?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?>
    </span>
    </div>
    
     </li>
  <?php endwhile; ?>
</ul>
<?php
			
			}

		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['show_thumbnail'] = $new_instance['show_thumbnail'];

		return $instance;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 'title' => __('Example', 'example'), 'name' => __('John Doe', 'example'), 'thumbnail' => 'male', 'show_thumbnail' => true );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

<!-- Show thumbnails? Checkbox -->
<p>
  <input class="checkbox" type="checkbox" <?php checked( (bool) $instance['show_thumbnail'], true ); ?> id="<?php echo $this->get_field_id( 'show_thumbnail' ); ?>" name="<?php echo $this->get_field_name( 'show_thumbnail' ); ?>" />
  <label for="<?php echo $this->get_field_id( 'show_thumbnail' ); ?>">
    <?php _e('Show thumbnails?', 'elemis'); ?>
  </label>
</p>
<?php
	}
}

?>
