<?php 

    add_filter('the_content', 'shortcode_empty_paragraph_fix');
    function shortcode_empty_paragraph_fix($content)
    {   
        $array = array (
            '<p>[' => '[', 
            ']</p>' => ']', 
            ']<br />' => ']'
        );

        $content = strtr($content, $array);

		return $content;
    }

	if ( !function_exists('elemis_shortcode_formatter') ) :

function elemis_shortcode_formatter($content) {
	$new_content = '';
	
	/* Matches the contents and the open and closing tags */
	$pattern_full = '{(\[raw\].*?\[/raw\])}is';
	
	/* Matches just the contents */
	$pattern_contents = '{\[raw\](.*?)\[/raw\]}is';
	
	/* Divide content into pieces */
	$pieces = preg_split($pattern_full, $content, -1, PREG_SPLIT_DELIM_CAPTURE);
	
	/* Loop over pieces */
	foreach ($pieces as $piece) {
		/* Look for presence of the shortcode */
		if (preg_match($pattern_contents, $piece, $matches)) {
			
			/* Append to content (no formatting) */
			$new_content .= $matches[1];
		} else {
			
			/* Format and append to content */
			$new_content .= wptexturize(wpautop($piece));		
		}
	}
	
	return $new_content;
}

// Remove the 2 main auto-formatters
remove_filter('the_content', 'wpautop');
remove_filter('the_content', 'wptexturize');

// Before displaying for viewing, apply this function
add_filter('the_content', 'elemis_shortcode_formatter', 99);
add_filter('widget_text', 'elemis_shortcode_formatter', 99);

endif;
	
/**
 * Image
 */
function image_shortcode($atts) {
	extract(shortcode_atts(array(	
		"url" => "",
		"img" => "",
		"alt" => "",
		"rel" => "",
		"align" => "",
		"frame" => "false",
		"lightbox" => 'false'
	), $atts));
	
	if ( $img == '' )
		return NULL;
	
	if( $lightbox == 'true' )
		$img_rel = 'rel="prettyPhoto[' . $rel . ']"';
		
	if( $frame == 'true' )
		$border = 'frame';
		
	if( $url != '' ) {
		$output  .=  "\n" . '<a href="' . $url . '" title="' . $alt . '" ' . $img_rel . '><img src="' . $img . '" class="' . $align . ' ' . $border . '" alt="' . $alt . '" title="' . $alt . '"/></a>';
	} else {
		$output  .=  "\n" . '<img src="' . $img . '" alt="' . $alt . '" title="' . $alt . '" class="' . $align . ' ' . $border . '"/>';
	}
	
	return $output;
}
add_shortcode('image', 'image_shortcode');

/**
 * h1
 */

function h1_shortcode( $atts, $content = null ) {
   extract( shortcode_atts( array(
      'line' => 'false',
      ), $atts ) );
      
      if( $line == 'true' )
		$lines = 'class="line"';
 
   return '<h1 ' . $lines . '>' . $content . '</h1>';
}
add_shortcode('h1', 'h1_shortcode');

/**
 * h2
 */

function h2_shortcode( $atts, $content = null ) {
   extract( shortcode_atts( array(
      'line' => 'false',
      ), $atts ) );
      
      if( $line == 'true' )
		$lines = 'class="line"';
 
   return '<h2 ' . $lines . '>' . $content . '</h2>';
}
add_shortcode('h2', 'h2_shortcode');

/**
 * h3
 */

function h3_shortcode( $atts, $content = null ) {
   extract( shortcode_atts( array(
      'line' => 'false',
      ), $atts ) );
      
      if( $line == 'true' )
		$lines = 'class="line"';
 
   return '<h3 ' . $lines . '>' . $content . '</h3>';
}
add_shortcode('h3', 'h3_shortcode');


/**
 * h4
 */

function h4_shortcode( $atts, $content = null ) {
   extract( shortcode_atts( array(
      'line' => 'false',
      ), $atts ) );
      
      if( $line == 'true' )
		$lines = 'class="line"';
 
   return '<h4 ' . $lines . '>' . $content . '</h4>';
}
add_shortcode('h4', 'h4_shortcode');

/**
 * h5
 */

function h5_shortcode( $atts, $content = null ) {
   extract( shortcode_atts( array(
      'line' => 'false',
      ), $atts ) );
      
      if( $line == 'true' )
		$lines = 'class="line"';
 
   return '<h5 ' . $lines . '>' . $content . '</h5>';
}
add_shortcode('h5', 'h5_shortcode');

/**
 * h6
 */

function h6_shortcode( $atts, $content = null ) {
   extract( shortcode_atts( array(
      'line' => 'false',
      ), $atts ) );
      
      if( $line == 'true' )
		$lines = 'class="line"';
 
   return '<h6 ' . $lines . '>' . $content . '</h6>';
}
add_shortcode('h6', 'h6_shortcode');

/** Button */
add_shortcode( 'button', 'button_shortcode' );
function button_shortcode( $atts, $content = null ) {
    extract( shortcode_atts( array( 
    "url" => '', 
    "color" => '',
	"text_color" => '',
	"border_color" => '',
    "blank" => 'false'
    ), $atts ) );
    
    if( $blank == 'true' )
		$target = 'blank="_blank"';
    
    $backgroundColor = $color != '' ? ' background-color:#' . $color . ';' : '' ;
	$textColor = $text_color != '' ? ' color:#' . $text_color . ';' : '' ;
	$borderColor = $border_color != '' ? ' border-color:#' . $border_color . ';' : '' ;
	$style = $backgroundColor.$textColor.$borderColor != '' ? ' style="'.$backgroundColor.$textColor.$borderColor.'"' : '' ;
	
	return '<a href="' . $url . '" class="button"'.$style.' ' . $blank . '>' . do_shortcode($content) . '</a>';
    
}

/**
 * Video
 */
function video_shortcode( $atts, $content = null ) {
   return '<div class="video"> 
    	' . do_shortcode($content) . '
</div>';
}
add_shortcode('video', 'video_shortcode');



/** Info */
function info_box_shortcode($atts, $content = null) {	
	return '<div class="info-box">' . do_shortcode($content) . '</div>';
}
add_shortcode('info_box', 'info_box_shortcode');

/** Warning */
function warning_box_shortcode($atts, $content = null) {	
	return '<div class="warning-box">' . do_shortcode($content) . '</div>';
}
add_shortcode('warning_box', 'warning_box_shortcode');


/** Note */
function note_box_shortcode($atts, $content = null) {	
	return '<div class="note-box">' . do_shortcode($content) . '</div>';
}
add_shortcode('note_box', 'note_box_shortcode');


/** Download */
function download_box_shortcode($atts, $content = null) {	
	return '<div class="download-box">' . do_shortcode($content) . '</div>';
}
add_shortcode('download_box', 'download_box_shortcode');


/** Br */
function br_shortcode( $atts, $content = null ) {
   return '<br />';
}
add_shortcode('br', 'br_shortcode');

/** Divider */
function divider_shortcode( $atts, $content = null ) {
   return '<div class="divider"></div>';
}
add_shortcode('divider', 'divider_shortcode');

/** Clear */
function clear_shortcode( $atts, $content = null ) {
   return '<div class="clear"></div>';
}
add_shortcode('clear', 'clear_shortcode');

/** Social Media Links */
function social_links_shortcode( $atts, $content = null ) {
   ob_start();
include TEMPLATEPATH . '/social.php';
$content = ob_get_clean();
return $content;
}
add_shortcode('social_links', 'social_links_shortcode');


/** 2 Columns */
function col2_shortcode( $atts, $content = null ) {
   return '<div class="one-half">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col2', 'col2_shortcode');



/** 2 Columns Last */
add_shortcode( 'col2_last', 'col2_last_shortcode' );
function col2_last_shortcode( $atts, $content = null ) {
    return '<div class="one-half last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}

/** 3 Columns */
function col3_shortcode( $atts, $content = null ) {
   return '<div class="one-third">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col3', 'col3_shortcode');



/** 3 Columns Last */
add_shortcode( 'col3_last', 'col3_last_shortcode' );
function col3_last_shortcode( $atts, $content = null ) {
    return '<div class="one-third last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}

/** 4 Columns */
function col4_shortcode( $atts, $content = null ) {
   return '<div class="one-fourth">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col4', 'col4_shortcode');



/** 4 Columns Last */
add_shortcode( 'col4_last', 'col4_last_shortcode' );
function col4_last_shortcode( $atts, $content = null ) {
    return '<div class="one-fourth last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}

/** 5 Columns */
function col5_shortcode( $atts, $content = null ) {
   return '<div class="one-fifth">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col5', 'col5_shortcode');

/** 5 Columns Last */
add_shortcode( 'col5_last', 'col5_last_shortcode' );
function col5_last_shortcode( $atts, $content = null ) {
    return '<div class="one-fifth last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}

/** 6 Columns */
function col6_shortcode( $atts, $content = null ) {
   return '<div class="one-sixth">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col6', 'col6_shortcode');

/** 6 Columns Last */
add_shortcode( 'col6_last', 'col6_last_shortcode' );
function col6_last_shortcode( $atts, $content = null ) {
    return '<div class="one-sixth last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}


/** One-Third Columns */
function col1_3_shortcode( $atts, $content = null ) {
   return '<div class="one-third">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col1_3', 'col1_3_shortcode');

/** One-Third Columns Last */
function col1_3_last_shortcode( $atts, $content = null ) {
   return '<div class="one-third last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('col1_3_last', 'col1_3_last_shortcode');


/** Two-Third Columns */
function col2_3_shortcode( $atts, $content = null ) {
   return '<div class="two-third">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col2_3', 'col2_3_shortcode');

/** Two-Third Columns Last */
function col2_3_last_shortcode( $atts, $content = null ) {
   return '<div class="two-third last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('col2_3_last', 'col2_3_last_shortcode');

/** One-Fourth Columns */
function col1_4_shortcode( $atts, $content = null ) {
   return '<div class="one-fourth">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col1_4', 'col1_4_shortcode');

/** One-Fourth Columns Last */
function col1_4_last_shortcode( $atts, $content = null ) {
   return '<div class="one-fourth last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('col1_4_last', 'col1_4_last_shortcode');

/** Three-Fourth Columns */
function col3_4_shortcode( $atts, $content = null ) {
   return '<div class="three-fourth">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('col3_4', 'col3_4_shortcode');

/** Three-Fourth Columns Last */
function col3_4_last_shortcode( $atts, $content = null ) {
   return '<div class="three-fourth last">'."\n\n" . do_shortcode($content) . '</div><div class="clear"></div>';
}
add_shortcode('col3_4_last', 'col3_4_last_shortcode');


/**
 * Dropcap
 */
function dropcap_shortcode($atts, $content = null) {	
	return '<span class="dropcap">' . do_shortcode($content) . '</span>';
}
add_shortcode('dropcap', 'dropcap_shortcode');

/**
 * Unordered List
 */
function u_list_shortcode($atts, $content = null) {	
	return '<ul>' . do_shortcode($content) . '</ul>';
}
add_shortcode('u_list', 'u_list_shortcode');

/**
 * Ordered List
 */
function o_list_shortcode($atts, $content = null) {	
	return '<ol>' . do_shortcode($content) . '</ol>';
}
add_shortcode('o_list', 'o_list_shortcode');

/**
 * Li
 */
function li_shortcode($atts, $content = null) {	
	return '<li>' . do_shortcode($content) . '</li>';
}
add_shortcode('li', 'li_shortcode');


/**
 * Highlight
 */
function lite1_shortcode($atts, $content = null) {	
	return '<span class="lite1">' . do_shortcode($content) . '</span>';
}
add_shortcode('lite1', 'lite1_shortcode');

/**
 * Highlight 2
 */
function lite2_shortcode($atts, $content = null) {	
	return '<span class="lite2">' . do_shortcode($content) . '</span>';
}
add_shortcode('lite2', 'lite2_shortcode');

/**
 * hr
 */
function hr_shortcode($atts, $content = null) {	
	return '<div class="hr">' . do_shortcode($content) . '</div>';
}
add_shortcode('hr', 'hr_shortcode');


/**
 * Blockquote
 */
function quote_shortcode($atts, $content = null) {	
	return '<blockquote>' . do_shortcode($content) . '</blockquote>';
}
add_shortcode('quote', 'quote_shortcode');

/**
 * Code
 */
function code_shortcode($atts, $content = null) {	
	return '<pre>' . do_shortcode($content) . '</pre>';
}
add_shortcode('code', 'code_shortcode');

/**
 * Intro
 */
function intro_shortcode($atts, $content = null) {	
	return '<div class="intro">'."\n\n" . do_shortcode($content) . '</div>';
}
add_shortcode('intro', 'intro_shortcode');

/**
 * Tabs
 */
add_shortcode( 'tabgroup', 'etdc_tab_group' );
function etdc_tab_group( $atts, $content ){
$GLOBALS['tab_count'] = 0;

do_shortcode( $content );

if( is_array( $GLOBALS['tabs'] ) ){
foreach( $GLOBALS['tabs'] as $tab ){
$tabs[] = '<li><a class="" href="#">'.$tab['heading'].'</a></li>';
$panes[] = '<div class="pane">'."\n\n".do_shortcode($tab['content']).'</div>';
}
$return = "\n".'<!-- the tabs --><ul class="tabs">'.implode( "\n", $tabs ).'</ul>'."\n".'<!-- tab "panes" --><div class="panes">'.implode( "\n", $panes ).'</div><div class="clear"></div>'."\n";
}
return $return;
}

add_shortcode( 'tab', 'etdc_tab' );
function etdc_tab( $atts, $content ){
extract(shortcode_atts(array(
'heading' => 'Tab %d'
), $atts));

$x = $GLOBALS['tab_count'];
$GLOBALS['tabs'][$x] = array( 'heading' => sprintf( $heading, $GLOBALS['tab_count'] ), 'content' =>  $content );

$GLOBALS['tab_count']++;
}


/**
 * Toggle
 */

function toggle_shortcode( $atts, $content = null ) {
	extract(shortcode_atts(array(
        'heading'      => ''
    ), $atts));
	
	
	$out .= '<div class="toggle">';
	$out .= '<h4 class="trigger title" style="width:' .$width. 'px;"><span class="trigger-wrapper">' .$heading. '</span></h4>';
	$out .= '<div class="togglebox"><div>';
	$out .= "\n\n";
	$out .= do_shortcode( $content );
	$out .= '</div></div>';
	$out .= '</div>';
	
   return $out;
}
add_shortcode('toggle', 'toggle_shortcode');


//Google Maps Shortcode
function fn_googleMaps($atts, $content = null) {
   extract(shortcode_atts(array(
      "width" => '695',
      "height" => '250',
      "src" => ''
   ), $atts));
   return '<iframe width="'.$width.'" height="'.$height.'" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="'.$src.'&amp;output=embed"></iframe>';
}
add_shortcode("googlemap", "fn_googleMaps");

/**
 * Forms
 */

function forms_shortcode( $atts, $content = null ) {
	
	global $data;
	
	extract( shortcode_atts( array( 
    "emailto" => '',
	"emailsubject" => '',
	"submit" => 'Submit'
    ), $atts ) );
	
	$obfuscatedLink = "";
	for ($i=0; $i<strlen($emailto); $i++){
		$obfuscatedLink .= "&#" . ord($emailto[$i]) . ";";
	}
	
	$validError = $data['valid_error'] == '' ? 'Required' : $data['valid_error'];
	$validEmail = $data['valid_email'] == '' ? 'Enter a valid email' : $data['valid_email'];
	
	$out = '<div class="form-container"><div class="response"></div>';
	$out .= '<form class="forms" action="'.get_stylesheet_directory_uri().'/admin/form-handler.php" method="post">';
	$out .= '<fieldset><ol>';
	$out .= do_shortcode( $content );
	$out .= '<li class="nocomment"><label for="nocomment">Leave This Field Empty</label><input id="nocomment" value="" name="nocomment" /></li>';
	$out .= '<li class="button-row"><input type="submit" value="'.$submit.'" name="submit" class="btn-submit" /></li>';
	$out .= '</ol>';
	$out .= '<input type="hidden" name="emailto" value="'.$obfuscatedLink.'" />';
	$out .= '<input type="hidden" name="emailsubject" value="'.$emailsubject.'" />';
	$out .= '<input type="hidden" name="v_error" id="v-error" value="'.$validError.'" />';
	$out .= '<input type="hidden" name="v_email" id="v-email" value="'.$validEmail.'" />';
	$out .= '<input type="hidden" name="ip" value="'.$ip.'" />';
	$out .= '<input type="hidden" name="url" value="'.$url.'" />';
	$out .= '</fieldset></form></div>';
	
   return $out;
}
add_shortcode('forms', 'forms_shortcode');

/**
 * Form Item
 */

function form_item_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array( 
    "input" => '', 
    "label" => '',
    "validation" => '1',
	"emailfrom" => '',
	"required" => '',
	"value" => '',
	"checked" => ''
    ), $atts ) );
	
	$valid = $required == 'true' ? ' required' : '';
	$checked = $checked == 'true' ? ' checked="checked"' : '';
	$name = strtolower(str_replace(" ", "-", $label));
	$validation = $input == 'text-input' ? $validation : '1' ;
	
	switch($validation)
    {
        case '1':
            $valid .= '';
            break;
        case '2':
			$valid .= ' email';
			$name = $emailfrom == true ? 'email' : $name ;
            break;
    }
	
	switch($input)
    {
        case 'text-input':
            $field = '<label>'.$label.'</label><input type="text" name="'.$name.'" value="" class="'.$input.$valid.'" title="" />';
            break;
        case 'password':
            $field = '<label>'.$label.'</label><input type="password" name="'.$name.'" value="" class="'.$input.$valid.'" />';
            break;
        case 'checkbox':
            $field = '<label>'.$label.'</label><input type="checkbox" name="'.$name.'" value="'.$value.'" class="'.$input.$valid.'"'.$checked.' />';
            break;
		case 'radio':
            $field = '<label>'.$label.'</label><input type="radio" name="'.$name.'" value="'.$value.'" class="'.$input.$valid.'"'.$checked.' />';
            break;
		case 'hidden':
            $field = '<input type="hidden" name="'.$name.'" value="" />';
            break;
		case 'text-area':
            $field = '<label>'.$label.'</label><textarea name="'.$name.'" class="'.$input.$valid.'"></textarea>';
            break;
    }
	
	$out = '<li class="form-row '.$input.'-row">';
	$out .= $field;
	$out .= '</li>';
	
   return $out;
}
add_shortcode('form_item', 'form_item_shortcode');

/**
 * Form Select List
 */

function form_select_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array( 
    "label" => ''
    ), $atts ) );
	
	$name = strtolower(str_replace(" ", "-", $label));
	$label = '<label>'.$label.'</label>';

	switch($selecttype)
    {
        case 'single':
            $field = $label.'<select name="'.$name.'" class="select" title="">';
			$field .= do_shortcode( $content );
			$field .= '</select>';
            break;
        case 'multi':
            $field = $label.'<select name="'.$name.'" class="multi-select" title="" multiple="multiple">';
			$field .= do_shortcode( $content );
			$field .= '</select>';
            break;
		default:
			$field = $label.'<select name="'.$name.'" class="select" title="">';
			$field .= do_shortcode( $content );
			$field .= '</select>';
            break;
    }
	
	$out = '<li class="form-row select-row">';
	$out .= $field;
	$out .= '</li>';
	
   return $out;
}
add_shortcode('form_select', 'form_select_shortcode');

/**
 * Form Select Option
 */

function form_option_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array( 
    "value" => ''
    ), $atts ) );

	$field = '<option value="'.$value.'">';
	$field .= do_shortcode( $content );
	$field .= '</option>';
	return $field;
}
add_shortcode('form_option', 'form_option_shortcode');

?>