<?php

/*-----------------------------------------------------------------------------------*/
/* Options Framework Functions
/*-----------------------------------------------------------------------------------*/

define('ADMIN_PATH', TEMPLATEPATH . '/admin/');
define('ADMIN', get_template_directory_uri() . '/admin/');
define('FUNCTIONS_PATH', TEMPLATEPATH . '/functions/');
define('INCLUDES_PATH', TEMPLATEPATH . '/includes/');
define('IMAGES', get_template_directory_uri() . '/style/images');
define('RWMB_URL', trailingslashit( get_template_directory_uri().'/includes/meta-box' ) );
define('RWMB_DIR', trailingslashit( get_template_directory().'/includes/meta-box' ) );

require_once (FUNCTIONS_PATH . 'socialike-functions.php');
require_once (FUNCTIONS_PATH . 'socialike-options.php');
require_once (FUNCTIONS_PATH . 'shortcodes.php');
require_once (FUNCTIONS_PATH . 'widget.php');
include_once (TEMPLATEPATH . '/includes/sidebar_generator/sidebar_generator.php');
include_once (TEMPLATEPATH . '/includes/like-this/likethis.php');


require_once (ADMIN_PATH . 'shortcodes-editor.php');
require_once (RWMB_DIR . 'meta-box.php');
include (INCLUDES_PATH  . 'meta-box/config.php');



if ( !function_exists( 'optionsframework_init' ) ) {

	/*-----------------------------------------------------------------------------------*/
	/* Options Framework Theme
	/*-----------------------------------------------------------------------------------*/

	/* Set the file path based on whether the Options Framework Theme is a parent theme or child theme */

	if ( STYLESHEETPATH == TEMPLATEPATH ) {
		define('OPTIONS_FRAMEWORK_URL', TEMPLATEPATH . '/admin/');
		define('OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/admin/');
	} else {
		define('OPTIONS_FRAMEWORK_URL', STYLESHEETPATH . '/admin/');
		define('OPTIONS_FRAMEWORK_DIRECTORY', get_stylesheet_directory_uri() . '/admin/');
	}

	require_once (OPTIONS_FRAMEWORK_URL . 'options-framework.php');

}

/* 
 * This is an example of how to add custom scripts to the options panel.
 * This example shows/hides an option when a checkbox is clicked.
 */

add_action('optionsframework_custom_scripts', 'optionsframework_custom_scripts');

function optionsframework_custom_scripts() { ?>

<script type="text/javascript">
jQuery(document).ready(function() {

	jQuery('#example_showhidden').click(function() {
  		jQuery('#section-example_text_hidden').fadeToggle(400);
	});
	
	if (jQuery('#example_showhidden:checked').val() !== undefined) {
		jQuery('#section-example_text_hidden').show();
	}
	
});
</script>

<?php
}

load_theme_textdomain( 'elemis', TEMPLATEPATH . '/lang' );


function load_my_scripts() {

//don't use (deregister) WP's jQuery version
wp_deregister_script( 'jquery' );

//Use jQuery from Google Code
wp_register_script('jquery', 'http://ajax.googleapis.com/ajax/libs/jquery/1.7.0/jquery.min.js');


//Include one of my custom javascript files
wp_register_script( 'uiwidget', get_template_directory_uri().'/style/js/jquery.ui.widget.min.js', 'jquery', '1.0');
wp_register_script( 'audio', get_template_directory_uri().'/style/js/AudioPlayerV1.js', 'jquery', '1.1.3');
wp_register_script( 'menu', get_template_directory_uri().'/style/js/superfish.js', 'jquery', '1.4.8');
wp_register_script( 'hover', get_template_directory_uri().'/style/js/jquery.hoverIntent.js', 'jquery', '1.0');
wp_register_script( 'selectnav', get_template_directory_uri().'/style/js/selectnav.js', 'jquery', '0.1');
wp_register_script( 'jtools', get_template_directory_uri().'/style/js/jquery.tools.min.js', 'jquery', '1.2.5');
wp_register_script( 'fitvids', get_template_directory_uri().'/style/js/jquery.fitvids.js', 'jquery', '1.0');
wp_register_script( 'flex', get_template_directory_uri().'/style/js/jquery.flexslider-min.js', 'jquery', '1.8');
wp_register_script( 'fancybox', get_template_directory_uri().'/style/js/jquery.fancybox.pack.js', 'jquery', '2.0.6');
wp_register_script( 'buttons', get_template_directory_uri().'/style/js/fancybox/helpers/jquery.fancybox-buttons.js', 'jquery', '1.0.2');
wp_register_script( 'thumbs', get_template_directory_uri().'/style/js/fancybox/helpers/jquery.fancybox-thumbs.js', 'jquery', '1.0.2');
wp_register_script( 'media', get_template_directory_uri().'/style/js/fancybox/helpers/jquery.fancybox-media.js', 'jquery', '1.0.0');
wp_register_script( 'forms', get_stylesheet_directory_uri().'/style/js/jquery.slickforms.js', 'jquery', '1.0');
wp_register_script( 'scripts', get_template_directory_uri().'/style/js/scripts.js', 'jquery', '1.0');
wp_register_script( 'masonry', get_template_directory_uri().'/style/js/jquery.masonry.min.js', 'jquery', '2.1.05');
wp_register_script( 'dribbble', get_template_directory_uri().'/style/js/jquery.jribbble-0.11.0.ugly.js', 'jquery', '0.11');
wp_register_script( 'flickr', get_template_directory_uri().'/style/js/jquery.dcflickr.1.0.js', 'jquery', '1.0');
wp_register_script( 'engage', get_template_directory_uri().'/style/js/engage.js', 'jquery', '1.0');

wp_enqueue_script('jquery');
wp_enqueue_script('uiwidget');
wp_enqueue_script('audio');
wp_enqueue_script('menu');
wp_enqueue_script('selectnav');
wp_enqueue_script('hover');
wp_enqueue_script('jtools');
wp_enqueue_script('fitvids');
wp_enqueue_script('flex');
wp_enqueue_script('fancybox');
wp_enqueue_script('buttons');
wp_enqueue_script('thumbs');
wp_enqueue_script('media');
wp_enqueue_script('forms');
wp_enqueue_script('scripts');


if(is_page_template('template-dribbble.php')):
	wp_enqueue_script('masonry');
	wp_enqueue_script('dribbble');
endif;

if(is_page_template('template-flickr.php')):
	wp_enqueue_script('masonry');
	wp_enqueue_script('flickr');
endif;

if(is_page_template('template-gallery.php')):
	wp_enqueue_script('masonry');
endif;

if(is_page_template('template-lastfm.php')):
	wp_enqueue_script('engage');
endif;

}
add_action('wp_enqueue_scripts', 'load_my_scripts');
?>