<?php
					// Check if this is a post or page, if it has a thumbnail, and if it's a big one
					if ( has_post_thumbnail( $post->ID ) &&
							( /* $src, $width, $height */ $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), array( HEADER_IMAGE_WIDTH, HEADER_IMAGE_WIDTH ) ) ) &&
							$image[1] >= HEADER_IMAGE_WIDTH ) :
					 {  ?>

<div class="full-size"><a href="<?php the_permalink(); ?>">
  <?php the_post_thumbnail( 'full-size' ); ?>
  </a></div>
<?php } else : ?>
<div class="normal-size"><a href="<?php the_permalink(); ?>">
  <?php the_post_thumbnail( 'post-thumbnail'); ?>
  </a></div>
<?php endif; // end check for featured image ?>
<?php if ( is_singular() ) { ?>
<h1 class="entry-title">
  <?php the_title(); ?>
</h1>
<?php } else { ?>
<h2 class="entry-title"><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'elemis' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark">
  <?php the_title(); ?>
  </a></h2>
<?php } ?>
