<?php
	class hybrid_testimonials extends WP_Widget{
	
		function hybrid_testimonials() 
		{
			parent::WP_Widget(false, $name = 'Hybrid > Testimonials');
		}
		
		function widget($args, $instance)
		{
			extract( $args );
			$title = apply_filters('widget_title', $instance['title']);		
		
				//echo $before_widget;		
			if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '<div class="span3">';// Display some text
			}?>
			 
			  <h3><?php echo $title;?></h3>
			  <div class="testmonials">
				<ul id="testmonials-feed" class="feed">
					<?php
						$args = array('post_type' => 'testmonials_post','posts_per_page' => -1 );
						$the_query = new WP_Query($args);
						while ( $the_query->have_posts() ):$the_query->the_post();
							?>
							<li>
								<a href="<?php echo esc_url( get_permalink( get_page_by_title( 'Testimonials' ) ) ); ?>"><p class="desc desc-container">
									<?php $excerpt = get_the_excerpt();
										echo $excerpt; ?>
								</p></a>
								<div class="testmonials-text">
									<p class="post-title"><?php the_title();?></p>
									<p class="post-categoty"><?php the_field('position');?></p>
								</div>
							</li>
						<?php endwhile ;?>
				</ul>			 
			  </div>
			  
				<?php		
				if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '</div>';
					}					
				//echo $after_widget;
		}
		
		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			return $instance;
		}
		
		function form($instance)
		{
			$title = isset($instance['title']) ? esc_attr($instance['title']) : "";			
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title',"um_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<?php
		}
	}
	
	function hybrid_widgets_testimonials() {			
		register_widget('hybrid_testimonials');			
	}
	add_action('widgets_init', 'hybrid_widgets_testimonials');
?>