<?php
class hybrid_flickr_widget extends WP_Widget{
	function hybrid_flickr_widget() 
	{
		parent::WP_Widget(false, $name = 'Hybrid > Flickr');
	}
	
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters('widget_title', $instance['title']);	
		$user_id	= $instance['user_id'];
		$apikey		= $instance['apikey'];
		echo $before_widget;
		?>
		
				<h3><?php echo $title;?></h3>
				<div class="widget" id="flickr"></div>
					<script>
						jQuery(document).ready(function() {
							jQuery(function(){
									var apikey = '<?php echo $apikey; ?>';//'2a43875a89a5f83a7096c26b4a62b5cf';
									var userid = '<?php echo $user_id; ?>';//'102896215@N07';
									jQuery.getJSON('http://api.flickr.com/services/rest/?&method=flickr.people.getPublicPhotos&api_key='+apikey+'&user_id='+userid+'&format=json&jsoncallback=?',
									function(data){
										$.each(data.photos.photo, function(i,item){
											if(i<=7){
												var purl = 'http://farm' + item.farm + '.static.flickr.com/' + item.server + '/' + item.id + '_' + item.secret + '_m.jpg';
												var pid = item.id;	
												$("<img class='instagram-image'/>").attr("src", purl).appendTo("#flickr")
													.wrap("<div class='instagram-placeholder'><a href='http://www.flickr.com/photos/"+userid+"/" + item.id  + "' target='_blank' title=''></a></div>");
										
											}
										});
									});
								});
							});
					</script>
					
		<?php
		 echo $after_widget;
	}
	
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);	
		$instance['user_id'] = strip_tags($new_instance['user_id']);	
		$instance['apikey'] = strip_tags($new_instance['apikey']);	
		
		return $instance;
	}
	
	function form($instance)
	{
		$title = isset($instance['title']) ? esc_attr($instance['title']) : "";
		$user_id = isset($instance['user_id']) ? esc_attr($instance['user_id']) : "";
		$apikey = isset($instance['apikey']) ? esc_attr($instance['apikey']) : "";
	
		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title',"hybrid_lang"); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('user_id'); ?>"><?php _e('User ID',"hybrid_lang"); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('user_id'); ?>" name="<?php echo $this->get_field_name('user_id'); ?>" type="text" value="<?php echo $user_id; ?>" />
		</p>	
		<p>
			<label for="<?php echo $this->get_field_id('apikey'); ?>"><?php _e('API KEY',"hybrid_lang"); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id('apikey'); ?>" name="<?php echo $this->get_field_name('apikey'); ?>" type="text" value="<?php echo $apikey; ?>" />
		</p>			
		<?php
	}
}

function register_hybrid_flickr_widget() {			
	register_widget('hybrid_flickr_widget');			
}
add_action('widgets_init', 'register_hybrid_flickr_widget');
?>