<?php
	class st_hybrid_blogposts extends WP_Widget{
	
		function st_hybrid_blogposts() 
		{
			parent::WP_Widget(false, $name = 'Hybrid > BlogPosts');
		}
		
		function widget($args, $instance)
		{
			extract( $args );
			$title = apply_filters('widget_title', $instance['title']);		
			global $post;
			setup_postdata( $post );

			  ?>
			 <div class="span6">
					<ul class="blogPosts">
					<?php
                            $args1 = array(
                                'post_type' => 'post',
                                'posts_per_page' => -1,
                            );
                            $the_query = new WP_Query($args1);
                            while ( $the_query->have_posts() ):
                                $the_query->the_post();
								
                        ?>
					 <li>
							<div id="blog-slider-container">
								<input type="hidden" value="<?php echo $post->ID;?>"/>
								<div class="post-image">
									<a href="<?php the_permalink();?>">
                                    <?php if(has_post_thumbnail()): ?>
                                        <?php
                                        $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'home1-blog');
                                        echo '<img src="'.$image[0].'"/>';
                                        ?>
                                    <?php endif; ?>
									<div class="image-hover"></div>
									</a>
								</div>
								<div class="post-desc">
									<div class="border-container">
										<div class="comment-size-box">
                                                <p class="comment-number">
                                                    <?php  echo get_comments_number(); ?>
                                                </p></div>
										<div class="triangle-box">
											<div class="triangle triangle-border"></div>
											<div class="triangle triangle-body"></div>
										</div>
									</div>									
									<a href="<?php the_permalink();?>"><p class="post-title"><?php the_title();?></p></a>
									<a href="#"><p class="post-categoty">
										<?php 
										$post_categories = wp_get_post_categories( $post->ID );								
										$categories = '';	
										foreach($post_categories as $c){
											$cat = get_category( $c );									
											$categories = $categories.' '.$cat->name;
										}
										echo 'Posted in '.$categories;
										?></p></a>
                                    <?php $excerpt = get_the_excerpt();?>
									<p class="desc"><?php echo $excerpt; ?></p>
								</div>
							</div>
						</li>
                            <?php endwhile ?>
						<?php  wp_reset_postdata();?>
					</ul>
				  </div>
					<?php
         
		}
		
		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			return $instance;
		}
		
		function form($instance)
		{
			$title = isset($instance['title']) ? esc_attr($instance['title']) : "";			
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title',"tonika_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<?php
		}
	}
	
	function st_hybrid_widgets_blogposts() {			
		register_widget('st_hybrid_blogposts');			
	}
	add_action('widgets_init', 'st_hybrid_widgets_blogposts');
?>