<?php
	class st_hybrid_blogposts_noimage extends WP_Widget{
	
		function st_hybrid_blogposts_noimage() 
		{
			parent::WP_Widget(false, $name = 'Hybrid > BlogPosts-noImage');
		}
		
		function widget($args, $instance)
		{
			extract( $args );
			$title = apply_filters('widget_title', $instance['title']);		
			if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '<div class="span3">';// Display some text
			}
			
			global $post;				
			  ?>
			
					<ul class="blogPosts" id="no-img-blogposts">
					<?php
                            $args1 = array(
                                'post_type' => 'post',
                                'posts_per_page' => -1,
                            );
                            $the_query = new WP_Query($args1);
                            while ( $the_query->have_posts() ):
                                $the_query->the_post();
								
                        ?>
					 <li>
							<div id="blog-slider-container">								
								<div class="post-desc2">
									<div class="border-container">
										<div class="comment-size-box">
                                                <p class="comment-number">
                                                    <?php  echo get_comments_number(); ?>
                                                </p></div>
										<div class="triangle-box">
											<div class="triangle triangle-border"></div>
											<div class="triangle triangle-body"></div>
										</div>
									</div>
									<a href="<?php the_permalink();?>"><p class="post-title"><?php the_title();?></p></a>
									<a href="#"><p class="post-categoty">
										<?php 
										$post_categories = wp_get_post_categories( $post->ID );								
										$categories = '';	
										foreach($post_categories as $c){
											$cat = get_category( $c );									
											$categories = $categories.' '.$cat->name;
										}
										echo 'Posted in '.$categories;
										?></p></a>
                                    <?php $excerpt = get_the_excerpt();?>
									<p class="desc"><?php echo $excerpt; ?></p>
								</div>
							</div>
						</li>
                            <?php endwhile ?>
						<?php  wp_reset_postdata();?>
					</ul>
				  
					<?php        	
				if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '</div>';
					}	
		}
		
		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			return $instance;
		}
		
		function form($instance)
		{
			$title = isset($instance['title']) ? esc_attr($instance['title']) : "";			
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title',"hybrid_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<?php
		}
	}
	
	function st_hybrid_widgets_blogposts_noimage() {			
		register_widget('st_hybrid_blogposts_noimage');			
	}
	add_action('widgets_init', 'st_hybrid_widgets_blogposts_noimage');
?>