<?php

class st_facebook_widget extends WP_Widget {

    public function __construct() {

        parent::__construct(
            'pu_facebook_widget',       // Base ID
            'Hybrid > Facebook',        // Name
            array(
                'classname'     =>   'pu_facebook_widget',
                'description'   =>   __('A widget that displays a facebook like box from your facebook page.', 'framework')
            )
        );

    }

    public function widget( $args, $instance ) {
        extract( $args );

        /* Our variables from the widget settings. */
        $this->widget_title = apply_filters('widget_title', $instance['title'] );

        $this->facebook_id = $instance['app_id'];
        $this->facebook_username = $instance['page_name'];
        $this->facebook_width = $instance['width'];
        $this->facebook_show_faces = ($instance['show_faces'] == "1" ? "true" : "false");
        $this->facebook_stream = ($instance['show_stream'] == "1" ? "true" : "false");
        $this->facebook_header = ($instance['show_header'] == "1" ? "true" : "false");

        add_action('wp_footer', array(&$this,'add_js'));

        /* Display the widget title if one was input (before and after defined by themes). */
         echo $before_widget;
		if ( $this->widget_title )
            echo '<h3>'.$this->widget_title.'</h3>';
        /* Like Box */
        ?>
	 
        <div  id="" class="fb-like-box span12 widget" 
             data-href="http://www.facebook.com/<?php echo $this->facebook_username; ?>"
             data-width="<?php echo $this->facebook_width; ?>"
             data-show-faces="<?php echo $this->facebook_show_faces; ?>"
             data-stream="<?php echo $this->facebook_stream; ?>"
             data-header="<?php echo $this->facebook_header; ?>"
             data-show-border="false"
             data-height="200">
			 
			 </div>
			
		
    <?php
		 echo $after_widget;
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        /* Strip tags for title and name to remove HTML (important for text inputs). */
        $instance['title'] = strip_tags( $new_instance['title'] );
        $instance['app_id'] = strip_tags( $new_instance['app_id'] );
        $instance['page_name'] = strip_tags( $new_instance['page_name'] );
        $instance['width'] = strip_tags( $new_instance['width'] );

        $instance['show_faces'] = (bool)$new_instance['show_faces'];
        $instance['show_stream'] = (bool)$new_instance['show_stream'];
        $instance['show_header'] = (bool)$new_instance['show_header'];

        return $instance;
    }

    function form( $instance ) {

       /* Set up some default widget settings. */
        /*
		$defaults = array(
            'title' => widget_title,
            'app_id' => facebook_id,
            'page_name' => facebook_username,
            'width' => facebook_width,
            'show_faces' => facebook_show_faces,
            'show_stream' =>facebook_stream,
            'show_header' => facebook_header
        );
		*/
		//wp_parse_args( (array) $instance,$defaults); 
        $instance = wp_parse_args( (array) $instance); ?>

        <!-- Widget Title: Text Input -->
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'framework') ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" /></p>

        <!-- App id: Text Input -->
        <p><label for="<?php echo $this->get_field_id( 'app_id' ); ?>"><?php _e('App Id', 'framework') ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'app_id' ); ?>" name="<?php echo $this->get_field_name( 'app_id' ); ?>" value="<?php echo $instance['app_id']; ?>" /></p>

        <!-- Page name: Text Input -->
        <p><label for="<?php echo $this->get_field_id( 'page_name' ); ?>"><?php _e('Page name (http://www.facebook.com/[page_name])', 'framework') ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'page_name' ); ?>" name="<?php echo $this->get_field_name( 'page_name' ); ?>" value="<?php echo $instance['page_name']; ?>" /></p>

        <!-- Width: Text Input -->
        <p><label for="<?php echo $this->get_field_id( 'width' ); ?>"><?php _e('Width', 'framework') ?></label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id( 'width' ); ?>" name="<?php echo $this->get_field_name( 'width' ); ?>" value="<?php echo $instance['width']; ?>" /></p>

        <!-- Show Faces: Checkbox -->
        <p><label for="<?php echo $this->get_field_id( 'show_faces' ); ?>"><?php _e('Show Faces', 'framework') ?></label>
            <input type="checkbox" class="widefat" id="<?php echo $this->get_field_id( 'show_faces' ); ?>" name="<?php echo $this->get_field_name( 'show_faces' ); ?>" value="1" <?php echo ($instance['show_faces'] == "true" ? "checked='checked'" : ""); ?> /></p>

        <!-- Show Stream: Checkbox -->
        <p><label for="<?php echo $this->get_field_id( 'show_stream' ); ?>"><?php _e('Show Stream', 'framework') ?></label><input type="checkbox" class="widefat" id="<?php echo $this->get_field_id( 'show_stream' ); ?>" name="<?php echo $this->get_field_name( 'show_stream' ); ?>" value="1" <?php echo ($instance['show_stream'] == "true" ? "checked='checked'" : ""); ?> /></p>

        <!-- Show Header: Checkbox -->
        <p><label for="<?php echo $this->get_field_id( 'show_header' ); ?>"><?php _e('Show Header', 'framework') ?></label>
            <input type="checkbox" class="widefat" id="<?php echo $this->get_field_id( 'show_header' ); ?>" name="<?php echo $this->get_field_name( 'show_header' ); ?>" value="1" <?php echo ($instance['show_header'] == "true" ? "checked='checked'" : ""); ?> /></p>

    <?php
    }
    public function add_js() {
        echo '<div id="fb-root"></div>
        <script>(function(d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) return;
            js = d.createElement(s); js.id = id;
            js.src = "//connect.facebook.net/en_GB/all.js#xfbml=1&appId='.$this->facebook_id.'";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, \'script\', \'facebook-jssdk\'));</script>';
    }
}

function registerWidget_facebook() {
    register_widget('st_facebook_widget');
}
add_action('widgets_init', 'registerWidget_facebook');
?>