<?php
/*
Template Name: About
*/
?>
<?php get_header();?>
  <div class="content-wrapper">
    	<div class="container">
    		<div class="row-fluid">
    			<div class="span6">
    				<h3><?php the_field('introduction');?></h3>
    				<div id="introduction" class="about-intro">
					 <?php setup_postdata($post);?>
						<?php the_content();?>
					<?php wp_reset_postdata();?>    					
    				</div>
    			</div>

    			<div class="span6">
    				<!-- Controls -->
				  	<ul class="pg_paging_bp pull-right for-carousel">
						<li class="pg_previous_bp transition">
							<a href="#carousel-example-generic" data-slide="prev">
								<i class="icon-caret-left transition"></i>
							</a>
						</li>
						<li class="pg_next_bp transition">
							<a href="#carousel-example-generic" data-slide="next">
								<i class="icon-caret-right transition"></i>
							</a>
						</li>
					</ul>
					<h3><?php the_field('gallery_title'); ?></h3>
    				<div id="carousel-example-generic" class="carousel slide" style="clear:left;">
					  <!-- Indicators -->
					  <ol class="carousel-indicators">
					  <?php $gallery =  get_field('gallery_items'); ?>
					  <?php if($gallery): ?>
						<?php 	$counter = 0; ?>
						<?php foreach($gallery as $gallery_item):
								
								 if($counter==0)		
									echo '<li data-target="#carousel-example-generic" data-slide-to="'.$counter.'" class="active"></li>';
							     else
									echo '<li data-target="#carousel-example-generic" data-slide-to="'.$counter.'"></li>';
								   $counter++;
								   endforeach;
							endif;	
						   ?>
					  </ol>

					  <!-- Wrapper for slides -->
					  <div class="carousel-inner">
					  <?php $gallery =  get_field('gallery_items'); ?>
					  <?php if($gallery): ?>
					  <?php
							$counter = 0;
							foreach($gallery as $gallery_item):
							?>						
							<?php if($counter==0)		
									echo '<div class="item active">';
								  else
									echo '<div class="item">';
								   $counter++;
									?>
									<?php if($gallery_item['g_image']){
										$image = wp_get_attachment_image_src(  $gallery_item['g_image'], 'home2-featured' ); 
										echo '<img src="'.$image[0].'" alt=""/>';
										}
									?>
							</div>
						<?php endforeach ;
								endif;	
						?>						  
					  <!--<a class="left carousel-control" href="#carousel-example-generic" data-slide="prev">
					    <span class="icon-prev"></span>
					  </a>
					  <a class="right carousel-control" href="#carousel-example-generic" data-slide="next">
					    <span class="icon-next"></span>
					  </a>-->
					</div>
    			</div>
    		</div>
    		<div class="row-fluid">
    			<div class="span12">				
    				<h3><?php the_field('team_title');?></h3>
				<?php $teamMembers =  get_field('team'); ?>
					<?php if($teamMembers): ?>
						
    				<ul class="latestWorks">
						<?php foreach($teamMembers as $member):?>
						<li class="span3">							
								<div class="image-container">
									<a>
									<?php if($member['image'])	{								
											$image = wp_get_attachment_image_src( $member['image'], 'our-team' );
												echo '<img src="'.$image[0].'" alt="T 2"/>';
											}						
										  ?>									
									<div class="image-hover">
										<!--<p><i class="icon-play icon-large"></i></p>-->
									</div>		
									</a>
								</div>
								<div class="pull-right">
								 <?php $socialNetworks = $member['social_networks'];?>							
		                         <?php if($socialNetworks): ?>
									<?php foreach($socialNetworks as $network):?>
										<?php 											
											 echo '<a href="'.$network['url'].'" style="float:left;"> <div class="social-item transition" > <i class="'.$network['network'].'"> </i></div></a>';
										?>
										<?php
											endforeach;
										?>
								<?php endif;?>
								</div>
								<h4>
									<?php 
									if($member['link']!='') {
											echo '<a href="'.$member['link'].'">';
									}?>
									<?php echo $member['full_name'];?>
									<?php 
									if($member['link']!='') {
										echo '</a>';
									}?>
								</h4>
								<p class="post-categoty capitalize"><?php echo $member['position'];?></p>
						</li>		
					<?php endforeach;?>						
					</ul><!--latestWorks-->					 
			<?php endif;?>
    			</div>
    		</div>
    	</div><!--container-->
    </div><!--.content-wrapper-->
</div>
  
<?php get_footer();?>