<?php
add_action( 'init', 'register_posts' );
	function register_posts() {				
        register_post_type( 'work_post',
			array(
				'labels' => array(
					'name' => __( "Works","hybrid_lang"),
					'singular_name' => __( "Works" ,"hybrid_lang")
				),
				'public' => true,
				'has_archive' => true,			
				'rewrite' => array('slug' => "work_post", 'with_front' => TRUE),
				'supports' => array('title','editor','thumbnail','page-attributes')				
			)
		);

		register_taxonomy('works_category',array (
		  0 => 'work_post',
		),array( 'hierarchical' => true,
				 'label' => __('Works Category',"hybrid_lang"),
				 'show_ui' => true,
				 'query_var' => true,
				 'singular_label' => __('Work Category',"hybrid_lang")) );
		
		register_post_type( 'service_post',
			array(
				'labels' => array(
					'name' => __( "Services","hybrid_lang"),
					'singular_name' => __( "Services" ,"hybrid_lang")
				),
				'public' => true,
				'has_archive' => true,			
				'rewrite' => array('slug' => "service_post", 'with_front' => TRUE),
				'supports' => array('title','editor','thumbnail','page-attributes')					
			)
		);

		register_taxonomy('services_category',array (
		  0 => 'service_post',
		),array( 'hierarchical' => true, 
				 'label' => __('Services Category',"hybrid_lang"),
				 'show_ui' => true,
				 'query_var' => true,
				 'singular_label' => __('Service Category',"hybrid_lang")) );

        register_post_type( 'testmonials_post',
            array(
                'labels' => array(
                    'name' => __( "Testmonials","hybrid_lang"),
                    'singular_name' => __( "Testmonials" ,"hybrid_lang")
                ),
                'public' => true,
                'has_archive' => true,
                'rewrite' => array('slug' => "testmonials_post", 'with_front' => TRUE),
                'supports' => array('title','editor','page-attributes')
            )
        );

	}
?>