<?php
/*
Template Name: Contact
*/
?>

<?php 
	if ( $_SERVER['REQUEST_METHOD'] == 'POST' ) {
		if(!isset($hasError)) {
			$fname = trim($_POST['fname']);
			$email = trim($_POST['email']);
			$website = trim($_POST['website']);
			if(function_exists('stripslashes')) {
				$message = stripslashes(trim($_POST['message']))  . "\n\nIP: " . photo_get_the_ip();
			} else {
				$message = trim($_POST['message'])  . "\n\nIP: " . photo_get_the_ip();
			}

			$emailTo = get_option('photo_contactemail'); // please change this to your desire email address thru theme options
			$subject = "[" . get_bloginfo( 'name' ) . "]" . get_option('photo_subject');
			$body = "Name:" . $fname . "\n\nEmail:" . $email . "\n\nWebsite:" . $website . "\n\nComments:" . $message;
			$headers = "From: " . $fname . " <" . $email . ">\n";
			$headers .= "Content-Type: text/plain; charset=UTF-8\n";
        	$headers .= "Content-Transfer-Encoding: 8bit\n";
			
			wp_mail( $emailTo, $subject, $body, $headers );		
			$emailSent = true;
		}
	}

	get_header(); 
?>
	
	<div class="theme-content clear">

		<section class="title-header">
			<div class="breadcrumb-title">
				<?php
					photo_get_page_title();
					photo_breadcrumb();
				?>
			</div>
		</section>
		
		<section class="page-contents">

			<!--MAP-->
			<div id="map"></div>

			<div class="page-description">
				<?php
					if (have_posts()) : 
						while (have_posts()) : the_post(); 
							the_content(); 								
						endwhile; 
					endif;
				?>
			</div>
			<?php
				photo_contactus();
			?>
		</section>

		<section class="sidebar">
			<?php
				if($sidebar_choice == "Default") { get_sidebar('contact'); } else { photo_get_custom_sidebar(); }
			?>
		</section>
		
	</div>

<?php get_footer(); ?>