<?php get_header(); ?>
	
	<div class="theme-content clear">

		<section class="title-header">
			<div class="breadcrumb-title">
				<h2 class="ptitle">
					<?php
						$ptitle = "";
						$blog_pages = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'template-blog.php'));
						foreach($blog_pages as $page){
							$blog_page_id = $page->ID;
							$blog_page_url = get_permalink($blog_page_id);
							if(get_post_meta( $page->ID, "ptitle", true )!="") { $ptitle = get_post_meta( $page->ID, "ptitle", true ); } else { $ptitle = $page->post_title; }
						}
						echo $ptitle;
					?>
				</h2>
				<?php photo_breadcrumb(); ?>
			</div>
		</section>
		
		<section class="page-contents blog-page">			
			<?php 
				while (have_posts()) : the_post(); 	
					?>
					<div class="blog-list">
						<div class="btitle clear">
							<div class="author-avatar">
								<?php echo get_avatar( get_the_author_meta('user_email'), $size = '55'); ?>
							</div>
							<h2><?php the_title(); ?></h2>
							<label><?php the_time(get_option('date_format')); ?> / <?php the_category(', ') ?> / <a href="<?php the_permalink(); ?>#comments"><?php comments_number('No Comments', '1 Comment', '% Comments'); ?></a></label>
							<?php
								if ( ( function_exists( 'get_post_format' ) && 'image' == get_post_format( $post->ID ) )  ) {
									?><span><i class="fa fa-picture-o fa-lg"></i></span><?php		
								}elseif ( ( function_exists( 'get_post_format' ) && 'video' == get_post_format( $post->ID ) )  ) { 
									?><span><i class="fa fa-video-camera fa-lg"></i></span><?php	
								}elseif ( ( function_exists( 'get_post_format' ) && 'gallery' == get_post_format( $post->ID ) )  ) { 
									?><span><i class="fa fa-camera fa-lg"></i></span><?php	
								}
							?>
						</div>

						<?php
							if ( post_password_required() ) {
								?>
									<div class="password-protect-thumb"><i class="fa fa-lock fa-3x"></i></div>					
									<div class="blog-desc"><?php the_content(); ?></div>
								<?php								
							}else {
								?>
								<div class="bimage-single">
									<?php 
										$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'theme-large');

										if ( ( function_exists( 'get_post_format' ) && 'image' == get_post_format( $post->ID ) )  ) {
											if ( has_post_thumbnail() ) {
												the_post_thumbnail('theme-large');
											}
										}elseif ( ( function_exists( 'get_post_format' ) && 'video' == get_post_format( $post->ID ) )  ) { 
											if(get_post_meta( $post->ID, "video_host", true ) == "self") {
												?>
												<video id="videojs_blog" class="video-js vjs-default-skin" controls preload="none" width="650" height="433" poster="<?php echo $large_image_url[0]; ?>" data-setup="{}">
													<source src="<?php echo get_post_meta( $post->ID, "video", true ); ?>" type='video/mp4' />
												    <source src="<?php echo get_post_meta( $post->ID, "video", true ); ?>" type='video/webm' />
												    <source src="<?php echo get_post_meta( $post->ID, "video", true ); ?>" type='video/ogg' />
												</video>													
												<?php
											}else {
												?>
												<iframe width="650" height="433" src="<?php echo get_post_meta( $post->ID, "video", true ); ?>" frameborder="0" allowfullscreen class="sframe"></iframe>
												<?php
											}
										}elseif ( ( function_exists( 'get_post_format' ) && 'gallery' == get_post_format( $post->ID ) )  ) { 
											?>
											<div class="blog-flexslider">
												<ul class="slides">
													<?php
														$args = array( 'post_type' => 'attachment', 'orderby' => 'menu_order', 'numberposts' => -1, 'post_status' => null, 'post_parent' => $post->ID );

														$attachments = get_posts( $args );
														if ( $attachments ) {								
															foreach ( $attachments as $attachment ) {
																$attachment_id = $attachment->ID;
																$type = get_post_mime_type( $attachment->ID ); 

																switch ( $type ) {
																	case 'video/mp4':
																		?>
																		<li>
																			<video id="videojs_gallery" class="video-js vjs-default-skin" controls preload="none" width="650" height="433" poster="" data-setup="{}">
																				<source src="<?php echo wp_get_attachment_url( $attachment->ID ); ?>" type='video/mp4' />
																			</video>
																		</li>
																		<?php
																	break;
																	default:
																		?>
																		<li><?php echo wp_get_attachment_image( $attachment->ID, 'theme-large' ); ?></li>
																		<?php
																	break;
																}
															}
														}			
													?>
												</ul>
											</div> 
											<?php
										}
									?>
								</div>

								<div class="blog-desc"><?php the_content(); ?></div>
								<?php 
									wp_link_pages();
									
									if(get_option('photo_hide_tag')!="true") { ?><div class="blog-tags"><?php the_tags('','',''); ?></div><?php }

									social_share(); 

									if(get_option('photo_hide_author')!="true") {
										?>
											<!--AUTHOR-->
											<div class="author-block clear">
												<?php echo get_avatar( get_the_author_meta( 'ID' ), 80 ); ?>
												<h3><?php the_author_meta( 'user_firstname' ); echo "&nbsp;"; the_author_meta( 'user_lastname' ); ?></h3>
												<p><?php the_author_meta( 'user_description' ); ?></p>
											</div>
										<?php
									}

									comments_template();
							}
						?>
					</div>
					<?php
				endwhile;
			?>
		</section>

		<section class="sidebar">
			<?php
				if($sidebar_choice == "Default") { get_sidebar('blog'); } else { photo_get_custom_sidebar(); }
			?>
		</section>
		
	</div>

<?php get_footer(); ?>