<?php get_header(); ?>
	
	<div class="theme-content clear">

		<section class="title-header">
			<div class="breadcrumb-title">
				<h2 class="ptitle">
					<?php
						$ptitle = "";
						$blog_pages = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'template-portfolio.php'));
						foreach($blog_pages as $page){
							$blog_page_id = $page->ID;
							$blog_page_url = get_permalink($blog_page_id);
							if(get_post_meta( $page->ID, "ptitle", true )!="") { $ptitle = get_post_meta( $page->ID, "ptitle", true ); } else { $ptitle = $page->post_title; }
						}
						echo $ptitle;
					?>
				</h2>
				<?php photo_breadcrumb(); ?>
			</div>
		</section>
		
		<section class="page-contents blog-page">			
			<?php 
				while (have_posts()) : the_post(); 	
					$pattachment_order = get_option('photo_attachment_order');
					$pattachment_orderby = get_option('photo_attachment_orderby');
					
					if(get_option('photo_portfolio_thumb_slider')!="true") {
						$args = array( 'post_type' => 'attachment', 'numberposts' => -1, 'order' => $pattachment_order, 'orderby' => $pattachment_orderby, 'post_status' => null, 'post_parent' => $post->ID );
					}else {
						$thumb_id = get_post_thumbnail_id( get_the_ID() );
						$args = array( 'post_type' => 'attachment', 'numberposts' => -1, 'order' => $pattachment_order, 'orderby' => $pattachment_orderby, 'post_status' => null, 'post_parent' => $post->ID, 'exclude' => $thumb_id );
					}					
					$attachments = get_posts( $args );	

					?>
					<div class="blog-list">
						<div class="btitle clear">
							<h2><?php the_title(); ?></h2>
							<label><?php echo get_the_term_list( $post->ID, 'portfolio_categories', ' ', ', ', '' ); ?></label>
						</div>

						<?php
							if ( post_password_required() ) {
								?>
									<div class="password-protect-thumb"><i class="fa fa-lock fa-3x"></i></div>
									<div class="portfolio-desc"><?php the_content(); ?></div>
								<?php
							}else {
								?>
								<div class="bimage-single single-portfolio">
									<div class="portfolio-flexslider">
										<ul class="slides">
											<?php
												if ( get_post_meta( $post->ID, "video", true ) ) {
													?>
														<li><iframe width="650" height="430" src="<?php echo get_post_meta( $post->ID, "video", true ); ?>" frameborder="0" allowfullscreen></iframe></li>
													<?php
												}else {
													if ( $attachments ) {								
														foreach ( $attachments as $attachment ) {
															$attachment_id = $attachment->ID;
															$type = get_post_mime_type( $attachment->ID ); 
															$large_image_url = wp_get_attachment_image_src( $attachment_id, 'full' ); 

															switch ( $type ) {
																case 'video/mp4':
																	?>
																	<li>
																		<video id="videojs_gallery" class="video-js vjs-default-skin" controls preload="none" width="650" height="360" poster="" data-setup="{}">
																			<source src="<?php echo wp_get_attachment_url( $attachment->ID ); ?>" type='video/mp4' />
																		</video>
																	</li>
																	<?php
																break;
																default:
																	?>
																	<li>
																		<a href="<?php echo $large_image_url[0]; ?>" rel="gallery" title="<?php _e( 'View Fullscreen', CODEEX_THEME_NAME ); ?>">
																			<?php echo wp_get_attachment_image( $attachment->ID, 'theme-large' ); ?>
																		</a>
																	</li>
																	<?php
																break;
															}
														}
													}	
												}					
											?>
										</ul>
									</div>
								</div>

								<div class="portfolio-links">
									<?php global $portfolio_page_url; ?>
									<a href="<?php echo $portfolio_page_url; ?>" class="back-port">
										<?php if(get_option('photo_portfolio_back')!="") { echo get_option('photo_portfolio_back'); } else { _e( 'Back to Portfolio', CODEEX_THEME_NAME ); } ?>
									</a>	
									<span class="or"><?php _e( 'or', CODEEX_THEME_NAME ); ?></span>
									<a href="<?php echo get_post_meta($post->ID, "url", true); ?>" target="_blank" class="view-more">
										<?php if(get_option('photo_vsite')!="") { echo get_option('photo_vsite'); } else { _e( 'View Website', CODEEX_THEME_NAME ); } ?>
									</a>
								</div>
								
								<div class="portfolio-desc"><?php the_content(); ?></div>

								<?php social_share(); ?>
								<div class="post-link clear">
									<span class="prev"><?php previous_post_link('%link'); ?></span>
									<span class="next"><?php next_post_link('%link'); ?></span>
								</div>	
								<?php
							}
						?>
					</div>
					<?php
				endwhile;
			?>
		</section>

		<section class="sidebar">
			<?php
				if($sidebar_choice == "Default") { get_sidebar('portfolio'); } else { photo_get_custom_sidebar(); }
			?>
		</section>
		
	</div>

<?php get_footer(); ?>