<div id="post-<?php the_ID(); ?>" <?php post_class('blog-list'); ?>>
	<div class="btitle clear">
		<div class="author-avatar">
			<?php echo get_avatar( get_the_author_meta('user_email'), $size = '55'); ?>
		</div>
		<h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		<label><?php the_time(get_option('date_format')); ?> / <?php the_category(', ') ?> / <a href="<?php the_permalink(); ?>#comments"><?php comments_number('No Comments', '1 Comment', '% Comments'); ?></a></label>
		<?php
			if ( ( function_exists( 'get_post_format' ) && 'image' == get_post_format( $post->ID ) )  ) {
				?><span><i class="fa fa-picture-o fa-lg"></i></span><?php		
			}elseif ( ( function_exists( 'get_post_format' ) && 'video' == get_post_format( $post->ID ) )  ) { 
				?><span><i class="fa fa-video-camera fa-lg"></i></span><?php	
			}elseif ( ( function_exists( 'get_post_format' ) && 'gallery' == get_post_format( $post->ID ) )  ) { 
				?><span><i class="fa fa-camera fa-lg"></i></span><?php	
			}
		?>
	</div>
	<div class="bimage">
		<a href="<?php the_permalink(); ?>">
			<?php 
				if ( post_password_required() ) {
					?>
					<div class="password-protect-thumb"><i class="fa fa-lock fa-3x"></i></div>
					<?php
				}else {
					if ( has_post_thumbnail() ) { the_post_thumbnail('theme-large'); } 
				}
			?>
		</a>
		<div class="blog-mask">	
			<a href="<?php the_permalink(); ?>"><i class="fa fa-link fa-lg"></i></a>
		</div>
	</div>
	<div class="blog-desc">
		<?php 
			if(get_option('photo_hide_excerpt')!="true") {
				the_excerpt(); 
			}			
		?>
		<a href="<?php the_permalink(); ?>" class="read-more">
			<?php if(get_option('photo_read_more')!="") { echo get_option('photo_read_more'); } else { _e( 'Read More', CODEEX_THEME_NAME ); } ?><i class="fa fa-caret-right"></i>
		</a>
	</div>
</div>