<?php
	/**********************************************
	CUSTOM TESTIMONIALS WIDGET
	***********************************************/
	
	class photo_Widget_Testimonials extends WP_Widget {
	
		function photo_Widget_Testimonials() {		
			$widget_ops = array('classname' => 'widget-testimonials', 'description' => __('Custom widget for testimonials', CODEEX_THEME_NAME));	
			$this -> WP_Widget('Testimonials', __('Photo: Testimonials', CODEEX_THEME_NAME), $widget_ops);		
		}
	
		function widget($args, $instance) {		
			extract($args);		
			$title = apply_filters('widget_title', $instance['title']);		
			if (empty($title)) $title = false;
				$instance_testi_limit = array();
				
				$testi_limit = 'testi_limit';
				$instance_testi_limit = isset($instance[$testi_limit]) ? $instance[$testi_limit] : '';
							
				echo ''.$before_widget.'';					
				if ($title) {						
					echo $before_title;
			 		echo $title;
			 		echo $after_title.'';						
			 	}

					global $post;
			 		$args = array( 'post_type' => 'testimonials', 'posts_per_page' => $instance_testi_limit );		
					$wp_query = new WP_Query( $args );						
					?>
						<div class="testi-flexslider">
							<ul class="slides">
								<?php
									while ($wp_query->have_posts()) : $wp_query->the_post(); 
										?>
											<li>
												<div class="circle-thumb">
													<?php if ( has_post_thumbnail() ) { the_post_thumbnail('testi-thumb'); } ?>
													<span>&nbsp;</span>
												</div>
												<?php the_content(); ?>
												<h5><?php the_title(); ?></h5>
												<span><?php echo get_post_meta($post->ID, "position", true); ?></span>
											</li>
										<?php
									endwhile;	
								?>
							</ul>
						</div>
					<?php
					wp_reset_query();


					echo $after_widget.'';				
				}
			
				function update($new_instance, $old_instance) {				
					$instance = $old_instance;				
					$instance['title'] = strip_tags($new_instance['title']);
					$instance['testi_limit'] = $new_instance['testi_limit'];				
					return $instance;				
				}
			
				function form($instance) {				
					$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
					$instance_testi_limit = array();							
					
					$testi_limit = 'testi_limit';
					$instance_testi_limit = isset($instance[$testi_limit]) ? $instance[$testi_limit] : '';					
					
				?>
					<p><label for="<?php echo $this -> get_field_id('title'); ?>"><?php _e('Title:', CODEEX_THEME_NAME); ?></label>
					<input class="widefat" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>					
					<div>			
						<div>
							<p><label for="<?php echo $this -> get_field_id($testi_limit); ?>"><?php _e('Number of Testimonials:', CODEEX_THEME_NAME); ?></label>
							<input class="widefat" type="text" id="<?php echo $this -> get_field_id($testi_limit); ?>" name="<?php echo $this -> get_field_name($testi_limit); ?>" value="<?php echo $instance_testi_limit; ?>">
							</p>
							<div>	
								<small><i><?php _e( 'Testimonials will automatically display...', CODEEX_THEME_NAME ); ?></i></small>	
							</div>														
						</div>			
					</div>
		<?php
				}			
		}

		function photo_widget_testimonials() {			
			register_widget('photo_Widget_Testimonials');			
		}
		add_action('widgets_init', 'photo_widget_testimonials');
?>