<?php
	/**********************************************
	CUSTOM LATEST WORK WIDGET
	***********************************************/
	
	class photo_Widget_Latest_Work extends WP_Widget {
	
		function photo_Widget_Latest_Work() {		
			$widget_ops = array('classname' => 'widget-latest-work', 'description' => __('Custom widget for portfolio latest work', CODEEX_THEME_NAME));	
			$this -> WP_Widget('LatestWork', __('Photo: Latest Work', CODEEX_THEME_NAME), $widget_ops);		
		}
	
		function widget($args, $instance) {		
			extract($args);		
			$title = apply_filters('widget_title', $instance['title']);		
			if (empty($title)) $title = false;
							
				echo ''.$before_widget.'';					
				if ($title) {						
					echo $before_title;
			 		echo $title;
			 		echo $after_title.'';						
			 	}


			 		global $post;
			 		$args = array( 'post_type' => 'portfolio', 'posts_per_page' => 1 );		
					$wp_query = new WP_Query( $args );						
					?>
						<ul class="clear">
							<?php
								while ($wp_query->have_posts()) : $wp_query->the_post(); 
									?>
									<li>
										<a href="<?php the_permalink(); ?>">
											<?php 
												if ( post_password_required() ) {
													?>
													<div class="password-protect-thumb"><i class="fa fa-lock fa-3x"></i></div>
													<?php
												}else {
													if ( has_post_thumbnail() ) { the_post_thumbnail('widget-medium'); } 
												}												
											?>
										</a>	
										<div class="hover-mask"><a href="<?php the_permalink(); ?>"><i class="fa fa-link fa-lg"></i></a></div>
										<h4><?php the_title(); ?></h4>
									</li>
									<?php
								endwhile;	
							?>
						</ul>
					<?php
					wp_reset_query();


					echo $after_widget.'';				
				}
			
				function update($new_instance, $old_instance) {				
					$instance = $old_instance;				
					$instance['title'] = strip_tags($new_instance['title']);
					return $instance;				
				}
			
				function form($instance) {				
					$title = isset($instance['title']) ? esc_attr($instance['title']) : '';						
				?>
					<p><label for="<?php echo $this -> get_field_id('title'); ?>"><?php _e('Title:', CODEEX_THEME_NAME); ?></label>
					<input class="widefat" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>
					<div>	
						<small><i><?php _e( 'Portfolio latest work will automatically display...', CODEEX_THEME_NAME ); ?></i></small>	
					</div>
		<?php
				}			
		}

		function photo_widget_latest_work() {			
			register_widget('photo_Widget_Latest_Work');			
		}
		add_action('widgets_init', 'photo_widget_latest_work');
?>