<?php
	/**********************************************
	CUSTOM POST TYPE: SERVICES
	***********************************************/	
	
	add_action( 'init', 'photo_services_post_type' );
	function photo_services_post_type() {

		if(get_option('photo_services_cpt')!="") { $services_name = get_option('photo_services_cpt'); } else { $services_name = "Services"; }
		if(get_option('photo_services_cpt_slug')!="") { $services_slug = get_option('photo_services_cpt_slug'); } else { $services_slug = "services-item"; }
		if(get_option('photo_services_add')!="") { $services_add = get_option('photo_services_add'); } else { $services_add = "Add New Services"; }
		if(get_option('photo_services_edit')!="") { $services_edit = get_option('photo_services_edit'); } else { $services_edit = "Edit Services"; }

		register_post_type( 'services',
			array(
				'labels' => array(
					'name' => $services_name,
					'singular_name' => $services_name,
					'add_new_item' => $services_add,
					'edit_item' => $services_edit,
				),
				'public' => true,
				'has_archive' => true,	
				'exclude_from_search' => true,
				'rewrite' => array('slug' => $services_slug, 'with_front' => TRUE),
				'supports' => array('title','editor', 'author', 'page-attributes', 'thumbnail'),
				'menu_icon' => get_template_directory_uri() . '/includes/posts/img/services.png'					
			)
		);
	}	


	/*META*/
	function photo_services_meta() {
		global $post;

		$icon = get_post_meta($post->ID, 'icon', TRUE);
		$bgimage = get_post_meta($post->ID, 'bgimage', TRUE);

		?>
			<div class="mabuc-form-wrap">
				<table>
					<tr>
						<td style="width:10%;"><label for="icon"><?php _e( 'Icon', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input id="icon" name="icon" type="text" value="<?php echo $icon; ?>" /><br>
							<span class="desc"><?php _e( 'Select your services icon below, just copy class name (ex: fa-adjust)', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td>
							<ul class="the-icons">	
								<li><span><i class="fa fa-rub"></i> fa-rub</span></li>
								<li><span><i class="fa fa-ruble"></i> fa-ruble</span></li>
								<li><span><i class="fa fa-rouble"></i> fa-rouble</span></li>
								<li><span><i class="fa fa-pagelines"></i> fa-pagelines</span></li>
								<li><span><i class="fa fa-caret-square-o-left"></i> fa-caret-square-o-left</span></li>
								<li><span><i class="fa fa-toggle-left"></i> fa-toggle-left</span></li>
								<li><span><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</span></li>
								<li><span><i class="fa fa-wheelchair"></i> fa-wheelchair</span></li>
								<li><span><i class="fa fa-vimeo-square"></i> fa-vimeo-square</span></li>
								<li><span><i class="fa fa-try"></i> fa-try</span></li>
								<li><span><i class="fa fa-turkish-lira"></i> fa-turkish-lira</span></li>
								<li><span><i class="fa fa-adjust"></i> fa-adjust</span></li>
								<li><span><i class="fa fa-anchor"></i> fa-anchor</span></li>
								<li><span><i class="fa fa-asterisk"></i> fa-asterisk</span></li>
								<li><span><i class="fa fa-ban"></i> fa-ban</span></li>
								<li><span><i class="fa fa-bar-chart-o"></i> fa-bar-chart-o</span></li>
								<li><span><i class="fa fa-barcode"></i> fa-barcode</span></li>
								<li><span><i class="fa fa-beer"></i> fa-beer</span></li>
								<li><span><i class="fa fa-bell"></i> fa-bell</span></li>
								<li><span><i class="fa fa-bell-o"></i> fa-bell-o</span></li>
								<li><span><i class="fa fa-bell"></i> fa-bell</span></li>
								<li><span><i class="fa fa-bolt"></i> fa-bolt</span></li>
								<li><span><i class="fa fa-book"></i> fa-book</span></li>
								<li><span><i class="fa fa-bookmark-o"></i> fa-bookmark-o</span></li>
								<li><span><i class="fa fa-bookmark"></i> fa-bookmark</span></li>
								<li><span><i class="fa fa-briefcase"></i> fa-briefcase</span></li>
								<li><span><i class="fa fa-bullhorn"></i> fa-bullhorn</span></li>
								<li><span><i class="fa fa-bullseye"></i> fa-bullseye</span></li>
								<li><span><i class="fa fa-calendar-o"></i> fa-calendar-o</span></li>
								<li><span><i class="fa fa-calendar"></i> fa-calendar</span></li>
								<li><span><i class="fa fa-camera-retro"></i> fa-camera-retro</span></li>
								<li><span><i class="fa fa-camera"></i> fa-camera</span></li>
								<li><span><i class="fa fa-certificate"></i> fa-certificate</span></li>
								<li><span><i class="fa fa-check"></i> fa-check</span></li>
								<li><span><i class="fa fa-check-circle"></i> fa-check-circle</span></li>
								<li><span><i class="fa fa-check-circle-o"></i> fa-check-circle-o</span></li>
								<li><span><i class="fa fa-check-square"></i> fa-check-square</span></li>
								<li><span><i class="fa fa-check-square-o"></i> fa-check-square-o</span></li>								
								<li><span><i class="fa fa-circle-o"></i> fa-circle-o</span></li>
								<li><span><i class="fa fa-circle"></i> fa-circle</span></li>
								<li><span><i class="fa fa-cloud-download"></i> fa-cloud-download</span></li>
								<li><span><i class="fa fa-cloud-upload"></i> fa-cloud-upload</span></li>
								<li><span><i class="fa fa-cloud"></i> fa-cloud</span></li>
								<li><span><i class="fa fa-code-fork"></i> fa-code-fork</span></li>
								<li><span><i class="fa fa-code"></i> fa-code</span></li>
								<li><span><i class="fa fa-coffee"></i> fa-coffee</span></li>
								<li><span><i class="fa fa-cog"></i> fa-cog</span></li>
								<li><span><i class="fa fa-cogs"></i> fa-cogs</span></li>
								<li><span><i class="fa fa-collapse-o"></i> fa-collapse-o</span></li>
								<li><span><i class="fa fa-comment-o"></i> fa-comment-o</span></li>
								<li><span><i class="fa fa-comment"></i> fa-comment</span></li>
								<li><span><i class="fa fa-comments-o"></i> fa-comments-o</span></li>
								<li><span><i class="fa fa-comments"></i> fa-comments</span></li>
								<li><span><i class="fa fa-credit-card"></i> fa-credit-card</span></li>
								<li><span><i class="fa fa-crop"></i> fa-crop</span></li>
								<li><span><i class="fa fa-dashboard"></i> fa-dashboard</span></li>
								<li><span><i class="fa fa-desktop"></i> fa-desktop</span></li>
								<li><span><i class="fa fa-download"></i> fa-download</span></li>
								<li><span><i class="fa fa-edit"></i> fa-edit</span></li>
								<li><span><i class="fa fa-ellipsis-horizontal"></i> fa-ellipsis-horizontal</span></li>
								<li><span><i class="fa fa-ellipsis-vertical"></i> fa-ellipsis-vertical</span></li>
								<li><span><i class="fa fa-envelope-o"></i> fa-envelope-o</span></li>
								<li><span><i class="fa fa-envelope"></i> fa-envelope</span></li>
								<li><span><i class="fa fa-exchange"></i> fa-exchange</span></li>
								<li><span><i class="fa fa-exclamation"></i> fa-exclamation</span></li>
								<li><span><i class="fa fa-exclamation-circle"></i> fa-exclamation-circle</span></li>
								<li><span><i class="fa fa-exclamation-triangle"></i> fa-exclamation-triangle</span></li>
								<li><span><i class="fa fa-expand-o"></i> fa-expand-o</span></li>
								<li><span><i class="fa fa-external-link-square"></i> fa-external-link-square</span></li>
								<li><span><i class="fa fa-external-link"></i> fa-external-link</span></li>
								<li><span><i class="fa fa-eye"></i> fa-eye</span></li>
								<li><span><i class="fa fa-eye-slash"></i> fa-eye-slash</span></li>
								<li><span><i class="fa fa-video-camera"></i> fa-video-camera</span></li>
								<li><span><i class="fa fa-fighter-jet"></i> fa-fighter-jet</span></li>
								<li><span><i class="fa fa-film"></i> fa-film</span></li>
								<li><span><i class="fa fa-filter"></i> fa-filter</span></li>
								<li><span><i class="fa fa-fire-extinguisher"></i> fa-fire-extinguisher</span></li>
								<li><span><i class="fa fa-fire"></i> fa-fire</span></li>
								<li><span><i class="fa fa-flag-o"></i> fa-flag-o</span></li>
								<li><span><i class="fa fa-flag-checkered"></i> fa-flag-checkered</span></li>
								<li><span><i class="fa fa-flag"></i> fa-flag</span></li>
								<li><span><i class="fa fa-folder"></i> fa-folder</span></li>
								<li><span><i class="fa fa-folder-o"></i> fa-folder-o</span></li>
								<li><span><i class="fa fa-folder-open-o"></i> fa-folder-open-o</span></li>
								<li><span><i class="fa fa-folder-open"></i> fa-folder-open</span></li>
								<li><span><i class="fa fa-frown-o"></i> fa-frown-o</span></li>
								<li><span><i class="fa fa-gamepad"></i> fa-gamepad</span></li>
								<li><span><i class="fa fa-gift"></i> fa-gift</span></li>
								<li><span><i class="fa fa-glass"></i> fa-glass</span></li>
								<li><span><i class="fa fa-globe"></i> fa-globe</span></li>
								<li><span><i class="fa fa-group"></i> fa-group</span></li>
								<li><span><i class="fa fa-hdd-o"></i> fa-hdd-o</span></li>
								<li><span><i class="fa fa-headphones"></i> fa-headphones</span></li>
								<li><span><i class="fa fa-heart-o"></i> fa-heart-o</span></li>
								<li><span><i class="fa fa-heart"></i> fa-heart</span></li>
								<li><span><i class="fa fa-home"></i> fa-home</span></li>
								<li><span><i class="fa fa-inbox"></i> fa-inbox</span></li>
								<li><span><i class="fa fa-info-circle"></i> fa-info-circle</span></li>
								<li><span><i class="fa fa-info"></i> fa-info</span></li>
								<li><span><i class="fa fa-key"></i> fa-key</span></li>
								<li><span><i class="fa fa-keyboard-o"></i> fa-keyboard-o</span></li>
								<li><span><i class="fa fa-laptop"></i> fa-laptop</span></li>
								<li><span><i class="fa fa-leaf"></i> fa-leaf</span></li>
								<li><span><i class="fa fa-legal"></i> fa-legal</span></li>
								<li><span><i class="fa fa-lemon-o"></i> fa-lemon-o</span></li>
								<li><span><i class="fa fa-level-down"></i> fa-level-down</span></li>
								<li><span><i class="fa fa-level-up"></i> fa-level-up</span></li>
								<li><span><i class="fa fa-lightbulb-o"></i> fa-lightbulb-o</span></li>
								<li><span><i class="fa fa-location-arrow"></i> fa-location-arrow</span></li>
								<li><span><i class="fa fa-lock"></i> fa-lock</span></li>
								<li><span><i class="fa fa-magic"></i> fa-magic</span></li>
								<li><span><i class="fa fa-magnet"></i> fa-magnet</span></li>
								<li><span><i class="fa fa-mail-forward"></i> fa-mail-forward</span></li>
								<li><span><i class="fa fa-mail-reply"></i> fa-mail-reply</span></li>
								<li><span><i class="fa fa-mail-reply-all"></i> fa-mail-reply-all</span></li>
								<li><span><i class="fa fa-map-marker"></i> fa-map-marker</span></li>
								<li><span><i class="fa fa-meh-o"></i> fa-meh-o</span></li>
								<li><span><i class="fa fa-microphone-slash"></i> fa-microphone-slash</span></li>
								<li><span><i class="fa fa-microphone"></i> fa-microphone</span></li>
								<li><span><i class="fa fa-minus"></i> fa-minus</span></li>
								<li><span><i class="fa fa-minus-circle"></i> fa-minus-circle</span></li>
								<li><span><i class="fa fa-minus-square"></i> fa-minus-square</span></li>
								<li><span><i class="fa fa-minus-square-o"></i> fa-minus-square-o</span></li>								
								<li><span><i class="fa fa-mobile-phone"></i> fa-mobile-phone</span></li>
								<li><span><i class="fa fa-money"></i> fa-money</span></li>
								<li><span><i class="fa fa-move"></i> fa-move</span></li>
								<li><span><i class="fa fa-music"></i> fa-music</span></li>
								<li><span><i class="fa fa-power-off"></i> fa-power-off</span></li>
								<li><span><i class="fa fa-pencil"></i> fa-pencil</span></li>
								<li><span><i class="fa fa-phone-square"></i> fa-phone-square</span></li>
								<li><span><i class="fa fa-phone"></i> fa-phone</span></li>
								<li><span><i class="fa fa-picture-o"></i> fa-picture-o</span></li>
								<li><span><i class="fa fa-plane"></i> fa-plane</span></li>
								<li><span><i class="fa fa-plus"></i> fa-plus</span></li>
								<li><span><i class="fa fa-plus-circle"></i> fa-plus-circle</span></li>
								<li><span><i class="fa fa-plus-square"></i> fa-plus-square</span></li>								
								<li><span><i class="fa fa-print"></i> fa-print</span></li>
								<li><span><i class="fa fa-puzzle-piece"></i> fa-puzzle-piece</span></li>
								<li><span><i class="fa fa-qrcode"></i> fa-qrcode</span></li>
								<li><span><i class="fa fa-question-circle"></i> fa-question-circle</span></li>
								<li><span><i class="fa fa-question"></i> fa-question</span></li>
								<li><span><i class="fa fa-quote-left"></i> fa-quote-left</span></li>
								<li><span><i class="fa fa-quote-right"></i> fa-quote-right</span></li>
								<li><span><i class="fa fa-random"></i> fa-random</span></li>
								<li><span><i class="fa fa-refresh"></i> fa-refresh</span></li>
								<li><span><i class="fa fa-reorder"></i> fa-reorder</span></li>
								<li><span><i class="fa fa-reply-all"></i> fa-reply-all</span></li>
								<li><span><i class="fa fa-reply"></i> fa-reply</span></li>
								<li><span><i class="fa fa-resize-horizontal"></i> fa-resize-horizontal</span></li>
								<li><span><i class="fa fa-resize-vertical"></i> fa-resize-vertical</span></li>
								<li><span><i class="fa fa-retweet"></i> fa-retweet</span></li>
								<li><span><i class="fa fa-road"></i> fa-road</span></li>
								<li><span><i class="fa fa-rocket"></i> fa-rocket</span></li>
								<li><span><i class="fa fa-rotate-left"></i> fa-rotate-left</span></li>
								<li><span><i class="fa fa-rotate-right"></i> fa-rotate-right</span></li>
								<li><span><i class="fa fa-rss-square"></i> fa-rss-square</span></li>
								<li><span><i class="fa fa-rss"></i> fa-rss</span></li>
								<li><span><i class="fa fa-search"></i> fa-search</span></li>
								<li><span><i class="fa fa-share-square-o"></i> fa-share-square-o</span></li>
								<li><span><i class="fa fa-share-square"></i> fa-share-square</span></li>
								<li><span><i class="fa fa-share"></i> fa-share</span></li>
								<li><span><i class="fa fa-shield"></i> fa-shield</span></li>
								<li><span><i class="fa fa-shopping-cart"></i> fa-shopping-cart</span></li>
								<li><span><i class="fa fa-signal"></i> fa-signal</span></li>
								<li><span><i class="fa fa-sign-in"></i> fa-sign-in</span></li>
								<li><span><i class="fa fa-sign-out"></i> fa-sign-out</span></li>
								<li><span><i class="fa fa-sitemap"></i> fa-sitemap</span></li>
								<li><span><i class="fa fa-smile-o"></i> fa-smile-o</span></li>
								<li><span><i class="fa fa-sort-down"></i> fa-sort-down</span></li>
								<li><span><i class="fa fa-sort-up"></i> fa-sort-up</span></li>
								<li><span><i class="fa fa-sort"></i> fa-sort</span></li>
								<li><span><i class="fa fa-spinner"></i> fa-spinner</span></li>
								<li><span><i class="fa fa-star-o"></i> fa-star-o</span></li>
								<li><span><i class="fa fa-star-half-full"></i> fa-star-half-full</span></li>
								<li><span><i class="fa fa-star-half-empty"></i> fa-star-half-empty</span></li>
								<li><span><i class="fa fa-star-half"></i> fa-star-half</span></li>
								<li><span><i class="fa fa-star"></i> fa-star</span></li>
								<li><span><i class="fa fa-tablet"></i> fa-tablet</span></li>
								<li><span><i class="fa fa-tag"></i> fa-tag</span></li>
								<li><span><i class="fa fa-tags"></i> fa-tags</span></li>
								<li><span><i class="fa fa-tasks"></i> fa-tasks</span></li>
								<li><span><i class="fa fa-terminal"></i> fa-terminal</span></li>
								<li><span><i class="fa fa-thumbs-down"></i> fa-thumbs-down</span></li>
								<li><span><i class="fa fa-thumbs-up"></i> fa-thumbs-up</span></li>
								<li><span><i class="fa fa-ticket"></i> fa-ticket</span></li>
								<li><span><i class="fa fa-times"></i> fa-times</span></li>
								<li><span><i class="fa fa-times-circle"></i> fa-times-circle</span></li>
								<li><span><i class="fa fa-times-circle-o"></i> fa-times-circle-o</span></li>
								<li><span><i class="fa fa-tint"></i> fa-tint</span></li>
								<li><span><i class="fa fa-trash-o"></i> fa-trash-o</span></li>
								<li><span><i class="fa fa-trophy"></i> fa-trophy</span></li>
								<li><span><i class="fa fa-truck"></i> fa-truck</span></li>
								<li><span><i class="fa fa-umbrella"></i> fa-umbrella</span></li>
								<li><span><i class="fa fa-unlock-o"></i> fa-unlock-o</span></li>
								<li><span><i class="fa fa-unlock"></i> fa-unlock</span></li>
								<li><span><i class="fa fa-upload"></i> fa-upload</span></li>
								<li><span><i class="fa fa-user-md"></i> fa-user-md</span></li>
								<li><span><i class="fa fa-user"></i> fa-user</span></li>
								<li><span><i class="fa fa-volume-down"></i> fa-volume-down</span></li>
								<li><span><i class="fa fa-volume-off"></i> fa-volume-off</span></li>
								<li><span><i class="fa fa-volume-up"></i> fa-volume-up</span></li>
								<li><span><i class="fa fa-warning"></i> fa-warning</span></li>
								<li><span><i class="fa fa-wrench"></i> fa-wrench</span></li>
								<li><span><i class="fa fa-file"></i> fa-file</span></li>
								<li><span><i class="fa fa-file-o"></i> fa-file-o</span></li>
								<li><span><i class="fa fa-cut"></i> fa-cut</span></li>
								<li><span><i class="fa fa-copy"></i> fa-copy</span></li>
								<li><span><i class="fa fa-paste"></i> fa-paste</span></li>
								<li><span><i class="fa fa-save"></i> fa-save</span></li>
								<li><span><i class="fa fa-undo"></i> fa-undo</span></li>
								<li><span><i class="fa fa-repeat"></i> fa-repeat</span></li>
								<li><span><i class="fa fa-text-height"></i> fa-text-height</span></li>
								<li><span><i class="fa fa-text-width"></i> fa-text-width</span></li>
								<li><span><i class="fa fa-align-left"></i> fa-align-left</span></li>
								<li><span><i class="fa fa-align-center"></i> fa-align-center</span></li>
								<li><span><i class="fa fa-align-right"></i> fa-align-right</span></li>
								<li><span><i class="fa fa-align-justify"></i> fa-align-justify</span></li>
								<li><span><i class="fa fa-indent"></i> fa-indent</span></li>
								<li><span><i class="fa fa-font"></i> fa-font</span></li>
								<li><span><i class="fa fa-bold"></i> fa-bold</span></li>
								<li><span><i class="fa fa-italic"></i> fa-italic</span></li>
								<li><span><i class="fa fa-strikethrough"></i> fa-strikethrough</span></li>
								<li><span><i class="fa fa-underline"></i> fa-underline</span></li>
								<li><span><i class="fa fa-superscript"></i> fa-superscript</span></li>
								<li><span><i class="fa fa-subscript"></i> fa-subscript</span></li>
								<li><span><i class="fa fa-link"></i> fa-link</span></li>
								<li><span><i class="fa fa-unlink"></i> fa-unlink</span></li>
								<li><span><i class="fa fa-paperclip"></i> fa-paperclip</span></li>
								<li><span><i class="fa fa-eraser"></i> fa-eraser</span></li>
								<li><span><i class="fa fa-columns"></i> fa-columns</span></li>
								<li><span><i class="fa fa-table"></i> fa-table</span></li>
								<li><span><i class="fa fa-th-large"></i> fa-th-large</span></li>
								<li><span><i class="fa fa-th"></i> fa-th</span></li>
								<li><span><i class="fa fa-th-list"></i> fa-th-list</span></li>
								<li><span><i class="fa fa-list"></i> fa-list</span></li>
								<li><span><i class="fa fa-list-ol"></i> fa-list-ol</span></li>
								<li><span><i class="fa fa-list-ul"></i> fa-list-ul</span></li>
								<li><span><i class="fa fa-list-alt"></i> fa-list-alt</span></li>
								<li><span><i class="fa fa-angle-left"></i> fa-angle-left</span></li>
								<li><span><i class="fa fa-angle-right"></i> fa-angle-right</span></li>
								<li><span><i class="fa fa-angle-up"></i> fa-angle-up</span></li>
								<li><span><i class="fa fa-angle-down"></i> fa-angle-down</span></li>
								<li><span><i class="fa fa-arrow-down"></i> fa-arrow-down</span></li>
								<li><span><i class="fa fa-arrow-left"></i> fa-arrow-left</span></li>
								<li><span><i class="fa fa-arrow-right"></i> fa-arrow-right</span></li>
								<li><span><i class="fa fa-arrow-up"></i> fa-arrow-up</span></li>
								<li><span><i class="fa fa-caret-down"></i> fa-caret-down</span></li>
								<li><span><i class="fa fa-caret-left"></i> fa-caret-left</span></li>
								<li><span><i class="fa fa-caret-right"></i> fa-caret-right</span></li>
								<li><span><i class="fa fa-caret-up"></i> fa-caret-up</span></li>
								<li><span><i class="fa fa-chevron-circle-down"></i> fa-chevron-circle-down</span></li>
								<li><span><i class="fa fa-chevron-circle-left"></i> fa-chevron-circle-left</span></li>
								<li><span><i class="fa fa-chevron-circle-right"></i> fa-chevron-circle-right</span></li>
								<li><span><i class="fa fa-chevron-circle-up"></i> fa-chevron-circle-up</span></li>
								<li><span><i class="fa fa-chevron-down"></i> fa-chevron-down</span></li>
								<li><span><i class="fa fa-chevron-left"></i> fa-chevron-left</span></li>
								<li><span><i class="fa fa-chevron-right"></i> fa-chevron-right</span></li>
								<li><span><i class="fa fa-chevron-up"></i> fa-chevron-up</span></li>
								<li><span><i class="fa fa-arrow-circle-down"></i> fa-arrow-circle-down</span></li>
								<li><span><i class="fa fa-arrow-circle-left"></i> fa-arrow-circle-left</span></li>
								<li><span><i class="fa fa-arrow-circle-o-down"></i> fa-arrow-circle-o-down</span></li>
								<li><span><i class="fa fa-arrow-circle-o-left"></i> fa-arrow-circle-o-left</span></li>
								<li><span><i class="fa fa-arrow-circle-o-right"></i> fa-arrow-circle-o-right</span></li>
								<li><span><i class="fa fa-arrow-circle-o-up"></i> fa-arrow-circle-o-up</span></li>								
								<li><span><i class="fa fa-arrow-circle-right"></i> fa-arrow-circle-right</span></li>
								<li><span><i class="fa fa-arrow-circle-up"></i> fa-arrow-circle-up</span></li>
								<li><span><i class="fa fa-angle-double-down"></i> fa-angle-double-down</span></li>
								<li><span><i class="fa fa-angle-double-left"></i> fa-angle-double-left</span></li>
								<li><span><i class="fa fa-angle-double-right"></i> fa-angle-double-right</span></li>
								<li><span><i class="fa fa-angle-double-up"></i>fa-angle-double-up</span></li>
								<li><span><i class="fa fa-angle-down"></i>fa-angle-down</span></li>
								<li><span><i class="fa fa-hand-o-down"></i> fa-hand-o-down</span></li>
								<li><span><i class="fa fa-hand-o-left"></i> fa-hand-o-left</span></li>
								<li><span><i class="fa fa-hand-o-right"></i> fa-hand-o-right</span></li>
								<li><span><i class="fa fa-hand-o-up"></i> fa-hand-o-up</span></li>
								<li><span><i class="fa fa-play-circle"></i> fa-play-circle</span></li>
								<li><span><i class="fa fa-play"></i> fa-play</span></li>
								<li><span><i class="fa fa-pause"></i> fa-pause</span></li>
								<li><span><i class="fa fa-stop"></i> fa-stop</span></li>
								<li><span><i class="fa fa-eject"></i> fa-eject</span></li>
								<li><span><i class="fa fa-backward"></i> fa-backward</span></li>
								<li><span><i class="fa fa-forward"></i> fa-forward</span></li>
								<li><span><i class="fa fa-fast-backward"></i> fa-fast-backward</span></li>
								<li><span><i class="fa fa-fast-forward"></i> fa-fast-forward</span></li>
								<li><span><i class="fa fa-step-backward"></i> fa-step-backward</span></li>
								<li><span><i class="fa fa-step-forward"></i> fa-step-forward</span></li>
								<li><span><i class="fa fa-fullscreen"></i> fa-fullscreen</span></li>
								<li><span><i class="fa fa-resize-full"></i> fa-resize-full</span></li>
								<li><span><i class="fa fa-resize-small"></i> fa-resize-small</span></li>
								<li><span><i class="fa fa-css3"></i> fa-css3</span></li>
								<li><span><i class="fa fa-facebook"></i> fa-facebook</span></li>
								<li><span><i class="fa fa-facebook-square"></i> fa-facebook-square</span></li>
								<li><span><i class="fa fa-twitter"></i> fa-twitter</span></li>
								<li><span><i class="fa fa-twitter-square"></i> fa-twitter-square</span></li>
								<li><span><i class="fa fa-github"></i> fa-github</span></li>
								<li><span><i class="fa fa-github-square"></i> fa-github-square</span></li>
								<li><span><i class="fa fa-github-alt"></i> fa-github-alt</span></li>
								<li><span><i class="fa fa-html5"></i> fa-html5</span></li>
								<li><span><i class="fa fa-linkedin"></i> fa-linkedin</span></li>
								<li><span><i class="fa fa-linkedin-square"></i> fa-linkedin-square</span></li>
								<li><span><i class="fa fa-maxcdn"></i> fa-maxcdn</span></li>
								<li><span><i class="fa fa-pinterest"></i> fa-pinterest</span></li>
								<li><span><i class="fa fa-pinterest-square"></i> fa-pinterest-square</span></li>
								<li><span><i class="fa fa-google-plus"></i> fa-google-plus</span></li>
								<li><span><i class="fa fa-google-plus-square"></i> fa-google-plus-square</span></li>
								<li><span><i class="fa fa-ambulance"></i> fa-ambulance</span></li>
								<li><span><i class="fa fa-h-square"></i> fa-h-sign</span></li>
								<li><span><i class="fa fa-hospital"></i> fa-hospital</span></li>
								<li><span><i class="fa fa-medkit"></i> fa-medkit</span></li>
								<li><span><i class="fa fa-stethoscope"></i> fa-stethoscope</span></li>
								<li><span><i class="fa fa-user-md"></i> fa-user-md</span></li>					
								<li><span><i class="fa fa-compass"></i> fa-compass</span></li>					
								<li><span><i class="fa fa-eur"></i> fa-eur</span></li>			
								<li><span><i class="fa fa-euro"></i> fa-euro</span></li>			
								<li><span><i class="fa fa-gbp"></i> fa-gbp</span></li>			
								<li><span><i class="fa fa-usd"></i> fa-usd</span></li>			
								<li><span><i class="fa fa-usd"></i> fa-usd</span></li>
								<li><span><i class="fa fa-dollar"></i> fa-dollar</span></li>		
								<li><span><i class="fa fa-inr"></i> fa-inr</span></li>		
								<li><span><i class="fa fa-rupee"></i> fa-rupee</span></li>		
								<li><span><i class="fa fa-jpy"></i> fa-jpy</span></li>	
								<li><span><i class="fa fa-yen"></i> fa-yen</span></li>	
								<li><span><i class="fa fa-cny"></i> fa-cny</span></li>	
								<li><span><i class="fa fa-krw"></i> fa-krw</span></li>	
								<li><span><i class="fa fa-won"></i> fa-won</span></li>	
								<li><span><i class="fa fa-btc"></i> fa-btc</span></li>	
								<li><span><i class="fa fa-bitcoin"></i> fa-bitcoin</span></li>	
								<li><span><i class="fa fa-file-text"></i> fa-file-text</span></li>	
								<li><span><i class="fa fa-sort"></i> fa-sort</span></li>	
								<li><span><i class="fa fa-sort-alpha-asc"></i> fa-sort-alpha-asc</span></li>	
								<li><span><i class="fa fa-sort-alpha-desc"></i> fa-sort-alpha-desc</span></li>
								<li><span><i class="fa fa-sort-amount-asc"></i> fa-sort-amount-asc</span></li>	
								<li><span><i class="fa fa-sort-amount-desc"></i> fa-sort-amount-desc</span></li>					
								<li><span><i class="fa fa-sort-asc"></i> fa-sort-asc</span></li>	
								<li><span><i class="fa fa-sort-desc"></i> fa-sort-desc</span></li>	
								<li><span><i class="fa fa-sort-numeric-asc"></i> fa-sort-numeric-asc</span></li>	
								<li><span><i class="fa fa-sort-numeric-desc"></i> fa-sort-numeric-desc</span></li>	
								<li><span><i class="fa fa-thumbs-up"></i> fa-thumbs-up</span></li>					
								<li><span><i class="fa fa-thumbs-down"></i> fa-thumbs-down</span></li>					
								<li><span><i class="fa fa-youtube"></i> fa-youtube</span></li>					
								<li><span><i class="fa fa-youtube-play"></i> fa-youtube-play</span></li>
								<li><span><i class="fa fa-youtube-square"></i> fa-youtube-square</span></li>		
								<li><span><i class="fa fa-xing"></i> fa-xing</span></li>					
								<li><span><i class="fa fa-xing-square"></i> fa-xing-square</span></li>					
								<li><span><i class="fa fa-dropbox"></i> fa-dropbox</span></li>					
								<li><span><i class="fa fa-stack-exchange"></i> fa-stack-exchange</span></li>					
								<li><span><i class="fa fa-instagram"></i> fa-instagram</span></li>					
								<li><span><i class="fa fa-flickr"></i> fa-flickr</span></li>					
								<li><span><i class="fa fa-adn"></i> fa-adn</span></li>					
								<li><span><i class="fa fa-bitbucket"></i> fa-bitbucket</span></li>					
								<li><span><i class="fa fa-bitbucket-square"></i> fa-bitbucket-square</span></li>					
								<li><span><i class="fa fa-tumblr"></i> fa-tumblr</span></li>					
								<li><span><i class="fa fa-tumblr-square"></i> fa-tumblr-square</span></li>					
								<li><span><i class="fa fa-long-arrow-down"></i> fa-long-arrow-down</span></li>					
								<li><span><i class="fa fa-long-arrow-up"></i> fa-long-arrow-up</span></li>					
								<li><span><i class="fa fa-long-arrow-left"></i> fa-long-arrow-left</span></li>					
								<li><span><i class="fa fa-long-arrow-right"></i> fa-long-arrow-right</span></li>					
								<li><span><i class="fa fa-apple"></i> fa-apple</span></li>					
								<li><span><i class="fa fa-windows"></i> fa-windows</span></li>					
								<li><span><i class="fa fa-android"></i> fa-android</span></li>					
								<li><span><i class="fa fa-linux"></i> fa-linux</span></li>					
								<li><span><i class="fa fa-dribbble"></i> fa-dribbble</span></li>					
								<li><span><i class="fa fa-skype"></i> fa-skype</span></li>					
								<li><span><i class="fa fa-foursquare"></i> fa-foursquare</span></li>					
								<li><span><i class="fa fa-trello"></i> fa-trello</span></li>					
								<li><span><i class="fa fa-female"></i> fa-female</span></li>					
								<li><span><i class="fa fa-male"></i> fa-male</span></li>					
								<li><span><i class="fa fa-gittip"></i> fa-gittip</span></li>					
								<li><span><i class="fa fa-sun-o"></i> fa-sun-o</span></li>					
								<li><span><i class="fa fa-moon-o"></i> fa-moon-o</span></li>					
								<li><span><i class="fa fa-archive"></i> fa-archive</span></li>					
								<li><span><i class="fa fa-bug"></i> fa-bug</span></li>					
								<li><span><i class="fa fa-vk"></i> fa-vk</span></li>					
								<li><span><i class="fa fa-weibo"></i> fa-weibo</span></li>					
								<li><span><i class="fa fa-renren"></i> fa-renren</span></li>					
							</ul>
						</td>
					</tr>
					<tr>
						<td><label for="bgimage"><?php _e( 'Background', CODEEX_THEME_NAME ); ?></label></td>
						<td>	
							<input name="bgimage" type="text" id="bgimage" value="<?php echo $bgimage; ?>" /> <input id="upload_image_button_photo_bgimage" type="button" value="Upload" class="button-secondary" /><br>
							<span class="desc"><?php _e( 'Add your background image here', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
				</table>
			</div>	
		<?php
	}


	/*CUSTOM COLUMNS*/
	add_filter( 'manage_edit-services_columns', 'photo_edit_services_columns' ) ;
	function photo_edit_services_columns( $columns ) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __( 'Title', CODEEX_THEME_NAME ),		
			'author' => __( 'Author', CODEEX_THEME_NAME ),
			'date' => __( 'Date', CODEEX_THEME_NAME )
		);
		return $columns;
	}


	/**********************************************
	SAVE & UPDATE CUSTOM FIELDS
	***********************************************/
	
	add_action( 'add_meta_boxes', 'photo_custom_posts_services' );
	function photo_custom_posts_services(){
		add_meta_box("photo_services_meta", "Services Options", "photo_services_meta", "services", "normal", "low");	
	}	
	
	add_action('save_post', 'photo_custom_posts_save_services');
	function photo_custom_posts_save_services( $post_id ){
		
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || (defined('DOING_AJAX') && DOING_AJAX)) return;
		if ( 'page' == isset($_POST['post_type']) ) { if ( !current_user_can( 'edit_page', $post_id ) ) return;
		} else { if ( !current_user_can( 'edit_post', $post_id ) ) return; }
		
		update_post_meta($post_id, "icon", @$_POST["icon"]);
		update_post_meta($post_id, "bgimage", @$_POST["bgimage"]);
	}	
?>