<?php
	/********************
	PORTFOLIO FULLWIDTH
	********************/

	function photo_portfolio_list() {
		global $post;
		?>
			<!--PORTFOLIO-->
			<div id="ib-main-wrapper" class="portfolio-block ib-main-wrapper">
				<ul id="da-thumbs" class="ib-main clear da-thumbs">
					<?php
						$album_order = get_option('photo_album_order');
						$album_orderby = get_option('photo_album_orderby');
						$album_limit = get_option('photo_num_portfolio');

						$args = array( 'post_type' => 'portfolio', 'orderby' => $album_orderby, 'order' => $album_order, 'posts_per_page' => $album_limit );

						$wp_query = new WP_Query( $args );	
						while ($wp_query->have_posts()) : $wp_query->the_post(); 
							get_template_part( 'loop', 'portfolio' );
						endwhile;	
					?>
				</ul>
			</div>
		<?php	
	}


	/********************
	PORTFOLIO MASONRY
	********************/

	function photo_portfolio_list_masonry() {
		global $post;
		?>
			<!--PORTFOLIO-->
			<div class="portfolio-block masonry">
				<ul id="da-thumbs" class="clear da-thumbs">
					<?php
						$album_order = get_option('photo_album_order');
						$album_orderby = get_option('photo_album_orderby');
						$album_limit = get_option('photo_num_portfolio');

						$args = array( 'post_type' => 'portfolio', 'orderby' => $album_orderby, 'order' => $album_order, 'posts_per_page' => $album_limit );

						$wp_query = new WP_Query( $args );	
						while ($wp_query->have_posts()) : $wp_query->the_post(); 
							get_template_part( 'loop', 'masonry' );
						endwhile;	
					?>
				</ul>
			</div>
		<?php	
	}

	
	/******************
	PORTFOLIO + SLIDER
	******************/

	function photo_portfolio_slider() {
		global $post;
		if(get_option('photo_portfolio_hide_slider')!="true") {
			?>
				<!--PORTFOLIO-->
				<section class="portfolio-slide-block">
					<div class="home-portfolio-flexslider">
						<ul class="slides"> 
							<?php
								$album_order = get_option('photo_album_order');
								$album_orderby = get_option('photo_album_orderby');
								$album_limit = get_option('photo_num_hportfolio');

								$args = array( 'post_type' => 'portfolio', 'orderby' => $album_orderby, 'order' => $album_order, 'posts_per_page' => $album_limit, 'meta_query' => array( array( 'key' => 'featured', 'value' => 'on', 'compare' => '==' ) ) );		
								$wp_query = new WP_Query( $args );	
								while ($wp_query->have_posts()) : $wp_query->the_post(); 
									?>
										<li id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
											<div class="bg-overlay">&nbsp;</div>
											<div class="slide-image"><?php if ( has_post_thumbnail() ) { the_post_thumbnail('full'); } ?></div>
											<div class="portfolio-slide-desc">
												<h2><?php the_title(); ?></h2>
												<h3><?php echo get_post_meta($post->ID, "subtitle", true); ?></h3>
												<div class="portfolio-links">
													<a href="<?php echo get_post_meta($post->ID, "url", true); ?>" class="view-site" target="_blank">
														<?php if(get_option('photo_view_site')!="") { echo get_option('photo_view_site'); } else { _e( 'View Site', CODEEX_THEME_NAME ); } ?>
													</a>	
													<span class="or"><?php _e( 'or', CODEEX_THEME_NAME ); ?></span>
													<a href="<?php the_permalink(); ?>" class="view-more">
														<?php if(get_option('photo_view_more')!="") { echo get_option('photo_view_more'); } else { _e( 'View More', CODEEX_THEME_NAME ); } ?>
													</a>
												</div>												
											</div>
										</li>
									<?php
								endwhile;
							?>
						</ul>	
					</div>	
				</section>
			<?php
		}		
	}


	/***************
	SERVICES
	***************/

	function photo_services_list() {
		global $post;
		?>
			<!--SERVICES-->
			<section class="services-block">
				<?php
					$services_order = get_option('photo_services_order');
					$services_orderby = get_option('photo_services_orderby');

					$args = array( 'post_type' => 'services', 'orderby' => $services_orderby, 'order' => $services_order );		
					$wp_query = new WP_Query( $args );	
					while ($wp_query->have_posts()) : $wp_query->the_post(); 
						?>
						<div id="post-<?php the_ID(); ?>" <?php post_class('services-list clear'); ?>>
							<span class="sicon"><i class="fa <?php echo get_post_meta( $post->ID, "icon", true ); ?> fa-3x"></i></span>
							<div class="services-desc">
								<h5><?php the_title(); ?></h5>
								<?php the_content(); ?>
							</div>
						</div>
						<?php
					endwhile;
				?>
			</section>
		<?php
	}


	/***************
	SKILLS
	***************/

	function photo_skills_list() {
		global $post;
		if(get_option('photo_skills_hide')!="true") {
			?>
				<!--OUR SKILLS-->
				<div class="skills-block clear">
					<h3><?php if(get_option('photo_skills_header')!="") { echo get_option('photo_skills_header'); } else { _e( 'Our Skills', CODEEX_THEME_NAME ); } ?></h3>
					<?php
						$skills_order = get_option('photo_skills_order');
						$skills_orderby = get_option('photo_skills_orderby');
						$skills_limit = get_option('photo_num_skills');

						$args = array( 'post_type' => 'skills', 'orderby' => $skills_orderby, 'order' => $skills_order, 'posts_per_page' => $skills_limit );		
						$wp_query = new WP_Query( $args );	
						for($i = 1; $wp_query->have_posts(); $i++) { 
							$bar = "";
							if(get_option('photo_chart_style')=="Bar") { $bar = "skills-bar"; }

							$wp_query->the_post();			
							$columns = 4;	
							$class = 'skills-list ' . $bar. ' clear ';
							$class .= ($i % $columns == 0) ? 'last' : '';
							?>
							<div id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
								<?php
									if(get_option('photo_chart_style')=="Bar") {
										?>
											<div class="meter nostripes">
												<span style="width:<?php echo get_post_meta( $post->ID, "percent", true ); ?>%"></span>
											</div>
										<?php
									}else {
										?>
											<span class="chart" data-percent="<?php echo get_post_meta( $post->ID, "percent", true ); ?>">
												<span class="percent"></span>
											</span>
										<?php
									}
								?>	
								<h4>
									<?php 
										the_title(); 
										if(get_option('photo_chart_style')=="Bar") { 
											?><span><?php echo get_post_meta( $post->ID, "percent", true ); _e( '%', CODEEX_THEME_NAME ); ?></span><?php 
										} 
									?>
								</h4>
							</div>
							<?php
						};	
					?>
				</div>
			<?php
		}
	}


	/***************
	OUR TEAM
	***************/

	function photo_team_list() {
		global $post;
		if(get_option('photo_team_hide')!="true") {
			?>
				<!--OUR TEAM-->
				<div class="team-block clear">
					<h3><?php if(get_option('photo_team_header')!="") { echo get_option('photo_team_header'); } else { _e( 'Our Team Members', CODEEX_THEME_NAME ); } ?></h3>
					<?php
						$team_order = get_option('photo_team_order');
						$team_orderby = get_option('photo_team_orderby');
						$team_limit = get_option('photo_num_members');

						$args = array( 'post_type' => 'ourteam', 'orderby' => $team_orderby, 'order' => $team_order, 'posts_per_page' => $team_limit );		
						$wp_query = new WP_Query( $args );	
						for($i = 1; $wp_query->have_posts(); $i++) { 							
							$wp_query->the_post();			
							$columns = 2;	
							$class = 'team-list clear ';
							$class .= ($i % $columns == 0) ? 'last' : '';
							?>
							<div id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
								<?php 
									if(get_option('photo_thumb_style')=="Circle") {
										?>
											<div class="circle-thumb">
												<?php if ( has_post_thumbnail() ) { the_post_thumbnail('member-thumb'); } ?>
												<span>&nbsp;</span>
											</div>
										<?php 
									}else {
										if ( has_post_thumbnail() ) { the_post_thumbnail('member-medium'); } 
									}
									
								?>
								<div class="team-desc">
									<h4><?php the_title(); ?></h4>
									<h5><?php echo get_post_meta( $post->ID, "position", true ); ?></h5>
									<?php 
										the_excerpt();
										if(get_option('photo_team_social_hide')!="true") {
											?>
											<div class="team-social">
												<?php
													if(get_post_meta( $post->ID, "facebook", true )) {
														?>
														<a href="http://facebook.com/<?php echo get_post_meta( $post->ID, "facebook", true ); ?>" title="" target="_blank">
															<?php _e( 'Facebook', CODEEX_THEME_NAME ); ?>
														</a>
														<?php
													}
													if(get_post_meta( $post->ID, "twitter", true )) {
														?>
														<a href="http://twitter.com/<?php echo get_post_meta( $post->ID, "twitter", true ); ?>" title="" target="_blank">
															<?php _e( 'Twitter', CODEEX_THEME_NAME ); ?>
														</a>
														<?php
													}
													if(get_post_meta( $post->ID, "dribbble", true )) {
														?>
														<a href="http://dribbble.com/<?php echo get_post_meta( $post->ID, "dribbble", true ); ?>" title="" target="_blank">
															<?php _e( 'Dribbble', CODEEX_THEME_NAME ); ?>
														</a>
														<?php
													}
													if(get_post_meta( $post->ID, "flickr", true )) {
														?>
														<a href="<?php echo get_post_meta( $post->ID, "flickr", true ); ?>" title="" target="_blank">
															<?php _e( 'Flickr', CODEEX_THEME_NAME ); ?>
														</a>
														<?php
													}
												?>
											</div>
											<?php
										}
									?>
								</div>
							</div>
							<?php
						};	
					?>
				</div>
			<?php
		}
	}


	/***************
	CONTACT US
	***************/

	function photo_contactus() {
		global $post, $emailSent;
		?>
		<!--FORM-->
		<div class="contact-form">
			<h3><?php if(get_option('photo_form_header')!="") { echo get_option('photo_form_header'); } else { _e( 'Send a message', CODEEX_THEME_NAME ); }?></h3>
			<?php
				if(isset($emailSent) && $emailSent == true) { 
					?><label class="sent"><?php echo get_option('photo_email_sent_message'); ?></label><?php 
				} 
			?>	
			<div id="respond">
				<form id="cform" action="<?php the_permalink(); ?>" method="post">
					<ul class="clear"> 
						<li><input type="text" name="fname" id="fname" tabindex="1" class="required" placeholder="Name" /></li>
						<li><input type="text" name="email" id="email" tabindex="2" class="required email" placeholder="Email Address" /></li>
						<li class="last"><input type="text" name="website" id="website" tabindex="3" placeholder="Website" /></li>
						<li class="msg"><textarea name="message" rows="0" cols="0" id="message" tabindex="4" class="required" placeholder="Message"></textarea></li>        
					 </ul>
					 <p class="form-submit"><input type="submit" value="<?php if(get_option('photo_contact_button_value')!="") { echo get_option('photo_contact_button_value'); } else { echo "Send Message"; } ?>" id="submit" name="btsend"></p>
				</form> 
			</div>
		</div>			
		<?php
	}


	/***************
	SHARE ICONS
	***************/

	function social_share() {
		if(get_option('photo_hide_share')!="true") {
			?>
				<!--SHARE-->
				<div class="share clear">
					<span><?php _e( 'Share', CODEEX_THEME_NAME ); ?><i class="fa fa-share fa-lg"></i></span>
					<ul class="clear">	
						<li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink();?>&amp;title=<?php the_title(); ?>" target="_blank"><i class="fa fa-facebook fa-lg"></i></a></li>
						<li><a href="http://twitter.com/share?url=<?php the_permalink();?>&amp;title=<?php the_title(); ?>" target="_blank"><i class="fa fa-twitter fa-lg"></i></a></li>
						<li><a href="https://plus.google.com/share?url=<?php the_permalink();?>&amp;title=<?php the_title(); ?>" target="_blank"><i class="fa fa-google-plus fa-lg"></i></a></li>
						<li><a href="javascript:void((function()%7Bvar%20e=document.createElement('script');e.setAttribute('type','text/javascript');e.setAttribute('charset','UTF-8');e.setAttribute('src','http://assets.pinterest.com/js/pinmarklet.js?r='+Math.random()*99999999);document.body.appendChild(e)%7D)());" target="_blank"><i class="fa fa-pinterest fa-lg"></i></a></li>
						<li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php the_permalink();?>&amp;title=<?php the_title(); ?>" target="_blank"><i class="fa fa-linkedin fa-lg"></i></a></li>
					</ul>
				</div>
			<?php
		}
	}
?>