<?php
	/**********************************************
	POSTS CUSTOM FIELDS
	***********************************************/

	function photo_post_menu() {
		global $post;

		$video = get_post_meta($post->ID, 'video', TRUE);
		$bgimage = get_post_meta($post->ID, 'bgimage', TRUE);		

		$custom = get_post_custom($post->ID);
		$selected = isset( $custom['video_host'] ) ? esc_attr( $custom['video_host'][0] ) : ''; 

		?>
			<div class="mabuc-form-wrap">
				<table>
					<tr>
						<td style="width:10%;"><label for="video_host"><?php _e( 'Video Host', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<select name="video_host" type="text" id="video_host">
								<option value="youtube" <?php selected( $selected, 'youtube' ); ?>>Youtube</option>
								<option value="vimeo" <?php selected( $selected, 'vimeo' ); ?>>Vimeo</option>
								<option value="self" <?php selected( $selected, 'self' ); ?>>Self Hosted</option>
							</select> <span class="desc"><?php _e( 'Select your video host here either YouTube, Vimeo or Self Hosted', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="video"><?php _e( 'Video', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="video" type="text" id="video" value="<?php echo $video; ?>" /> <input id="upload_image_button_photo_svideo" type="button" value="Upload" class="button-secondary" /><br>
							<span class="desc"><?php _e( 'Add your video embedded code here (ex. http://player.vimeo.com/video/21942776 and http://youtube.com/embed/68AqHwgk2s8) or just click upload for self hosted video', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="bgimage"><?php _e( 'Background', CODEEX_THEME_NAME ); ?></label></td>
						<td>	
							<input name="bgimage" type="text" id="bgimage" value="<?php echo $bgimage; ?>" /> <input id="upload_image_button_photo_bgimage" type="button" value="Upload" class="button-secondary" /><br>
							<span class="desc"><?php _e( 'Add your background image here', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
				</table>						
			</div>	
		<?php
	}		
	

	/**********************************************
	PAGE CUSTOM FIELDS
	***********************************************/

	function photo_page_menu() {
		global $post;

		$ptitle = get_post_meta($post->ID, 'ptitle', TRUE);
		$bgimage = get_post_meta($post->ID, 'bgimage', TRUE);			

		?>
			<div class="mabuc-form-wrap">
				<table>
					<tr>
						<td style="width:10%;"><label for="ptitle"><?php _e( 'Page Title', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="ptitle" type="text" id="ptitle" value="<?php echo $ptitle; ?>" /><br>
							<span class="desc"><?php _e( 'Add your page title here if you want another title header', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="bgimage"><?php _e( 'Background', CODEEX_THEME_NAME ); ?></label></td>
						<td>	
							<input name="bgimage" type="text" id="bgimage" value="<?php echo $bgimage; ?>" /> <input id="upload_image_button_photo_bgimage" type="button" value="Upload" class="button-secondary" /><br>
							<span class="desc"><?php _e( 'Add your background image here', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>			
				</table>											
			</div>	
		<?php
	}	


	/**********************************************
	ADD AND SAVE CUSTOM FIELDS
	***********************************************/

	add_action( 'add_meta_boxes', 'photo_custom_fields_box' );
	function photo_custom_fields_box(){
		add_meta_box("photo_post_menu", "Post Options", "photo_post_menu", "post", "normal", "low");							
		add_meta_box("photo_page_menu", "Page Options", "photo_page_menu", "page", "normal", "low");							
	}	
	
	add_action('save_post', 'photo_custom_fields_save');
	function photo_custom_fields_save( $post_id ){
		
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || (defined('DOING_AJAX') && DOING_AJAX)) return;
		if ( 'page' == isset($_POST['post_type']) ) { if ( !current_user_can( 'edit_page', $post_id ) ) return;
		} else { if ( !current_user_can( 'edit_post', $post_id ) ) return; }

		update_post_meta($post_id, "ptitle", @$_POST["ptitle"]); 
		update_post_meta($post_id, "bgimage", @$_POST["bgimage"]); 	 
		update_post_meta($post_id, "video", @$_POST["video"]);		  
		update_post_meta($post_id, "video_host", @$_POST["video_host"]);		  
	}	
?>