<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta name="keywords" content="<?php echo get_option('photo_meta_keywords'); ?>" />   
<meta name="description" content="<?php echo get_option('photo_meta_descriptions'); ?>" /> 
<?php
	if(get_option('photo_site_layout') != "true") {
		?><meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" /><?php
	}
?>
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<?php
	if(get_option('photo_favicon') == ""){
		?><link rel="shortcut icon" href="http://themecss.com/img/favicon.ico" /><?php
	}else {
		?><link rel="shortcut icon" href="<?php echo get_option('photo_favicon'); ?>" /><?php
	}
?>

<title><?php bloginfo('name'); ?> | <?php is_front_page() ? bloginfo('description') : wp_title(''); ?></title>
<?php wp_head(); ?>
</head>

<!--[if lt IE 9]>
<script src="//html5shim.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->

<body <?php $class=''; body_class( $class ); ?>>
	
	<!--CONTAINER-->
	<div id="container" class="clear">

		<section class="header-footer <?php if(get_option('photo_sidebar_sticky')=="true") { echo "un-sticky-header"; } ?>">
			<header class="clear">
				<!--LOGO-->		
				<aside class="logo">
					<h1>
						<a href="<?php echo home_url(); ?>">
							<?php 
								if(get_option('photo_logo') == "") {
									?><img src="<?php echo get_template_directory_uri(); ?>/img/logo.png" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?>" /><?php
								}else {
									?><img src="<?php echo get_option('photo_logo'); ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?>" /><?php
								}
							?>
						</a>
					</h1>
				</aside>

				<!--MENU-->
				<nav>
					<?php
						wp_nav_menu( array( 'theme_location' => 'primary-menu', 'fallback_cb' => 'photo_menu_fallback', 'container_class' => 'menu clear', 'container_id' => 'dropdown', 'menu_id' => 'main-menu', 'menu_class' => 'sf-menu' ) );
					?>
				</nav>	
				<select class="select-menu"></select>	
			</header>


			<!--HEADER WIDGET-->
			<div class="header-widget">
				<?php get_sidebar( 'header' ); ?>
			</div>


			<!--FOOTER-->
			<footer>	
				<label class="copyright">
					<?php
						if(get_option('photo_footertext')!="") {
							echo get_option('photo_footertext');
						}else {
							_e( 'Copyright &copy; ', CODEEX_THEME_NAME ); echo date('Y'); echo "&nbsp;"; bloginfo('name');			
						}
					?>
				</label>			
			</footer>
		</section>


		<!--CUSTOM SIDEBAR-->
		<?php
			global $options, $sidebar_choice;
			
			@$options = get_post_custom(get_the_ID());
			if(isset($options['custom_sidebar'])) {
				$sidebar_choice = $options['custom_sidebar'][0];
			}

			photo_portfolio_link();
			photo_blog_link();
		?>