<?php
	include get_template_directory() . '/includes/mabuc-panel/main.php';
	include get_template_directory() . '/includes/lib/custom-posts.php';
	include get_template_directory() . '/includes/lib/custom-fields.php';
	include get_template_directory() . '/includes/lib/custom-widgets.php';
	include get_template_directory() . '/includes/lib/custom-functions.php';
	include get_template_directory() . '/includes/lib/tgm/activation.php';


	/**********************************************
	REGISTER STYLES AND SCRIPTS
	***********************************************/

	function photo_script_styles_reg () {
		wp_register_style( 'style', get_stylesheet_directory_uri() . '/style.css' );	
		wp_register_style( 'responsive', get_stylesheet_directory_uri() . '/responsive.css' );	
		wp_register_style( 'roboto', 'http://fonts.googleapis.com/css?family=Roboto:400,100italic,100,300,300italic,400italic,500,500italic,700,900,700italic,900italic&subset=latin,cyrillic-ext,greek-ext,greek,vietnamese,latin-ext,cyrillic' );		
		wp_register_style( 'bitter', 'http://fonts.googleapis.com/css?family=Bitter:400,700,400italic&subset=latin,latin-ext' );		
		wp_register_style('font-awesome', get_template_directory_uri() . '/includes/font-awesome/css/font-awesome.min.css');
		wp_register_script( 'validate', get_template_directory_uri() . '/js/jquery.validate.min.js', array(), '', true );
		wp_register_script( 'mobile-menu', get_template_directory_uri() . '/js/jquery.mobilemenu.js', array(), '', true );	
		wp_register_script( 'easing', get_template_directory_uri() . '/js/jquery.easing-1.3.min.js', array(), '', true );	
		wp_register_script( 'masonry', get_template_directory_uri() . '/js/jquery.masonry.min.js', array(), '', true );		
		wp_register_script( 'retina', get_template_directory_uri() . '/js/retina.js', array(), '', true );	
		wp_register_script( 'backstretch', get_template_directory_uri() . '/js/jquery.backstretch.min.js', array(), '', true );
		wp_register_script( 'custom-js', get_template_directory_uri() . '/js/custom.js', array(), '', true );	
		
		
		/*SUPERFISH DROPDOWN MENU*/
		wp_register_style( 'superfish-style', get_template_directory_uri() . '/js/superfish/superfish.css' );	
		wp_register_style( 'superfish-vertical', get_template_directory_uri() . '/js/superfish/superfish-vertical.css' );	
		wp_register_script( 'superfish', get_template_directory_uri() . '/js/superfish/jquery.superfish.min.js', array(), '', true );	

		/*FLEXSLIDER*/
		wp_register_style( 'flexslider-style', get_template_directory_uri() . '/js/flexslider/flexslider.css' );		
		wp_register_script( 'flexslider', get_template_directory_uri() . '/js/flexslider/jquery.flexslider-min.js', array(), '', true );

		/*HTML5 VIDEO PLAYER*/
		wp_register_style( 'videojs-css', get_template_directory_uri() . '/js/video/video-js.css' );	
		wp_register_script( 'videojs', get_template_directory_uri() . '/js/video/video.js', array(), '', true );

		/*TOUCHTOUCH*/
		wp_register_style( 'touch-style', get_template_directory_uri() . '/js/touchTouch/touchTouch.css' );	
		wp_register_script( 'touch', get_template_directory_uri() . '/js/touchTouch/touchTouch.jquery.js', array(), '', true );	

		/*GOOGLE MAP*/
		wp_register_script( 'gmap-sensor', 'http://maps.google.com/maps/api/js?sensor=true' );
		wp_register_script( 'gmap', get_template_directory_uri() . '/js/gmaps.js' );

		/*DRAGGABLE GALLERY*/
		wp_register_style( 'drag-style', get_stylesheet_directory_uri() . '/js/draggable/drag-style.css' );		
		wp_register_script( 'drag-tmpl', get_template_directory_uri() . '/js/draggable/jquery.tmpl.min.js', array(), '', true );
		wp_register_script( 'drag-kinetic', get_template_directory_uri() . '/js/draggable/jquery.kinetic.js', array(), '', true );
		wp_register_script( 'drag-custom', get_template_directory_uri() . '/js/draggable/drag-custom.js', array(), '', true );
		
		/*HOVER EFFECT*/
		wp_register_style( 'hover-style', get_stylesheet_directory_uri() . '/js/hover/hover.css' );		
		wp_register_script( 'hover', get_template_directory_uri() . '/js/hover/jquery.hoverdir.js', array(), '', true );
		wp_register_script( 'hover-modernizr', get_template_directory_uri() . '/js/hover/modernizr.custom.97074.js', array(), '', true );

		/*PIE CHART*/
		wp_register_style( 'piechart-style', get_stylesheet_directory_uri() . '/js/piechart/piechart.css' );		
		wp_register_script( 'piechart', get_template_directory_uri() . '/js/piechart/jquery.easypiechart.min.js', array(), '', true );	
		wp_register_script( 'piechart-custom', get_template_directory_uri() . '/js/piechart/jquery.piechart.custom.js', array(), '', true );	

				
		/*ENQUEUE STYLE*/
		wp_enqueue_style( 'style' );
		wp_enqueue_style( 'roboto' );
		wp_enqueue_style( 'bitter' );
		wp_enqueue_style( 'font-awesome' );
		wp_enqueue_style( 'superfish-style' );
		wp_enqueue_style( 'superfish-vertical' );
		wp_enqueue_style( 'piechart-style' );
		wp_enqueue_style( 'flexslider-style' );	
		
		/*ENQUEUE SCRIPT*/
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'superfish' );
		wp_enqueue_script( 'easing' );
		wp_enqueue_script( 'retina' );
		wp_enqueue_script( 'piechart' );
		wp_enqueue_script( 'piechart-custom' );
		wp_enqueue_script( 'flexslider' );
		
		if(get_option('photo_bg_type')=="Image") { wp_enqueue_script( 'backstretch' ); }
		
		if (is_singular()) wp_enqueue_script('comment-reply');

		if(is_page_template('template-homepage-masonry.php') || is_page_template('template-portfolio-masonry.php') || is_page_template('template-blog-grid.php')) {
			wp_enqueue_script( 'masonry' );
		}

		if(is_front_page() || is_page_template('template-homepage.php') || is_page_template('template-portfolio.php') || taxonomy_exists('portfolio_categories')) {			
			wp_enqueue_style( 'drag-style' );
			wp_enqueue_style( 'hover-style' );			
			wp_enqueue_script( 'drag-tmpl' );
			wp_enqueue_script( 'drag-kinetic' );
			wp_enqueue_script( 'drag-custom' );
			wp_enqueue_script( 'hover' );		
			wp_enqueue_script( 'hover-modernizr' );


			//HOVER EFFECT
			function hover_thumb() {
				?>
				<script type="text/javascript">
					var $j = jQuery.noConflict();
					$j(function() {							
						$j(' #da-thumbs > li ').each( function() { $j(this).hoverdir(); } );
					});
				</script>
			<?php	
			}
			add_action( 'wp_head', 'hover_thumb' );
		}

		if(is_single()) {
			wp_enqueue_style( 'videojs-css' );
			wp_enqueue_script( 'videojs' );
		}

		if(is_page_template('template-contact.php')) {
			wp_enqueue_script( 'validate' );
			wp_enqueue_script( 'gmap-sensor' );
			wp_enqueue_script( 'gmap' );

			//GOOGLE MAP 
			function google_map() {
				$lat = get_option('photo_map_lat');
				$lng = get_option('photo_map_lng');
				$marker_tip = get_option('photo_map_marker');
				$marker_window = get_option('photo_map_window');
				?>
				<script type="text/javascript">
					(function($) {
					  	"use strict";
					  	var map;
					    $(document).ready(function(){
					    	map = new GMaps({
						        div: '#map',
						        lat: <?php if($lat == "") { echo "-12.043333"; }else { echo $lat; } ?>,
	  							lng: <?php if($lng == "") { echo "-77.028333"; }else { echo $lng; } ?>
					      	});
					      	map.addMarker({
						        lat: <?php if($lat == "") { echo "-12.043333"; }else { echo $lat; } ?>,
	  							lng: <?php if($lng == "") { echo "-77.028333"; }else { echo $lng; } ?>,
						        title: '<?php if($marker_tip == "") { echo "Add your marker title window"; }else { echo $marker_tip; } ?>',
						        infoWindow: {
							    	content: '<p><?php if($marker_window == "") { echo "Please add your text marker here"; }else { echo $marker_window; } ?></p>'
							    }
					      	});
					    });
					})(jQuery);					
				</script>
				<?php
			}
			add_action( 'wp_head', 'google_map' );
		}

		if(is_singular('portfolio')) {
			wp_enqueue_style( 'touch-style' );
			wp_enqueue_script( 'touch' );
		}

		if(get_option('photo_site_layout') != "true") {
			wp_enqueue_style( 'responsive' );		
			wp_enqueue_script( 'mobile-menu' );	
		}

		wp_enqueue_script( 'custom-js' );

	}
	add_action( 'wp_enqueue_scripts', 'photo_script_styles_reg' );


	/**********************************************
	CHANGE DEFAULT SITE TITLE 
	***********************************************/

	function photo_change_default_site_title( $title ){
		$screen = get_current_screen();
		if('portfolio' == $screen->post_type) {
			$title = 'Enter portfolio name';
		}elseif('services' == $screen->post_type) {
			$title = 'Enter services name';
		}elseif('testimonials' == $screen->post_type) {
			$title = 'Enter name';
		}
		return $title;
	}

	add_filter( 'enter_title_here', 'photo_change_default_site_title' );


	/**********************************************
	MAIN MENU FALLBACK
	***********************************************/

	function photo_menu_fallback() {
		$class = "";
		if(is_front_page()){ $class="current_page_item"; }
		?>
		<div id="dropdown" class="menu clear">
			<ul id="menu-main-nav" class="sf-menu">
				<li class="<?php echo $class; ?>">
					<a href="<?php echo home_url(); ?>"><?php if(get_option('photo_home_menu')!="") { echo get_option('photo_home_menu'); } else { _e( 'Home', CODEEX_THEME_NAME ); } ?></a>
				</li>
				<?php wp_list_pages( 'title_li=&sort_column=menu_order' ); ?>
			</ul>
		</div>
		<?php
	}


	/*****************************************************
	THEME SUPPORTS, EDITOR, POST FORMATS AND BACKGROUND
	*****************************************************/

	add_theme_support( 'automatic-feed-links' );
	add_editor_style();
	//add_theme_support( 'custom-background' );
	add_theme_support( 'post-formats', array( 'image', 'video', 'gallery' ) );


	/**********************************************
	CUSTOM MENUS
	***********************************************/
	
	add_action( 'init', 'photo_register_my_menus' );
	function photo_register_my_menus() {
		register_nav_menus(
			array(
				'primary-menu' => 'Primary Menu',
			)
		);
	}


	/**********************************************
	DO SHORTCODES
	***********************************************/

	add_filter('widget_text', 'do_shortcode');
	add_filter('the_content', 'do_shortcode');


	/**********************************************
	SET MAXIMUM CONTENT WIDTH
	***********************************************/

	if ( ! isset( $content_width ) ) $content_width = 930;


	/**********************************************
	LANGUAGE LOCALIZATION
	***********************************************/

	define('CODEEX_THEME_NAME', 'photo_lang');

	add_action('after_setup_theme', 'photo_language_setup');
	function photo_language_setup(){		
		load_theme_textdomain(CODEEX_THEME_NAME, get_template_directory() . '/lang');
	}
	

	/**********************************************
	POST THUMBNAIL
	***********************************************/

	if ( function_exists( 'add_theme_support' ) ) { 
		add_theme_support( 'post-thumbnails', array( 'post', 'portfolio', 'testimonials', 'ourteam' ) );
		set_post_thumbnail_size( 242, 200, true ); 
		add_image_size( 'widget-thumb', 60, 66, true );
		add_image_size( 'widget-medium', 250, 205, true );
		add_image_size( 'testi-thumb', 60, 60, true );
		add_image_size( 'member-thumb', 100, 100, true );
		add_image_size( 'member-medium', 280, 280, true );
		add_image_size( 'other-thumb', 190, 180, true );
		add_image_size( 'theme-large', 650, 9999 );
	}


	/**********************************************
	GET PAGE CUSTOM TITLE
	***********************************************/

	function photo_get_page_title() {
		global $post;
		if( get_post_meta( $post->ID, "ptitle", true ) != "") { 
			?><h2 class="ptitle"><?php echo stripslashes(get_post_meta( $post->ID, "ptitle", true )); ?></h2><?php 
		}else {
			?><h2 class="ptitle"><?php the_title(); ?></h2><?php
		}
	}


	/**********************************************
	GET BREADCRUMB
	***********************************************/

	function photo_breadcrumb() {
        ?>
    	<div class="breadcrumbs">
    		<?php 
    			if (!is_front_page()) {
		            ?><a href="<?php echo home_url(); ?>"><?php _e( 'Home', CODEEX_THEME_NAME ); ?></a><?php

		            if(is_archive()) {
		            	echo " / ";
		            	if ( is_day() ) :
							printf( __( '%s', CODEEX_THEME_NAME ), get_the_date() ); 
						elseif ( is_month() ) :
							printf( __( '%s', CODEEX_THEME_NAME ), get_the_date( __( 'F Y', 'monthly archives date format', CODEEX_THEME_NAME ) ) ); 
						elseif ( is_year() ) :
							printf( __( '%s', CODEEX_THEME_NAME ), get_the_date( __( 'Y', 'yearly archives date format', CODEEX_THEME_NAME ) ) );
						elseif (is_category()) :
							single_cat_title(); 
						elseif( is_tag() ) :
							printf( single_tag_title() ); 
						elseif( is_tax() ) :
							$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
							echo $term->name;
						endif;
		            }elseif (is_category() || is_single()) {
		                echo " / ";
		                the_category(', ');
		                if (is_single()) {
		                	if(is_singular('portfolio')) {
		                		the_title();
		                	}else {
		                		echo " / ";
		                		the_title();
		                	}		                	
		                }
		            }elseif (is_page()) { 
		            	echo " / "; 
		            	echo the_title(); 
		            }elseif(is_search()) {
		            	echo " / "; 
		            	_e( 'Search', CODEEX_THEME_NAME );
		            }elseif(is_404()) {
		            	echo " / "; 
		            	_e( 'Page Not Found', CODEEX_THEME_NAME );
		            }
		        }else { _e( 'Home', CODEEX_THEME_NAME ); }
    		?>
    	</div>
        <?php
	}


	/**********************************************
	GET RECEIPIANT IP ADDRESS
	***********************************************/

	function photo_get_the_ip() {
	    if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
	        return $_SERVER["HTTP_X_FORWARDED_FOR"];
	    }
	    elseif (isset($_SERVER["HTTP_CLIENT_IP"])) {
	        return $_SERVER["HTTP_CLIENT_IP"];
	    }
	    else {
	        return $_SERVER["REMOTE_ADDR"];
	    }
	}


	/**********************************************
	CATEGORY/ARCHIVE COUNT SPAN
	***********************************************/

	add_filter('wp_list_categories', 'category_count_span_inline');
	function category_count_span_inline($output) {
		$output = str_replace('</a> (','<span> ',$output);
		$output = str_replace(')','</span></a> ',$output);
		return $output;
	}


	/**********************************************
	FOR PAGINATION WORKING ON STATIC HOMEPAGE
	***********************************************/

	function photo_get_home_pagination() {
		global $paged, $wp_query, $wp;
		$args = wp_parse_args($wp->matched_query);
		if ( !empty ( $args['paged'] ) && 0 == $paged ) {
			$wp_query->set('paged', $args['paged']);
		  	$paged = $args['paged'];
		}
	}


	/**********************************************
	GET PORTFOLIO CATEGORIES
	***********************************************/

	function photo_get_portfolio_category() {
		global $portfolio_page_url, $portfolio_page_url_classic;
		?>
			<div class="cat-toogles clear">
				<ul class="cat-list filter">
					<li <?php if(is_page_template('template-homepage.php') || is_page_template('template-homepage-masonry.php') || is_page_template('template-portfolio.php') || is_page_template('template-portfolio-masonry.php') || is_page_template('template-portfolio-classic.php')) { echo "class='current-cat'"; } ?>>
						<a href="<?php echo $portfolio_page_url; ?>"><?php if(get_option('photo_pcategory_label')!="") { echo get_option('photo_pcategory_label'); } else { _e( 'All', CODEEX_THEME_NAME ); } ?></a>
					</li>
					<?php
						$args = array( 'taxonomy' => 'portfolio_categories', 'style' => 'list', 'title_li' => '', 'hierarchical' => false, 'order' => 'DESC', 'orderby' => 'title' );
						wp_list_categories ( $args );
					?>	
				</ul>
			</div>
		<?php
	}	


	/**********************************************
	GET PAGES LINK
	***********************************************/

	function photo_portfolio_link() {
		global $portfolio_page_url, $portfolio_page_url_classic;
		$portfolio_pages = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'template-portfolio.php'));
		foreach($portfolio_pages as $page){
			$portfolio_page_id = $page->ID;
			$portfolio_page_url = get_permalink($portfolio_page_id);
		}
	}

	function photo_blog_link() {
		global $blog_page_url;
		$blog_pages = get_pages(array('meta_key' => '_wp_page_template', 'meta_value' => 'template-blog.php'));
		foreach($blog_pages as $page){
			$blog_page_id = $page->ID;
			$blog_page_url = get_permalink($blog_page_id);
		}
	}


	/**********************************************
	CUSTOM EXCERPT LENGTH
	***********************************************/

	function photo_custom_excerpt_length( $length ) {
		return 15;
	}
	add_filter( 'excerpt_length', 'photo_custom_excerpt_length', 999 );

	function photo_custom_excerpt_more( $more ) {
		return ' ...';
	}
	add_filter( 'excerpt_more', 'photo_custom_excerpt_more' );


	/**********************************************
	REMOVE DEFAULT COMMENT FIELDS
	***********************************************/

	function photo_remove_comment_fields($arg) {
	    $arg['url'] = '';
	    return $arg;
	}
	add_filter('comment_form_default_fields', 'photo_remove_comment_fields');

	
	/**********************************************
	CUSTOM COMMENT STYLE
	***********************************************/

	function photo_theme_comment($comment, $args, $depth) {
		$GLOBALS['comment'] = $comment; ?>
			
			<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
				<div class="parent clear" id="comment-<?php comment_ID(); ?>">
					
					<?php echo get_avatar( $comment, 60 ); ?>
					<div class="comment-details">
						<h6>
							<?php 
								comment_author_link();
								comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); 
							?>
						</h6> 
						<span>
							<?php comment_date(get_option('date_format')); _e( '&nbsp;at&nbsp;', CODEEX_THEME_NAME ); comment_time(get_option('time_format')); ?> 
							<?php edit_comment_link('edit','&nbsp;',''); ?>
						</span>	
						<?php comment_text() ?> 
					</div>
					
					<?php 
						if ($comment->comment_approved == '0') : ?>
						<em><?php _e( 'Your comment is awaiting moderation.', CODEEX_THEME_NAME ); ?></em>
					<?php 
						endif; 					
					?>
				</div>	
			
			<?php
				$oddcomment = ( empty( $oddcomment ) ) ? 'class="alt" ' : '';
				paginate_comments_links();
	}


	/**********************************************
	CUSTOM PAGINATION
	***********************************************/

	function photo_pagination() {  
		global $wp_query;
		$big = 999999999;
		if($wp_query->max_num_pages == '1' ) {
		}else {
			echo "<div class=\"pagination clear\">";
		}
		echo paginate_links( array(
			'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
			'format' => '?paged=%#%',
			'prev_text' => __( '&laquo;', CODEEX_THEME_NAME ),
    		'next_text' => __( '&raquo;', CODEEX_THEME_NAME ),
			'current' => max( 1, get_query_var('paged') ),
			'total' => $wp_query->max_num_pages,
			'type' => 'list'
		));
		if($wp_query->max_num_pages == '1' ) {
		}else {
			echo "</div>";
		}
	}


	/**********************************************
	CUSTOM NEXT PREVIOUS LINK
	***********************************************/

	function photo_next_previous() {
		?>
		<div class="pagination">
			<?php
			    global $wp_query, $paged;		    
			    if ($paged > 1) {
			    	?><div class="alignleft"><a href="<?php previous_posts(); ?>">&larr; <?php _e( 'Previous', CODEEX_THEME_NAME ); ?></a></div><?php
			    }
			    if ($wp_query->max_num_pages == 1) {		    		
		    	}elseif ($paged < $wp_query->max_num_pages) {
		    		?><div class="alignright"><a href="<?php next_posts(); ?>"><?php _e( 'Next', CODEEX_THEME_NAME ); ?> &rarr;</a> </div><?php
		    	}
			?>
		</div>
		<?php
	}


	/**********************************************
	FIX PAGINATION FOR TAXONOMIES
	***********************************************/

	$option_posts_per_page = get_option( 'posts_per_page' );
	
	function photo_modify_posts_per_page() {
	    add_filter( 'option_posts_per_page', 'photo_option_posts_per_page' );
	}
	add_action( 'init', 'photo_modify_posts_per_page', 0);

	function photo_option_posts_per_page( $value ) {
	    global $option_posts_per_page, $wp_query;
	    if ( is_tax( 'portfolio_categories') ) {
	        return $wp_query->max_num_pages;
	    } else {
	        return $option_posts_per_page;
	    }
	}


	/**********************************************
	SEARCH FILTER : BLOG POST ONLY
	***********************************************/

	function photo_searchfilter($query) {
	    if ( !$query->is_admin && $query->is_search) {
	         $query->set('post_type', 'post');
	    }
	    return $query;
	}	 
	add_filter('pre_get_posts','photo_searchfilter');


	/**********************************************
	REMOVE & ADD NEW FIELD IN USER PROFILE
	***********************************************/

	function photo_remove_aim( $contactmethods ) {
		unset($contactmethods['aim']);
		unset($contactmethods['jabber']);
		unset($contactmethods['yim']);
		return $contactmethods;
	}
	add_filter('user_contactmethods','photo_remove_aim',10,1);

	function photo_add_twitter_facebook( $contactmethods ) {
	    $contactmethods['twitter'] = 'Twitter';
	    $contactmethods['facebook'] = 'Facebook';
	    return $contactmethods;
	}
	add_filter('user_contactmethods','photo_add_twitter_facebook',10,1);


	/**********************************************
	DISPLAY LIST OF WIDGETS
	***********************************************/

	add_action( 'add_meta_boxes', 'photo_add_sidebar_metabox' );
	add_action( 'save_post', 'photo_save_sidebar_postdata' );

	function photo_add_sidebar_metabox() {
		add_meta_box( 'custom_sidebar', __( 'Custom Sidebar', CODEEX_THEME_NAME ), 'photo_custom_sidebar_callback', 'page', 'side' );
		add_meta_box( 'custom_sidebar', __( 'Custom Sidebar', CODEEX_THEME_NAME ), 'photo_custom_sidebar_callback', 'post', 'side' ); 
		add_meta_box( 'custom_sidebar', __( 'Custom Sidebar', CODEEX_THEME_NAME ), 'photo_custom_sidebar_callback', 'portfolio', 'side' ); 
	}

	/*SIDEBAR CALLBACK*/

	function photo_custom_sidebar_callback( $post ) {
		global $wp_registered_sidebars;
		$custom = get_post_custom($post->ID);

		if(isset($custom['custom_sidebar']))
			$val = $custom['custom_sidebar'][0];
		else
			$val = "Default";

			wp_nonce_field( plugin_basename( __FILE__ ), 'custom_sidebar_nonce' );

			$output = '<p><small><label for="myplugin_new_field">'.__("Choose a sidebar to display except footer columns", CODEEX_THEME_NAME ).'</label></small></p>';
			$output .= "<select name='custom_sidebar'>";

		$output .= "<option";
		if($val == "Default")
			$output .= " selected='selected'";
			$output .= " value='Default'>".__('Default', CODEEX_THEME_NAME)."</option>";

			foreach($wp_registered_sidebars as $sidebar_id => $sidebar) {
				$output .= "<option";
				if($sidebar_id == $val)
					$output .= " selected='selected'";
					$output .= " value='".$sidebar_id."'>".$sidebar['name']."</option>";
			}

		$output .= "</select>";
		echo $output;
	}

	/*SAVE SIDEBAR DATA*/

	function photo_save_sidebar_postdata( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
			return;

		if ( !wp_verify_nonce( @$_POST['custom_sidebar_nonce'], plugin_basename( __FILE__ ) ) )
		 	return;

		if ( !current_user_can( 'edit_page', $post_id ) )
			return;

		$data = $_POST['custom_sidebar'];
		update_post_meta($post_id, "custom_sidebar", $data);
	}


	/**********************************************
	GET CUSTOM SIDEBAR
	***********************************************/

	function photo_get_custom_sidebar() {
		global $sidebar_choice;

		if($sidebar_choice == "sidebar") {
			get_sidebar();
		}elseif($sidebar_choice == "blog_sidebar") {
			get_sidebar( 'blog' );
		}elseif($sidebar_choice == "services_sidebar") {
			get_sidebar( 'services' );
		}elseif($sidebar_choice == "portfolio_sidebar") {
			get_sidebar( 'portfolio' );
		}elseif($sidebar_choice == "contact_sidebar") {
			get_sidebar( 'contact' );
		}else {
			get_sidebar();
		}
	}


	/**********************************************
	ADD POST THUMBNAIL SIZE IN MEDIA UPLOAD
	***********************************************/

	function photo_get_additional_image_sizes() {
		$sizes = array();
		global $_wp_additional_image_sizes;
		if ( isset($_wp_additional_image_sizes) && count($_wp_additional_image_sizes) ) {
			$sizes = apply_filters( 'intermediate_image_sizes', $_wp_additional_image_sizes );
			$sizes = apply_filters( 'photo_get_additional_image_sizes', $_wp_additional_image_sizes );
		}
		return $sizes;
	}

	function additional_image_size_input_fields( $fields, $post ) {
		if ( !isset($fields['image-size']['html']) || substr($post->post_mime_type, 0, 5) != 'image' )
			return $fields;

		$sizes = photo_get_additional_image_sizes();
		if ( !count($sizes) )
			return $fields;

		$items = array();
		foreach ( array_keys($sizes) as $size ) {
			$downsize = image_downsize( $post->ID, $size );
			$enabled = $downsize[3];
			$css_id = "image-size-{$size}-{$post->ID}";
			$label = apply_filters( 'image_size_name', $size );

			$html  = "<div class='image-size-item'>\n";
			$html .= "<input type='radio' " . disabled( $enabled, false, false ) . "name='attachments[{$post->ID}][image-size]' id='{$css_id}' value='{$size}' />\n";
			$html .= "<label for='{$css_id}'>{$label}</label>\n";
			if ( $enabled )
				$html .= "<label for='{$css_id}' class='help'>" . sprintf( "(%d x %d)", $downsize[1], $downsize[2] ). "</label>\n";
			$html .= "</div>";

			$items[] = $html;
		}

		$items = join( "\n", $items );
		$fields['image-size']['html'] = "{$fields['image-size']['html']}\n{$items}";

		return $fields;
	}

	add_filter( 'attachment_fields_to_edit', 'additional_image_size_input_fields', 11, 2 );


	/**********************************************
	CONVERT HEX TO RGBA
	***********************************************/

	function hex2rgba($color, $opacity = false) {
		$default = 'rgb(0,0,0)';
		if(empty($color))
	        return $default; 
	        if ($color[0] == '#' ) {
	        	$color = substr( $color, 1 );
	        }

	        if (strlen($color) == 6) {
	            $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
	        } elseif ( strlen( $color ) == 3 ) {
	            $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
	        } else {
	            return $default;
	        }

	        $rgb =  array_map('hexdec', $hex);

	        if($opacity){
	        	if(abs($opacity) > 1)
	        		$opacity = 1.0;
	        		$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
	        } else {
	        	$output = 'rgb('.implode(",",$rgb).')';
	        }
	        return $output;
	}	


	/**********************************************
	CUSTOM THEME STYLESHEETS
	***********************************************/

	function photo_theme_custom_styles() {
		?><style type="text/css"><?php	

		/*PATTERNS*/

		if(get_option('photo_pattern')=="Gray Lines") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/gray_lines.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Noise Lines") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/noise_lines.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Tiny Grid") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/tiny_grid.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Bullseye") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/strange_bullseyes.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Gray Paper") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/gray_paper.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Norwegian Rose") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/norwegian_rose.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Subtle Net") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/subtlenet.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Polyester Lite") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/polyester_lite.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Absurdity") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/absurdidad.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="White Bed Sheet") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/white_bed_sheet.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Subtle Stripes") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/subtle_stripes.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Light Mesh") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/lghtmesh.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Rough Diagonal") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/rough_diagonal.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Arabesque") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/arab_tile.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Stack Circles") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/stacked_circles.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Hexellence" ) {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/hexellence.png') repeat top fixed fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="White Texture" ) {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/white_texture.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Concrete Wall") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/concrete_wall.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Brush Aluminum") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/brushed_alu.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Groovepaper") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/groovepaper.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Diagonal Noise") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/diagonal_noise.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Rocky Wall") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/rockywall.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Whitey") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/whitey.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Bright flexs") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/bright_flexs.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Freckles") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/freckles.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Wallpaper") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/wallpaper.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Project Paper") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/project_papper.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Cubes") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/cubes.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Washi") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/washi.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Dot Noise") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/dotnoise.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="xv") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/xv.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Little Plaid") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/plaid.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Old Wall") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/old_wall.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Connect") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/connect.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Ravenna") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/ravenna.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Smooth Wall") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/smooth_wall.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Tapestry") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/tapestry.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Psychedelic") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/psychedelic.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Scribble Light") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/scribble_light.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="GPlay") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/gplay.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Lil Fiber") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/lil_fiber.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="First Aid") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/first_aid.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Frenchstucco") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/frenchstucco.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Light Wool") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/light_wool.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Gradient flexs") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/gradient_flexs.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Escheresque") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/escheresque.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Climpek") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/climpek.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Lyonnette") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/lyonnette.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Gray Floral") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/greyfloral.png') repeat top fixed !important; }<?php
		}elseif(get_option('photo_pattern')=="Reticular Tissue") {
			?>body { background:url('<?php echo get_template_directory_uri(); ?>/img/patterns/reticular_tissue.png') repeat top fixed !important; }<?php
		}else { }


		/*CUSTOM COLORS*/

		$theme_color_global = get_option('photo_global_color');
		$rgb_theme_color = hex2rgba($theme_color_global);
		$rgba_theme_color = hex2rgba($theme_color_global, 0.9);

		$button_color_global = get_option('photo_button_bg_color');
		$rgb_button_color = hex2rgba($button_color_global);
		$rgba_button_color = hex2rgba($button_color_global, 0.9);

		if(get_option('photo_global_color')!="" ) { 
			?>
			.cat-toogles, .portfolio-links a:hover, .flex-active, .title-header, .meter > span, .page-not-found,
			.widget_categories ul li a span, #today, .tagcloud a, .blog-mask a,
			.contact-form input[type="submit"], .comment-respond input[type="submit"] { background-color:<?php echo $theme_color_global ?>; }
			.portfolio-links a, .da-thumbs li .project-mask .masking { background:<?php echo $rgba_theme_color ?>; }
			.masking a.slink, a.back-home:link, a.back-home:visited, .team-list h4,
			a.read-more:link, a.read-more:visited, .single-portfolio .portfolio-links a,
			.post-link .prev a, .post-link .next a { color:<?php echo $theme_color_global ?>; }
			a.back-home:hover { color:#FFF; }
			<?php
		}

		if(get_option('photo_menu_text_color')!="" ) { 
			?>
			.menu ul li a { color:<?php echo get_option('photo_menu_text_color') ?> !important; }
			<?php
		}
		if(get_option('photo_header_text_color')!="" ) { 
			?>
			.ptitle, .header-widget .widget h5, .sidebar .widget h5, .comments h3, .comment-respond h3,
			.team-block h3, .skills-block h3, .contact-form h3 { color:<?php echo get_option('photo_header_text_color') ?> !important; }
			<?php
		}
		if(get_option('photo_sidebar_text_color')!="" ) { 
			?>.sidebar .widget h5 { color:<?php echo get_option('photo_sidebar_text_color') ?> !important; }<?php
		}
		if(get_option('photo_button_bg_color')!="" ) { 
			?>
			.portfolio-links a, .masking a.slink, a.back-home:link, a.back-home:visited,
			.widget_categories ul li a span, .tagcloud a, a.read-more:link, a.read-more:visited,
			.contact-form input[type="submit"], .comment-respond input[type="submit"],
			.post-link .prev a, .post-link .next a { background-color:<?php echo $rgba_button_color ?> !important; }
			.portfolio-links a:hover { background-color:<?php echo $button_color_global ?> !important; }
			<?php
		}
		if(get_option('photo_button_bg_hover_color')!="" ) { 
			?>
			.masking a.slink:hover, a.back-home:hover, .widget_categories ul li a:hover span,
			.tagcloud a:hover, a.read-more:hover, .contact-form input[type="submit"]:hover, 
			.comment-respond input[type="submit"]:hover, .single-portfolio .portfolio-links a:hover,
			.post-link .prev a:hover, .post-link .next a:hover { background-color:<?php echo get_option('photo_button_bg_hover_color') ?> !important; }
			<?php
		}
		if(get_option('photo_button_text_color')!="" ) { 
			?>
			.masking a.slink, a.back-home:link, a.back-home:visited, .widget_categories ul li a span,
			.tagcloud a, a.read-more:link, a.read-more:visited, 
			.contact-form input[type="submit"], .comment-respond input[type="submit"],
			.single-portfolio .portfolio-links a, .post-link .prev a, .post-link .next a { color:<?php echo get_option('photo_button_text_color') ?> !important; }
			<?php
		}
		if(get_option('photo_custom_css')!="") {
			echo get_option('photo_custom_css');
		}

		?></style><?php
	}
	add_action( 'wp_head', 'photo_theme_custom_styles' );



	/**********************************************
	CUSTOM RESIZABLE BACKGROUND
	***********************************************/

	function photo_theme_custom_background() {
		global $post, $archive_bgimage;
		$bgimage = get_post_meta(@$post->ID, "bgimage", true);
		$archive_bgimage = get_option('photo_archive_bgimage');
		$search_bgimage = get_option('photo_search_bgimage');
		$notfound_bgimage = get_option('photo_notfound_bgimage');

		if(is_archive()) {
			if($archive_bgimage != "") {
				?>
				<script type="text/javascript"> 
					jQuery(window).load(function() { jQuery.backstretch("<?php echo $archive_bgimage; ?>"); }); 
				</script>
				<?php	
			}else { default_img_bg(); }
		}elseif(is_search()) {
			if($search_bgimage != "") {
				?>
				<script type="text/javascript"> 
					jQuery(window).load(function() { jQuery.backstretch("<?php echo $search_bgimage; ?>"); }); 
				</script>
				<?php					
			}else { default_img_bg(); }
		}elseif(is_404()) {
			if($notfound_bgimage != "") {
				?>
				<script type="text/javascript"> 
					jQuery(window).load(function() { jQuery.backstretch("<?php echo $notfound_bgimage; ?>"); }); 
				</script>
				<?php						
			}else { default_img_bg(); }
		}elseif(is_page() || is_single()) {
			if($bgimage != "") {
				?>
				<script type="text/javascript"> 
					jQuery(window).load(function() { jQuery.backstretch("<?php echo $bgimage; ?>"); }); 
				</script>
				<?php					
			}else { default_img_bg(); }
		}else {
			default_img_bg();
		}

	}	
	add_action( 'wp_footer', 'photo_theme_custom_background' );

	function default_img_bg() {
		$default_image = get_option('photo_default_bgimage');

		if(get_option('photo_pattern')=="Select Pattern") {	
			if(get_option('photo_bg_type')!="Pattern") {
				if($default_image != "") {
					?>
						<script type="text/javascript"> 
							jQuery(window).load(function() { jQuery.backstretch("<?php echo $default_image; ?>"); });
						</script>
					<?php	
				}else {
					?>
					<script type="text/javascript"> 
						jQuery(window).load(function() { jQuery.backstretch("http://wp.themecss.com/Photo/wp-content/uploads/2013/10/tumblr_msueg2zH6y1st5lhmo1_1280.jpg"); }); 
					</script>
					<?php
				}			
			}	
		}
	}	
?>