<?php get_header(); ?>
	
	<div class="theme-content clear">

		<section class="title-header">
			<div class="breadcrumb-title">
				<h2 class="ptitle">
					<?php if (is_category()) : ?>
						<?php single_cat_title(); ?>
					<?php elseif( is_tag() ) : ?>
						<?php printf( _e('Posts Tagged: ', CODEEX_THEME_NAME), single_tag_title() ); ?>
					<?php elseif ( is_day() ) : ?>
						<?php printf( __( '%s', CODEEX_THEME_NAME ), get_the_date() ); ?>
					<?php elseif ( is_month() ) : ?>
						<?php printf( __( '%s', CODEEX_THEME_NAME ), get_the_date( __( 'F Y', 'monthly archives date format', CODEEX_THEME_NAME ) ) ); ?>
					<?php elseif ( is_year() ) : ?>
						<?php printf( __( '%s', CODEEX_THEME_NAME ), get_the_date( __( 'Y', 'yearly archives date format', CODEEX_THEME_NAME ) ) ); ?>
					<?php endif; ?>
				</h2>
				<?php photo_breadcrumb(); ?>
			</div>
		</section>
		
		<section class="page-contents blog-page">			
			<?php 
				while (have_posts()) : the_post(); 					
					get_template_part( 'loop', 'entry' );
				endwhile;		

				if(get_option('photo_pnav')=="Next Previous Link") { photo_next_previous(); } else { photo_pagination(); }
				wp_link_pages(); 
			?>
		</section>

		<section class="sidebar">
			<?php
				if($sidebar_choice == "Default") { get_sidebar('blog'); } else { photo_get_custom_sidebar(); }
			?>
		</section>
		
	</div>

<?php get_footer(); ?>