<?php
/**
 * @version     $Id: mmbackground.php 549 2010-09-17 21:38:37Z martin $
 * @package     Joomla
 * @subpackage  System - mmBackground Free
 * @author      Martin Gray <author [at] mmPlugins.com>
 * @copyright   Copyright (C) 2009 mmPlugins | All rights reserved
 * @license     GNU/GPL v.2
 * @see         /plugins/system/mmbackground/LICENSE.php
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );
jimport( 'joomla.filesystem.folder' );

class plgSystemMmbackground extends JPlugin
{
    /**
     * Constructor
     *
     * For php4 compatability we must not use the __constructor as a constructor for plugins
     * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
     * This causes problems with cross-referencing necessary for the observer design pattern.
     *
     * @param   object      $subject The object to observe
     * @param  array       $config  An array that holds the plugin configuration
     * @since   1.0
     */
    function plgSystemMmbackground(&$subject, $config)  {
        parent::__construct($subject, $config);
    }

    function onAfterDispatch()
    {
        global $mainframe;

        $app =& JFactory::getApplication();
        if ( $app->getName() != 'site' ) return true;

        // Make sure mootools is loaded
        JHTML::_( 'behavior.mootools' );

        if ( JApplication::getCfg( 'debug' ) && file_exists( JPATH_PLUGINS.DS.'system'.DS.'mmbackground'.DS.'assets'.DS.'js'.DS.'mmbackground.source.js' ) ) JHTML::_( 'script', 'mmbackground.source.js', 'plugins/system/mmbackground/assets/js/' );
        else JHTML::_( 'script', 'mmbackground.min.js', 'plugins/system/mmbackground/assets/js/' );

        if ( JApplication::getCfg( 'debug' ) && file_exists( JPATH_PLUGINS.DS.'system'.DS.'mmbackground'.DS.'assets'.DS.'js'.DS.'mmstage.source.js' ) ) JHTML::_( 'script', 'mmstage.source.js', 'plugins/system/mmbackground/assets/js/' );
        else JHTML::_( 'script', 'mmstage.min.js', 'plugins/system/mmbackground/assets/js/' );

        $image = $this->params->get( 'image', '' );
        $jsImages = "'".$this->_getImagePath($image)."'";

        $document =& JFactory::getDocument();

        // IE6 hack -> get rid of scroll bars
        $document->addStyleDeclaration("
            html { overflow: hidden !important; }
        ");

        // Add some css to make the wrapper behave as desired
        $document->addStyleDeclaration("
            #mmWrapper { scroll: auto; position: absolute; z-index: 1; top: 0px; left: 0px; overflow: auto; overflow-x: hidden; }
        ");
        
        // Add script that initialises mmBackground
        $document->addScriptDeclaration("
            var mmBgImageOpacity    = ".$this->params->get( 'image_opacity', 1 ).";
            var mmBgColor           = '".$this->params->get( 'background_color', '#000000' )."';
            var mmBgOpacity         = ".$this->params->get( 'background_opacity', 1 ).";

            var theStage = null;
            window.addEvent('domready', function() {
                // init mmStage
                theStage = new mmStage({
                    element: 'mmStage',
                    onInit: function() {
                        var mmWrapper = new wdgtWrapper(this, {});
                        this.registerWidget('mmWrapper', mmWrapper);
                        var mmBackground = new wdgtBackground(this, {
                            images: [".$jsImages."],
                            background: { opacity: mmBgOpacity, color: mmBgColor },
                            image: { opacity: mmBgImageOpacity }
                        });
                        this.registerWidget('mmBackground', mmBackground);
                    }
                });
            });
        ");
    }

    function _getImagePath( $image, $imageDir = '' )
    {
        $imageDir = str_replace('\\', '/', $imageDir);
        $url = JURI::root();
        if ( substr( $url, strlen( $url )-1, strlen( $url ) ) != '/' ) $url .= '/';
        if ( $imageDir != '') {
            if ( substr( $imageDir, strlen( $imageDir )-1, strlen( $imageDir ) ) != '/' ) $imageDir .= '/';
            if ( substr( $imageDir, 0, 1 ) == '/' ) $imageDir = substr( $imageDir, 1, strlen( $imageDir ) );
            $url .= $imageDir;
        }
        if (substr( $image, 0, 1 ) == '/') $image = substr( $image, 1, strlen( $image ) );
        return $url . $image;
    }

    function onAfterRender()
    {
        $app =& JFactory::getApplication();
        if ( $app->getName() != 'site' ) return true;

        $pattern = "/<body[0-9a-zA-Z=\s\"_-]{0,}>/";
        preg_match( $pattern, JResponse::getBody(), $matches );
        $bodyOpen = $matches[0];

        // wrapping body contents with required markup
        JResponse::setBody(str_replace($bodyOpen, $bodyOpen.'<div id="mmStage"><div id="mmWrapper">', JResponse::getBody()));
        JResponse::setBody(str_replace('</body>', '</div></div>'.'</body>', JResponse::getBody()));

        return true;
    }
}
