<?php
/*
Template Name: Portfolio Classic
*/
?>

<?php get_header(); ?>
	
	<div class="theme-content clear">

		<section class="title-header">
			<div class="breadcrumb-title">
				<?php
					photo_get_page_title();
					photo_breadcrumb();
				?>
			</div>
		</section>
		
		<section class="portfolio-classic">
			
			<?php photo_get_portfolio_category(); ?>

			<div class="portfolio-block">
				<ul id="da-thumbs" class="clear da-thumbs">
					<?php
						photo_get_home_pagination();

						$album_order = get_option('photo_album_order');
						$album_orderby = get_option('photo_album_orderby');
						$album_limit = get_option('photo_num_portfolio');

						$args = array( 'post_type' => 'portfolio', 'orderby' => $album_orderby, 'order' => $album_order, 'posts_per_page' => $album_limit, 'paged' => $paged );
						$wp_query = new WP_Query( $args );	
						
						for($i = 1; $wp_query->have_posts(); $i++) { 
							$wp_query->the_post();			
							$columns = 3;	
							$class = 'portfolio-classic-list ';
							$class .= ($i % $columns == 0) ? 'last' : '';

							get_template_part( 'loop', 'classic' );

						};	
					?>
				</ul>
			</div>		

			<?php if(get_option('photo_pnav')=="Next Previous Link") { photo_next_previous(); } else { photo_pagination(); } ?>

		</section>		
		
	</div>

<?php get_footer(); ?>	