<?php
/*
Template Name: Blog List
*/
?>

<?php get_header(); ?>
	
	<div class="theme-content clear">
		<section class="title-header">
			<div class="breadcrumb-title">
				<?php
					photo_get_page_title();
					photo_breadcrumb();
				?>
			</div>
		</section>
		
		<section class="page-contents blog-page">			
			<?php 
				photo_get_home_pagination();
				$blog_limit = get_option('photo_num_blog');

				$args = array( 'post_type' => 'post', 'paged' => $paged );		
				$wp_query = new WP_Query( $args );	
				while ($wp_query->have_posts()) : $wp_query->the_post(); 					
					get_template_part( 'loop', 'entry' );
				endwhile;		

				if(get_option('photo_pnav')=="Next Previous Link") { photo_next_previous(); } else { photo_pagination(); }
			?>
		</section>

		<section class="sidebar">
			<?php
				if($sidebar_choice == "Default") { get_sidebar('blog'); } else { photo_get_custom_sidebar(); }
			?>
		</section>
		
	</div>

<?php get_footer(); ?>