<?php
	/**********************************************
	CUSTOM SKILLS WIDGET
	***********************************************/
	
	class photo_Widget_Skills extends WP_Widget {
	
		function photo_Widget_Skills() {		
			$widget_ops = array('classname' => 'widget-skills', 'description' => __('Custom widget for skills list', CODEEX_THEME_NAME));	
			$this -> WP_Widget('Skills', __('Photo: Skills Bar List', CODEEX_THEME_NAME), $widget_ops);		
		}
	
		function widget($args, $instance) {		
			extract($args);		
			$title = apply_filters('widget_title', $instance['title']);		
			if (empty($title)) $title = false;
				$instance_skills_limit = array();
				
				$skills_limit = 'skills_limit';
				$instance_skills_limit = isset($instance[$skills_limit]) ? $instance[$skills_limit] : '';
							
				echo ''.$before_widget.'';					
				if ($title) {						
					echo $before_title;
			 		echo $title;
			 		echo $after_title.'';						
			 	}

					global $post;
			 		$args = array( 'post_type' => 'skills', 'posts_per_page' => $instance_skills_limit );		
					$wp_query = new WP_Query( $args );						
					?>
						<ul class="clear">
							<?php
								while ($wp_query->have_posts()) : $wp_query->the_post(); 
									?>
									<li>
										<label><?php the_title(); ?><span><?php echo get_post_meta( $post->ID, "percent", true ); echo "%"; ?></span></label>
										<div class="meter nostripes">
											<span style="width:<?php echo get_post_meta( $post->ID, "percent", true ); ?>%"></span>
										</div>
									</li>
									<?php
								endwhile;	
							?>
						</ul>
					<?php
					wp_reset_query();


					echo $after_widget.'';				
				}
			
				function update($new_instance, $old_instance) {				
					$instance = $old_instance;				
					$instance['title'] = strip_tags($new_instance['title']);
					$instance['skills_limit'] = $new_instance['skills_limit'];				
					return $instance;				
				}
			
				function form($instance) {				
					$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
					$instance_skills_limit = array();							
					
					$skills_limit = 'skills_limit';
					$instance_skills_limit = isset($instance[$skills_limit]) ? $instance[$skills_limit] : '';					
					
				?>
					<p><label for="<?php echo $this -> get_field_id('title'); ?>"><?php _e('Title:', CODEEX_THEME_NAME); ?></label>
					<input class="widefat" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>					
					<div>			
						<div>
							<p><label for="<?php echo $this -> get_field_id($skills_limit); ?>"><?php _e('Number of List:', CODEEX_THEME_NAME); ?></label>
							<input class="widefat" type="text" id="<?php echo $this -> get_field_id($skills_limit); ?>" name="<?php echo $this -> get_field_name($skills_limit); ?>" value="<?php echo $instance_skills_limit; ?>">
							</p>
							<div>	
								<small><i><?php _e( 'Skills list will automatically display...', CODEEX_THEME_NAME ); ?></i></small>	
							</div>														
						</div>			
					</div>
		<?php
				}			
		}

		function photo_widget_skills() {			
			register_widget('photo_Widget_Skills');			
		}
		add_action('widgets_init', 'photo_widget_skills');
?>